/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import java.lang.reflect.*;
import java.util.logging.Level;

import com.sun.enterprise.tools.verifier.Result;

/** 
 * Filter class must implement a no arg constructor.
 * Verify that the Filter class implements a no arg constructor.
 * 
 * @author Jerome Dochez
 * @version 1.0
 */
public class FilterClassHasValidConstructor extends FilterClass implements WebCheck {
    /**
     * <p>
     * Run the verifier test against a declared individual filter class
     * </p>
     *
     * @param result is used to put the test results in
     * @param filterClass is the individual filter class object to test
     * @return true if the test pass
     */        
    protected boolean runIndividualFilterTest(Result result, Class filterClass) {
        
        boolean validConstructor = false;
        boolean foundIt = false;
        Class clazz = filterClass;
        
        if (filterClass == null) 
            return false;
        
        // walk up the class tree 
        do {
            Constructor[] constructors = filterClass.getDeclaredConstructors();
            for (int i = 0; i < constructors.length; i++) {
                logger.log(Level.FINE, getClass().getName() + ".debug",
                        new Object[] {constructors[i].toString()});
                Class[] parameters = constructors[i].getParameterTypes();
                if (parameters.length == 0) {
                    // we found it, let's look if it is public
                    if (Modifier.isPublic(constructors[i].getModifiers())) {
                        validConstructor = true;
                    } else {
                        validConstructor = false;
                    }
                    // we exit anyway...
                    foundIt = true;;
                }
            }
        } while ((!foundIt) && ((filterClass=filterClass.getSuperclass()) != null));
        
        if (validConstructor) {
            result.addGoodDetails(smh.getLocalString
                (getClass().getName() + ".passed",
                    "Listener class [ {0} ] implements a valid constructor.",
                    new Object[] {filterClass.getName()}));
        } else {
            result.addErrorDetails(smh.getLocalString
                (getClass().getName() + ".failed",
                 "Error: Listener class [ {0} ] does not implement a valid constructor.",
                 new Object[] {clazz.getName()}));
        }   
        return validConstructor;
    }
}
