/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.sun.enterprise.diagnostics.util;

import java.io.File;

import java.io.FilenameFilter;
import java.util.Set;
import java.util.HashSet;

/**
 * Filename filter to filter system applications.
 */
public class SystemAppsFilter implements FilenameFilter {

    // Initialize all system-names.
    // TODO hard coded ? is there a server wide util method ?
    private static Set<String> systemApps = new HashSet<String>();
    static{
        systemApps.add("adminapp");
        systemApps.add("admingui");
        systemApps.add("WSTXServices");
        systemApps.add("__JWSappclients");
        systemApps.add("__ejb_container_timer_app");
        systemApps.add("MEjbApp");
    }

    /**
     * Tests if a specified file should be included in a file list.
     *
     * @param aDir  the directory in which the file was found.
     * @param fileName the name of the file.
     * @return <code>true</code> if and only if the name should be
     *         included in the file list; <code>false</code> otherwise.
     */
    public boolean accept (File aDir, String fileName) {
        boolean result = true;
        if(systemApps.contains(fileName)){
            result = false;
        }
        return result;
    }
}