# !/usr/bin/env python
#    Giplet - GNOME Panel Applet to display an IP Address
#    Copyright (C) 2006  Erik Larson
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#
import sys
try:
    import pygtk
    pygtk.require('2.0')
except:
    pass
try:
    import gtk
    import gtk.glade
    import gconf
    import giplet_globals as gipglobals
except:
    sys.exit(1)
    
class GipPrefs:
    """Giplet Preferences Class"""
    def __init__(self, _conf_path):
        self.interface = 'eth0 wlan0 www.whatismyip.org'
        self.interval = 10
        self.conf_client = gconf.client_get_default()
        self.conf_path = _conf_path
        
    def saveSettings(self, gipDlg):    
        self.interface = gipDlg.txtInterface.get_text()
        self.interval = int(gipDlg.txtTimer.get_text())

    def readFromGConf(self):
        if (self.conf_client.dir_exists(self.conf_path)) :
            interface = self.conf_client.get_string(self.conf_path + "/interface")
            if (not interface == None) :
                self.interface = interface
                self.interval = self.conf_client.get_int(self.conf_path + "/interval")

    def writeToGConf(self):
        self.conf_client.set_int(self.conf_path + "/interval", self.interval)
        self.conf_client.set_string(self.conf_path + "/interface", self.interface)
        
    def printSettings(self):
        print '*** start ***'
        print self.interval
        print self.interface
        print '*** end ***'        
    
class GipPrefsDlg:
    """Giplet Preferences Dialog"""
    
    def __init__(self, gipPrefs):
        #Set the Glade File
        self.gladefile = gipglobals.RES_DIR + "/giplet.glade"
        self.gipPrefs = gipPrefs
        self.getControls()
        self.txtInterface.set_tooltip_text(
            _("giplet shows the first availalbe IP.\nRemove eth*/wlan* if you wanna an external IP."))
        self.txtTimer.set_tooltip_text(
            _("Tell giplet how long to probe IP again, in minute"))
        self.setValues()
        
    def getControls(self):
        # Load the Widget Tree
        self.wTree = gtk.glade.XML(self.gladefile, "pref", "giplet")        
        # Get the Dialog
        self.dlg = self.wTree.get_widget("pref")
        # Get  the IP text boxes
        self.txtInterface = self.wTree.get_widget("interface")
        # Get the Timer Controls
        self.txtTimer = self.wTree.get_widget("timerinterval")                
        
    def setValues(self):
        self.txtInterface.set_text(self.gipPrefs.interface)
        self.txtTimer.set_text(str(self.gipPrefs.interval))
        
    def run(self):        
        # Run the Dialog
        self.result = self.dlg.run()   
        # After Running
        self.gipPrefs.saveSettings(self)
        # Done
        self.dlg.destroy()
        # Return
        return self.result
