/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#ifndef __CHANGED_NOTIFY_PAIR_H__
#define __CHANGED_NOTIFY_PAIR_H__


#include <glib-object.h>


G_BEGIN_DECLS



struct _ChangedNotifyPair {
  GObject *changed_object;
  gint     changed_handler_id;

  GObject *notify_object;
  gint     notify_handler_id;


  gint ref_count;
};
typedef struct _ChangedNotifyPair ChangedNotifyPair;


ChangedNotifyPair* changed_notify_pair_new (GObject *changed_object,
					    GObject *notify_object);
void changed_notify_pair_ref   (ChangedNotifyPair *changed_notify_pair);
void changed_notify_pair_unref (ChangedNotifyPair *changed_notify_pair);

void changed_notify_pair_block_changed_handler   (ChangedNotifyPair *changed_notify_pair);
void changed_notify_pair_unblock_changed_handler (ChangedNotifyPair *changed_notify_pair);
void changed_notify_pair_block_notify_handler    (ChangedNotifyPair *changed_notify_pair);
void changed_notify_pair_unblock_notify_handler  (ChangedNotifyPair *changed_notify_pair);

void changed_notify_pair_changed_connect
				(ChangedNotifyPair *changed_notify_pair,
				 const gchar       *detailed_signal,
				 GCallback          c_handler,
				 gpointer           data);
void changed_notify_pair_notify_connect
				(ChangedNotifyPair *changed_notify_pair,
				 const gchar       *detailed_signal,
				 GCallback          c_handler,
				 gpointer           data);



G_END_DECLS


#endif /* __CHANGED_NOTIFY_PAIR_H__ */
