/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspector-builtin.h"

#include "ginspector-core.h"
#include "ginspector-gtk.h"
#include "ginspector-ui.h"

#include "glrr-gobject.h"



static void builtin_module_init (void);

static gpointer create_window_help (gpointer data,
				    gpointer func_data,
				    gpointer invoke_data);



void
g_inspector_builtin_register_module_window_help (void)
{
  {
    static GInspectorBuiltinModuleInfo builtin_module_info;

    builtin_module_info.name       = "builtin-window-help";
    builtin_module_info.data       = NULL;
    builtin_module_info.init       = builtin_module_init;
    builtin_module_info.activate   = NULL;
    builtin_module_info.deactivate = NULL;

    g_inspector_builtin_register_module (&builtin_module_info);
  }
}

static void
builtin_module_init (void)
{
  g_inspector_register_procedure ("create-window-help",
				  "",
				  G_INSPECTOR_PROCEDURE_TYPE_WINDOW,
				  G_INSPECTOR_ELEMENT_TYPE_NONE,
				  G_TYPE_NONE,
				  create_window_help,
				  NULL);
}



static void
panel_update (GInspectorPanel *panel,
	      gpointer         user_data)
{
  GtkWidget *label;

  label = GTK_WIDGET (user_data);

  gtk_label_set_text (GTK_LABEL (label), "Updated Panel");
}

static gpointer
create_window_help (gpointer data,
		    gpointer func_data,
		    gpointer invoke_data)
{
  GtkWidget *top;
  GtkWidget *window;
  GtkWidget *vbox;
  GtkSizeGroup *size_group;

  window = g_inspector_window_new ();
  top = window;

  gtk_window_set_title (GTK_WINDOW (window), "Help");
  gtk_window_set_default_size (GTK_WINDOW (window), 400, 300);


  {
    vbox = gtk_vbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (window), vbox);
  }

  {
    size_group = gtk_size_group_new (GTK_SIZE_GROUP_BOTH);
  }

  {
    GtkWidget *hbox;

    GtkWidget *panel;
    GtkWidget *label;

    hbox = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start_defaults (GTK_BOX (vbox), hbox);


    {
      GtkWidget *frame;
      GtkWidget *panel_label;

      panel = g_object_new (G_TYPE_INSPECTOR_PANEL,
			    NULL);
      gtk_box_pack_start (GTK_BOX (hbox), panel, FALSE, FALSE, 0);

      frame = g_inspector_panel_frame_new ();
      g_inspector_panel_frame_set_title (G_INSPECTOR_PANEL_FRAME (frame), "Click Me");
      gtk_container_add (GTK_CONTAINER (panel), frame);

      panel_label = gtk_label_new ("Panel");
      gtk_container_add (GTK_CONTAINER (frame), panel_label);

      g_signal_connect (gtk_frame_get_label_widget (GTK_FRAME (frame)),
			"clicked",
			G_CALLBACK (panel_update),
			panel_label);

      gtk_widget_set_size_request (panel, 150, -1);
      gtk_size_group_add_widget (size_group, panel);
    }


    {
      label = gtk_label_new ("Panel.\n"
			     "\n"
			     "To update the panel,\n"
			     "Click the label of the panel frame.");
      gtk_box_pack_start_defaults (GTK_BOX (hbox), label);
    }
  }

  gtk_box_pack_start (GTK_BOX (vbox),
		      gtk_hseparator_new (),
		      FALSE, TRUE, 2);


  {
    GtkWidget *hbox;

    GtkWidget *panel;
    GtkWidget *label;

    hbox = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start_defaults (GTK_BOX (vbox), hbox);


    {
      panel = g_inspector_invoke_procedure_by_name ("create-panel-type-class-hierarchy",
						    GTYPE_TO_POINTER (GDK_TYPE_DRAWABLE),
						    NULL);

      gtk_box_pack_start (GTK_BOX (hbox), panel, FALSE, FALSE, 0);

      gtk_size_group_add_widget (size_group, panel);
    }

    {
      label = gtk_label_new ("Element tree.\n"
			     "\n"
			     "element\n"
			     "  Button 1 click: Invoke procedure\n"
			     "  Button 3 press: Popup menu\n"
			     "\n"
			     "other place\n"
			     "  Button press: popup tree menu");
      gtk_box_pack_start_defaults (GTK_BOX (hbox), label);
    }
  }

  gtk_box_pack_start (GTK_BOX (vbox),
		      gtk_hseparator_new (),
		      FALSE, TRUE, 2);

  {
    GtkWidget *hbox;

    GtkWidget *panel;
    GtkWidget *label;

    hbox = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start_defaults (GTK_BOX (vbox), hbox);


    {
      GType dummy_a;
      GType dummy_b;
      dummy_a = GTK_TYPE_IM_CONTEXT_SIMPLE;
      dummy_b = GTK_TYPE_IM_MULTICONTEXT;

      panel = g_inspector_invoke_procedure_by_name ("create-panel-settings-list",
						    NULL,
						    NULL);
      gtk_box_pack_start (GTK_BOX (hbox), panel, FALSE, FALSE, 0);

      gtk_size_group_add_widget (size_group, panel);
    }

    {
      label = gtk_label_new ("Element list.\n"
			     "\n"
			     "element\n"
			     "  Button 1 d-click: Invoke procedure\n"
			     "  Button 3 press: Popup menu");
      gtk_box_pack_start_defaults (GTK_BOX (hbox), label);
    }
  }



  g_object_unref (size_group);

  gtk_widget_show_all (top);


  return top;
}
