/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#undef GTK_DISABLE_DEPRECATED /* XXX */

#include "ginspector-builtin.h"

#include "ginspector-core.h"
#include "ginspector-gtk.h"
#include "ginspector-ui.h"

#include "ginspector-gtk-tag-deprecated.h"



static void builtin_module_init (void);

static gpointer popup_main_window (gpointer data,
				   gpointer func_data,
				   gpointer invoke_data);

static void init_main_item_factory (void);
static void main_window_activate   (GInspectorContext *context,
				    gpointer           user_data);



void
g_inspector_builtin_register_module_main_window (void)
{
  {
    static GInspectorBuiltinModuleInfo builtin_module_info;

    builtin_module_info.name       = "builtin-main-window";
    builtin_module_info.data       = NULL;
    builtin_module_info.init       = builtin_module_init;
    builtin_module_info.activate   = NULL;
    builtin_module_info.deactivate = NULL;

    g_inspector_builtin_register_module (&builtin_module_info);
  }
}

static void
builtin_module_init (void)
{
  g_inspector_register_procedure ("popup-main-window",
				  "",
				  G_INSPECTOR_PROCEDURE_TYPE_WINDOW,
				  G_INSPECTOR_ELEMENT_TYPE_NONE,
				  G_TYPE_NONE,
				  popup_main_window,
				  NULL);

  {
    init_main_item_factory ();
  }

  {
    GInspectorContext *context;

    context = g_inspector_get_context ();


    g_signal_connect_after (context,
			    "activate",
			    G_CALLBACK (main_window_activate),
			    NULL);
  }
}

static void
main_window_activate (GInspectorContext *context,
		      gpointer           user_data)
{
  g_inspector_invoke_procedure_by_name ("popup-main-window",
                                        NULL,
                                        NULL);
}



/*
 *
 */
static void construct_menu (GtkItemFactory *item_factory);

static GtkItemFactory *g_inspector_main_item_factory = NULL;

static void
init_main_item_factory (void)
{
  GtkItemFactory *item_factory;

  item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR,
				       "<GInspectorMain>",
				       NULL);
  g_inspector_main_item_factory = item_factory;

  construct_menu (item_factory);

  g_inspector_tag_to_widgets_of_item_factory (item_factory);

}

static void
menu_activate (GtkWidget *widget,
	       gpointer   callback_data,
	       guint      callback_action)
{
  gchar *func_name;

  func_name = (gchar *)callback_data;

  if (func_name != NULL)
    {
      g_inspector_invoke_procedure_by_name (func_name,
					    NULL,
					    NULL);
    }
}

static void
append_item (GtkItemFactory *item_factory,
	     gchar          *item_path,
	     gchar          *item_type,
	     gchar          *func_name)
{
  GtkItemFactoryEntry real_entry;
  GtkItemFactoryEntry *entry;

  entry = &real_entry;

  entry->path            = item_path;
  entry->accelerator     = NULL;
  entry->callback        = (item_type ? NULL : menu_activate);
  entry->callback_action = 0;
  entry->item_type       = item_type;
  entry->extra_data      = NULL;


  gtk_item_factory_create_item (item_factory,
				entry,
				func_name,
				2);
}

void
g_inspector_main_menu_append_item (gchar *item_path,
				   gchar *item_type,
				   gchar *func_name)
{
  append_item (g_inspector_main_item_factory,
	       item_path,
	       item_type,
	       func_name);
}


/*
 *
 */

static GtkWidget *
create_main_window (void)
{
  GtkWidget *window;
  GtkWidget *vbox;
  GtkWidget *table;

  window = g_inspector_window_new ();

  gtk_window_set_title (GTK_WINDOW (window), "G Inspector");
  g_signal_connect (window,
		    "delete-event",
		    G_CALLBACK (gtk_true),
		    NULL);

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (window), vbox);


  {
    GtkItemFactory *item_factory;

    item_factory = g_inspector_main_item_factory;

    gtk_box_pack_start
      (GTK_BOX (vbox),
       GTK_WIDGET (gtk_item_factory_get_widget (item_factory,
						"<GInspectorMain>")),
       FALSE, FALSE, 0);
  }

  {
    GtkWidget *w;

    w = g_inspector_invoke_procedure_by_name ("create-panel-process-generic-info",
					      NULL,
					      NULL);

    gtk_box_pack_start_defaults (GTK_BOX (vbox), w);
  }

  return window;
}

/*
 *
 */

static GtkWidget *main_window = NULL;

static gpointer
popup_main_window (gpointer data,
		   gpointer func_data,
		   gpointer invoke_data)
{
  if (main_window == NULL)
    {
      main_window = create_main_window ();
      g_signal_connect (main_window,
                        "destroy", G_CALLBACK (gtk_widget_destroyed), &main_window);

      gtk_widget_show_all (main_window);
   }
  else
    {
      gdk_window_raise (GTK_WIDGET (main_window)->window);      
    }

  return NULL;
}


/*
 *
 */

typedef struct _MyMenuEntry MyMenuEntry;

struct _MyMenuEntry {
  gchar           *item_path;
  gchar           *item_type;

  gchar           *func_name;
};

static MyMenuEntry menu_items[] = {
#define B   "<Branch>"
#define T   "<Tearoff>"
#define SEP "<Separator>"

  { "/Inspector",                   B,	  NULL },
#if 0
  { "/Inspector/Preferences",       NULL, NULL },
  { "/Inspector/---",               SEP,  NULL },
#endif
  { "/Inspector/About...",          NULL, "create-window-about" },
  { "/Inspector/Help",              NULL, "create-window-help" },
  { "/Inspector/---",               SEP,  NULL },
  { "/Inspector/gtk__main__quit()", NULL, "misc-gtk-main-quit" },

  { "/View",				B,    NULL },
  { "/View/---",			T,    NULL },
  { "/View/Widget Picker",		NULL, "create-window-widget-picker" },
  { "/View/Pickup List",		NULL, "create-window-pickup-list" },
  { "/View/---",			SEP,  NULL },
  { "/View/Widget List",		NULL, "create-window-widget-list" },
  { "/View/Widget Tree",		NULL, "create-window-all-toplevels-hierarchy" },
  { "/View/---",			SEP,  NULL },
  { "/View/GType List",			NULL, "create-window-type-list" },
  { "/View/GType Tree",			NULL, "create-window-all-types-hierarchy" },
  { "/View/---",			SEP,  NULL },
  { "/View/Signal List",		NULL, "create-window-signal-list" },
  { "/View/Property List",		NULL, "create-window-property-list" },
  { "/View/Child Property List",	NULL, "create-window-child-property-list" },
  { "/View/---",			SEP,  NULL },
  { "/View/Stock Item List",		NULL, "create-window-stock-item-list" },
  { "/View/Quark List",			NULL, "create-window-quark-list" },
  { "/View/---",			SEP,  NULL },
  { "/View/GdkDisplay List",		NULL, "create-window-display-list" },
  { "/View/GdkScreen List",		NULL, "create-window-screen-list" },
  { "/View/GtkSettings List",		NULL, "create-window-settings-list" },
  { "/View/---",			SEP,  NULL },
  { "/View/GtkRc Stuff",		NULL, "create-window-rc-stuff" },
  { "/View/---",			SEP,  NULL },
  { "/View/Loupe",			NULL, "create-window-loupe" },
  { "/View/---",			SEP,  NULL },

#undef B
#undef T
#undef SEP
};
static int nmenu_items = G_N_ELEMENTS (menu_items);

static void
construct_menu (GtkItemFactory *item_factory)
{
  int i;

  for (i = 0; i < nmenu_items; ++i)
    {
      MyMenuEntry *entry;
      gchar *item_path;
      gchar *item_type;
      gchar *func_name;

      entry = &(menu_items[i]);

      item_path = entry->item_path;
      item_type = entry->item_type;
      func_name = entry->func_name;

      append_item (item_factory, item_path, item_type, func_name);
    }

  g_inspector_tag_to_widgets_of_item_factory (item_factory);
}
