/*
*  $Id: GFooExtensionView.h 3681 2011-04-12 10:53:31Z tovar $
*  Proyecto Ginkgo
*
*  Copyright 2008 MetaEmotion S.L. All rights reserved.
*
*/
#pragma once

#include "gfooextensionbaseviews.h"

#include <export/iherramientapuntero.h>
#include <export/iherramientaregla.h>
#include <export/iherramientaangulo.h>
#include <export/iherramientaelevacion.h>
#include <api/inotificadoresherramientas.h>
#include <api/icontroladoreventos.h>
#include <api/ianotador.h>

#include <vtkSmartPointer.h>
#include <vtkImageBlend.h>
#include <vtkContourFilter.h>
#include <vtkPolyDataMapper.h>
#include <vtkImageMapToColors.h>
#include <vtkContourFilter.h>
#include <vtkActor.h>
#include <vtkImageData.h>
#include <vector>


namespace FooExtension{
	class FooExtensionView;
	namespace GUI {
		class GFooExtensionView: public GFooExtensionViewBase, public GNC::GCS::IContratoWidgets, public GNC::GCS::IObservador, public GNC::GCS::IAnotador
		{
		public:
			GFooExtensionView(FooExtensionView* pView);
			~GFooExtensionView();

			void InitPipeline();

			//region "Events"
			virtual void OnPaint(wxPaintEvent& evt);
			virtual void OnEraseBackground( wxEraseEvent& event );
			virtual void OnFocus(wxChildFocusEvent& event);
			virtual void OnSize(wxSizeEvent& event);
			void OnMouseWheel( wxMouseEvent& event );
			void OnKeyDown( wxKeyEvent& event );
			void GoToSlice(int i);
			void OnScrollSliderSerie(wxScrollEvent& event);
			//	view this slice number
			void SetSlice(unsigned int vid, bool force = false);

			//Widgets contract
			virtual vtkGinkgoImageViewer* GetViewer();

			//Ginkgo CADx events interface
			void PreProcesarEvento(GNC::GCS::Eventos::IEvento* evt, GNC::GCS::IControladorEventos::TipoListaPunterosEventos& lista);
			void ProcesarEvento(GNC::GCS::Eventos::IEvento *evt) ;
			//

			//Ianotador
			virtual std::string GetTopLeftAnnotation(GNC::GCS::Contexto3D* c);
			virtual std::string GetTopRightAnnotation(GNC::GCS::Contexto3D* c);
			virtual std::string GetBottomLeftAnnotation(GNC::GCS::Contexto3D* c);
			virtual std::string GetBottomRightAnnotation(GNC::GCS::Contexto3D* c);
			virtual std::string GetAnotacionPosicion(GNC::GCS::Vector* pPosicionRaton);
			//

		protected:
			FooExtension::FooExtensionView*               IView;
		};
	}
}
