/*
 *  
 *  $Id: ginkgoresourcemanager.h 4511 2012-01-12 07:34:48Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/api.h>
#include <wx/bitmap.h>
#include <wx/animate.h>

 class EXTAPI GinkgoResourcesManager {

 	public:

 	// Adquisicion
 	class EXTAPI Adquisicion {
 		public:
		static const wxBitmap GetIcoAdquirirArchivo();
		static const wxBitmap GetIcoAdquirirPACS();
		static const wxBitmap GetIcoDownload();
		static const wxBitmap GetIcoClear();
		static const wxBitmap GetIcoEliminarDescarga();
 	};

 	class EXTAPI BarraAngulo {
 		public:
		static const wxBitmap GetIcoAnguloCobb();
		static const wxBitmap GetIcoAnguloNormal();
 	};

 	class EXTAPI BarraChroma {
 		public:
		static const wxBitmap GetIcoAmbitoGlobal();
		static const wxBitmap GetIcoAmbitoLocal();
		static const wxBitmap GetIcoChroma();
		static const wxBitmap GetIcoInvertir();
		static const wxBitmap GetIcoPiel();
		static const wxBitmap GetIcoTodoChroma();
		static const wxBitmap GetIcoTodoPiel();
		static const wxBitmap GetTodosChroma();
 	};

 	class EXTAPI BarraElevacion {
 		public:
		static const wxBitmap GetIcoAumentarValoracion();
		static const wxBitmap GetIcoDisminuirValoracion();
 	};

 	class EXTAPI BarraLupa {
 		public:
		static const wxBitmap GetIcoZoomIn();
		static const wxBitmap GetIcoZoomOut();
 	};

	class EXTAPI BarraRejilla {
 		public:
		static const wxBitmap GetIcoVerRejilla();
		static const wxBitmap GetIcoOcultarRejilla();
 	};

 	class EXTAPI BarraWindowLevel {
 		public:
		static const wxBitmap GetIcoReset();
 	};

 	class EXTAPI BarraMarcado {
 		public:
 		static const wxBitmap GetIcoElipse();
 		static const wxBitmap GetIcoFlecha();
 		static const wxBitmap GetIcoPoligono();
 		static const wxBitmap GetIcoPunto();
 		static const wxBitmap GetIcoRectangulo();
 		static const wxBitmap GetIcoTrapezoide();
 	};

 	class EXTAPI PanelHistorial {
 		public:
		static const wxBitmap GetIcoEstudio();
		static const wxBitmap GetIcoSerie();
		static const wxBitmap GetIcoImagen();
		static const wxBitmap GetIcoHistorial();
		static const wxBitmap GetIcoHistorialOpen();
		static const wxBitmap GetIcoHombre();
		static const wxBitmap GetIcoMujer();
		static const wxBitmap GetIcoOtro();
		static const wxBitmap GetIcoFicheroClave();
		static const wxBitmap GetIcoPlegar();
		static const wxBitmap GetIcoDesplegar();
		static const wxBitmap GetMoviePreview();
		static const wxBitmap GetIcoCleanAll();
		static const wxBitmap GetIcoAllPatients();
 	};

 	class EXTAPI IconosHerramientas {
 		public:
 		static const wxBitmap GetIcoAngulo();
 		static const wxBitmap GetIcoAnotacion();
 		static const wxBitmap GetIcoCruz();
 		static const wxBitmap GetIcoElevacion();
 		static const wxBitmap GetIcoFlecha();
 		static const wxBitmap GetIcoLongitud();
 		static const wxBitmap GetIcoPoligono();
 		static const wxBitmap GetIcoVarita();
		static const wxBitmap GetIcoLazoChroma();
 		static const wxBitmap GetIcoWindowLevel();
 		static const wxBitmap GetIcoZoom();
		static const wxBitmap GetIcoSinOpciones();
		static const wxBitmap GetIcoDebug();
		static const wxBitmap GetIcoMarcado();
		static const wxBitmap GetIcoRejilla();
		static const wxBitmap GetIcoMostrarOcultarTags();
		static const wxBitmap GetIcoDesencajar();
		static const wxBitmap GetIcoCornerAnnotations();
		static const wxBitmap GetIcoInforme();
		static const wxBitmap GetIcoSlider();
		static const wxBitmap GetIcoLupa();
		static const wxBitmap GetIcoPan();
		static const wxBitmap GetIcoMouseR();
		static const wxBitmap GetIcoMouseL();
		static const wxBitmap GetIcoMouseRL();
	};

 	class EXTAPI IconosMenus {
 		public:
 		static const wxBitmap GetIcoAbrir();
		static const wxBitmap GetIcoOpenDir();
		static const wxBitmap GetIcoRemovableUnit();
		static const wxBitmap GetIcoOpenFile();
 		static const wxBitmap GetIcoCerrarTab();
 		static const wxBitmap GetIcoConfiguracion();
 		static const wxBitmap GetIcoEditor();
 		static const wxBitmap GetIcoExportar();
 		static const wxBitmap GetIcoFiltrado();
 		static const wxBitmap GetIcoGuardar();
 		static const wxBitmap GetIcoImportar();
		static const wxBitmap GetIcoDicomDir();
 		static const wxBitmap GetIcoReset();
 		static const wxBitmap GetIcoSalir();
		static const wxBitmap GetIcoImpresora();
		static const wxBitmap GetIcoVistaPreliminar();
		static const wxBitmap GetIcoCalibrarImagen();
		static const wxBitmap GetIcoEliminar();
		static const wxBitmap GetIcoEliminarTodo();
		static const wxBitmap GetIcoEditar();
		static const wxBitmap GetIcoSendToPACS();
		static const wxBitmap GetIcoEliminarWidget();
		static const wxBitmap GetIcoPantallaCompleta();
		static const wxBitmap GetIcoUser();
		static const wxBitmap GetIcoHelp();
		static const wxBitmap GetIcoSupport();
		static const wxBitmap GetIcoObtainExtensions();
 	};

 	class EXTAPI Logos {
 		public:
 		static const wxBitmap GetLogoGinkgo48x48();
		static const wxBitmap GetLogoGinkgo16x16();
		static const wxBitmap GetLogoGinkgo32x32();
		static const wxBitmap GetLogoSplash();
		static const wxBitmap GetLogoBackground();
		static const wxBitmap GetExtensionsLogo();
		static const wxBitmap GetExtensionsErrorLogo();
 	};

	class EXTAPI Cursores {
		public:
		static const wxImage GetCursorTransparente();
		static const wxImage GetCursorLupa();
		static const wxImage GetCursorCrearLinea();
		static const wxImage GetCursorManoAbierta();
		static const wxImage GetCursorManoCerrada();
		static const wxImage GetCursorSeleccionar();
		static const wxImage GetCursorCrearAnguloCobb();
		static const wxImage GetCursorCrearAnguloNormal();
		static const wxImage GetCursorCrearAnotacion();
		static const wxImage GetCursorCrearElipse();
		static const wxImage GetCursorCrearPoligono();
		static const wxImage GetCursorCrearPunto();
		static const wxImage GetCursorCrearRectangulo();
		static const wxImage GetCursorWindowLevel();
		static const wxImage GetCursorAnclaSimple();
		static const wxImage GetCursorAnclaCompuesta();
	};

	class EXTAPI BarraProgreso {
 		public:
		static const wxAnimation GetIcoLoading();
		static const wxBitmap GetIcoStopped();
 	};

	class EXTAPI AcercaDe {
		public:
		static const wxBitmap GetIcoAcercaDe();
	};

	class EXTAPI Wizards {
	public:
		static const wxBitmap GetIcoBarraSuperior();
	};

	class EXTAPI BarraLayout {
	public:
		static const wxBitmap GetIcoAddColumna();
		static const wxBitmap GetIcoAddFila();
		static const wxBitmap GetIcoDelColumna();
		static const wxBitmap GetIcoDelFila();
		static const wxBitmap GetIcoLayout1x1();
		static const wxBitmap GetIcoLayout1x2();
		static const wxBitmap GetIcoLayout2x1();
		static const wxBitmap GetIcoLayout2x2();
		static const wxBitmap GetIcoLayout3x3();
		static const wxBitmap GetIcoLayout4x4();
	};

	class EXTAPI MenusTabs {
	public:
		static const wxBitmap GetIcoCerrarTab();
		static const wxBitmap GetIcoPrimerPlano();
		static const wxBitmap GetIcoGrid2Col();
		static const wxBitmap GetIcoGrid3Col();
		static const wxBitmap GetIcoReagrupar();
	};

	class EXTAPI BarraCine {
	public:
		static wxBitmap GetIcoPlay();
		static wxBitmap GetIcoBucle();
		static wxBitmap GetIcoNoBucle();
		static wxBitmap GetIcoStop();		
		static wxBitmap GetIcoPause();	
		static wxBitmap GetIcoCine();		
	};

 };
