/*
 *  
 *  $Id: toolwindowlevel.cpp 4533 2012-01-16 08:20:00Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE
#include <wx/aui/aui.h>
#include <wx/stattext.h>
#include <wx/combobox.h>
#include <wx/valtext.h>
#include <wx/textctrl.h>
#include <wx/menu.h>

#include <api/api.h>
#include <api/globals.h>
#include <api/inotificadoresherramientas.h>

#include "toolwindowlevel.h"
#include <api/iwidgetsmanager.h>
#include <resources/ginkgoresourcemanager.h>
#include <main/entorno.h>
#include <main/controllers/controladoreventos.h>
#include <main/controllers/controladorlog.h>
#include <eventos/eventosginkgo.h>


#ifdef __DEPRECATED
#undef __DEPRECATED
#endif
#include <vtk/vtkginkgoimageviewer.h>
#include <vtkImageData.h>
#include <vtkPointData.h>

#include <vtkImageData.h>
#include <vtkRenderWindowInteractor.h>
#include <vtkSmartPointer.h>
#include <vtkObject.h>
#include <vtkPointData.h>
#include <vtkImageData.h>
#include <vtkLookupTable.h>
#include <vtkImageActor.h>
#include <vtkRenderWindow.h>
#include <vtkRenderer.h>

#define RESETEAR_WINDOWLEVEL 1221
#define FIRST_WINDOW_LEVEL 1222

namespace GNC {
	namespace GUI {
		class EventHandlerWindowLevel: public wxEvtHandler {
		public:
			EventHandlerWindowLevel(wxWindow* pParent, GNC::ToolWindowLevel* pHerramienta, GNC::GCS::IContractWindowLevel::ListaWindowLevels* pListaWindowLevels):wxEvtHandler()
			{
				m_pParent = pParent;
				m_pHerramienta=pHerramienta;
				m_pWindowLevelList = pListaWindowLevels;
				// Connect Events
				m_pParent->Connect(wxID_ANY, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( EventHandlerWindowLevel::OnMenuWindowLevelClick),NULL,this);
			}

			~EventHandlerWindowLevel()
			{
				m_pParent->Disconnect(wxID_ANY, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( EventHandlerWindowLevel::OnMenuWindowLevelClick),NULL,this);
				m_pParent = NULL;
				m_pHerramienta = NULL;
			}

			
			virtual void OnMenuWindowLevelClick( wxCommandEvent& event ){
				if (event.GetId() == RESETEAR_WINDOWLEVEL) {
					m_pHerramienta->Resetear();
				} else {
					if (m_pWindowLevelList != NULL) {
						int index = event.GetId() - FIRST_WINDOW_LEVEL;
						GNC::GCS::IContractWindowLevel::ListaWindowLevels::iterator it = m_pWindowLevelList->begin();
						for (int i = 0;index != i && it != m_pWindowLevelList->end(); ++it, ++i);
						if (it != m_pWindowLevelList->end()) {
							m_pHerramienta->SetWindowLevel((*it).m_label);
						}
					}
				}
				event.Skip(false);
			}		

			GNC::ToolWindowLevel* m_pHerramienta;
			wxWindow* m_pParent;
			GNC::GCS::IContractWindowLevel::ListaWindowLevels* m_pWindowLevelList;
		};

		class MenuItemWindowLevel : public wxMenuItem {
		public:
			MenuItemWindowLevel(wxWindow* pParent, long id, const wxString& nombre, wxMenu* pMenuPadre, GNC::ToolWindowLevel* pHerramienta, GNC::GCS::IContractWindowLevel::ListaWindowLevels* pListaWindowLevels):wxMenuItem(pMenuPadre,id,nombre,nombre,wxITEM_CHECK) {
				pEventHandler = new EventHandlerWindowLevel(pParent,pHerramienta, pListaWindowLevels);
			}
			~MenuItemWindowLevel() {
				if(pEventHandler != NULL) {
					delete pEventHandler;
					pEventHandler = NULL;
				}
			}
			EventHandlerWindowLevel* pEventHandler;
		};
	}
}

//----------------------------------------------------------------------

GNC::ToolWindowLevel::ToolWindowLevel()
{
	m_Descripcion = _Std("Window/Level\tCtrl+W");
	m_IsDropDown = true;
	m_AcceleratorCode = m_Descripcion[m_Descripcion.size() - 1];

	m_Icono = GinkgoResourcesManager::IconosHerramientas::GetIcoWindowLevel();
}

GNC::ToolWindowLevel::~ToolWindowLevel()
{
}


//region "Realizacion de la interfaz IHerramienta"

void GNC::ToolWindowLevel::CrearPaneles( wxPanel* )
{
	m_pAbstractPanelHerramientaOpciones = NULL;
}

bool GNC::ToolWindowLevel::AppendInMenu(wxWindow* pParent, wxMenu* pMenuParent)
{
	GNC::GCS::IContractWindowLevel::ListaWindowLevels* pList = NULL;
	double window = -1, level = -1;

	TContratableWindowLevel::IteradorListaContratos itWindowLevel = TContratableWindowLevel::m_pListaActiva->begin();
	TContractableWidgets::IteradorListaContratos itWidgets = TContractableWidgets::m_pListaActiva->begin();
	for (; itWindowLevel != TContratableWindowLevel::m_pListaActiva->end() && itWidgets != TContractableWidgets::m_pListaActiva->end(); itWindowLevel++,itWidgets++) {
		TContractWidgets* pCW = (*itWidgets);
		TContratoWindowLevel* pCWL = (*itWindowLevel);
		if (pCW->Inicializado()) {
			pList = &pCWL->m_listaWindowLevels;
			vtkGinkgoImageViewer* pIV = pCW->GetViewer();
			window = pIV->GetWindow();
			level = pIV->GetLevel();
		}
	}
	if (pList != NULL && !pList->empty()) {
		bool inserted = false;
		//first file
		int i = FIRST_WINDOW_LEVEL;
		for (GNC::GCS::IContractWindowLevel::ListaWindowLevels::iterator it = pList->begin(); it != pList->end(); it++) {
			if ((*it).m_type == TContratoWindowLevel::WindowLevel::TWLT_FILE) {
				wxMenuItem* pItem = new GNC::GUI::MenuItemWindowLevel(pParent,i++, wxString::FromUTF8((*it).m_label.c_str()), pMenuParent,this, pList);
				pMenuParent->Append(pItem);
				pMenuParent->Check(pItem->GetId(), (window == (*it).m_window && level == (*it).m_level));
				inserted = true;
			}
		}
		if (inserted) {
			pMenuParent->AppendSeparator();
		}
		inserted = false;
		for (GNC::GCS::IContractWindowLevel::ListaWindowLevels::iterator it = pList->begin(); it != pList->end(); it++) {
			if ((*it).m_type == TContratoWindowLevel::WindowLevel::TWLT_PREDEFINED) {
				wxMenuItem* pItem = new GNC::GUI::MenuItemWindowLevel(pParent,i++, wxString::FromUTF8((*it).m_label.c_str()), pMenuParent,this, pList);
				pMenuParent->Append(pItem);
				pMenuParent->Check(pItem->GetId(), (window == (*it).m_window && level == (*it).m_level));
				inserted = true;
			}
		}
		if (inserted) {
			pMenuParent->AppendSeparator();
		}
	}

	{
		wxMenuItem* pReset = new GNC::GUI::MenuItemWindowLevel(pParent,RESETEAR_WINDOWLEVEL,_("Reset to default"), pMenuParent,this, pList);
		pMenuParent->Append(pReset);
		pMenuParent->Check(pReset->GetId(), false);
	}
	
	return true;
}

void GNC::ToolWindowLevel::ConectarContratoFalso(bool activar) {
	if (TContratableWindowLevel::m_pListaActiva == NULL || TContractableWidgets::m_pListaActiva == NULL) {
		//std::cerr << "Error: Se trato de activar el modo deshabilitado de una vista sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		return;
	}

	TContratableWindowLevel::IteradorListaContratos itWindowLevel = TContratableWindowLevel::m_pListaActiva->begin();
	TContractableWidgets::IteradorListaContratos itWidgets = TContractableWidgets::m_pListaActiva->begin();

	for (; itWindowLevel != TContratableWindowLevel::m_pListaActiva->end() && itWidgets != TContractableWidgets::m_pListaActiva->end(); itWindowLevel++,itWidgets++) {
		TContractWidgets* pC = (*itWidgets);
		if (pC->Inicializado()) {
			if (activar) {
				GTRACE( "ToolWindowLevel: Conectando contrato falso de vista " << TContratableWindowLevel::m_pVistaActiva );
				pC->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
			}
			else {
				GTRACE( "ToolWindowLevel: Desconectando contrato falso de vista " << TContratableWindowLevel::m_pVistaActiva );
				pC->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
			}
		}
	}
}

void GNC::ToolWindowLevel::SetVistaActiva(GNC::GCS::IVista* pVista) {
	TContratableWindowLevel::EstablecerVistaActiva(pVista);
	TContractableWidgets::EstablecerVistaActiva(pVista);
	GTRACE("GNC::TContratableWindowLevel::EstablecerVistaActiva(pVista);::SetVistaActiva(" <<  pVista << ")");
}

// FIXME: Aviso!!!! para que funcione deben contratarse contratos pareados obligatorios y en el mismo orden
void GNC::ToolWindowLevel::ConectarContratos(bool activar)
{
	if (TContratableWindowLevel::m_pListaActiva == NULL || TContractableWidgets::m_pListaActiva == NULL) {
		if (activar) {
			std::cerr << "Error: Se trataron de conectar contratos sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		} else {
			if (m_pWindowLevelBuilder != NULL) {
				delete m_pWindowLevelBuilder;
				m_pWindowLevelBuilder = NULL;
			}
		}
		return;
	}

	// Recorrido de los contratos.
	TContratableWindowLevel::IteradorListaContratos itWindowLevel = TContratableWindowLevel::m_pListaActiva->begin();
	TContractableWidgets::IteradorListaContratos itWidgets = TContractableWidgets::m_pListaActiva->begin();

	for (; itWindowLevel != TContratableWindowLevel::m_pListaActiva->end() && itWidgets != TContractableWidgets::m_pListaActiva->end(); itWindowLevel++,itWidgets++) {
		TContractWidgets* pCW = (*itWidgets);
		if (pCW->Inicializado()) {
			if (activar) {
				GTRACE("ToolWindowLevel: Conectando contratos de vista " << pCW->GetViewer() );
				// Subscribimos los eventos de la ventana a un metodo especifico del panel de esta herramienta
				// Usamos de Id de grupo el valor del puntero de la herramienta, que es unico y no cambia
				m_pWindowLevelBuilder = new GNC::GCS::Widgets::WWindowLevelBuilder(pCW->GetManager(), GetTriggerButton(), (unsigned long)this);
				m_pWindowLevelBuilder->SetObservador(this);
				pCW->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pCW->GetManager()->SetCursor(m_pWindowLevelBuilder->GetCursor());
			}
			else {
				GTRACE( "ToolWindowLevel: Desconectando contratos de vista " << pCW->GetViewer() );
				if (m_pWindowLevelBuilder != NULL) {
					delete m_pWindowLevelBuilder;
					m_pWindowLevelBuilder = NULL;
				}
				pCW->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pCW->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
			}
		}
	}
}


//region "Realización de la interfaz IHerramienta"

void GNC::ToolWindowLevel::OnStart() {
	TContractableWidgets::IteradorListaContratos itWidgets = TContractableWidgets::m_pListaActiva->begin();
	for (; itWidgets != TContractableWidgets::m_pListaActiva->end(); itWidgets++) {
		TContractWidgets* pCW = (*itWidgets);
		vtkGinkgoImageViewer* pIV = pCW->GetViewer();
		double window = pIV->GetColorWindow();
		double level = pIV->GetColorLevel();
		m_WindowLevelInicial[pCW] = GNC::GCS::IContractWindowLevel::WindowLevel("",window, level, TContratoWindowLevel::WindowLevel::TWLT_PREDEFINED);
	}
}


void GNC::ToolWindowLevel::OnAjuste(TVector& start, TVector& stop) {
	GTRACE("GNC::ToolWindowLevel::OnAjuste()");

	TContractableWidgets::IteradorListaContratos itWidgets = TContractableWidgets::m_pListaActiva->begin();
	for (TContratableWindowLevel::IteradorListaContratos itWindowLevel = TContratableWindowLevel::m_pListaActiva->begin(); itWidgets != TContractableWidgets::m_pListaActiva->end(); itWidgets++, itWindowLevel++) {
		TContractWidgets* pCW = (*itWidgets);
		TContratoWindowLevel* pCWL = (*itWindowLevel);
		vtkGinkgoImageViewer* pIV = pCW->GetViewer();

		GNC::GCS::IContractWindowLevel::WindowLevel& wlInicial = m_WindowLevelInicial[pCW];

		int* size = pIV->GetRenderWindow()->GetSize();

		TVector delta = ((stop - start) * 2) / TVector(size[0], size[1]);

		GTRACE("delta     " << delta << " window inicial: "<<wlInicial.m_window << " level inicial " << wlInicial.m_level)

		if (std::abs(wlInicial.m_window) > 0.01) {
			delta.x *= wlInicial.m_window;
		}
		else {
			delta.x *= (wlInicial.m_window < 0 ? -0.01 : 0.01);
		}
		if (std::abs(wlInicial.m_level) > 0.01) {
			delta.y *= wlInicial.m_level;
		}
		else {
			delta.y *= (wlInicial.m_level < 0 ? -0.01 : 0.01);
		}

		// Abs so that direction does not flip

		if (wlInicial.m_window < 0.0) {
			delta.x *= -1.0f;
		}
		if (wlInicial.m_level < 0.0) {
			delta.y *= -1.0f;
		}

		// Compute new window level

		double newWindow = delta.x + wlInicial.m_window;
		double newLevel = wlInicial.m_level - delta.y;

		GTRACE("delta final     " << delta << " new window "<<newWindow<<" new level "<<newLevel)

		// Stay away from zero and really

		newWindow = std::max((double)0.01f, newWindow);
		if (std::abs(newLevel) < 0.01)
		{
			newLevel = 0.01*(newLevel < 0 ? -1 : 1);
		}

		double newClampedWindow = newWindow;
		double newClampedLevel = newLevel;
		ClampWindowLevel(newWindow, newLevel, newClampedWindow, newClampedLevel);

		pCWL->SetUserDefinedWindowLevel(newClampedWindow, newClampedLevel);
		SetWindowLevel(newClampedWindow, newClampedLevel);
	}
}

void GNC::ToolWindowLevel::OnEnd() {
	m_WindowLevelInicial.clear();
}

//endregion

//region "metodos propios de la herramienta window/level"

void GNC::ToolWindowLevel::ClampWindowLevel(double window, double level, double& clampedWindow, double& clampedLevel) {
	TContractableWidgets::IteradorListaContratos itWidgets = TContractableWidgets::m_pListaActiva->begin();
	TContratableWindowLevel::IteradorListaContratos itWL = TContratableWindowLevel::m_pListaActiva->begin();
	clampedWindow = window;
	clampedLevel = level;
	/*
	double range[2];
	for (; itWidgets != TContractableWidgets::m_pListaActiva->end() && itWL != TContratableWindowLevel::m_pListaActiva->end(); itWidgets++,itWL++) {
		TContractWidgets* pCW = (*itWidgets);
		TContratoWindowLevel* pCWL = (*itWL);
		if (pCW != NULL && pCWL != NULL) {
			vtkGinkgoImageViewer* pIV = pCW->GetViewer();
			if (pIV != NULL) {
				vtkImageData* pImg = pIV->GetInput();
				pImg->GetScalarRange(range);
				clampedWindow = std::min( std::max(window, (double)1.0f), (range[1] - range[0]) );
				clampedLevel = std::min( std::max( level, range[0]), range[1] );

				if (clampedLevel != level || clampedWindow != window) {
					LOG_DEBUG("W/L", window << "/" << level << " clamped to  " << clampedWindow << "/" << clampedLevel);
				}
			}
		}
	}
	*/

}

void GNC::ToolWindowLevel::SetWindowLevel(const std::string& label) 
{
	for (TContratableWindowLevel::IteradorListaContratos itWindowLevel = TContratableWindowLevel::m_pListaActiva->begin(); itWindowLevel != TContratableWindowLevel::m_pListaActiva->end(); itWindowLevel++) {
		for (TContratoWindowLevel::ListaWindowLevels::iterator it = (*itWindowLevel)->m_listaWindowLevels.begin(); it != (*itWindowLevel)->m_listaWindowLevels.end(); ++it) {
			if ( (*it).m_label == label) {
				(*itWindowLevel)->m_labelCurrent = label;
				SetWindowLevel((*it).m_window, (*it).m_level);
				return;
			}
		}
	}
}

void GNC::ToolWindowLevel::SetWindowLevel(double window, double level){
	if(Habilitada()){		
		GTRACE("GNC::ToolWindowLevel::Resetear()");
		GNC::GCS::Eventos::EventoModificacionImagen* pEvt = new GNC::GCS::Eventos::EventoModificacionImagen(TContratableWindowLevel::m_pVistaActiva,GNC::GCS::Eventos::EventoModificacionImagen::VisualizacionImagenModificada, -1);
		pEvt->SetWindow(window);
		pEvt->SetLevel(level);
		GNC::Entorno::Instance()->GetControladorEventos()->ProcesarEvento(pEvt);
	}
}

void GNC::ToolWindowLevel::Resetear() {
	GTRACE("GNC::ToolWindowLevel::Resetear()");
	TContractableWidgets::IteradorListaContratos itWidgets = TContractableWidgets::m_pListaActiva->begin();
	wxString wLStr, wWStr;
	for (TContratableWindowLevel::IteradorListaContratos itWindowLevel = TContratableWindowLevel::m_pListaActiva->begin(); itWidgets != TContractableWidgets::m_pListaActiva->end() ; itWidgets++, itWindowLevel++) {
		TContractWidgets* pCW = (*itWidgets);
		TContratoWindowLevel* pCWL = (*itWindowLevel);
		vtkGinkgoImageViewer* pIV = pCW->GetViewer();

		GNC::GCS::Eventos::EventoModificacionImagen* pEvt = new GNC::GCS::Eventos::EventoModificacionImagen(TContratableWindowLevel::m_pVistaActiva,GNC::GCS::Eventos::EventoModificacionImagen::VisualizacionImagenModificada, -1);
		
		pEvt->EnableResetWindowLevel();

		GNC::Entorno::Instance()->GetControladorEventos()->ProcesarEvento(pEvt);

		double window = pIV->GetWindow();
		double level = pIV->GetLevel();
	
		pCWL->m_labelCurrent = "";
		SetWindowLevel(window, level);
	}
}

//endregion


