/*
 *  
 *  $Id: herramientaelevacion.cpp 4478 2011-12-13 11:55:00Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE
#include <wx/aui/aui.h>
#include <wx/stattext.h>
#include <wx/slider.h>

#include <api/globals.h>
#include <api/iwidgetsmanager.h>
#include "herramientaelevacion.h"
#include <resources/ginkgoresourcemanager.h>
#include <api/inotificadoresherramientas.h>
#include <main/entorno.h>


#ifdef __DEPRECATED
#undef __DEPRECATED
#endif
#include <vtk/vtkginkgoimageviewer.h>
#include <vtkImageData.h>
#include <vtkPointData.h>

//#include <AVL.h>

#define ELEVAR_VALORACION 1351
#define DISMINUIR_VALORACION 1352


namespace GNC {
	namespace GUI {
		class HerramientaOpcionesElevacionGUI : public AUI_NAMESPACE wxAuiToolBar {
		public:
			HerramientaOpcionesElevacionGUI(wxWindow* pParent, GNC::HerramientaElevacion* pHerramienta): AUI_NAMESPACE wxAuiToolBar(pParent,wxID_ANY, wxDefaultPosition, wxDefaultSize)
			{
				m_pHerramienta = pHerramienta;

				SetToolBitmapSize( wxSize( 16,16 ) );
				AddTool( DISMINUIR_VALORACION, _("Decrease"), GinkgoResourcesManager::BarraElevacion::GetIcoDisminuirValoracion(), _("Decrease value"), wxITEM_CHECK);
				AddTool( ELEVAR_VALORACION, _("Increase"), GinkgoResourcesManager::BarraElevacion::GetIcoAumentarValoracion(), _("Increase value"), wxITEM_CHECK );
				ToggleTool(ELEVAR_VALORACION,true);

				AddSeparator();


				wxStaticText* m_staticText4 = new wxStaticText( this, wxID_ANY, _("Radious"), wxDefaultPosition, wxSize(-1,16), 0 );
				AddControl(m_staticText4 );
				m_pSliderRadio = new wxSlider( this, wxID_ANY, 15, 1, 100, wxDefaultPosition, wxSize(-1,16), wxSL_HORIZONTAL );
				m_pSliderRadio->SetToolTip(_("Radious"));
				AddControl(m_pSliderRadio);
				AddSeparator();

				m_pLabelFactor = new wxStaticText( this, wxID_ANY, _("Factor (0.50)"), wxDefaultPosition, wxSize(-1,16), 0 );
				AddControl(m_pLabelFactor );
				m_pSliderFactor = new wxSlider( this, wxID_ANY, 50,0, 100, wxDefaultPosition, wxSize(-1,16), wxSL_HORIZONTAL );
				m_pSliderFactor->SetToolTip(_("Factor"));
				AddControl(m_pSliderFactor);

				Realize();
				Layout();

				// Connect Events
				this->Connect( ELEVAR_VALORACION, wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler( HerramientaOpcionesElevacionGUI::OnBElevarClick ) );
				this->Connect( DISMINUIR_VALORACION, wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler( HerramientaOpcionesElevacionGUI::OnBDisminuirClick ) );

				m_pSliderRadio->Connect( wxEVT_SCROLL_TOP, wxScrollEventHandler( HerramientaOpcionesElevacionGUI::OnRadioScroll ), NULL, this );
				m_pSliderRadio->Connect( wxEVT_SCROLL_BOTTOM, wxScrollEventHandler( HerramientaOpcionesElevacionGUI::OnRadioScroll ), NULL, this );
				m_pSliderRadio->Connect( wxEVT_SCROLL_LINEUP, wxScrollEventHandler( HerramientaOpcionesElevacionGUI::OnRadioScroll ), NULL, this );
				m_pSliderRadio->Connect( wxEVT_SCROLL_LINEDOWN, wxScrollEventHandler( HerramientaOpcionesElevacionGUI::OnRadioScroll ), NULL, this );
				m_pSliderRadio->Connect( wxEVT_SCROLL_PAGEUP, wxScrollEventHandler( HerramientaOpcionesElevacionGUI::OnRadioScroll ), NULL, this );
				m_pSliderRadio->Connect( wxEVT_SCROLL_PAGEDOWN, wxScrollEventHandler( HerramientaOpcionesElevacionGUI::OnRadioScroll ), NULL, this );
				m_pSliderRadio->Connect( wxEVT_SCROLL_THUMBTRACK, wxScrollEventHandler( HerramientaOpcionesElevacionGUI::OnRadioScroll ), NULL, this );
				m_pSliderRadio->Connect( wxEVT_SCROLL_THUMBRELEASE, wxScrollEventHandler( HerramientaOpcionesElevacionGUI::OnRadioScroll ), NULL, this );
				m_pSliderRadio->Connect( wxEVT_SCROLL_CHANGED, wxScrollEventHandler( HerramientaOpcionesElevacionGUI::OnRadioScroll ), NULL, this );

				m_pSliderFactor->Connect( wxEVT_SCROLL_TOP, wxScrollEventHandler( HerramientaOpcionesElevacionGUI::OnFactorScroll ), NULL, this );
				m_pSliderFactor->Connect( wxEVT_SCROLL_BOTTOM, wxScrollEventHandler( HerramientaOpcionesElevacionGUI::OnFactorScroll ), NULL, this );
				m_pSliderFactor->Connect( wxEVT_SCROLL_LINEUP, wxScrollEventHandler( HerramientaOpcionesElevacionGUI::OnFactorScroll ), NULL, this );
				m_pSliderFactor->Connect( wxEVT_SCROLL_LINEDOWN, wxScrollEventHandler( HerramientaOpcionesElevacionGUI::OnFactorScroll ), NULL, this );
				m_pSliderFactor->Connect( wxEVT_SCROLL_PAGEUP, wxScrollEventHandler( HerramientaOpcionesElevacionGUI::OnFactorScroll ), NULL, this );
				m_pSliderFactor->Connect( wxEVT_SCROLL_PAGEDOWN, wxScrollEventHandler( HerramientaOpcionesElevacionGUI::OnFactorScroll ), NULL, this );
				m_pSliderFactor->Connect( wxEVT_SCROLL_THUMBTRACK, wxScrollEventHandler( HerramientaOpcionesElevacionGUI::OnFactorScroll ), NULL, this );
				m_pSliderFactor->Connect( wxEVT_SCROLL_THUMBRELEASE, wxScrollEventHandler( HerramientaOpcionesElevacionGUI::OnFactorScroll ), NULL, this );
				m_pSliderFactor->Connect( wxEVT_SCROLL_CHANGED, wxScrollEventHandler( HerramientaOpcionesElevacionGUI::OnFactorScroll ), NULL, this );
			}

			~HerramientaOpcionesElevacionGUI(){
				// Disconnect Events
				this->Disconnect( ELEVAR_VALORACION, wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler( HerramientaOpcionesElevacionGUI::OnBElevarClick ) );
				this->Disconnect( DISMINUIR_VALORACION, wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler( HerramientaOpcionesElevacionGUI::OnBDisminuirClick ) );

				m_pSliderRadio->Disconnect( wxEVT_SCROLL_TOP, wxScrollEventHandler( HerramientaOpcionesElevacionGUI::OnRadioScroll ), NULL, this );
				m_pSliderRadio->Disconnect( wxEVT_SCROLL_BOTTOM, wxScrollEventHandler( HerramientaOpcionesElevacionGUI::OnRadioScroll ), NULL, this );
				m_pSliderRadio->Disconnect( wxEVT_SCROLL_LINEUP, wxScrollEventHandler( HerramientaOpcionesElevacionGUI::OnRadioScroll ), NULL, this );
				m_pSliderRadio->Disconnect( wxEVT_SCROLL_LINEDOWN, wxScrollEventHandler( HerramientaOpcionesElevacionGUI::OnRadioScroll ), NULL, this );
				m_pSliderRadio->Disconnect( wxEVT_SCROLL_PAGEUP, wxScrollEventHandler( HerramientaOpcionesElevacionGUI::OnRadioScroll ), NULL, this );
				m_pSliderRadio->Disconnect( wxEVT_SCROLL_PAGEDOWN, wxScrollEventHandler( HerramientaOpcionesElevacionGUI::OnRadioScroll ), NULL, this );
				m_pSliderRadio->Disconnect( wxEVT_SCROLL_THUMBTRACK, wxScrollEventHandler( HerramientaOpcionesElevacionGUI::OnRadioScroll ), NULL, this );
				m_pSliderRadio->Disconnect( wxEVT_SCROLL_THUMBRELEASE, wxScrollEventHandler( HerramientaOpcionesElevacionGUI::OnRadioScroll ), NULL, this );
				m_pSliderRadio->Disconnect( wxEVT_SCROLL_CHANGED, wxScrollEventHandler( HerramientaOpcionesElevacionGUI::OnRadioScroll ), NULL, this );

				m_pSliderFactor->Disconnect( wxEVT_SCROLL_TOP, wxScrollEventHandler( HerramientaOpcionesElevacionGUI::OnFactorScroll ), NULL, this );
				m_pSliderFactor->Disconnect( wxEVT_SCROLL_BOTTOM, wxScrollEventHandler( HerramientaOpcionesElevacionGUI::OnFactorScroll ), NULL, this );
				m_pSliderFactor->Disconnect( wxEVT_SCROLL_LINEUP, wxScrollEventHandler( HerramientaOpcionesElevacionGUI::OnFactorScroll ), NULL, this );
				m_pSliderFactor->Disconnect( wxEVT_SCROLL_LINEDOWN, wxScrollEventHandler( HerramientaOpcionesElevacionGUI::OnFactorScroll ), NULL, this );
				m_pSliderFactor->Disconnect( wxEVT_SCROLL_PAGEUP, wxScrollEventHandler( HerramientaOpcionesElevacionGUI::OnFactorScroll ), NULL, this );
				m_pSliderFactor->Disconnect( wxEVT_SCROLL_PAGEDOWN, wxScrollEventHandler( HerramientaOpcionesElevacionGUI::OnFactorScroll ), NULL, this );
				m_pSliderFactor->Disconnect( wxEVT_SCROLL_THUMBTRACK, wxScrollEventHandler( HerramientaOpcionesElevacionGUI::OnFactorScroll ), NULL, this );
				m_pSliderFactor->Disconnect( wxEVT_SCROLL_THUMBRELEASE, wxScrollEventHandler( HerramientaOpcionesElevacionGUI::OnFactorScroll ), NULL, this );
				m_pSliderFactor->Disconnect( wxEVT_SCROLL_CHANGED, wxScrollEventHandler( HerramientaOpcionesElevacionGUI::OnFactorScroll ), NULL, this );
			}


			virtual void OnRadioScroll( wxScrollEvent&  ){
				m_pHerramienta->AjustarRadio((float)(m_pSliderRadio->GetValue()));
			}

			virtual void OnFactorScroll( wxScrollEvent&  ){
				m_pHerramienta->AjustarSensibilidad((float)(m_pSliderFactor->GetValue())/GetRango());
				wxString str = wxString::Format(_("Factor (%.2f)"),(float)(m_pSliderFactor->GetValue())/GetRango());
				m_pLabelFactor->SetLabel(str);
			}

			virtual void OnBElevarClick( wxCommandEvent& event ){
				m_pHerramienta->SetTipoAccion(GNC::TAE_AUMENTAR);
				ToggleTool(DISMINUIR_VALORACION,false);
				ToggleTool(ELEVAR_VALORACION,true);
				event.Skip(false);
			}
			virtual void OnBDisminuirClick( wxCommandEvent& event ){
				m_pHerramienta->SetTipoAccion(GNC::TAE_DISMINUIR);
				ToggleTool(DISMINUIR_VALORACION,true);
				ToggleTool(ELEVAR_VALORACION,false);
				event.Skip(false);
			}

			void SetNumeroValores(int numeroValores)
			{
				m_pSliderFactor->SetMax(numeroValores);
				if(numeroValores ==2) {
					m_pSliderFactor->SetValue(1);
					m_pHerramienta->AjustarSensibilidad((float)(m_pSliderFactor->GetValue())/GetRango());
					wxString str = wxString::Format(_("Factor (%.2f)"),(float)(m_pSliderFactor->GetValue())/GetRango());
					m_pLabelFactor->SetLabel(str);
					m_pSliderFactor->Show(false);
					m_pLabelFactor->Show(false);
				} else {
					m_pSliderFactor->Show(true);
					m_pLabelFactor->Show(true);
				}
			}

			int GetRango() {
				return m_pSliderFactor->GetMax() - m_pSliderFactor->GetMin();
			}

			wxStaticText* m_pLabelFactor;
			wxSlider* m_pSliderRadio;
			wxSlider* m_pSliderFactor;
			GNC::HerramientaElevacion* m_pHerramienta;

		};
	}
}

//----------------------------------------------------------------------

GNC::HerramientaElevacion::HerramientaElevacion()
{
	m_Activa = false;
	m_pElevacionBuilder = NULL;

	// Representacion 0: Semilla sana

	/* Configuracion del widget de semillas de elevacion. Atributos radiometricos de las semillas */
	GNC::GCS::Widgets::Elevacion::RepresentacionElevacion* pRep = NULL;
	m_radio=15.0f;
	m_sensibilidad=0.5f;
	m_TipoAccion=GNC::TAE_AUMENTAR;

	// Representacion 0: Semilla poner mas afectado
	pRep = new GNC::GCS::Widgets::Elevacion::RepresentacionElevacion();
	pRep->colorCircunferencia.asignar(0.5f, 0.0f, 0.0f, 0.5f);
	pRep->colorCircunferenciaIluminada.asignar(1.0f, 0.0f, 0.0f, 0.5f);
	pRep->m_RadioCircunferencia=m_radio;
	m_RepresentacionesElevacion.push_back(pRep);

	// Representacion 0: Semilla poner mas sano
	pRep = new GNC::GCS::Widgets::Elevacion::RepresentacionElevacion();
	pRep->colorCircunferencia.asignar(0.0f, 0.5f, 0.0f, 0.5f);
	pRep->colorCircunferenciaIluminada.asignar(0.0f, 1.0f, 0.0f, 0.5f);
	pRep->m_RadioCircunferencia=m_radio;
	m_RepresentacionesElevacion.push_back(pRep);
	m_PuntosInsertados.clear();

	m_Descripcion = _Std("Elevation");

	m_Icono = GinkgoResourcesManager::IconosHerramientas::GetIcoElevacion();
}

GNC::HerramientaElevacion::~HerramientaElevacion()
{
	for(GNC::GCS::Widgets::Elevacion::ListaRepresentaciones::iterator it = m_RepresentacionesElevacion.begin(); it != m_RepresentacionesElevacion.end(); it++) {
		delete *it;
	}
	m_RepresentacionesElevacion.clear();

	m_PuntosInsertados.clear();
}

//region "Realizacion de la interfaz IHerramienta"

void GNC::HerramientaElevacion::CrearPaneles( wxPanel* panel )
{
	m_pAbstractPanelHerramientaOpciones = new GNC::GUI::HerramientaOpcionesElevacionGUI(panel,this);
}

void GNC::HerramientaElevacion::ConectarContratoFalso(bool activar) {
	if (TContratableWidgets::m_pListaActiva == NULL) {
		//std::cerr << "Error: Se trato de activar el modo deshabilitado de una vista sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		return;
	}

	for (TContratableWidgets::IteradorListaContratos it = TContratableWidgets::m_pListaActiva->begin(); it != TContratableWidgets::m_pListaActiva->end(); it++) {
		TContratoWidgets* pC = (*it);
		if (pC->Inicializado()) {
			pC->GetManager()->EnableAnotacionDinamica(activar);
			if (activar) {
				GTRACE( "HerramientaElevacion: Conectando contrato falso de vista " << TContratableWidgets::m_pVistaActiva );
				pC->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
				pC->GetManager()->Render();
			}
			else {
				GTRACE( "HerramientaElevacion: Desconectando contrato falso de vista " << TContratableWidgets::m_pVistaActiva );
				pC->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
			}
		}
	}
}

void GNC::HerramientaElevacion::SetVistaActiva(GNC::GCS::IVista* pVista) {
	TContratableWidgets::EstablecerVistaActiva(pVista);
	TContratableElevacion::EstablecerVistaActiva(pVista);
	GTRACE("GNC::TContratableElevacion::EstablecerVistaActiva(pVista);::SetVistaActiva(" <<  pVista << ")");
}

/* FIXME: Aviso!!!! para que funcione deben contratarse contratos pareados obligatorios y en el mismo orden*/
void GNC::HerramientaElevacion::ConectarContratos(bool activar)
{
	if (TContratableWidgets::m_pListaActiva == NULL || TContratableElevacion::m_pListaActiva == NULL) {
		if (activar) {
			std::cerr << "Error: Se trataron de conectar contratos sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		} else {
			if(m_pElevacionBuilder != NULL) {
				delete m_pElevacionBuilder;
				m_pElevacionBuilder = NULL;
			}
		}
		return;
	}

	if (TContratableWidgets::m_pListaActiva->size() != TContratableElevacion::m_pListaActiva->size()) {
		std::cerr << "Error: La vista tiene un numero distinto de contratos IContratoWidget que IContratoElevacion y de IcontratoAnotador. Imposible conectar" << std::endl;
		return;
	}

	// Recorrido de los contratos pareados: Contrato de widgets y Contrato específico de herramienta de semillas.
	TContratableWidgets::IteradorListaContratos it1 = TContratableWidgets::m_pListaActiva->begin();
	TContratableElevacion::IteradorListaContratos it2 = TContratableElevacion::m_pListaActiva->begin();
	for ( ; it1 != TContratableWidgets::m_pListaActiva->end() && it2 != TContratableElevacion::m_pListaActiva->end(); it1++, it2++) {
		TContratoWidgets* pCW = (*it1);
		TContratoElevacion* pCE = (*it2);
		if (pCW->Inicializado() && pCE->Inicializado()) {
			pCW->GetManager()->EnableAnotacionDinamica(activar);
			if (activar) {
				GTRACE("HerramientaElevacion: Conectando contratos de vista " << pCW->m_pVista);
				// Usamos de Id de grupo el valor del puntero de la herramienta, que es unico y no cambia
				m_pElevacionBuilder = new GNC::GCS::Widgets::WElevacionBuilder(pCW->GetManager(), &m_RepresentacionesElevacion, GetTriggerButton(), (unsigned long)this);
				if(m_TipoAccion==GNC::TAE_DISMINUIR){
					m_pElevacionBuilder->SetRepresentacionActiva(1);
				}else{
					m_pElevacionBuilder->SetRepresentacionActiva(0);
				}
				//conectamos los observadores
				m_pElevacionBuilder->SetObservador(this);
				pCW->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pCW->GetManager()->SetCursor(m_pElevacionBuilder->GetCursor());
				pCW->GetManager()->Render();
				if(pCE->m_modoMascara) {
					((GNC::GUI::HerramientaOpcionesElevacionGUI*)m_pAbstractPanelHerramientaOpciones)->SetNumeroValores(2);
				} else {
					((GNC::GUI::HerramientaOpcionesElevacionGUI*)m_pAbstractPanelHerramientaOpciones)->SetNumeroValores((pCE->m_maximo-pCE->m_minimo)+1);
				}
			}
			else {
				GTRACE( "HerramientaElevacion: Desconectando contratos de vista " << pCW->m_pVista );
				if(m_pElevacionBuilder != NULL) {
					delete m_pElevacionBuilder;
					m_pElevacionBuilder = NULL;
				}
				//se borra la semilla
				for(GNC::GCS::IWidgetsManager::IteradorListaWidgets it2 = pCW->GetManager()->GetListaWidgets().begin(); it2 != pCW->GetManager()->GetListaWidgets().end(); it2++){
					if((*it2)->GetGID() == (long)this){
						pCW->GetManager()->EliminarWidget(*it2,false);
						break;
					}
				}
				pCW->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pCW->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
			}
		}
	}
}

//endregion


//region "Eventos refinados desde los paneles"

//endregion

//region "metodos propios de la varita"

void GNC::HerramientaElevacion::OnPuntoInsertado(float x, float y) {

	if (TContratableElevacion::m_pListaActiva == NULL) {
		std::cerr << "Error: Se trataron de conectar contratos sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		return;
	}

	m_PuntosInsertados.push_back(GNC::GCS::Vector(x,y));
}

void GNC::HerramientaElevacion::OnTerminarInsertar() {

	if (TContratableElevacion::m_pListaActiva == NULL) {
		std::cerr << "Error: Se trataron de conectar contratos sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		return;
	}


	TContratableWidgets::IteradorListaContratos it1 = TContratableWidgets::m_pListaActiva->begin();
	for (TContratableElevacion::IteradorListaContratos it = TContratableElevacion::m_pListaActiva->begin(); it != TContratableElevacion::m_pListaActiva->end()&&it1 != TContratableWidgets::m_pListaActiva->end(); it++,it1++) {
		GNC::GCS::IContratoElevacion* pC = (*it);
		//TContratoWidgets* pCW = (*it1);
		if(pC!=NULL && pC->m_pMapaValoracion != NULL){
			int dimensiones[3];
			pC->m_pMapaValoracion->GetDimensions(dimensiones);
			unsigned char* img = new unsigned char[dimensiones[0]*dimensiones[1]];

			GNC::GCS::Vector p;
			GNC::GCS::Vector d;
			unsigned int ix, iy;
			unsigned int off = 0;
			unsigned int size = dimensiones[0]*dimensiones[1];
			for(; off<size; ++off)
				img[off] = 0;

			off = 0;

			// TODO: Arreglar todo esto. Podría ser elíptico
			//float radio = m_radio / std::max(vSpacing.x, vSpacing.y);

			for (TipoIteradorPuntosInsertados it = m_PuntosInsertados.begin(); it!= m_PuntosInsertados.end(); ++it) {
				GNC::GCS::Vector n = (*it);
				float nNorma2Cuadrado = (m_radio * m_radio);
				for (int y = (n.y - m_radio); y < (n.y + m_radio); ++y) {
					iy = y; // Correccion de coordenadas ??????????????????
					if (iy >= 0 && iy < (unsigned int)dimensiones[1]) {
						for (int x = (n.x - m_radio); x < (n.x + m_radio); ++x) {
							ix = x;
							if (ix >= 0 && ix < (unsigned int)dimensiones[0]) {
								off = iy * dimensiones[0] + ix;
								d = n - (GNC::GCS::Vector(x, y));
								if (img[off] == 0) {
									if (d.Norma2Cuadrado() < nNorma2Cuadrado) {
										img[off] = 255;
									}
								}
							}
						}
					}
				}
			}

			off = 0;

			if(pC->m_modoMascara) {
				unsigned char maskSet = pC->m_mascaraSet;
				unsigned char maskUnset = pC->m_mascaraUnSet;
				unsigned char* data = (unsigned char*) pC->m_pMapaValoracion->GetScalarPointer();

				if(m_TipoAccion==GNC::TAE_AUMENTAR){
					for (off = 0; off < size; off++) {
						if (img[off] == 255) {
							data[off] |= maskSet;
						}
					}
				} else {
					for (off = 0; off < size; off++) {
						if (img[off] == 255) {
							data[off] &= maskUnset;
						}
					}
				}
			} else {
				double valor;
				const int st = pC->m_pMapaValoracion->GetScalarType();
				const double maximo = pC->m_maximo;
				const double minimo = pC->m_minimo;
				double factor = m_sensibilidad * (pC->m_maximo-pC->m_minimo+1);

				switch(st) {
					case VTK_DOUBLE:
						{
							double* data = (double*) pC->m_pMapaValoracion->GetScalarPointer();
							for (off = 0; off < size; off++) {
								if (img[off] == 255) {
									if(m_TipoAccion==GNC::TAE_AUMENTAR){
										valor = std::min( (data[off] + factor) ,maximo);
									}
									else{
										valor = std::max( (data[off]-factor) ,minimo);
									}
									data[off] = valor;
								}
							}
						}
						break;
					case VTK_FLOAT:
						{
							float* data = (float*) pC->m_pMapaValoracion->GetScalarPointer();
							for (off = 0; off < size; off++) {
								if (img[off] == 255) {
									if(m_TipoAccion==GNC::TAE_AUMENTAR){
										valor = std::min( (double)(data[off] + factor) ,maximo);
									}
									else{
										valor = std::max( (double)(data[off]-factor) ,minimo);
									}
									data[off] = (float)valor;
								}
							}
						}
						break;
					case VTK_UNSIGNED_LONG:
						{
							unsigned long* data = (unsigned long*) pC->m_pMapaValoracion->GetScalarPointer();
							for (off = 0; off < size; off++) {
								if (img[off] == 255) {
									if(m_TipoAccion==GNC::TAE_AUMENTAR){
										valor = std::min( (double)(data[off] + factor) ,maximo);
									}
									else{
										valor = std::max( (double)(data[off]-factor) ,minimo);
									}
									data[off] = (unsigned long)valor;
								}
							}
						}
						break;
					case VTK_LONG:
						{
							long* data = (long*) pC->m_pMapaValoracion->GetScalarPointer();
							for (off = 0; off < size; off++) {
								if (img[off] == 255) {
									if(m_TipoAccion==GNC::TAE_AUMENTAR){
										valor = std::min( (double)(data[off] + factor) ,maximo);
									}
									else{
										valor = std::max( (double)(data[off]-factor) ,minimo);
									}
									data[off] = (long)valor;
								}
							}
						}
						break;
					case VTK_UNSIGNED_INT:
						{
							unsigned int* data = (unsigned int*) pC->m_pMapaValoracion->GetScalarPointer();
							for (off = 0; off < size; off++) {
								if (img[off] == 255) {
									if(m_TipoAccion==GNC::TAE_AUMENTAR){
										valor = std::min( (double)(data[off] + factor) ,maximo);
									}
									else{
										valor = std::max( (double)(data[off]-factor) ,minimo);
									}
									data[off] = (unsigned int)valor;
								}
							}
						}
						break;
					case VTK_INT:
						{
							int* data = (int*) pC->m_pMapaValoracion->GetScalarPointer();
							for (off = 0; off < size; off++) {
								if (img[off] == 255) {
									if(m_TipoAccion==GNC::TAE_AUMENTAR){
										valor = std::min( (double)(data[off] + factor) ,maximo);
									}
									else{
										valor = std::max( (double)(data[off]-factor) ,minimo);
									}
									data[off] = (int)valor;
								}
							}
						}
						break;
					case VTK_UNSIGNED_SHORT:
						{
							unsigned short* data = (unsigned short*) pC->m_pMapaValoracion->GetScalarPointer();
							for (off = 0; off < size; off++) {
								if (img[off] == 255) {
									if(m_TipoAccion==GNC::TAE_AUMENTAR){
										valor = std::min( (double)(data[off] + factor) ,maximo);
									}
									else{
										valor = std::max( (double)(data[off]-factor) ,minimo);
									}
									data[off] = (unsigned short)valor;
								}
							}
						}
						break;
					case VTK_SHORT:
						{
							short* data = (short*) pC->m_pMapaValoracion->GetScalarPointer();
							for (off = 0; off < size; off++) {
								if (img[off] == 255) {
									if(m_TipoAccion==GNC::TAE_AUMENTAR){
										valor = std::min( (double)(data[off] + factor) ,maximo);
									}
									else{
										valor = std::max( (double)(data[off]-factor) ,minimo);
									}
									data[off] = (short)valor;
								}
							}
						}
						break;
					case VTK_UNSIGNED_CHAR:
						{
							unsigned char* data = (unsigned char*) pC->m_pMapaValoracion->GetScalarPointer();
							for (off = 0; off < size; off++) {
								if (img[off] == 255) {
									if(m_TipoAccion==GNC::TAE_AUMENTAR){
										valor = std::min( (double)(data[off] + factor) ,maximo);
									}
									else{
										valor = std::max( (double)(data[off]-factor) ,minimo);
									}
									data[off] = (unsigned char)valor;
								}
							}
						}
						break;
					case VTK_CHAR:
						{
							char* data = (char*) pC->m_pMapaValoracion->GetScalarPointer();
							for (off = 0; off < size; off++) {
								if (img[off] == 255) {
									if(m_TipoAccion==GNC::TAE_AUMENTAR){
										valor = std::min( (double)(data[off] + factor) ,maximo);
									}
									else{
										valor = std::max( (double)(data[off]-factor) ,minimo);
									}
									data[off] = (char)valor;
								}
							}
						}
						break;
				}
			}

			delete [] img;

			pC->m_pMapaValoracion->Modified();
			pC->m_pNotificador->ActualizarVistaElevacion();
		}
	}
	m_PuntosInsertados.clear();
}

void GNC::HerramientaElevacion::AjustarSensibilidad(float valorNormalizado) {
	m_sensibilidad=valorNormalizado;
}

void GNC::HerramientaElevacion::AjustarRadio(float valor) {
	for(GNC::GCS::Widgets::Elevacion::ListaRepresentaciones::iterator it = m_RepresentacionesElevacion.begin(); it != m_RepresentacionesElevacion.end(); it++) {
		(*it)->m_RadioCircunferencia=valor;
	}

	m_radio=valor;

	for ( TContratableWidgets::IteradorListaContratos it1 = TContratableWidgets::m_pListaActiva->begin(); it1 != TContratableWidgets::m_pListaActiva->end() ; it1++) {
		TContratoWidgets* pCW = (*it1);
		pCW->GetManager()->Modificado();
	}
}

void GNC::HerramientaElevacion::SetTipoAccion(GNC::TipoAccionElevacion tipoAccion){
	m_TipoAccion=tipoAccion;
	if(m_pElevacionBuilder!=NULL){
		if(m_TipoAccion==GNC::TAE_DISMINUIR){
			m_pElevacionBuilder->SetRepresentacionActiva(1);
		}else{
			m_pElevacionBuilder->SetRepresentacionActiva(0);
		}
		for ( TContratableWidgets::IteradorListaContratos it1 = TContratableWidgets::m_pListaActiva->begin(); it1 != TContratableWidgets::m_pListaActiva->end() ; it1++) {
			TContratoWidgets* pCW = (*it1);
			pCW->GetManager()->Modificado();
		}
	}
}

//endregion
