/*
 *  
 *  $Id: pacscontroller.h 4477 2011-12-13 11:16:56Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <map>

#include <api/api.h>
#include <api/controllers/ipacscontroller.h>
#include "dcmtk/istorecallback.h"


class Network;
namespace GNC{
	class IProxyNotificadorProgreso;
}

namespace GIL {
	namespace DICOM {
		class Service;
	}
}

namespace GIL {
	namespace DICOM {
		class EXTAPI PACSController : public IPACSController, public IStoreCallBack {
		public:

			// TODO: corregir
			typedef std::map<void*, IDICOMImg2DCM*> ListaInstanciasImg2DCMType;
			
			typedef std::map<void*, Network> NetworkConnectionList;

			static PACSController* Instance();
			static void FreeInstance();

			virtual IModeloDicom* BuscarPaciente(
				void* connectionKey,
				const std::string& serverId,
				const std::string& idPaciente,
				const std::string& nombrePaciente,
				const std::string& fechaNacimiento,
				IModeloDicom* pModelo,
				GNC::IProxyNotificadorProgreso* pNotificador
			);

			virtual IModeloDicom* BuscarEstudio(
				void* connectionKey,
				const std::string& serverId,
				const std::string& idPaciente,
				const std::string& nombrePaciente,
				const std::string& idEstudio,
				const std::string& AccNumber,
				const std::string& modalidad,
				const std::string& fechaDesde,
				const std::string& fechaHasta,
				const std::string& timeFrom,
				const std::string& timeTo,
				const std::string& descripcionEstudio,
				const std::string& nombreEstacion,
				IModeloDicom* pModelo,
				GNC::IProxyNotificadorProgreso* pNotificador
			);

			virtual IModeloDicom* BuscarSeries(
				void* connectionKey,
				const std::string& serverId,
				const std::string& idEstudio,
				const std::string& idSerie,
				IModeloDicom* pModelo,
				GNC::IProxyNotificadorProgreso* pNotificador
			);

			virtual IModeloDicom* BuscarImagenes(
				void* connectionKey,
				const std::string& serverId,
				const std::string& idSerie,
				const std::string& idImagen,
				IModeloDicom* pModelo,
				GNC::IProxyNotificadorProgreso* pNotificador
			);

			virtual void SubirArchivos(void* connectionKey, const std::string& serverId, const std::vector<std::string>& pathsSubida, GNC::IProxyNotificadorProgreso* pNotificador, TipoTransferSyntaxEnvio transferSyntax);

			virtual void FillInQuery(const GIL::DICOM::TipoJerarquia& base, DcmDataset* query);

			virtual bool ObtenerEstudio(
				void* connectionKey,
				const std::string& serverId,
				const GIL::DICOM::TipoJerarquia& base,
				IModeloDicom* pModelo,
				GNC::IProxyNotificadorProgreso* pNotificador
			);

			virtual bool ObtenerSerie(
				void* connectionKey,
				const std::string& serverId,
				const GIL::DICOM::TipoJerarquia& base,
				IModeloDicom* pModelo,
				GNC::IProxyNotificadorProgreso* pNotificador
			);

			virtual bool ObtenerImagen(
				void* connectionKey,
				const std::string& serverId,
				const GIL::DICOM::TipoJerarquia& base,
				IModeloDicom* pModelo,
				GNC::IProxyNotificadorProgreso* pNotificador
			);

			virtual bool QueryRetrieve(
				void* connectionKey,
				const std::string& serverId,
				IModeloDicom* pModelo,
				const GIL::DICOM::TipoJerarquia& base,
				GNC::IProxyNotificadorProgreso* pNotificador
			);

			virtual void StartService();

			virtual void StopService();

			virtual void  GetConnection(void* connectionKey);

			virtual void  ReleaseConnection(void* connectionKey);

			bool LeerDicomDir(const std::string& pathDicomDir, IModeloDicom* pModelo);

			virtual bool findAndGetTagFromFile(const std::string& ruta, unsigned short group, unsigned short element, std::string& value);

			virtual bool EsDICOM(const std::string& path, bool accept_dicomdir, bool accept_dicomfile);

			virtual bool GetRutaSerie(const std::string& uidPaciente, const std::string& uidEstudio, const std::string& uidSerie, std::string& ruta, bool crearDirectorios = true, bool temporal = false);
			virtual bool GetRutaImagen(const std::string& uidPaciente, const std::string& uidEstudio, const std::string& uidSerie, const std::string& uidImagen, std::string& ruta, bool crearDirectorios = true);
			virtual bool GetRutaImagenTemp(const std::string& uidPaciente, const std::string& uidEstudio, const std::string& uidSerie, const std::string& uidImagen, std::string& ruta, bool crearDirectorios = true);

//region "Interfaz IStoreCallBack"
			virtual void Store(const std::string& fileName, DcmDataset* dset);
//endregion

			void DumpFileElements(const std::string& rutaFichero, IInspectCallBack* callback);


//region "Métodos de Dicomización"

			IDICOMImg2DCM* CrearInstanciaDeImportacion();
			void LiberarInstanciaDeImportacion(IDICOMImg2DCM* instancia);

//endregion

//region "Métodos de carga/almacenamiento de DICOMS"

			IDICOMManager* CrearInstanciaDeDICOMManager();

			void LiberarInstanciaDeDICOMManager(IDICOMManager* instancia);

//endregion

		protected:
			PACSController();
			~PACSController();

			static void PurgarDirectorioTemporal();

		protected:

			static PACSController*     m_pInstance;
			ListaInstanciasImg2DCMType m_ListaInstanciasDicomImg2DCM;
			GIL::DICOM::Service*       m_pServiceInstance;

		private:
			void buildDicomDir();
		};
	};
};
