/*
*  
*  $Id: comandomergediagnosticwithimage.h 4404 2011-11-15 09:41:03Z tovar $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
#pragma once
#include <api/icomando.h>
#include <yasper/yasper.h>
#include <main/gui/export/datospersistentesexportacion.h>
#include <api/icontroladoreventos.h>
#include <api/icontroladormodulo.h>

namespace GNC {
	namespace GCS {
		class IVista;
	}
}

namespace GADAPI {
	class ComandoMergeDiagnosticWithImageParams;

	class ComandoMergeDiagnosticWithImageParams : public GNC::GCS::IComandoParams {
	public:
		typedef struct T_File {
			std::string m_path;
			std::string m_sopInstance;
			std::string m_seriesInstance;
		} T_File;
		typedef std::vector<T_File> TFileList;

		typedef enum {
			TC_UPLOAD,
			TC_EXPORT 
		} T_COMMAND;
		T_COMMAND m_commandType;

		ComandoMergeDiagnosticWithImageParams(const std::string& targetPath, const std::string& diagnosticStudyInstanceUID, const GIL::DICOM::TipoJerarquia& anonymizedTags, bool incluirTagsGinkgo);

		ComandoMergeDiagnosticWithImageParams(const std::string& serverSeleccionado, const std::string& diagnosticStudyInstanceUID, GIL::DICOM::TipoTransferSyntaxEnvio transferSyntax = GIL::DICOM::SendDefault);

		ComandoMergeDiagnosticWithImageParams(const std::string& targetPath, GnkPtr<GNC::GCS::IContextoEstudio>& pStudyContext, const GIL::DICOM::TipoJerarquia& anonymizedTags, bool incluirTagsGinkgo, bool actual);

		void FindModule();

		virtual ~ComandoMergeDiagnosticWithImageParams() {}

		GIL::DICOM::TipoJerarquia								m_anonymizedTags;
		bool															m_includeGinkgoTags;
		
		std::string													m_ServerSeleccionado;
		GnkPtr<GIL::IModeloIntegracion>						m_pModeloIntegracion;
		TFileList													m_oldImages;
		std::string													m_uidDiagnosticStudy;
		GNC::GCS::IContextoEstudio::TModoFuncionamiento m_diagnosticMode;
		GIL::DICOM::TipoTransferSyntaxEnvio					m_transferSyntax;
		wxString														m_tempPath;
		TFileList													m_newImages;
		GNC::GCS::IControladorModulo::TMapaTagsPrivados	m_mapTagsPrivadosReplace;
		//relation between old sop instances and new sop instances
		std::map<wxString, wxString>					m_mapSeriesUIDs;
		std::map<wxString, wxString>					m_mapSopUIDs;

		wxSemaphore											m_SemaforoEsperarComando;
		GNC::GCS::IComando*								m_pComandoEspera;
	};

	class ComandoMergeDiagnosticWithImage : public GNC::GCS::IComando, public GNC::GCS::IObservador {
	public:
		typedef std::map<std::string, GnkPtr<GIL::DICOM::TipoPrivateTags> > TMapaTagsPrivados;

		ComandoMergeDiagnosticWithImage(ComandoMergeDiagnosticWithImageParams* pParams);

		virtual void Execute();
    protected:
		virtual void Update();

	protected:
		virtual bool OneDiagnostic();
		virtual bool MultipleDiagnostic();

		bool BorrarArchivosTemporales(wxString& dirPath);
		void AdaptSRDataset(GIL::DICOM::TipoJerarquia& data, TMapaTagsPrivados & privateTagsDiagnosticList, const ComandoMergeDiagnosticWithImageParams::T_File& newFile, const std::string& uidEstudio);

		wxString GetFichero(const wxString& dir, const wxString& extension);

		virtual void ProcesarEvento(GNC::GCS::Eventos::IEvento *evt) ;

		ComandoMergeDiagnosticWithImageParams* m_pMergeParams;
	};
}
