/*
 *
 *  $Id: comandodicomizacionintegracion.cpp 4330 2011-10-25 10:28:33Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE
//#define DUMP_IMAGENES

#include <sstream>
#include <map>
#include <cmath>
#include <locale>

#include <wx/msgdlg.h>
#include <wx/filename.h>
#include <wx/dir.h>
#include <wx/file.h>
#include <wx/xml/xml.h>
#include <wx/mstream.h>
#include <wx/image.h>

#include <api/globals.h>

#include <api/icontroladoreventos.h>
#include <api/icontroladorcomandos.h>
#include <api/controllers/ipacscontroller.h>

#include <api/dicom/idicomizador.h>
#include <api/dicom/idicommanager.h>

#include <main/controllers/controladorlog.h>

#include <commands/comandopacs.h>
#include <commands/comandoavisarficheros.h>

#include <eventos/eventosginkgo.h>

#include <export/tagsprivadoscomunes.h>

#include "comandodicomizacionintegracion.h"

#define IDC_DICOMIZACION_INTEGRACION           2030
#define IDC_SUBCOMANDO_ADD_HISTORIAL           2031

// Singleton de persistencia
namespace GNKVisualizator {
	namespace GADAPI {

		ComandoDicomizacionIntegracionParams::ComandoDicomizacionIntegracionParams(GnkPtr<GNKVisualizator::GUI::TipoWizardImportacion> pDatosPersistentes,GNC::GCS::IEntorno* pEntorno,const std::string& dirTemporal)
		{
			GTRACE(">> ComandoDicomizacionIntegracionParams::ComandoDicomizacionIntegracionParams(): " << this);
			m_pDatosPersistentes = pDatosPersistentes;
			m_pEntorno = pEntorno;
			//se copia todo el directorio temporal a uno nuevo
			wxString wxNuevoDirTemp;
			do {
				wxNuevoDirTemp = FROMPATH(m_pEntorno->GetGinkgoTempDir()) + wxFileName::GetPathSeparator(wxPATH_NATIVE) + wxT("_gnktmp_") + wxString::Format(wxT("%d"), rand());
			} while(wxDir::Exists(wxNuevoDirTemp));

	#ifdef _WIN32
			wxFileName::Mkdir(wxNuevoDirTemp);
	#else
			wxFileName::Mkdir(wxNuevoDirTemp.c_str(), 0777);
	#endif
			wxDir dir;
			if (dir.Open(FROMPATH(dirTemporal))) {
				wxString fileName;
				wxString destino;
				bool cont = dir.GetFirst(&fileName);

				while (cont) {
					destino = wxNuevoDirTemp + wxFileName::GetPathSeparator(wxPATH_NATIVE) + fileName;
					fileName=dir.GetName()+ wxFileName::GetPathSeparator(wxPATH_NATIVE) +fileName;
					wxRenameFile(fileName,destino);
					for(GNKVisualizator::GUI::TipoWizardImportacion::TListaFicheros::iterator it = m_pDatosPersistentes->m_listaFicherosADicomizar.begin(); it!= m_pDatosPersistentes->m_listaFicherosADicomizar.end(); it++){
						if ( FROMPATH((*it).pathImagen) == fileName )
						{
							(*it).pathImagen = TOPATH(destino);
							break;
						}
					}
					cont = dir.GetNext(&fileName);
				}
			}
			m_dirTemporal = TOPATH(wxNuevoDirTemp);
			///
			m_mensajeError = "";
			m_copiadoCorrecto = false;
			m_subirCorrecto = false;
			m_importacionCorrecta = false;
			m_pComandoEspera = NULL;
			m_pParamsEspera = NULL;
			//
			GTRACE("<< ComandoDicomizacionIntegracionParams::ComandoDicomizacionIntegracionParams(): " << this);
		}

		ComandoDicomizacionIntegracionParams::ComandoDicomizacionIntegracionParams( const ComandoDicomizacionIntegracionParams& o)
		{
			this->m_pDatosPersistentes = o.m_pDatosPersistentes;
			this->m_pEntorno=o.m_pEntorno;
			this->m_dirTemporal = o.m_dirTemporal;

			this->m_ListaFicheros = o.m_ListaFicheros;
			this->m_mensajeError = "";
			this->m_copiadoCorrecto = o.m_copiadoCorrecto;
			this->m_subirCorrecto = o.m_subirCorrecto;
			this->m_importacionCorrecta = o.m_importacionCorrecta;
			m_pComandoEspera = NULL;
			m_pParamsEspera = NULL;
		}

		ComandoDicomizacionIntegracionParams& ComandoDicomizacionIntegracionParams::operator = (const ComandoDicomizacionIntegracionParams& o) {
			this->m_pDatosPersistentes = o.m_pDatosPersistentes;
			this->m_pEntorno=o.m_pEntorno;
			this->m_dirTemporal = o.m_dirTemporal;

			this->m_ListaFicheros = o.m_ListaFicheros;
			this->m_mensajeError = "";
			this->m_copiadoCorrecto = o.m_copiadoCorrecto;
			this->m_subirCorrecto = o.m_subirCorrecto;
			this->m_importacionCorrecta = o.m_importacionCorrecta;

			m_pComandoEspera = NULL;
			m_pParamsEspera = NULL;
			return *this;
		}

		ComandoDicomizacionIntegracionParams::~ComandoDicomizacionIntegracionParams() {
		}

		bool ComandoDicomizacionIntegracionParams::EnviarMensajeHL7()
		{
			return m_pDatosPersistentes->m_pModeloImportacion.IsValid();
		}

		ComandoDicomizacionIntegracion::ComandoDicomizacionIntegracion(ComandoDicomizacionIntegracionParams* pParams) : IComando(pParams)
		{
			GTRACE(">> ComandoDicomizacionIntegracion::ComandoDicomizacionIntegracion(): " << this);
			m_pIntegracionParams = pParams;
			SetId(IDC_DICOMIZACION_INTEGRACION);
			EsperaA(IDC_DICOMIZACION_INTEGRACION);

			m_pIntegracionParams->m_pEntorno->GetControladorEventos()->Registrar(this, GNC::GCS::Eventos::EventoProgresoComando());
			GTRACE("<< ComandoDicomizacionIntegracion::ComandoDicomizacionIntegracion(): " << this);
		}

		void ComandoDicomizacionIntegracion::Execute()
		{
			NotificarProgreso(0.05f, _Std("Step 1 of 3: Importing images"));

			if(!m_pIntegracionParams->m_importacionCorrecta) {
			  m_pIntegracionParams->m_importacionCorrecta = ImportarFicherosOriginales();
			}
			if(!m_pIntegracionParams->m_importacionCorrecta) {
				return;
			}

			//se inserta la evidencia de estudio y serie
			if(m_pIntegracionParams->EnviarMensajeHL7())
			{
				m_pIntegracionParams->m_pDatosPersistentes->m_pModeloImportacion->Evidencias.clear();
				//evidencia de estudio dicomizado
				GIL::IModeloEvidenciaEstudio evidenciaEstudioDicomizado("EstudioOriginal", m_pIntegracionParams->m_pDatosPersistentes->StudyInstanceUID, m_pIntegracionParams->m_pDatosPersistentes->AccessionNumber);
				GIL::IModeloEvidenciaSerie evidenciaSerie("SerieOriginal", m_pIntegracionParams->m_pDatosPersistentes->SerieUID);
				for(GNKVisualizator::GUI::TipoWizardImportacion::TListaFicheros::iterator it= m_pIntegracionParams->m_pDatosPersistentes->m_listaFicherosADicomizar.begin(); it!= m_pIntegracionParams->m_pDatosPersistentes->m_listaFicherosADicomizar.end(); it++) {
					//todas las imagenes son importantes
					GIL::IModeloEvidenciaImagen evidenciaImagen("Imagen", (*it).sopInstanceUID, (*it).sopClassUID);
					evidenciaSerie.ListaImagenes.push_back(evidenciaImagen);
				}
				evidenciaEstudioDicomizado.ListaSeries.push_back(evidenciaSerie);
				m_pIntegracionParams->m_pDatosPersistentes->m_pModeloImportacion->Evidencias.push_back(evidenciaEstudioDicomizado);
			}

			NotificarProgreso(0.40f, _Std("Step 2 of 3: Copying images"));
			//despues se copian todos los dicoms...

			if(!m_pIntegracionParams->m_copiadoCorrecto){
				m_pIntegracionParams->m_copiadoCorrecto = CopiarDicom();
			}
			if(!m_pIntegracionParams->m_copiadoCorrecto) {
				return;
			}

			//ahora se suben al pacs...
			NotificarProgreso(0.50f, _Std("Step 3 of 3: Uploading images"));

			if(m_pIntegracionParams->EnviarMensajeHL7()) {
				if(!m_pIntegracionParams->m_subirCorrecto) {
					m_pIntegracionParams->m_subirCorrecto = SubirPACS();
				}
				if(!m_pIntegracionParams->m_subirCorrecto) {
					return;
				}
			}

		}

		void ComandoDicomizacionIntegracion::Update()
		{
			if(m_pIntegracionParams->m_mensajeError != "") {
				wxString mensaje = _("Import process failed:") + wxString(wxT("\n - ")) + wxString::FromUTF8(m_pIntegracionParams->m_mensajeError.c_str()) + _("\nWould you like to retry?");

				int answer = wxMessageBox(mensaje,_("Info"),wxYES_NO | wxICON_INFORMATION, m_pIntegracionParams->m_pEntorno->GetVentanaRaiz());
				if(answer == wxYES) {
					ComandoDicomizacionIntegracionParams* pParams = new ComandoDicomizacionIntegracionParams(*m_pIntegracionParams);
					ComandoDicomizacionIntegracion* pCmd = new ComandoDicomizacionIntegracion(pParams);
					m_pIntegracionParams->m_pEntorno->GetControladorComandos()->ProcessAsync(_Std("Importing..."),pCmd,NULL);
				} else {
					BorrarArchivosTemporales(FROMPATH(m_pIntegracionParams->m_dirTemporal));
				}
			} else {
				BorrarArchivosTemporales(FROMPATH(m_pIntegracionParams->m_dirTemporal));
			}
		}

		void ComandoDicomizacionIntegracion::OnAbort()
		{
			BorrarArchivosTemporales(FROMPATH(m_pIntegracionParams->m_dirTemporal));
		}

		void ComandoDicomizacionIntegracion::LiberarRecursos()
		{
			BorrarArchivosTemporales(FROMPATH(m_pIntegracionParams->m_dirTemporal));
		}

		//resize files??
		void ComandoDicomizacionIntegracion::ResizeFiles()
		{
			return;
			wxString wxDirTemp = FROMPATH(m_pIntegracionParams->m_dirTemporal);
			int dims[2] = {-1,-1};
			//dimensiones del mas grande
			GNC::GCS::Vector vectorMaximo(-1.0,-1.0);
			GNC::GCS::Vector vectorOrigen(0.0,0.0);
			//
			bool redimensionar = false;
			//se leen las imagenes para ver que tengan la misma dimension
			for(GNKVisualizator::GUI::TipoWizardImportacion::TListaFicheros::iterator it= m_pIntegracionParams->m_pDatosPersistentes->m_listaFicherosADicomizar.begin(); it!= m_pIntegracionParams->m_pDatosPersistentes->m_listaFicherosADicomizar.end(); it++) {
				wxString path = FROMPATH(it->pathImagen);
				wxImage img(path);
				if(img.Ok())
				{
					if(dims[0]==-1 && dims[1]==-1){
						dims[0]=img.GetWidth();
						dims[1]=img.GetHeight();
						vectorMaximo.x =(double) std::max<double>(img.GetWidth(),img.GetHeight());
						vectorMaximo.y =(double) std::min<double>(img.GetWidth(),img.GetHeight());
					} else {
						if(!( (dims[0] == img.GetWidth() && dims[1] == img.GetHeight()) || (dims[1] == img.GetWidth() && dims[0] == img.GetHeight()) )){
							redimensionar = true;
							GNC::GCS::Vector v1((double)std::max<double>(img.GetWidth(),img.GetHeight()),(double)std::min<double>(img.GetWidth(),img.GetHeight()));
							if(!v1.DentroDeBoundingBox(vectorOrigen,vectorMaximo)){
								vectorMaximo.x = std::max<double>(vectorMaximo.x,v1.x);
								vectorMaximo.y = std::max<double>(vectorMaximo.y,v1.y);
							}
						}
					}
				} 
			}

			//por ultimo si hay que redimensionar se redimensionan proporcionalmente y se rellena con negros
			if (redimensionar){
				for(GNKVisualizator::GUI::TipoWizardImportacion::TListaFicheros::iterator it= m_pIntegracionParams->m_pDatosPersistentes->m_listaFicherosADicomizar.begin(); it!= m_pIntegracionParams->m_pDatosPersistentes->m_listaFicherosADicomizar.end(); it++) {
					wxString pathOrig = FROMPATH(it->pathImagen);
					wxImage img(pathOrig);
					if(!( (vectorMaximo.x == img.GetWidth() && vectorMaximo.y == img.GetHeight()) || (vectorMaximo.x == img.GetWidth() && vectorMaximo.y == img.GetHeight()) )){
						//primero se rescala proporcionalmente
						double scale;
						if(img.GetHeight() > img.GetWidth()){
							scale = (double)vectorMaximo.x / img.GetHeight();
						} else {
							scale = (double)vectorMaximo.x / img.GetWidth();
						}
						img = img.Rescale(img.GetWidth()*scale,img.GetHeight()*scale,wxIMAGE_QUALITY_HIGH);
						//se cambia el tama�o hasta el maximo
						if(img.GetHeight() > img.GetWidth()){
							wxPoint punto((vectorMaximo.y / 2) - ((float)img.GetWidth()/2),0);
							img = img.Resize(wxSize(vectorMaximo.y,vectorMaximo.x),punto,0,0,0);
						} else {
							wxPoint punto(0,(vectorMaximo.y / 2) - ((float)img.GetHeight()/2));
							img = img.Resize(wxSize(vectorMaximo.x,vectorMaximo.y),punto,0,0,0);
						}

						wxFileName fileName(pathOrig);
						wxString nombreImagenTemporal = wxDirTemp + wxFileName::GetPathSeparator() + fileName.GetName() + wxString::Format(wxT("%d"),rand()) + wxT(".jpg");
						while(wxFile::Exists(nombreImagenTemporal))
						{
							//si existe se busca uno que no exista
							nombreImagenTemporal= wxDirTemp + wxFileName::GetPathSeparator() + fileName.GetName() + wxString::Format(wxT("%d"),rand()) + wxT(".jpg");
						}
						img.SetOption(wxIMAGE_OPTION_QUALITY,100);
						img.SaveFile(nombreImagenTemporal);
						(*it).pathImagen = TOPATH(nombreImagenTemporal);

					}
				}
			}
		}



		bool ComandoDicomizacionIntegracion::ImportarFicherosOriginales()
		{
			ResizeFiles();
			bool esElPrimero=true;

			GIL::DICOM::IPACSController* pCI = m_pIntegracionParams->m_pEntorno->GetPACSController();

			int instanceNumber = 0;

			for(GNKVisualizator::GUI::TipoWizardImportacion::TListaFicheros::iterator it= m_pIntegracionParams->m_pDatosPersistentes->m_listaFicherosADicomizar.begin(); it!= m_pIntegracionParams->m_pDatosPersistentes->m_listaFicherosADicomizar.end(); it++) {

				GIL::DICOM::IDICOMImg2DCM* pI2D = NULL;
				GIL::DICOM::IDICOMManager*	pDICOMManager = NULL;

				try {
					
					pI2D = pCI->CrearInstanciaDeImportacion();
					
					std::string rutaFichero = (*it).pathImagen;

					pI2D->Inicializar(rutaFichero, NULL);

					std::string tag;
					std::string rtag;
					std::string stag;

					//base comun
					GIL::DICOM::TipoJerarquia base = m_pIntegracionParams->m_pDatosPersistentes->baseImagenes;

					if (m_pIntegracionParams->m_pDatosPersistentes->SerieUID != "") {
						base.tags[std::string("0020|000e")] = m_pIntegracionParams->m_pDatosPersistentes->SerieUID; //serie instance uid
					}

					//instance number
					{
						std::ostringstream ostr;
						ostr << instanceNumber++;
						base.tags[std::string("0020|0013")] = ostr.str();
					}

					pI2D->InsertarJerarquia(base);

					if (m_pIntegracionParams->m_pDatosPersistentes->m_pModeloImportacion.IsValid())
					{
						//raw data
						GIL::DICOM::TipoPrivateTags tagsPrivados(UID_TAGS_PRIVADOS_COMUNES);
						unsigned char tag = TAG_XML_INTEGRACION;
						tagsPrivados.SetTag(tag,m_pIntegracionParams->m_pDatosPersistentes->m_pModeloImportacion->rawXmlData);
						pI2D->InsertarTagsPrivados(tagsPrivados);
						
						// Override metadata tags here.
						GIL::DICOM::TipoJerarquia override;
						const GIL::IModeloIntegracion::ListaTuplas& tuplas = m_pIntegracionParams->m_pDatosPersistentes->m_pModeloImportacion->Metadatos;						
						for (GIL::IModeloIntegracion::ListaTuplas::const_iterator it = tuplas.begin(); it != tuplas.end(); it++) {
							const GIL::IModeloTupla& tupla = *it;						
							if (tupla.codigo == "DICOM") {							
								override.tags[tupla.clave] = tupla.valor;
							}
						}
						pI2D->InsertarJerarquia(override);
					}

					wxFileName inputFileName = wxFileName::FileName(FROMPATH(rutaFichero));
					//se crea el directorio de la serie
					wxString tempFilePath = FROMPATH(m_pIntegracionParams->m_dirTemporal) + wxFileName::GetPathSeparator(wxPATH_NATIVE) + inputFileName.GetName() + wxT(".dcm");
					while (wxFile::Exists(tempFilePath)) {
						tempFilePath = FROMPATH(m_pIntegracionParams->m_dirTemporal) + wxFileName::GetPathSeparator(wxPATH_NATIVE) + inputFileName.GetName() + wxString::Format(wxT("%d.dcm"),rand());
					}

					std::string rutaImportacion(TOPATH(tempFilePath));

					pI2D->Convertir(rutaImportacion);

					pCI->LiberarInstanciaDeImportacion(pI2D);
					pI2D = NULL;

					{//leemos tags
						pDICOMManager = pCI->CrearInstanciaDeDICOMManager();
						pDICOMManager->CargarFichero(rutaImportacion);
						if(esElPrimero || m_pIntegracionParams->m_pDatosPersistentes->AccessionNumber=="" || m_pIntegracionParams->m_pDatosPersistentes->StudyInstanceUID == "" || m_pIntegracionParams->m_pDatosPersistentes->SerieUID == ""){
							esElPrimero=false;

							if(pDICOMManager->GetTag(0x0008,0x0050,tag)) {//accession number
								m_pIntegracionParams->m_pDatosPersistentes->AccessionNumber = tag;
								m_pIntegracionParams->m_pDatosPersistentes->baseImagenes.tags[std::string("0008|0050")] = tag;
							}

							if(pDICOMManager->GetTag(0x0020,0x000d,tag)) {//studyUID
								m_pIntegracionParams->m_pDatosPersistentes->StudyInstanceUID = tag;
								m_pIntegracionParams->m_pDatosPersistentes->baseImagenes.tags[std::string("0020|000d")] = tag;
							}

							if(pDICOMManager->GetTag(0x0020,0x000e,tag)) {//uid serie original
								m_pIntegracionParams->m_pDatosPersistentes->SerieUID = tag;
								m_pIntegracionParams->m_pDatosPersistentes->baseImagenes.tags[std::string("0020|000e")] = tag;
							}
						}
						pDICOMManager->GetTag(0x0008,0x0018,(*it).sopInstanceUID); //sop instance uid
						pDICOMManager->GetTag(0x0008,0x0016,(*it).sopClassUID);//sop class uid

						pCI->LiberarInstanciaDeDICOMManager(pDICOMManager);
						pDICOMManager = NULL;

						(*it).pathDCM = rutaImportacion;
					}//fin leer tags

				}
				catch (GIL::DICOM::I2DException& ex) {
					m_pIntegracionParams->m_mensajeError = ex.GetCause();
					LOG_ERROR("DICOMIZATION", "Error in dicomization process: " << ex);
					if (pI2D != NULL) {						
						pCI->LiberarInstanciaDeImportacion(pI2D);
					}
					if (pDICOMManager != NULL) {
						pCI->LiberarInstanciaDeDICOMManager(pDICOMManager);
					}
					return false;
				}				
				catch (std::exception& e) {
					m_pIntegracionParams->m_mensajeError = e.what();
					LOG_ERROR("DICOMIZATION", "Error doing dicomization: " << e.what() );
					if (pI2D != NULL) {						
						pCI->LiberarInstanciaDeImportacion(pI2D);
					}
					if (pDICOMManager != NULL) {
						pCI->LiberarInstanciaDeDICOMManager(pDICOMManager);
					}
					return false;
				}
				catch (...) {
					m_pIntegracionParams->m_mensajeError = _Std("Unkown error in dicomization process");
					LOG_ERROR("Internal error in dicomization process", "DICOMIZATION");
					if (pI2D != NULL) {
						pCI->LiberarInstanciaDeImportacion(pI2D);
					}
					if (pDICOMManager != NULL) {
						pCI->LiberarInstanciaDeDICOMManager(pDICOMManager);
					}
					return false;
				}
				
			}
			return true;
		}

		bool ComandoDicomizacionIntegracion::CopiarDicom()
		{
			bool correcto = true;

			m_pIntegracionParams->m_ListaFicheros.clear();
			//el directorio existe, se crea un directorio para la serie, con el uid de la serie donde se copiaran los ficheros importados
			wxDir dir;
			if (dir.Open(FROMPATH(m_pIntegracionParams->m_dirTemporal))) {
				wxString pathOrigenWx,destinoWx;
				bool cont = dir.GetFirst(&pathOrigenWx,wxT("*.dcm"));
				std::string pathDestinoStd,pathOrigenStd;
				GIL::DICOM::IDICOMManager*	pDICOMManager;
				GIL::DICOM::TipoJerarquia base;

				while (cont) {
					pathOrigenWx=dir.GetName()+ wxFileName::GetPathSeparator(wxPATH_NATIVE) +pathOrigenWx;
					pathOrigenStd = TOPATH(pathOrigenWx);

					//nos falta el uid de la imagen...
					std::string idPaciente,uidEstudio,uidSerie,uidImagen;
					pDICOMManager= m_pIntegracionParams->m_pEntorno->GetPACSController()->CrearInstanciaDeDICOMManager();
					pDICOMManager->CargarFichero(pathOrigenStd);
					pDICOMManager->GetTag(0x0010,0x0020,idPaciente);
					pDICOMManager->GetTag(0x0020,0x000d,uidEstudio);
					pDICOMManager->GetTag(0x0020,0x000e,uidSerie);
					pDICOMManager->GetTag(0x0008,0x0018,uidImagen);
					m_pIntegracionParams->m_pEntorno->GetPACSController()->LiberarInstanciaDeDICOMManager(pDICOMManager);
					//se pilla el path
					correcto = correcto && m_pIntegracionParams->m_pEntorno->GetPACSController()->GetRutaImagen(idPaciente,uidEstudio,uidSerie,uidImagen,pathDestinoStd);
					destinoWx = FROMPATH(pathDestinoStd);

					correcto = correcto && wxCopyFile(pathOrigenWx,destinoWx,true);

					m_pIntegracionParams->m_ListaFicheros.push_back(pathDestinoStd);

					cont = dir.GetNext(&pathOrigenWx);
				}
			}

			if(correcto) {
				::GADAPI::ComandoAvisarFicherosParams * pParams = new ::GADAPI::ComandoAvisarFicherosParams(m_pIntegracionParams->m_ListaFicheros);
				::GADAPI::ComandoAvisarFicheros * pCmd = new ::GADAPI::ComandoAvisarFicheros(pParams);
				LanzarYEsperar(pCmd, pParams);
			}
			return correcto;
		}

		bool ComandoDicomizacionIntegracion::SubirPACS() {
			try{
				std::vector<std::string> rutas;
				for(std::list<std::string>::iterator it = m_pIntegracionParams->m_ListaFicheros.begin(); it!= m_pIntegracionParams->m_ListaFicheros.end(); it++){
					rutas.push_back((*it));
				}

				//el pacs sera el primero d la configuracion si no lanzar excepcion
				::GADAPI::ComandoPACSParams * pParams = new ::GADAPI::ComandoPACSParams(m_pIntegracionParams->m_pDatosPersistentes->m_pModeloImportacion->PACSAlmacenamiento, rutas, m_pIntegracionParams->m_pDatosPersistentes->m_pModeloImportacion);
				pParams->m_informar = false;
				::GADAPI::ComandoPACS * pCmd = new ::GADAPI::ComandoPACS(pParams);
				LanzarYEsperar(pCmd, pParams);

			}
			catch (GIL::DICOM::PACSException& ex) {
				std::stringstream ostr;
				ostr << _Std("Can not upload to the PACS:\n");
				ostr << ex;
				m_pIntegracionParams->m_mensajeError = ostr.str();
			}
			catch (std::exception& ex) {
				std::stringstream ostr;
				ostr << _Std("Can not upload to the PACS:\n");
				ostr << ex.what();
				m_pIntegracionParams->m_mensajeError = ostr.str();
			}
			catch (...) {
				std::stringstream ostr;
				ostr << _Std("Can not upload to the PACS:\nInternal Error");
				m_pIntegracionParams->m_mensajeError = ostr.str();
			}
			if(m_pIntegracionParams->m_mensajeError != ""){
				return false;
			} else {
				return true;
			}
		}

		void ComandoDicomizacionIntegracion::LanzarYEsperar(GNC::GCS::IComando* pCmd, GNC::GCS::IComandoParams* pCmdParams)
		{
			LOG_TRACE("ComandoDicomizacionIntegracion", "Esperando a " << pCmd);
			m_pIntegracionParams->m_pComandoEspera = pCmd;
			m_pIntegracionParams->m_pParamsEspera = pCmdParams;
			m_pIntegracionParams->m_pEntorno->GetControladorComandos()->ProcessAsync("Processing...",pCmd,NULL);
			m_pIntegracionParams->m_SemaforoEsperarComando.Wait();
			LOG_TRACE("ComandoDicomizacionIntegracion", "Espera de " << pCmd << " finalizada");
		}

		bool  ComandoDicomizacionIntegracion::BorrarArchivosTemporales(wxString dirPath)
		{
			//borra en cascada
			if(!wxRmdir(dirPath)){
				//vaciar
				wxDir dir;
				if (dir.Open(dirPath)) {
					wxString fileName;
					bool cont = dir.GetFirst(&fileName);
					while (cont) {
						fileName=dir.GetName()+ wxFileName::GetPathSeparator(wxPATH_NATIVE) +fileName;
						if(wxDir::Exists(fileName)){
							if (BorrarArchivosTemporales(fileName)) {
								cont = dir.GetFirst(&fileName);
							} else {
								cont = dir.GetNext(&fileName);
							}
						}else{
							if (wxRemoveFile(fileName)) {
								cont = dir.GetFirst(&fileName);
							} else {
								cont = dir.GetNext(&fileName);
							}
						}
					}
				}
			}
			if(wxDir::Exists(dirPath)){
				return wxRmdir(dirPath);
			}
			return true;
		}

		void ComandoDicomizacionIntegracion::ProcesarEvento(GNC::GCS::Eventos::IEvento *evt)
		{
			GNC::GCS::Eventos::EventoProgresoComando* pEvt = dynamic_cast<GNC::GCS::Eventos::EventoProgresoComando*> (evt);
			GNC::GCS::IComando* pCmd = pEvt->GetComando();
			if (pEvt == NULL  || pEvt->GetComando() == NULL || pCmd != m_pIntegracionParams->m_pComandoEspera) {
				LOG_TRACE("ComandoDicomizacionIntegracion", "Evento ignorado. No corresponde al comando de interes");
				return;
			}
			if (pEvt->GetTipo() == GNC::GCS::Eventos::EventoProgresoComando::TEP_Finalizado)
			{
				::GADAPI::ComandoPACS* pCmdPACS = dynamic_cast< ::GADAPI::ComandoPACS * > (m_pIntegracionParams->m_pComandoEspera);
				if (pCmdPACS != NULL)
				{
					LOG_TRACE("ComandoDicomizacionIntegracion", "Procesando evento de terminacion de comando pacs.");
					::GADAPI::ComandoPACSParams* pCmdPACSParams = dynamic_cast< ::GADAPI::ComandoPACSParams* > (m_pIntegracionParams->m_pParamsEspera);
					m_pIntegracionParams->m_mensajeError = pCmdPACSParams->m_error;
				}
				else
				{
					LOG_TRACE("ComandoDicomizacionIntegracion", "Procesando evento de terminacion del subcomando avisar.");
				}
				m_pIntegracionParams->m_pComandoEspera = NULL;
				m_pIntegracionParams->m_pParamsEspera = NULL;
				m_pIntegracionParams->m_SemaforoEsperarComando.Post();
			}
		}
	}
}

