/*
 *  
 *  $Id: wchroma.cpp 3535 2011-03-18 17:57:05Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE

#include <cmath>

#include <wx/xml/xml.h>

#include <api/globals.h>

#include <api/ievento.h>
#include <api/iwidgetsrenderer.h>
#include <api/iwidgetsmanager.h>
#include <api/icontexto.h>
#include <api/westilo.h>

#include <eventos/eventosginkgo.h>

#include <main/managers/widgetsmanager.h>

#include "wchroma.h"

#include <vtkgl.h>

#define WRADIO_CRUZ 12.0f
#define WLONGITUD_LINEA 15.0f

//region "Implementacion de WSemillasBuilder"

GNC::GCS::Widgets::WChromaBuilder::WChromaBuilder(GNC::GCS::IWidgetsManager* pManager, long gid, GNC::GCS::Widgets::Observadores::IObservadorChroma* pObservador) : GNC::GCS::Widgets::IWidgetBuilder(pManager, gid), GNC::GCS::Widgets::Notificadores::INotificadorChroma(pObservador)
{
	m_MouseDown = false;
	m_NumMaxSemillas = 1;
	m_Estado = WBS_Ninguno;
}

GNC::GCS::Widgets::WChromaBuilder::~WChromaBuilder()
{

}

void GNC::GCS::Widgets::WChromaBuilder::OnMouseEvents(GNC::GCS::Eventos::EventoRaton& evento)
{
	if (!m_pManager) {
		return;
	}
	GTRACE("GNC::GCS::Widgets::WSemillasBuilder::OnMouseEvents(wxMouseEvent&)");
	if (m_MouseDown && evento.ButtonUp(GNC::GCS::Eventos::EventoRaton::EB_IZQUIERDO)) {

		m_MouseDown = false;
		switch(m_Estado) {
			case WBS_Ninguno:
				// ¿Error?
				break;
			case WBS_Creando:
				{
					m_Nodo = evento.iP;

					GNC::GCS::Widgets::WChroma* semilla = new GNC::GCS::Widgets::WChroma(m_pManager, evento.c->GetRenderer()->GetVID(), m_Nodo, "chroma", m_GID);
					int numSemillas = 0;
					if (m_NumMaxSemillas > 0) {
						for (GNC::GCS::ListaWidgets::iterator it = m_pManager->GetListaWidgets().begin(); it !=  m_pManager->GetListaWidgets().end(); it++) {
							if ( (*it)->GetGID() == m_GID) {
								numSemillas++;
								if (numSemillas >= m_NumMaxSemillas) {
									m_pManager->EliminarWidget(it);
									break;
								}
							}
						}
					}
					m_pManager->InsertarWidget(semilla);
					m_pManager->LanzarEventoCreacion(semilla);
					m_pManager->Modificado();
					ConsumirEvento();
				}
				break;
			case WBS_Seleccionando:
				break;
			case WBS_Moviendo:
				break;
		}
		m_Estado = WBS_Ninguno;

	} else if (evento.ButtonDown(GNC::GCS::Eventos::EventoRaton::EB_IZQUIERDO)) {
		if (m_Estado != WBS_Ninguno) {
			return;
		}

		int numSemillas = 0;
		if (m_NumMaxSemillas > 0) {
			for (GNC::GCS::ListaWidgets::iterator it = m_pManager->GetListaWidgets().begin(); it !=  m_pManager->GetListaWidgets().end(); it++) {
				if ( (*it)->GetGID() == m_GID) {
					numSemillas++;
					if (numSemillas >= m_NumMaxSemillas) {
						m_pManager->EliminarWidget(it);
						break;
					}
				}
			}
		}
		
		m_Nodo = evento.iP;
		m_MouseDown = true;
		m_Estado = WBS_Creando;
		m_pManager->Modificado();
		ConsumirEvento();

	} else if (evento.Dragging() && m_MouseDown) {
		if (m_Estado == WBS_Creando) {
			m_Nodo = evento.iP;
			m_pManager->Modificado();
			ConsumirEvento();
		}
	}
}

void GNC::GCS::Widgets::WChromaBuilder::OnKeyEvents(GNC::GCS::Eventos::EventoTeclado& evt)
{
	NotificarKeyEvent(evt);
}

void GNC::GCS::Widgets::WChromaBuilder::Render(GNC::GCS::Contexto3D* c)
{
	if (m_Estado != WBS_Creando) {
		return;
	}

	GNC::GCS::Vector escala = c->RelacionImagenPantalla();

	float radioCruz = WRADIO_CRUZ * escala.x;
	float longitudLinea = WLONGITUD_LINEA * escala.x;

	// Sombra
	float fsombrax, fsombray;
	if (m_MouseDown)
	{
		fsombrax = WIDGET_OFFSET_X_SOMBRA_SELECCIONADO * escala.x;
		fsombray = WIDGET_OFFSET_Y_SOMBRA_SELECCIONADO * escala.y;
	}
	else
	{
		fsombrax = WIDGET_OFFSET_X_SOMBRA * escala.x;
		fsombray = WIDGET_OFFSET_Y_SOMBRA * escala.y;
	}


	wColorSombra.Aplicar();

	glLineWidth(WIDGET_GROSOR_LINEA);
	// cruz
	glEnable(GL_LINE_STIPPLE);
	glLineStipple(3, 0xAAAA);
	glBegin(GL_LINE_STRIP);
	glVertex3f(m_Nodo.x - radioCruz + fsombrax, m_Nodo.y - fsombray, 0.0f);
	glVertex3f(m_Nodo.x + fsombrax, m_Nodo.y - fsombray, 0.0f);
	glEnd();
	glBegin(GL_LINE_STRIP);
	glVertex3f(m_Nodo.x + radioCruz + fsombrax, m_Nodo.y - fsombray, 0.0f);
	glVertex3f(m_Nodo.x + fsombrax, m_Nodo.y - fsombray, 0.0f);
	glEnd();

	glBegin(GL_LINE_STRIP);
	glVertex3f(m_Nodo.x + fsombrax, m_Nodo.y - radioCruz - fsombray, 0.0f);
	glVertex3f(m_Nodo.x + fsombrax, m_Nodo.y - fsombray, 0.0f);
	glEnd();
	glBegin(GL_LINE_STRIP);
	glVertex3f(m_Nodo.x + fsombrax, m_Nodo.y + radioCruz - fsombray, 0.0f);
	glVertex3f(m_Nodo.x + fsombrax, m_Nodo.y - fsombray, 0.0f);
	glEnd();
	glDisable(GL_LINE_STIPPLE);

	//linea de la cruz 45 grados xa abajo
	glBegin(GL_LINES);
	glVertex3f(m_Nodo.x + fsombrax, m_Nodo.y - fsombray, 0.0f);
	glVertex3f(m_Nodo.x + longitudLinea + fsombrax, m_Nodo.y - longitudLinea - fsombray, 0.0f);
	glEnd();


	// Cuerpo
	glLineWidth(WIDGET_GROSOR_LINEA_ARRASTRE);
	wAplicarColor(m_Nodo.m_Iluminado, m_MouseDown, m_Nodo.m_Seleccionado);

	// Cruz
	glEnable(GL_LINE_STIPPLE);
	glLineStipple(3, 0xAAAA);
	glBegin(GL_LINE_STRIP);
	glVertex3f(m_Nodo.x - radioCruz, m_Nodo.y, 0.0f);
	glVertex3f(m_Nodo.x , m_Nodo.y, 0.0f);
	glEnd();
	glBegin(GL_LINE_STRIP);
	glVertex3f(m_Nodo.x + radioCruz, m_Nodo.y, 0.0f);
	glVertex3f(m_Nodo.x , m_Nodo.y, 0.0f);
	glEnd();

	glBegin(GL_LINE_STRIP);
	glVertex3f(m_Nodo.x, m_Nodo.y - radioCruz, 0.0f);
	glVertex3f(m_Nodo.x, m_Nodo.y, 0.0f);
	glEnd();
	glBegin(GL_LINE_STRIP);
	glVertex3f(m_Nodo.x, m_Nodo.y + radioCruz, 0.0f);
	glVertex3f(m_Nodo.x, m_Nodo.y, 0.0f);
	glEnd();
	glDisable(GL_LINE_STIPPLE);

	//linea de la cruz 45 grados xa abajo
	

	glBegin(GL_LINES);
	glVertex3f(m_Nodo.x, m_Nodo.y, 0.0f);
	glVertex3f(m_Nodo.x + longitudLinea, m_Nodo.y - longitudLinea, 0.0f);
	glEnd();
}

GNC::GCS::Widgets::TipoCursor GNC::GCS::Widgets::WChromaBuilder::GetCursor()
{
	return GNC::GCS::Widgets::CUR_CREAR_PUNTO;
}

//endregion


//region "Constructor y destructor"

GNC::GCS::Widgets::WChroma::WChroma(IWidgetsManager* pManager, long vid, GNC::GCS::Nodo nodo, const char* nombre, long gid, bool oculto) : GNC::GCS::Widgets::IWidget(pManager, vid, nombre, gid)
{
	m_Nodo = nodo;
	m_Nodo.m_Size = WRADIO_CRUZ;
	m_MouseDown = false;
	m_UID = (long)this;
	m_Oculto = oculto;

	/*GNC::GCS::Eventos::EventoModificacionImagen evt1(m_pManager->GetVista());
	m_pManager->GetControladorEventos()->Registrar(this, evt1);*/
}

GNC::GCS::Widgets::WChroma::~WChroma()
{
	LanzarEventoDestruccion();
}

//endregion

void GNC::GCS::Widgets::WChroma::OnMouseEvents(GNC::GCS::Eventos::EventoRaton& evento)
{
	if(EstaOculto()){
		return;
	}
	//------------------------------------------------------
	// Leaving
	else if (evento.Leaving() ) {
		Iluminar(false);
	}
	//------------------------------------------------------
	// Entering
	else if (evento.Entering() ) {
		if (m_MouseDown) {
			Iluminar(true);
		}
	}
	//------------------------------------------------------
	// Dragging
	if (evento.Dragging() && m_MouseDown) {
		if (m_Nodo.m_Seleccionado) {
			Vector delta = evento.iP - m_PosCursor;
			m_PosCursor = evento.iP;
			m_Nodo += delta;
			Modificar(true);

			NotificarCambios(true);
			ConsumirEvento();
			LanzarEventoModificacion();
		}
		return;
	}
	//------------------------------------------------------
	// LeftDown
	else if (evento.LeftDown()) {

		if (EventoConsumido() && !evento.m_controlDown) {
			if (EstaSeleccionado()) {
				NotificarCambios(true);
			}
			Seleccionar(false);
			return;
		}

		const GNC::GCS::Vector::TComponente& factor = evento.c->RelacionImagenPantalla().NormaInfinito();

		bool dentro = false;

		m_PosCursor = evento.iP;

		if (m_Nodo.Hits(evento.iP, factor)) { // click sobre el nodo
			dentro = true;
			if (evento.m_controlDown) { // Inversion de seleccion
				InvertirSeleccion();
			}
			else{
				Seleccionar(true);
			}
		}
		else { // Click fuera del nodo
			if (!evento.m_controlDown) {
				Seleccionar(false);
			}
			else {
				ConsumirEvento();
				if (EstaSeleccionado()) {
					m_MouseDown = true;
				}
			}
		}
		if (dentro) {
			m_MouseDown = true;
			m_PosAntigua = m_Nodo;
			ConsumirEvento();
		}
		return;
	}
	//------------------------------------------------------
	// LeftUP
	else if (evento.LeftUp()) {
		if (m_MouseDown) {
			m_MouseDown = false;
			ConsumirEvento();
		}
	}
	//------------------------------------------------------
	// Moving
	else if (evento.Moving()) {
		if (EventoConsumido()) {
			return;
		}
		const GNC::GCS::Vector::TComponente& factor = evento.c->RelacionImagenPantalla().NormaInfinito();

		bool dentro = false;

		m_PosCursor = evento.iP;

		if (m_Nodo.Hits(evento.iP, factor)) {
			Iluminar(true);
			dentro = true;
		}
		else {
			Iluminar(false);
		}
		if (dentro) {
			ConsumirEvento();
		}
		return;
	}
}

void GNC::GCS::Widgets::WChroma::OnKeyEvents(GNC::GCS::Eventos::EventoTeclado& evento)
{
	if (evento.GetKeyCode() == WXK_ESCAPE) {
		Seleccionar(false);
	}
}

bool GNC::GCS::Widgets::WChroma::HitTest(float /*x*/, float /*y*/, float /*umbralCuadrado*/)
{
	return false;
}

bool GNC::GCS::Widgets::WChroma::HitTest(GNC::GCS::Vector* vertices, int numVertices)
{
	return m_Nodo.DentroDePoligono2(vertices,numVertices);
}

void GNC::GCS::Widgets::WChroma::Render(GNC::GCS::Contexto3D* c)
{
	if(m_Oculto){
		return;
	}

	GNC::GCS::Vector escala = c->RelacionImagenPantalla();

	float radioCruz = WRADIO_CRUZ * escala.x;
	float longitudLinea = WLONGITUD_LINEA * escala.x;

	// Sombra
	float fsombrax, fsombray;
	if (m_MouseDown)
	{
		fsombrax = WIDGET_OFFSET_X_SOMBRA_SELECCIONADO * escala.x;
		fsombray = WIDGET_OFFSET_Y_SOMBRA_SELECCIONADO * escala.y;
	}
	else
	{
		fsombrax = WIDGET_OFFSET_X_SOMBRA * escala.x;
		fsombray = WIDGET_OFFSET_Y_SOMBRA * escala.y;
	}


	wColorSombra.Aplicar();

	// cruz
	glEnable(GL_LINE_STIPPLE);
	glLineStipple(3, 0xAAAA);
	glBegin(GL_LINE_STRIP);
	glVertex3f(m_Nodo.x - radioCruz + fsombrax, m_Nodo.y - fsombray, 0.0f);
	glVertex3f(m_Nodo.x + fsombrax, m_Nodo.y - fsombray, 0.0f);
	glEnd();
	glBegin(GL_LINE_STRIP);
	glVertex3f(m_Nodo.x + radioCruz + fsombrax, m_Nodo.y - fsombray, 0.0f);
	glVertex3f(m_Nodo.x + fsombrax, m_Nodo.y - fsombray, 0.0f);
	glEnd();

	glBegin(GL_LINE_STRIP);
	glVertex3f(m_Nodo.x + fsombrax, m_Nodo.y - radioCruz - fsombray, 0.0f);
	glVertex3f(m_Nodo.x + fsombrax, m_Nodo.y - fsombray, 0.0f);
	glEnd();
	glBegin(GL_LINE_STRIP);
	glVertex3f(m_Nodo.x + fsombrax, m_Nodo.y + radioCruz - fsombray, 0.0f);
	glVertex3f(m_Nodo.x + fsombrax, m_Nodo.y - fsombray, 0.0f);
	glEnd();
	glDisable(GL_LINE_STIPPLE);

	//linea de la cruz 45 grados xa abajo
	glBegin(GL_LINES);
	glVertex3f(m_Nodo.x + fsombrax, m_Nodo.y - fsombray, 0.0f);
	glVertex3f(m_Nodo.x + longitudLinea + fsombrax, m_Nodo.y - longitudLinea - fsombray, 0.0f);
	glEnd();

	// arrastre
	if (m_MouseDown) {
		glEnable(GL_LINE_STIPPLE);
		wColorLineaArrastre.Aplicar();
		glLineWidth(WIDGET_GROSOR_LINEA_ARRASTRE);
		glLineStipple(3, 0xAAAA);

		glBegin(GL_LINE_STRIP);
		glVertex2d(m_PosAntigua.x, m_PosAntigua.y);
		glVertex2d(m_Nodo.x, m_Nodo.y);
		glEnd();

		glDisable(GL_LINE_STIPPLE);
	}

	// Cuerpo
	glLineWidth(WIDGET_GROSOR_LINEA_ARRASTRE);
	wAplicarColor(m_Nodo.m_Iluminado, m_MouseDown, m_Nodo.m_Seleccionado);

	// Cruz
	glEnable(GL_LINE_STIPPLE);
	glLineStipple(3, 0xAAAA);
	glBegin(GL_LINE_STRIP);
	glVertex3f(m_Nodo.x - radioCruz, m_Nodo.y, 0.0f);
	glVertex3f(m_Nodo.x , m_Nodo.y, 0.0f);
	glEnd();
	glBegin(GL_LINE_STRIP);
	glVertex3f(m_Nodo.x + radioCruz, m_Nodo.y, 0.0f);
	glVertex3f(m_Nodo.x , m_Nodo.y, 0.0f);
	glEnd();

	glBegin(GL_LINE_STRIP);
	glVertex3f(m_Nodo.x, m_Nodo.y - radioCruz, 0.0f);
	glVertex3f(m_Nodo.x, m_Nodo.y, 0.0f);
	glEnd();
	glBegin(GL_LINE_STRIP);
	glVertex3f(m_Nodo.x, m_Nodo.y + radioCruz, 0.0f);
	glVertex3f(m_Nodo.x, m_Nodo.y, 0.0f);
	glEnd();
	glDisable(GL_LINE_STIPPLE);

	//linea de la cruz 45 grados xa abajo
	
	glLineWidth(WIDGET_GROSOR_LINEA);
	glBegin(GL_LINES);
	glVertex3f(m_Nodo.x, m_Nodo.y, 0.0f);
	glVertex3f(m_Nodo.x + longitudLinea, m_Nodo.y - longitudLinea, 0.0f);
	glEnd();
}

