/*
*
*  $Id: comandoactualizaciones.cpp 3907 2011-07-01 07:27:36Z tovar $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/

//#define _GINKGO_TRACE
#include <sstream>

#include <wx/xml/xml.h>
#include <wx/msgdlg.h>
#include <wx/sstream.h>
#include <wx/url.h>
#include <main/controllers/configurationcontroller.h>

#include <api/globals.h>

#include <main/entorno.h>
#include <main/controllers/controladoreventos.h>
#include <main/controllers/controladorlog.h>
#include <eventos/eventosginkgo.h>
#include "comandoactualizaciones.h"

#define IDC_CHECK_UPDATES 112

GNC::ComandoComprobarActualizaciones::ComandoComprobarActualizaciones(ComandoComprobarActualizacionesParams* pParams) : IComando(pParams, _Std("Check Updates"))
{
	m_Version    = 0;
	m_SubVersion = 0;
	m_Release    = 0;
	m_Build      = 0;
	GTRACE(">> ComandoComprobarActualizaciones::ComandoComprobarActualizaciones(): " << this);
	m_pComprobarActualizacionesParams = pParams;
	SetId(IDC_CHECK_UPDATES);
	CancelaA(IDC_CHECK_UPDATES);
	GTRACE("<< ComandoComprobarActualizaciones::ComandoComprobarActualizaciones(): " << this);
}

void GNC::ComandoComprobarActualizaciones::Execute()
{
	GTRACE("Arrancando comando ComprobarActualizaciones ")
	std::string tarea(_Std("Checking program updates..."));

	if (EstaAbortado()) {
		return;
	}

	try {
		wxInputStream *inputStream;

		wxURL url(wxString::FromUTF8(m_pComprobarActualizacionesParams->m_URL.c_str()) );
		if (!url.IsOk()) {
			m_Error = "URL Invalida: " + m_pComprobarActualizacionesParams->m_URL;
			return;
		}

		if (url.GetError() == wxURL_NOERR) {
			inputStream = url.GetInputStream();
			if (inputStream == NULL) {
				m_Error = "No se pudo obtener el flujo de datos desde la URL: " + m_pComprobarActualizacionesParams->m_URL;
				return;
			}
		}
		else {
			std::ostringstream os;
			switch (url.GetError()) {
				case wxURL_SNTXERR:
					os << "Error de sintaxis. ";
					break;
				case wxURL_NOPROTO:
					os << "No se encontro ningun protocolo para obtener de la URL. ";
					break;
				case wxURL_NOHOST:
					os << "No se especifico hostname para el protocolo. ";
					break;
				case wxURL_NOPATH:
					os << "No se especifico ruta para el protocolo. ";
					break;
				case wxURL_CONNERR:
					os << "Error al conectar. ";
					break;
				case wxURL_PROTOERR:
					os << "Error al negociar la conexion. ";
					break;
				default:
					os << "Error interno. ";
					break;
			}
			os << "URL = " << m_pComprobarActualizacionesParams->m_URL;
			m_Error  = os.str();
			return;
		}

		wxXmlDocument xml;
		xml.Load(*inputStream, wxT("UTF-8"));
		wxXmlNode* raiz = xml.GetRoot();
		if (raiz == NULL) {
			m_Error = "XML invalid";
			return;
		}
		if (raiz->GetName() == wxT("ginkgo")) {
			wxString propVal;
			long val;
			for (wxXmlNode* nodo = raiz->GetChildren(); nodo != NULL; nodo = nodo->GetNext()) {
				if (nodo->GetName() == wxT("version")) {
					if ( nodo->GetNodeContent().Trim().ToLong(&val) ) {
						if (val >= 0) {
							m_Version = (int) val;
						}
					}
				}
				else if (nodo->GetName() == wxT("subversion")) {
					if ( nodo->GetNodeContent().Trim().ToLong(&val) ) {
						if (val >= 0) {
							m_SubVersion = (int) val;
						}
					}
				}
				else if (nodo->GetName() == wxT("release")) {
					if ( nodo->GetNodeContent().Trim().ToLong(&val) ) {
						if (val >= 0) {
							m_Release = (int) val;
						}
					}
				}
				else if (nodo->GetName() == wxT("build")) {
					if ( nodo->GetNodeContent().Trim().ToLong(&val) ) {
						if (val >= 0) {
							m_Build = (int) val;
						}
					}
				}
				else if (nodo->GetName() == wxT("codename")) {
					m_CodeName = std::string(nodo->GetNodeContent().Trim().ToUTF8());
				}
				else if (nodo->GetName() == wxT("description")) {
					m_Description = std::string(nodo->GetNodeContent().Trim().ToUTF8());
				}
				else if (nodo->GetName() == wxT("url")) {
					m_URL = std::string(nodo->GetNodeContent().Trim().ToUTF8());
				}
			}
		}
		delete inputStream;

		if (m_Version == -1 || m_SubVersion == -1 || m_Release == -1 || m_Build == -1 || m_URL.empty()) {
			m_Error = _Std("Not enough parameters found on XML");
			Abort();
			return;
		}

		{
			std::ostringstream os;
			os << m_Version << "." << m_SubVersion << "." << m_Release;
			if (m_CodeName.size() > 0) {
				os << " " << m_CodeName;
			}
			m_VersionStr = os.str();
		}

		{
			std::ostringstream os;
			os << m_Version << "." << m_SubVersion << "." << m_Release << "." << m_Build;
			m_VersionCheckStr = os.str();
		}

		//Sleep(3000);
	}
	catch (...)
	{
		m_Error = _Std("XML parsing internal error");
		Abort();
	}
	GTRACE("Saliendo comando ComprobarActualizaciones ");
}

void GNC::ComandoComprobarActualizaciones::Update()
{

	if (m_Error.size() > 0) {
		LOG_ERROR("Core/Update", m_Error);
		if (m_pComprobarActualizacionesParams->m_Informar) {
			wxMessageBox(_("Error checking application updates"), _("Ginkgo CADx updates"), wxICON_ERROR);
		}
		return;
	}

	if (EstaAbortado()) {
		return;
	}
	try {

		GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GCS::Eventos::EventoUpdateAvailable(m_Version, m_SubVersion, m_Release, m_Build, m_VersionStr, m_VersionCheckStr, m_Description, m_URL, m_pComprobarActualizacionesParams->m_Informar));
	}
	catch (...)
	{
		LOG_ERROR("CORE/Updates", _Std("Internal error checking updates"));
	}

}

