/*
 *  
 *  $Id: abrir.cpp 4387 2011-11-08 08:49:01Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <wx/filename.h>
#include <wx/imaglist.h>
#include <wx/file.h>
#include <wx/dnd.h>
#include <wx/dir.h>
#include <wx/busyinfo.h>
#include <wx/filedlg.h>
#include <wx/menu.h>
#include <wx/dirdlg.h>
#include <main/controllers/configurationcontroller.h>
#include <wx/msgdlg.h>
#include <wx/treelistctrl/treelistctrl.h>
#include "dialogodicomdirbase.h"

#include "abrir.h"



#include <vector>
#include <sstream>

#include <main/entorno.h>
#include <main/controllers/controladorextensiones.h>
#include <main/controllers/controladorcomandos.h>
#include <main/controllers/pacscontroller.h>
#include <main/gui/dicombrowsercomponent.h>
#include <commands/comandoincluirhistorial.h>
#include <api/dicom/imodelodicom.h>
#include <resources/ginkgoresourcemanager.h>
#include <api/icontextoestudio.h>

#define ICONO_ESTUDIO 0
#define ICONO_SERIE 1
#define ICONO_HOMBRE 2
#define ICONO_MUJER 3
#define ICONO_OTRO 4
#define SIZE_ICONOS 16

#define COLUMNA_DCMDIR_FECHA 2
#define COLUMNA_DCMDIR_MODALIDAD 1
#define COLUMNA_DCMDIR_MEDICO 3
#define COLUMNA_DCMDIR_ACCNUMBER 4
#define COLUMNA_DCMDIR_UID 5

namespace GNC {
	namespace GUI {
		////////////////////////////////////////////////////
		////////////DIALOGO DICOMDIR////////////////////////
		////////////////////////////////////////////////////

		class DialogoDicomDir: public DialogoDicomDirBase
		{
		public:
			DialogoDicomDir(wxWindow* pParent, const std::string& pathDicomDir): DialogoDicomDirBase(pParent)
			{
				wxString pathWx = FROMPATH(pathDicomDir);
				if (wxFile::Exists(pathWx)){
					wxFileName file(pathWx);
					IModeloDicom modelo;

					if(GIL::DICOM::PACSController::Instance()->LeerDicomDir(pathDicomDir,&modelo) && modelo.ListaPacientes().size()!=0) {
						m_pDICOMDIRResultPanel->SetModel(modelo);
					}
				} else {
					wxMessageBox(_("Select a valid DICOMDIR file"), _("Info"),
									 wxOK | wxICON_INFORMATION, this);
				}
			}

			~DialogoDicomDir()
			{
			}

			void OnEndClick(wxCommandEvent &)
			{
				//adquirimos desde dicomdir
				std::list<std::string> listaPaths = m_pDICOMDIRResultPanel->GetSelectedPaths();

				if(listaPaths.size() == 0) {
					wxMessageBox(_("Select dicom dir files you want to acquire"), _("Info"),
									 wxOK | wxICON_INFORMATION, this);
					return;
				} else {
					//se lanza el comando de incluir en el historial
					GADAPI::ComandoIncluirHistorial::ComandoIncluirHistorialParams* pParams = new GADAPI::ComandoIncluirHistorial::ComandoIncluirHistorialParams(listaPaths);
					GADAPI::ComandoIncluirHistorial::ComandoIncluirHistorial* pCmd = new GADAPI::ComandoIncluirHistorial::ComandoIncluirHistorial(pParams);
					GNC::Entorno::Instance()->GetControladorComandos()->ProcessAsync(_Std("Storing in the history..."),pCmd, NULL);

					Close();
				}
			}

		protected:
		};
		////////////////////////////////////////////////////

		Abrir::Abrir()
		{
		}

		Abrir::~Abrir()
		{

		}

		void Abrir::AbrirFichero(wxWindow* pParent, const std::list<std::string>* directLoads)
		{
			
			bool success = false;
			std::list<std::string> listaPaths;
			wxString guiDir;
			
			if (directLoads != NULL) {
				
				listaPaths = (*directLoads);
				
				success = (listaPaths.size() > 0);
				
			}
			else {
				std::string pathDefectoStd;
				GNC::GCS::ConfigurationController::Instance()->readStringUser("/GinkgoCore/Adquisicion", "PathDefecto", pathDefectoStd);
				wxString defPathWx = wxString::FromUTF8(pathDefectoStd.c_str());
				if(!wxDirExists(defPathWx)){
					defPathWx = wxEmptyString;
				}
				//se muestra un di�logo de abrir fichero, si abre un fichero mira a ver si es dicomdir, si abre un directorio lo explora en profundidad
				#if defined(_WINDOWS)
				wxFileDialog fileDialog(NULL,_("Open..."),defPathWx,wxEmptyString,wxT("*.*"), wxFD_OPEN | wxFD_MULTIPLE);
				#else
				wxFileDialog fileDialog(pParent,_("Open..."),defPathWx,wxEmptyString,wxT("*"), wxFD_OPEN | wxFD_MULTIPLE);
				#endif
				fileDialog.SetDirectory(defPathWx);
				success = (fileDialog.ShowModal() == wxID_OK);				
				
				if (success) {
					
					guiDir = fileDialog.GetDirectory();
					wxArrayString ficherosWx;
					fileDialog.GetFilenames(ficherosWx);
					
					for(wxArrayString::iterator it = ficherosWx.begin(); it != ficherosWx.end(); ++it)
					{
						wxString wxPath = fileDialog.GetDirectory() + wxFileName::GetPathSeparator() + (*it);
						listaPaths.push_back(std::string(TOPATH(wxPath)));
					}
				}
			}
			
			if (success) {
				
				//si alguno de los ficheros es un dicomdir se pasa a tratarlos de una forma especial, si son ficheros normales, se lanza el comando
				bool esDicomDir = false;
				if (listaPaths.size() == 1 && GIL::DICOM::PACSController::Instance()->EsDICOM(listaPaths.front(),true,false)) {
					esDicomDir = true;
				}

				if (!esDicomDir) {
					//se lanza el comando de incluir en el historial
					GADAPI::ComandoIncluirHistorial::ComandoIncluirHistorialParams* pParams = new GADAPI::ComandoIncluirHistorial::ComandoIncluirHistorialParams(listaPaths);
					//pParams->m_informar = false;
					//pParams->m_abrirDespuesDeCargar = true;
					GADAPI::ComandoIncluirHistorial::ComandoIncluirHistorial* pCmd = new GADAPI::ComandoIncluirHistorial::ComandoIncluirHistorial(pParams);
					GNC::Entorno::Instance()->GetControladorComandos()->ProcessAsync(_Std("Storing in the history..."),pCmd, NULL);
				} else {
					//dialogo de adquisicion a traves de dicomdir...
					DialogoDicomDir dicomDirDialog(pParent,listaPaths.front());
					dicomDirDialog.ShowModal();
				}
				
				if (!guiDir.IsEmpty()) {
					//se actualiza el fichero de configuracion
					GNC::GCS::ConfigurationController::Instance()->writeStringUser("/GinkgoCore/Adquisicion", "PathDefecto", std::string(guiDir.ToUTF8()));
					GNC::GCS::ConfigurationController::Instance()->Flush();
				}
			}
		}

		//abrir directorio
		void Abrir::AbrirDirectorio(wxWindow* pParent)
		{
			std::string defPath;
			GNC::GCS::ConfigurationController::Instance()->readStringUser("/GinkgoCore/Adquisicion", "PathDefecto", defPath);
			wxString pathDefecto = wxString::FromUTF8(defPath.c_str());
			if(!wxDirExists(pathDefecto)){
				pathDefecto = wxEmptyString;
			}
			wxDirDialog dd( pParent, _("Choose a directory"), pathDefecto, 0, wxDefaultPosition );
			int response = dd.ShowModal();
			if (response == wxID_OK) {
				std::string stdPath(TOPATH(dd.GetPath()));
				//se lanza el comando de incluir en el historial
				GADAPI::ComandoIncluirHistorial::ComandoIncluirHistorialParams* pParams = new GADAPI::ComandoIncluirHistorial::ComandoIncluirHistorialParams(stdPath,true);
				GADAPI::ComandoIncluirHistorial::ComandoIncluirHistorial* pCmd = new GADAPI::ComandoIncluirHistorial::ComandoIncluirHistorial(pParams);
				GNC::Entorno::Instance()->GetControladorComandos()->ProcessAsync(_Std("Storing in the history..."),pCmd, NULL);

				//se actualiza el fichero de configuracion
				GNC::GCS::ConfigurationController::Instance()->writeStringUser("/GinkgoCore/Adquisicion", "PathDefecto", std::string(dd.GetPath().ToUTF8()));
				GNC::GCS::ConfigurationController::Instance()->Flush();
			}
		}
	}

}
