// GTK_P1DVIEW_WND.CPP

// Copyright (C) 2005 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "gtk_p1dview_wnd.h"

#include "p1dview_wcl.h"
#include "gtk_app.h"

/*################################################################################################*/

GtkActionEntry gtk_p1dview_wnd::entries[] =
{
	{ "AttachDetachPlot1D", NULL, "Attach/Detach This View", NULL, "Select whether this view is attached or in an independent window", (GCallback) gtk_p1dview_wnd::popup_AttachDetach },
	{ "DeleteViewPlot1D", NULL, "Delete View", NULL, "Delete this view", (GCallback) gtk_p1dview_wnd::popup_DeleteView }
};

const char * gtk_p1dview_wnd::ui_description =
"<ui>"
"  <popup name='gp1dvMenu'>"
"    <menuitem action='AttachDetachPlot1D'/>"
"    <separator/>"
"    <menuitem action='DeleteViewPlot1D'/>"
"  </popup>"
"</ui>";

gtk_p1dview_wnd::gtk_p1dview_wnd(bool det_flag) :
	gtk_wnd(det_flag)
{
	GtkActionGroup * action_group = gtk_action_group_new("gp1dvActions");
	gtk_action_group_add_actions(action_group, entries, G_N_ELEMENTS(entries), GTK_WIDGET(view_widget));
	
	gtk_ui_manager_insert_action_group(gtk_app::GetUIManager(), action_group, 0);
	
	GError * error = NULL;
	if (!gtk_ui_manager_add_ui_from_string(gtk_app::GetUIManager(), ui_description, -1, & error))
	{
		g_message("Building gp1dv menu failed : %s", error->message);
		g_error_free(error); exit(EXIT_FAILURE);
	}
	
	// set gtk_view::popupmenu so that gtk_ogl_view::ButtonHandler() will display it...
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	
	popupmenu = gtk_ui_manager_get_widget(gtk_app::GetUIManager(), "/gp1dvMenu");
}

gtk_p1dview_wnd::~gtk_p1dview_wnd(void)
{
}

// here are the popup menu callbacks:
// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

void gtk_p1dview_wnd::popup_AttachDetach(GtkWidget *, gpointer data)
{
	gtk_wnd * wnd = iv_Find((GtkWidget *) data);
	p1dview_wcl * wcl = dynamic_cast<p1dview_wcl *>(wnd->GetClient());
	
	gtk_app::GetAppX()->AttachDetachView(wcl);
}

void gtk_p1dview_wnd::popup_DeleteView(GtkWidget *, gpointer data)
{
	gtk_wnd * wnd = iv_Find((GtkWidget *) data);
	p1dview_wcl * wcl = dynamic_cast<p1dview_wcl *>(wnd->GetClient());
	
	gtk_app::GetPrjX()->RemovePlottingClient(wcl);
}

/*################################################################################################*/

// eof
