# WARNING: ghc.spec is automatically generated from ghc.spec.in by
# ./configure.  Make sure you are editing ghc.spec.in, not ghc.spec.
#
# RPM spec file for GHC					         -*-rpm-spec-*-
#
# Copyright [1998..2007] The GHC Team
#
# Thanks to Zoltan Vorosbaranyi <vbzoli@vbzo.li> for suggestions in
# earlier versions and Pixel <pixel@mandrakesoft.com> for coding tips.
#
# This file is subject to the same free software license as GHC.

%define name    ghc
%define version 7.2.2
%define release 1

Name:           %{name}
Version:        %{version}
Release:        %{release}
License:        BSD-like
Group:          Development/Languages/Haskell
URL:            http://haskell.org/ghc/
Source0:        http://haskell.org/ghc/dist/%{version}/ghc-%{version}-src.tar.bz2
Source1:        http://haskell.org/ghc/dist/%{version}/ghc-%{version}-src-extralibs.tar.bz2
Packager:       Sven Panne <sven.panne@aedion.de>
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
PreReq:         update-alternatives
Requires:       gmp, readline
BuildRequires:  update-alternatives, alex >= 2.0, happy >= 1.15, ghc >= 5, haddock, docbook-dtd, docbook-xsl-stylesheets, libxslt, libxml2, fop, xmltex, dvips, gmp, readline-devel, mesaglut-devel
Provides:       haskell
Summary:        The Glasgow Haskell Compiler

%description
Haskell is the standard lazy purely functional programming language.
The current language version is Haskell 98, agreed in December 1998,
with a revised version published in January 2003.

GHC is a state-of-the-art programming suite for Haskell. Included is
an optimising compiler generating good code for a variety of
platforms, together with an interactive system for convenient, quick
development. The distribution includes space and time profiling
facilities, a large collection of libraries, and support for various
language extensions, including concurrency, exceptions, and foreign
language interfaces (C, C++, whatever).

A wide variety of Haskell related resources (tutorials, libraries,
specifications, documentation, compilers, interpreters, references,
contact information, links to research groups) are available from the
Haskell home page at http://haskell.org/.

Authors:
--------
    Krasimir Angelov <ka2_mail@yahoo.com>
    Manuel Chakravarty <chak@cse.unsw.edu.au>
    Koen Claessen <koen@cs.chalmers.se>
    Robert Ennals <Robert.Ennals@cl.cam.ac.uk>
    Sigbjorn Finne <sof@galconn.com>
    Gabrielle Keller <keller@cvs.haskell.org>
    Marcin Kowalczyk <qrczak@knm.org.pl>
    Jeff Lewis <jeff@galconn.com>
    Ian Lynagh <igloo@earth.li>
    Simon Marlow <simonmar@microsoft.com>
    Sven Panne <sven.panne@aedion.de>
    Ross Paterson <ross@soi.city.ac.uk>
    Simon Peyton Jones <simonpj@microsoft.com>
    Don Stewart <dons@cse.unsw.edu.au>
    Volker Stolz <stolz@i2.informatik.rwth-aachen.de>
    Wolfgang Thaller <wolfgang.thaller@gmx.net>
    Andrew Tolmach <apt@cs.pdx.edu>
    Keith Wansbrough <Keith.Wansbrough@cl.cam.ac.uk>
    Michael Weber <michael.weber@post.rwth-aachen.de>
    plus a dozen helping hands...

%package prof
Requires:       ghc = %{version}-%{release}
Summary:        Profiling libraries for GHC
Group:          Development/Libraries

%description prof
Profiling libraries for Glorious Glasgow Haskell Compilation System
(GHC).  They should be installed when GHC's profiling subsystem is
needed.

%prep
%setup -b1

%build
test -f configure || perl boot
./configure --prefix=%{_prefix} --mandir=%{_mandir}

# Don't install these tools, we'll use update-alternatives below.
touch mk/build.mk
echo "NO_INSTALL_RUNHASKELL=YES" >>mk/build.mk
echo "NO_INSTALL_HSC2HS=YES" >>mk/build.mk

make %{?jobs:-j%jobs}
make html
# Alas, we don't pass make options/arguments down to "libraries", so let's redo make here...
make -C libraries HADDOCK_DOCS=YES
( cd libraries/Cabal && docbook2html doc/Cabal.xml --output doc/Cabal )
make -C docs/ext-core ps
make -C docs/storage-mgt ps

%install
# This is a cruel hack: There seems to be no way to install the Haddock
# documentation into the build directory, because DESTDIR is alway prepended.
# Furthermore, rpm removes the target documentation directory before the doc
# macros are processed. Therefore we have to copy things back into safety... :-P
# The right thing would be being able to install directly into the build tree.
make DESTDIR=${RPM_BUILD_ROOT} docdir=%{_datadir}/doc/packages/%{name} HADDOCK_DOCS=YES install install-docs
mkdir html-docs
cp -a ${RPM_BUILD_ROOT}%{_datadir}/doc/packages/%{name}/{index.html,libraries} html-docs
# Use version-less hsc2hs out of the way, we use update-alternatives.
mv ${RPM_BUILD_ROOT}%{_prefix}/bin/hsc2hs ${RPM_BUILD_ROOT}%{_prefix}/bin/hsc2hs-ghc

# generate the file list for lib/ _excluding_ all files needed for profiling
# only
#
# * generating file lists in a BUILD_ROOT spec is a bit tricky: the file list
#   has to contain complete paths, _but_ without the BUILD_ROOT, we also do
#   _not_ want have directory names in the list; furthermore, we have to make
#   sure that any leading / is removed from %{_prefix}/lib, as find has to
#   interpret the argument as a relative path; however, we have to include the
#   leading / again in the final file list (otherwise, rpm complains)
# * isn't there an easier way to do all this?
#
dir=`pwd`
cd ${RPM_BUILD_ROOT}
libdir=`echo %{_prefix}/lib | sed 's|^/||'`
find $libdir ! -type d !  -name '*.p_hi' !   -name '*_p.a'    -print | sed 's|^|/|' > $dir/rpm-noprof-lib-files
find $libdir ! -type d \( -name '*.p_hi' -or -name '*_p.a' \) -print | sed 's|^|/|' > $dir/rpm-prof-lib-files
cd $dir

%clean
rm -rf ${RPM_BUILD_ROOT}

%post
# Alas, GHC, Hugs and nhc all come with different set of tools in addition to
# a runFOO:
#
#   * GHC:  hsc2hs
#   * Hugs: hsc2hs, cpphs
#   * nhc:  cpphs
#
# Therefore it is currently not possible to use --slave below to form link
# groups under a single name 'runhaskell'. Either these tools should be
# disentangled from the Haskell implementations or all implementations should
# have the same set of tools. *sigh*
update-alternatives --install %{_bindir}/runhaskell runhaskell %{_bindir}/runghc     500
update-alternatives --install %{_bindir}/hsc2hs     hsc2hs     %{_bindir}/hsc2hs-ghc 500

%preun
if test "$1" = 0; then
  update-alternatives --remove runhaskell %{_bindir}/runghc
  update-alternatives --remove hsc2hs     %{_bindir}/hsc2hs-ghc
fi

%files -f rpm-noprof-lib-files
%defattr(-,root,root)
%doc docs/docbook-cheat-sheet/docbook-cheat-sheet
%doc ANNOUNCE
%doc LICENSE
%doc README
%doc docs/comm
%doc docs/ext-core/core.ps
%doc docs/storage-mgt/ldv.ps
%doc docs/storage-mgt/rp.ps
%doc docs/storage-mgt/sm.ps
%doc docs/users_guide/users_guide
%doc libraries/Cabal/doc/Cabal
%doc html-docs/*
%{_mandir}/man1/ghc.1*
%{_prefix}/bin/ghc
%{_prefix}/bin/ghc-%{version}
%{_prefix}/bin/ghc-pkg
%{_prefix}/bin/ghc-pkg-%{version}
%{_prefix}/bin/ghci
%{_prefix}/bin/ghci-%{version}
%{_prefix}/bin/ghcprof
%{_prefix}/bin/hp2ps
%{_prefix}/bin/hpc
%{_prefix}/bin/hsc2hs-ghc
%{_prefix}/bin/hsc2hs-%{version}
%{_prefix}/bin/runghc

%files prof -f rpm-prof-lib-files
%defattr(-,root,root)
