/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  types.cc - Pango types C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "types.hh"
#include <gfc/glib/unicode.hh>

using namespace GFC;

/*  Pango::unichar_direction
 */

Pango::Direction 
Pango::unichar_direction(G::Unichar ch)
{
	return (Direction)pango_unichar_direction(ch);
}

/*  Pango::find_base_dir
 */

Pango::Direction 
Pango::find_base_dir(const char *text, int length)
{
	return (Direction)pango_find_base_dir(text, length);
}

/*  Pango::Rectangle
 */

Pango::Rectangle::Rectangle()
{
	set(0, 0, 0, 0);
}

Pango::Rectangle::Rectangle(int x, int y, int width, int height)
{
	set(x, y, width, height);
}

Pango::Rectangle::Rectangle(const PangoRectangle& rectangle)
{
	set(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
}

void
Pango::Rectangle::set(int x, int y, int width, int height)
{
	rectangle_.x = x;
	rectangle_.y = y;
	rectangle_.width = width;
	rectangle_.height = height;
}

