/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
/// @file gfc/gtk/colorselectionsignals.hh
/// @brief Gtk::ColorSelection virtual signal handlers.
///
/// Provides Gtk::ColorSelectionSignals, an abstract base class that implements
/// the overridable virtual signal handlers for Gtk::ColorSelection objects.

#ifndef GFC_GTK_COLOR_SELECTION_SIGNALS_HH
#define GFC_GTK_COLOR_SELECTION_SIGNALS_HH

#ifndef GFC_GTK_CONTAINER_SIGNALS_HH
#include <gfc/gtk/containersignals.hh>
#endif

namespace GFC {

namespace Gtk {

/// @class ColorSelectionSignals colorselectionsignals.hh gfc/gtk/colorselectionsignals.hh
/// @brief Abstract base class that implements the virtual signal handlers for Gtk::ColorSelection.

class ColorSelectionSignals : public ContainerSignals
{
protected:
/// @name Constructors
/// @{
	
	ColorSelectionSignals(ColorSelection *color_selection);
	///< Construct a new ColorSelectionSignals object.
	///< @param color_selection A ColorSelection object inheriting the ColorSelectionSignals implementation.
	
	virtual ~ColorSelectionSignals() = 0;
	///< Destructor.

/// @}

public:
/// @name Signal Handlers
/// @{

	virtual void on_color_changed();
	///< Called when the color changes in the ColorSelection according to its update policy.

/// @}
};

} // namespace Gtk

} // namespace GFC

#endif // GFC_GTK_COLOR_SELECTION_SIGNALS_HH

