

#include <arpa/inet.h>
#include <netinet/in.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/time.h>
#include <time.h>

#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>

#include "stream.h"
#include "getstream.h"

inline void stream_send(struct channel_s *channel, uint8_t *tsp) {
	GList			*sl;

	sl=g_list_first(channel->stream);
	while(sl) {
		struct stream_s		*s=sl->data;
		sl=g_list_next(sl);

		/* Does this stream output have receiver */
		if (s->receiver == 0)
			continue;

		switch(s->type) {
			case(STYPE_UDP):
				stream_send_udp(s, tsp);
				break;
			case(STYPE_RTP):
			case(STYPE_RTCP):
				stream_send_rtp(s, tsp);
				break;
			case(STYPE_HTTP):
				stream_send_http(s, tsp);
				break;
			case(STYPE_PIPE):
				stream_send_pipe(s, tsp);
				break;
		}
	}
}

int stream_init(struct channel_s *channel) {
	GList		*sl;

	sl=g_list_first(channel->stream);

	while(sl) {
		struct stream_s	*s=sl->data;

		s->channel=channel;

		/* Initialize all stream outputs for this stream */
		switch(s->type) {
			case(STYPE_HTTP):
				stream_init_http(s);
				break;
			case(STYPE_UDP):
				stream_init_udp(s);
				break;
			case(STYPE_RTP):
			case(STYPE_RTCP):
				stream_init_rtp(s);
				break;
			case(STYPE_PIPE):
				stream_init_pipe(s);
				break;
		}

		sl=g_list_next(sl);
	}
	return 1;
}

