/*
 * Decompiled with CFR 0.152.
 */
package geotrans.gui;

import geotrans.gui.Accuracy;
import geotrans.gui.jOptions;
import geotrans.jni.GeotransError;
import geotrans.jni.JNIEngine;
import geotrans.jni.JNIException;
import geotrans.jni.JNISource;
import geotrans.jni.JNIStrtoval;
import geotrans.projections.AlbersEqualAreaConic;
import geotrans.projections.AzimuthalEquidistant;
import geotrans.projections.BNG;
import geotrans.projections.Bonne;
import geotrans.projections.Cassini;
import geotrans.projections.CylindricalEqualArea;
import geotrans.projections.Eckert4;
import geotrans.projections.Eckert6;
import geotrans.projections.EquidistantCylindrical;
import geotrans.projections.GARS;
import geotrans.projections.GEOREF;
import geotrans.projections.Geocentric;
import geotrans.projections.Geodetic;
import geotrans.projections.Gnomonic;
import geotrans.projections.LambertConformalConic1;
import geotrans.projections.LambertConformalConic2;
import geotrans.projections.LocalCartesian;
import geotrans.projections.MGRS;
import geotrans.projections.Mercator;
import geotrans.projections.MillerCylindrical;
import geotrans.projections.Mollweide;
import geotrans.projections.NZMG;
import geotrans.projections.Neys;
import geotrans.projections.ObliqueMercator;
import geotrans.projections.Orthographic;
import geotrans.projections.PolarStereographic;
import geotrans.projections.Polyconic;
import geotrans.projections.Sinusoidal;
import geotrans.projections.Stereographic;
import geotrans.projections.TransverseCylindricalEqualArea;
import geotrans.projections.TransverseMercator;
import geotrans.projections.UPS;
import geotrans.projections.USNG;
import geotrans.projections.UTM;
import geotrans.projections.VanDerGrinten;
import geotrans.utility.Platform;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;

public class CoordPanel
extends JPanel {
    private JNIStrtoval jniStrtoval;
    private JNIEngine jniEngine = new JNIEngine();
    private jOptions formatOptions;
    private boolean useNSEW;
    private boolean useMinutes;
    private boolean useSeconds;
    private char hemisphere;
    private int zone;
    private boolean usePrevAccuracies = false;
    private boolean _3dConversion = false;
    private JLabel _2CoordFieldsLabelA;
    private JLabel _2CoordFieldsLabelB;
    private JPanel _2CoordFieldsPanel;
    private JTextField _2CoordFieldsTextFieldA;
    private JTextField _2CoordFieldsTextFieldB;
    private JLabel _3CoordFieldsLabelA;
    private JLabel _3CoordFieldsLabelB;
    private JLabel _3CoordFieldsLabelC;
    private JPanel _3CoordFieldsPanel;
    private JTextField _3CoordFieldsTextFieldA;
    private JTextField _3CoordFieldsTextFieldB;
    private JTextField _3CoordFieldsTextFieldC;
    private JLabel ce90Label;
    private JTextField ce90TextField;
    private JLayeredPane coordLayeredPane;
    private JPanel errorsPanel;
    private JPanel inputErrorPanel;
    private JLabel le90Label;
    private JTextField le90TextField;
    private JPanel outputErrorPanel;
    private JLabel se90Label;
    private JTextField se90TextField;
    private JComboBox sourcesComboBox;
    private JLabel sourcesLabel;
    private JLabel tempLabel1;
    private JLabel tempLabel2;
    private JTextField tempTextField1;
    private JTextField tempTextField2;

    public CoordPanel(jOptions options, JNIStrtoval jniStr) {
        this.formatOptions = options;
        this.jniStrtoval = jniStr;
        this.setFormat();
        this.initComponents();
        this.tempLabel1.setVisible(false);
        this.tempLabel2.setVisible(false);
        this.tempTextField1.setVisible(false);
        this.tempTextField2.setVisible(false);
        if (Platform.isJavaV1_3) {
            this._3CoordFieldsLabelA.setForeground(Color.black);
            this._3CoordFieldsLabelB.setForeground(Color.black);
            this._3CoordFieldsLabelC.setForeground(Color.black);
            this._2CoordFieldsLabelA.setForeground(Color.black);
            this._2CoordFieldsLabelB.setForeground(Color.black);
            this.ce90Label.setForeground(Color.black);
            this.le90Label.setForeground(Color.black);
            this.se90Label.setForeground(Color.black);
            this.sourcesLabel.setForeground(Color.black);
        }
        this.setPanelSizes();
        this.fillAccuracyList();
        if (Platform.isUnix) {
            this._3CoordFieldsLabelA.setFont(new Font("Dialog", 1, 10));
            this._3CoordFieldsLabelB.setFont(new Font("Dialog", 1, 10));
            this._3CoordFieldsLabelC.setFont(new Font("Dialog", 1, 10));
            this._2CoordFieldsLabelA.setFont(new Font("Dialog", 1, 10));
            this._2CoordFieldsLabelB.setFont(new Font("Dialog", 1, 10));
            this.ce90Label.setFont(new Font("Dialog", 1, 10));
            this.le90Label.setFont(new Font("Dialog", 1, 10));
            this.se90Label.setFont(new Font("Dialog", 1, 10));
            this.sourcesLabel.setFont(new Font("Dialog", 1, 10));
            this.sourcesComboBox.setFont(new Font("Dialog", 1, 10));
            this.sourcesComboBox.setMaximumSize(new Dimension(265, 22));
            this.sourcesComboBox.setMinimumSize(new Dimension(265, 22));
            this.sourcesComboBox.setPreferredSize(new Dimension(265, 22));
            this.ce90TextField.setToolTipText("90% CE");
            this.le90TextField.setToolTipText("90% LE");
            this.se90TextField.setToolTipText("90% SE");
        }
    }

    private void initComponents() {
        this.coordLayeredPane = new JLayeredPane();
        this._3CoordFieldsPanel = new JPanel();
        this._3CoordFieldsLabelA = new JLabel();
        this._3CoordFieldsLabelB = new JLabel();
        this._3CoordFieldsLabelC = new JLabel();
        this._3CoordFieldsTextFieldA = new JTextField();
        this._3CoordFieldsTextFieldB = new JTextField();
        this._3CoordFieldsTextFieldC = new JTextField();
        this._2CoordFieldsPanel = new JPanel();
        this._2CoordFieldsLabelA = new JLabel();
        this._2CoordFieldsLabelB = new JLabel();
        this._2CoordFieldsTextFieldA = new JTextField();
        this._2CoordFieldsTextFieldB = new JTextField();
        this.tempLabel1 = new JLabel();
        this.tempLabel2 = new JLabel();
        this.tempTextField1 = new JTextField();
        this.tempTextField2 = new JTextField();
        this.errorsPanel = new JPanel();
        this.outputErrorPanel = new JPanel();
        this.ce90Label = new JLabel();
        this.le90Label = new JLabel();
        this.se90Label = new JLabel();
        this.ce90TextField = new JTextField();
        this.le90TextField = new JTextField();
        this.se90TextField = new JTextField();
        this.inputErrorPanel = new JPanel();
        this.sourcesLabel = new JLabel();
        this.sourcesComboBox = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.setMinimumSize(new Dimension(439, 80));
        this.setPreferredSize(new Dimension(439, 80));
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                CoordPanel.this.formComponentResized(evt);
            }
        });
        this.coordLayeredPane.setMaximumSize(new Dimension(439, 36));
        this.coordLayeredPane.setMinimumSize(new Dimension(439, 38));
        this.coordLayeredPane.setPreferredSize(new Dimension(460, 38));
        this.coordLayeredPane.setOpaque(true);
        this._3CoordFieldsPanel.setLayout(new GridLayout(2, 3, 12, 0));
        this._3CoordFieldsPanel.setMaximumSize(new Dimension(339, 36));
        this._3CoordFieldsPanel.setMinimumSize(new Dimension(339, 36));
        this._3CoordFieldsPanel.setPreferredSize(new Dimension(339, 36));
        this._3CoordFieldsPanel.setOpaque(false);
        this._3CoordFieldsLabelA.setText("X (m):");
        this._3CoordFieldsLabelA.setMaximumSize(new Dimension(105, 16));
        this._3CoordFieldsLabelA.setMinimumSize(new Dimension(105, 16));
        this._3CoordFieldsLabelA.setPreferredSize(new Dimension(105, 16));
        this._3CoordFieldsLabelA.setOpaque(true);
        this._3CoordFieldsPanel.add(this._3CoordFieldsLabelA);
        this._3CoordFieldsLabelB.setText("Y (m):");
        this._3CoordFieldsLabelB.setMaximumSize(new Dimension(105, 16));
        this._3CoordFieldsLabelB.setMinimumSize(new Dimension(105, 16));
        this._3CoordFieldsLabelB.setPreferredSize(new Dimension(105, 16));
        this._3CoordFieldsLabelB.setOpaque(true);
        this._3CoordFieldsPanel.add(this._3CoordFieldsLabelB);
        this._3CoordFieldsLabelC.setText("Z (m):");
        this._3CoordFieldsLabelC.setMaximumSize(new Dimension(105, 16));
        this._3CoordFieldsLabelC.setMinimumSize(new Dimension(105, 16));
        this._3CoordFieldsLabelC.setPreferredSize(new Dimension(105, 16));
        this._3CoordFieldsLabelC.setOpaque(true);
        this._3CoordFieldsPanel.add(this._3CoordFieldsLabelC);
        this._3CoordFieldsTextFieldA.setText("0.0");
        this._3CoordFieldsTextFieldA.setBorder(new BevelBorder(1));
        this._3CoordFieldsTextFieldA.setMinimumSize(new Dimension(105, 20));
        this._3CoordFieldsTextFieldA.setPreferredSize(new Dimension(105, 20));
        this._3CoordFieldsPanel.add(this._3CoordFieldsTextFieldA);
        this._3CoordFieldsTextFieldB.setText("0.0");
        this._3CoordFieldsTextFieldB.setBorder(new BevelBorder(1));
        this._3CoordFieldsTextFieldB.setMinimumSize(new Dimension(105, 20));
        this._3CoordFieldsTextFieldB.setPreferredSize(new Dimension(105, 20));
        this._3CoordFieldsPanel.add(this._3CoordFieldsTextFieldB);
        this._3CoordFieldsTextFieldC.setText("0.0");
        this._3CoordFieldsTextFieldC.setBorder(new BevelBorder(1));
        this._3CoordFieldsTextFieldC.setMinimumSize(new Dimension(105, 20));
        this._3CoordFieldsTextFieldC.setPreferredSize(new Dimension(105, 20));
        this._3CoordFieldsPanel.add(this._3CoordFieldsTextFieldC);
        this._3CoordFieldsPanel.setBounds(2, 2, 439, 37);
        this.coordLayeredPane.add((Component)this._3CoordFieldsPanel, JLayeredPane.DEFAULT_LAYER);
        this._2CoordFieldsPanel.setLayout(new GridBagLayout());
        this._2CoordFieldsPanel.setMaximumSize(new Dimension(229, 36));
        this._2CoordFieldsPanel.setMinimumSize(new Dimension(229, 36));
        this._2CoordFieldsPanel.setPreferredSize(new Dimension(229, 36));
        this._2CoordFieldsPanel.setOpaque(false);
        this._2CoordFieldsLabelA.setText("Easting / X (m):");
        this._2CoordFieldsLabelA.setAlignmentX(1.0f);
        this._2CoordFieldsLabelA.setMaximumSize(new Dimension(106, 16));
        this._2CoordFieldsLabelA.setMinimumSize(new Dimension(106, 16));
        this._2CoordFieldsLabelA.setPreferredSize(new Dimension(106, 16));
        this._2CoordFieldsLabelA.setOpaque(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this._2CoordFieldsPanel.add((Component)this._2CoordFieldsLabelA, gridBagConstraints);
        this._2CoordFieldsLabelB.setText("Northing / Y (m):");
        this._2CoordFieldsLabelB.setMaximumSize(new Dimension(106, 16));
        this._2CoordFieldsLabelB.setMinimumSize(new Dimension(106, 16));
        this._2CoordFieldsLabelB.setPreferredSize(new Dimension(106, 16));
        this._2CoordFieldsLabelB.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this._2CoordFieldsPanel.add((Component)this._2CoordFieldsLabelB, gridBagConstraints);
        this._2CoordFieldsTextFieldA.setText("0.0");
        this._2CoordFieldsTextFieldA.setAlignmentX(1.0f);
        this._2CoordFieldsTextFieldA.setBorder(new BevelBorder(1));
        this._2CoordFieldsTextFieldA.setMargin(new Insets(0, 0, 5, 0));
        this._2CoordFieldsTextFieldA.setMinimumSize(new Dimension(106, 20));
        this._2CoordFieldsTextFieldA.setPreferredSize(new Dimension(106, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 1, 6);
        this._2CoordFieldsPanel.add((Component)this._2CoordFieldsTextFieldA, gridBagConstraints);
        this._2CoordFieldsTextFieldB.setText("0.0");
        this._2CoordFieldsTextFieldB.setBorder(new BevelBorder(1));
        this._2CoordFieldsTextFieldB.setMargin(new Insets(0, 0, 5, 0));
        this._2CoordFieldsTextFieldB.setMinimumSize(new Dimension(106, 20));
        this._2CoordFieldsTextFieldB.setPreferredSize(new Dimension(106, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 6, 1, 6);
        this._2CoordFieldsPanel.add((Component)this._2CoordFieldsTextFieldB, gridBagConstraints);
        this.tempLabel1.setText("Easting / X (m):");
        this.tempLabel1.setAlignmentX(1.0f);
        this.tempLabel1.setMaximumSize(new Dimension(106, 16));
        this.tempLabel1.setMinimumSize(new Dimension(106, 16));
        this.tempLabel1.setPreferredSize(new Dimension(106, 16));
        this.tempLabel1.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 6);
        this._2CoordFieldsPanel.add((Component)this.tempLabel1, gridBagConstraints);
        this.tempLabel2.setText("Northing / Y (m):");
        this.tempLabel2.setMaximumSize(new Dimension(106, 16));
        this.tempLabel2.setMinimumSize(new Dimension(106, 16));
        this.tempLabel2.setPreferredSize(new Dimension(106, 16));
        this.tempLabel2.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this._2CoordFieldsPanel.add((Component)this.tempLabel2, gridBagConstraints);
        this.tempTextField1.setText("0.0");
        this.tempTextField1.setAlignmentX(1.0f);
        this.tempTextField1.setBorder(new BevelBorder(1));
        this.tempTextField1.setMargin(new Insets(0, 0, 5, 0));
        this.tempTextField1.setMinimumSize(new Dimension(106, 20));
        this.tempTextField1.setPreferredSize(new Dimension(106, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 1, 6);
        this._2CoordFieldsPanel.add((Component)this.tempTextField1, gridBagConstraints);
        this.tempTextField2.setText("0.0");
        this.tempTextField2.setBorder(new BevelBorder(1));
        this.tempTextField2.setMargin(new Insets(0, 0, 5, 0));
        this.tempTextField2.setMinimumSize(new Dimension(106, 20));
        this.tempTextField2.setPreferredSize(new Dimension(106, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 6, 1, 0);
        this._2CoordFieldsPanel.add((Component)this.tempTextField2, gridBagConstraints);
        this._2CoordFieldsPanel.setBounds(4, 2, 460, 45);
        this.coordLayeredPane.add((Component)this._2CoordFieldsPanel, JLayeredPane.DEFAULT_LAYER);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        this.add((Component)this.coordLayeredPane, gridBagConstraints);
        this.errorsPanel.setLayout(new GridBagLayout());
        this.errorsPanel.setMinimumSize(new Dimension(460, 40));
        this.errorsPanel.setPreferredSize(new Dimension(460, 40));
        this.errorsPanel.setOpaque(false);
        this.outputErrorPanel.setLayout(new GridBagLayout());
        this.outputErrorPanel.setMinimumSize(new Dimension(170, 40));
        this.outputErrorPanel.setPreferredSize(new Dimension(170, 40));
        this.outputErrorPanel.setOpaque(false);
        this.ce90Label.setText("90% CE:");
        this.ce90Label.setMaximumSize(new Dimension(48, 16));
        this.ce90Label.setMinimumSize(new Dimension(48, 16));
        this.ce90Label.setPreferredSize(new Dimension(48, 16));
        this.ce90Label.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.outputErrorPanel.add((Component)this.ce90Label, gridBagConstraints);
        this.le90Label.setText("90% LE:");
        this.le90Label.setMaximumSize(new Dimension(48, 16));
        this.le90Label.setMinimumSize(new Dimension(48, 16));
        this.le90Label.setPreferredSize(new Dimension(48, 16));
        this.le90Label.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.outputErrorPanel.add((Component)this.le90Label, gridBagConstraints);
        this.se90Label.setText("90% SE:");
        this.se90Label.setMaximumSize(new Dimension(48, 16));
        this.se90Label.setMinimumSize(new Dimension(48, 16));
        this.se90Label.setPreferredSize(new Dimension(48, 16));
        this.se90Label.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.outputErrorPanel.add((Component)this.se90Label, gridBagConstraints);
        this.ce90TextField.setToolTipText("");
        this.ce90TextField.setBorder(new BevelBorder(1));
        this.ce90TextField.setMinimumSize(new Dimension(48, 20));
        this.ce90TextField.setPreferredSize(new Dimension(48, 20));
        this.ce90TextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                CoordPanel.this.accuracyTextFieldKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.outputErrorPanel.add((Component)this.ce90TextField, gridBagConstraints);
        this.le90TextField.setToolTipText("");
        this.le90TextField.setBorder(new BevelBorder(1));
        this.le90TextField.setMinimumSize(new Dimension(48, 20));
        this.le90TextField.setPreferredSize(new Dimension(48, 20));
        this.le90TextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                CoordPanel.this.accuracyTextFieldKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.outputErrorPanel.add((Component)this.le90TextField, gridBagConstraints);
        this.se90TextField.setToolTipText("");
        this.se90TextField.setBorder(new BevelBorder(1));
        this.se90TextField.setMinimumSize(new Dimension(48, 20));
        this.se90TextField.setPreferredSize(new Dimension(48, 20));
        this.se90TextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                CoordPanel.this.accuracyTextFieldKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.outputErrorPanel.add((Component)this.se90TextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 5);
        this.errorsPanel.add((Component)this.outputErrorPanel, gridBagConstraints);
        this.inputErrorPanel.setLayout(new GridBagLayout());
        this.inputErrorPanel.setMinimumSize(new Dimension(265, 40));
        this.inputErrorPanel.setPreferredSize(new Dimension(265, 40));
        this.sourcesLabel.setHorizontalAlignment(2);
        this.sourcesLabel.setText("Sources:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.inputErrorPanel.add((Component)this.sourcesLabel, gridBagConstraints);
        this.sourcesComboBox.setMinimumSize(new Dimension(265, 23));
        this.sourcesComboBox.setPreferredSize(new Dimension(265, 23));
        this.sourcesComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CoordPanel.this.sourcesComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.inputErrorPanel.add((Component)this.sourcesComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 3);
        this.errorsPanel.add((Component)this.inputErrorPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        this.add((Component)this.errorsPanel, gridBagConstraints);
    }

    private void accuracyTextFieldKeyTyped(KeyEvent evt) {
        char keyChar = evt.getKeyChar();
        if (keyChar != '\n') {
            this.usePrevAccuracies = false;
        }
    }

    private void sourcesComboBoxActionPerformed(ActionEvent evt) {
        this.updateAccuracy();
    }

    private void formComponentResized(ComponentEvent evt) {
        this.setPanelSizes();
    }

    private void fillAccuracyList() {
        try {
            JNISource jniSource = new JNISource();
            String sourceName = "";
            long sourceCount = jniSource.JNISourceCount();
            int i = 1;
            while ((long)i <= sourceCount) {
                sourceName = jniSource.JNISourceName(i);
                this.sourcesComboBox.addItem(sourceName);
                ++i;
            }
        }
        catch (GeotransError e) {
            this.jniStrtoval.displayErrorMsg(new JFrame(), e.getMessage());
        }
        catch (JNIException e) {
            this.jniStrtoval.displayErrorMsg(new JFrame(), e.getMessage());
        }
    }

    private void setOneCoord() {
        this._2CoordFieldsPanel.setVisible(false);
        this._3CoordFieldsPanel.setVisible(true);
        this.coordLayeredPane.moveToFront(this._3CoordFieldsPanel);
        this._3CoordFieldsLabelA.setVisible(false);
        this._3CoordFieldsLabelC.setVisible(false);
        this._3CoordFieldsTextFieldA.setVisible(false);
        this._3CoordFieldsTextFieldC.setVisible(false);
        this._3CoordFieldsLabelB.setText("Coordinate String:");
    }

    private void setTwoCoords() {
        this._3CoordFieldsPanel.setVisible(false);
        this._2CoordFieldsPanel.setVisible(true);
        this.coordLayeredPane.moveToFront(this._2CoordFieldsPanel);
        this._2CoordFieldsLabelA.setText("Easting / X (m):");
        this._2CoordFieldsLabelB.setText("Northing / Y (m):");
        this._2CoordFieldsTextFieldA.setText("0");
        this._2CoordFieldsTextFieldB.setText("0");
    }

    private void setThreeCoords() {
        this._2CoordFieldsPanel.setVisible(false);
        this._3CoordFieldsPanel.setVisible(true);
        this.coordLayeredPane.moveToFront(this._3CoordFieldsPanel);
        this._3CoordFieldsLabelA.setVisible(true);
        this._3CoordFieldsLabelC.setVisible(true);
        this._3CoordFieldsTextFieldA.setVisible(true);
        this._3CoordFieldsTextFieldC.setVisible(true);
        this.setHeightFieldEditable();
        this._3CoordFieldsLabelA.setText("X (m):");
        this._3CoordFieldsLabelB.setText("Y (m):");
        this._3CoordFieldsLabelC.setText("Z (m):");
        this._3CoordFieldsTextFieldA.setText("0");
        this._3CoordFieldsTextFieldB.setText("0");
        this._3CoordFieldsTextFieldC.setText("0");
    }

    private void setFormat() {
        this.useNSEW = this.formatOptions.getUseNSEW();
        this.useMinutes = this.formatOptions.getUseMinutes();
        this.useSeconds = this.formatOptions.getUseSeconds();
    }

    private void setPanelSizes() {
        Dimension dsize = new Dimension();
        dsize = this.coordLayeredPane.getSize();
        this._2CoordFieldsPanel.setBounds(0, 0, dsize.width, dsize.height);
        this._3CoordFieldsPanel.setBounds(0, 0, dsize.width, dsize.height);
        this._2CoordFieldsPanel.updateUI();
        this._3CoordFieldsPanel.updateUI();
    }

    public void setCoords(int state, int direction, int projType) {
        try {
            switch (projType) {
                case 9: {
                    AlbersEqualAreaConic albersCoords = new AlbersEqualAreaConic(this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"), this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    this.jniEngine.JNISetAlbersEqualAreaConicCoordinates(state, direction, albersCoords);
                    break;
                }
                case 10: {
                    AzimuthalEquidistant azeqCoords = new AzimuthalEquidistant(this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"), this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    this.jniEngine.JNISetAzimuthalEquidistantCoordinates(state, direction, azeqCoords);
                    break;
                }
                case 11: {
                    BNG BNGCoords = new BNG(this._3CoordFieldsTextFieldB.getText().trim());
                    this.jniEngine.JNISetBNGCoordinates(state, direction, BNGCoords);
                    break;
                }
                case 12: {
                    Bonne bonneCoords = new Bonne(this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"), this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    this.jniEngine.JNISetBonneCoordinates(state, direction, bonneCoords);
                    break;
                }
                case 13: {
                    Cassini cassiniCoords = new Cassini(this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"), this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    this.jniEngine.JNISetCassiniCoordinates(state, direction, cassiniCoords);
                    break;
                }
                case 14: {
                    CylindricalEqualArea cyleqaCoords = new CylindricalEqualArea(this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"), this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    this.jniEngine.JNISetCylindricalEqualAreaCoordinates(state, direction, cyleqaCoords);
                    break;
                }
                case 15: {
                    Eckert4 eckert4Coords = new Eckert4(this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"), this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    this.jniEngine.JNISetEckert4Coordinates(state, direction, eckert4Coords);
                    break;
                }
                case 16: {
                    Eckert6 eckert6Coords = new Eckert6(this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"), this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    this.jniEngine.JNISetEckert6Coordinates(state, direction, eckert6Coords);
                    break;
                }
                case 17: {
                    EquidistantCylindrical eqdcylCoords = new EquidistantCylindrical(this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"), this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    this.jniEngine.JNISetEquidistantCylindricalCoordinates(state, direction, eqdcylCoords);
                    break;
                }
                case 35: {
                    String coordString = this._3CoordFieldsTextFieldB.getText().trim();
                    int length = coordString.length();
                    MGRS MGRSCoords = coordString.charAt(length - 1) == '0' && coordString.charAt(length - 2) == '0' ? new MGRS(coordString.substring(0, length - 2)) : new MGRS(coordString);
                    this.jniEngine.JNISetMGRSCoordinates(state, direction, MGRSCoords);
                    break;
                }
                case 2: {
                    GARS GARSCoords = new GARS(this._3CoordFieldsTextFieldB.getText().trim());
                    this.jniEngine.JNISetGARSCoordinates(state, direction, GARSCoords);
                    break;
                }
                case 3: {
                    Geocentric geocentricCoords = new Geocentric(this.jniStrtoval.stringToDouble(this._3CoordFieldsTextFieldA.getText().trim(), "Invalid coord X"), this.jniStrtoval.stringToDouble(this._3CoordFieldsTextFieldB.getText().trim(), "Invalid coord Y"), this.jniStrtoval.stringToDouble(this._3CoordFieldsTextFieldC.getText().trim(), "Invalid coord Z"));
                    this.jniEngine.JNISetGeocentricCoordinates(state, direction, geocentricCoords);
                    break;
                }
                case 0: {
                    Geodetic geodeticCoords = new Geodetic(this.jniStrtoval.stringToLongitude(this._3CoordFieldsTextFieldA.getText().trim(), "Invalid Longitude"), this.jniStrtoval.stringToLatitude(this._3CoordFieldsTextFieldB.getText().trim(), "Invalid Latitude"), this.jniStrtoval.stringToDouble(this._3CoordFieldsTextFieldC.getText().trim(), "Invalid Height"));
                    this.jniEngine.JNISetGeodeticCoordinates(state, direction, geodeticCoords);
                    break;
                }
                case 1: {
                    GEOREF GEOREFCoords = new GEOREF(this._3CoordFieldsTextFieldB.getText().trim());
                    this.jniEngine.JNISetGEOREFCoordinates(state, direction, GEOREFCoords);
                    break;
                }
                case 18: {
                    Gnomonic gnomonicCoords = new Gnomonic(this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"), this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    this.jniEngine.JNISetGnomonicCoordinates(state, direction, gnomonicCoords);
                    break;
                }
                case 19: {
                    LambertConformalConic1 lambert1Coords = new LambertConformalConic1(this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"), this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    this.jniEngine.JNISetLambertConformalConic1Coordinates(state, direction, lambert1Coords);
                    break;
                }
                case 20: {
                    LambertConformalConic2 lambert2Coords = new LambertConformalConic2(this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"), this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    this.jniEngine.JNISetLambertConformalConic2Coordinates(state, direction, lambert2Coords);
                    break;
                }
                case 4: {
                    LocalCartesian loccartCoords = new LocalCartesian(this.jniStrtoval.stringToDouble(this._3CoordFieldsTextFieldA.getText().trim(), "Invalid coord X"), this.jniStrtoval.stringToDouble(this._3CoordFieldsTextFieldB.getText().trim(), "Invalid coord Y"), this.jniStrtoval.stringToDouble(this._3CoordFieldsTextFieldC.getText().trim(), "Invalid coord Z"));
                    this.jniEngine.JNISetLocalCartesianCoordinates(state, direction, loccartCoords);
                    break;
                }
                case 21: {
                    Mercator mercatorCoords = new Mercator(this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"), this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    this.jniEngine.JNISetMercatorCoordinates(state, direction, mercatorCoords);
                    break;
                }
                case 5: {
                    MGRS MGRSCoords = new MGRS(this._3CoordFieldsTextFieldB.getText().trim());
                    this.jniEngine.JNISetMGRSCoordinates(state, direction, MGRSCoords);
                    break;
                }
                case 22: {
                    MillerCylindrical millerCoords = new MillerCylindrical(this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"), this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    this.jniEngine.JNISetMillerCylindricalCoordinates(state, direction, millerCoords);
                    break;
                }
                case 23: {
                    Mollweide mollweidCoords = new Mollweide(this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"), this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    this.jniEngine.JNISetMollweideCoordinates(state, direction, mollweidCoords);
                    break;
                }
                case 24: {
                    Neys neysCoords = new Neys(this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"), this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    this.jniEngine.JNISetNeysCoordinates(state, direction, neysCoords);
                    break;
                }
                case 25: {
                    NZMG NZMGCoords = new NZMG(this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"), this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    this.jniEngine.JNISetNZMGCoordinates(state, direction, NZMGCoords);
                    break;
                }
                case 26: {
                    ObliqueMercator omercCoords = new ObliqueMercator(this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"), this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    this.jniEngine.JNISetObliqueMercatorCoordinates(state, direction, omercCoords);
                    break;
                }
                case 27: {
                    Orthographic orthogrCoords = new Orthographic(this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"), this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    this.jniEngine.JNISetOrthographicCoordinates(state, direction, orthogrCoords);
                    break;
                }
                case 28: {
                    PolarStereographic polarstCoords = new PolarStereographic(this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"), this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    this.jniEngine.JNISetPolarStereographicCoordinates(state, direction, polarstCoords);
                    break;
                }
                case 29: {
                    Polyconic polyconCoords = new Polyconic(this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"), this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    this.jniEngine.JNISetPolyconicCoordinates(state, direction, polyconCoords);
                    break;
                }
                case 30: {
                    Sinusoidal sinusoidCoords = new Sinusoidal(this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"), this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    this.jniEngine.JNISetSinusoidalCoordinates(state, direction, sinusoidCoords);
                    break;
                }
                case 31: {
                    Stereographic stereogrCoords = new Stereographic(this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"), this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    this.jniEngine.JNISetStereographicCoordinates(state, direction, stereogrCoords);
                    break;
                }
                case 32: {
                    TransverseCylindricalEqualArea trcyleqaCoords = new TransverseCylindricalEqualArea(this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"), this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    this.jniEngine.JNISetTransverseCylindricalEqualAreaCoordinates(state, direction, trcyleqaCoords);
                    break;
                }
                case 33: {
                    TransverseMercator tranmercCoords = new TransverseMercator(this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"), this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    this.jniEngine.JNISetTransverseMercatorCoordinates(state, direction, tranmercCoords);
                    break;
                }
                case 34: {
                    VanDerGrinten grintenCoords = new VanDerGrinten(this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"), this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    this.jniEngine.JNISetVanDerGrintenCoordinates(state, direction, grintenCoords);
                    break;
                }
                case 8: {
                    UPS UPSCoords = new UPS(this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"), this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"), this.hemisphere);
                    this.jniEngine.JNISetUPSCoordinates(state, direction, UPSCoords);
                    break;
                }
                case 6: {
                    USNG USNGCoords = new USNG(this._3CoordFieldsTextFieldB.getText().trim());
                    this.jniEngine.JNISetUSNGCoordinates(state, direction, USNGCoords);
                    break;
                }
                case 7: {
                    UTM UTMCoords = new UTM(this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"), this.jniStrtoval.stringToDouble(this._2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"), this.zone, this.hemisphere);
                    this.jniEngine.JNISetUTMCoordinates(state, direction, UTMCoords);
                    break;
                }
            }
        }
        catch (GeotransError e) {
            this.jniStrtoval.setEngineError(true, e.getMessage());
        }
        catch (JNIException e) {
            this.jniStrtoval.setJNIError(true, e.getMessage());
        }
    }

    public boolean getCoords(int state, int direction, int projType) {
        boolean noErrors = true;
        this.setFormat();
        try {
            switch (projType) {
                case 9: {
                    AlbersEqualAreaConic albersCoords = this.jniEngine.JNIGetAlbersEqualAreaConicCoordinates(state, direction);
                    this._2CoordFieldsTextFieldA.setText(this.jniStrtoval.JNIMeterToString(albersCoords.getEasting()));
                    this._2CoordFieldsTextFieldB.setText(this.jniStrtoval.JNIMeterToString(albersCoords.getNorthing()));
                    break;
                }
                case 10: {
                    AzimuthalEquidistant azeqCoords = this.jniEngine.JNIGetAzimuthalEquidistantCoordinates(state, direction);
                    this._2CoordFieldsTextFieldA.setText(this.jniStrtoval.JNIMeterToString(azeqCoords.getEasting()));
                    this._2CoordFieldsTextFieldB.setText(this.jniStrtoval.JNIMeterToString(azeqCoords.getNorthing()));
                    break;
                }
                case 11: {
                    BNG BNGCoords = this.jniEngine.JNIGetBNGCoordinates(state, direction);
                    this._3CoordFieldsTextFieldB.setText(BNGCoords.getCoordinateString());
                    break;
                }
                case 12: {
                    Bonne bonneCoords = this.jniEngine.JNIGetBonneCoordinates(state, direction);
                    this._2CoordFieldsTextFieldA.setText(this.jniStrtoval.JNIMeterToString(bonneCoords.getEasting()));
                    this._2CoordFieldsTextFieldB.setText(this.jniStrtoval.JNIMeterToString(bonneCoords.getNorthing()));
                    break;
                }
                case 13: {
                    Cassini cassiniCoords = this.jniEngine.JNIGetCassiniCoordinates(state, direction);
                    this._2CoordFieldsTextFieldA.setText(this.jniStrtoval.JNIMeterToString(cassiniCoords.getEasting()));
                    this._2CoordFieldsTextFieldB.setText(this.jniStrtoval.JNIMeterToString(cassiniCoords.getNorthing()));
                    break;
                }
                case 14: {
                    CylindricalEqualArea cyleqaCoords = this.jniEngine.JNIGetCylindricalEqualAreaCoordinates(state, direction);
                    this._2CoordFieldsTextFieldA.setText(this.jniStrtoval.JNIMeterToString(cyleqaCoords.getEasting()));
                    this._2CoordFieldsTextFieldB.setText(this.jniStrtoval.JNIMeterToString(cyleqaCoords.getNorthing()));
                    break;
                }
                case 15: {
                    Eckert4 eckert4Coords = this.jniEngine.JNIGetEckert4Coordinates(state, direction);
                    this._2CoordFieldsTextFieldA.setText(this.jniStrtoval.JNIMeterToString(eckert4Coords.getEasting()));
                    this._2CoordFieldsTextFieldB.setText(this.jniStrtoval.JNIMeterToString(eckert4Coords.getNorthing()));
                    break;
                }
                case 16: {
                    Eckert6 eckert6Coords = this.jniEngine.JNIGetEckert6Coordinates(state, direction);
                    this._2CoordFieldsTextFieldA.setText(this.jniStrtoval.JNIMeterToString(eckert6Coords.getEasting()));
                    this._2CoordFieldsTextFieldB.setText(this.jniStrtoval.JNIMeterToString(eckert6Coords.getNorthing()));
                    break;
                }
                case 17: {
                    EquidistantCylindrical eqdcylCoords = this.jniEngine.JNIGetEquidistantCylindricalCoordinates(state, direction);
                    this._2CoordFieldsTextFieldA.setText(this.jniStrtoval.JNIMeterToString(eqdcylCoords.getEasting()));
                    this._2CoordFieldsTextFieldB.setText(this.jniStrtoval.JNIMeterToString(eqdcylCoords.getNorthing()));
                    break;
                }
                case 35: {
                    MGRS MGRSCoords = this.jniEngine.JNIGetMGRSCoordinates(state, direction);
                    String temp = MGRSCoords.getCoordinateString();
                    if (this.jniEngine.JNIGetPrecision() == 0) {
                        this._3CoordFieldsTextFieldB.setText(temp + "00");
                        break;
                    }
                    this._3CoordFieldsTextFieldB.setText(temp);
                    break;
                }
                case 2: {
                    GARS GARSCoords = this.jniEngine.JNIGetGARSCoordinates(state, direction);
                    this._3CoordFieldsTextFieldB.setText(GARSCoords.getCoordinateString());
                    break;
                }
                case 3: {
                    Geocentric geocentricCoords = this.jniEngine.JNIGetGeocentricCoordinates(state, direction);
                    this._3CoordFieldsTextFieldA.setText(this.jniStrtoval.JNIMeterToString(geocentricCoords.getX()));
                    this._3CoordFieldsTextFieldB.setText(this.jniStrtoval.JNIMeterToString(geocentricCoords.getY()));
                    this._3CoordFieldsTextFieldC.setText(this.jniStrtoval.JNIMeterToString(geocentricCoords.getZ()));
                    break;
                }
                case 0: {
                    Geodetic geodeticCoords = this.jniEngine.JNIGetGeodeticCoordinates(state, direction);
                    this._3CoordFieldsTextFieldA.setText(this.jniStrtoval.JNILongitudeToString(geodeticCoords.getLongitude() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._3CoordFieldsTextFieldB.setText(this.jniStrtoval.JNILatitudeToString(geodeticCoords.getLatitude() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._3CoordFieldsTextFieldC.setText(this.jniStrtoval.JNIMeterToString(geodeticCoords.getHeight()));
                    break;
                }
                case 1: {
                    GEOREF GEOREFCoords = this.jniEngine.JNIGetGEOREFCoordinates(state, direction);
                    this._3CoordFieldsTextFieldB.setText(GEOREFCoords.getCoordinateString());
                    break;
                }
                case 18: {
                    Gnomonic gnomonicCoords = this.jniEngine.JNIGetGnomonicCoordinates(state, direction);
                    this._2CoordFieldsTextFieldA.setText(this.jniStrtoval.JNIMeterToString(gnomonicCoords.getEasting()));
                    this._2CoordFieldsTextFieldB.setText(this.jniStrtoval.JNIMeterToString(gnomonicCoords.getNorthing()));
                    break;
                }
                case 19: {
                    LambertConformalConic1 lambert1Coords = this.jniEngine.JNIGetLambertConformalConic1Coordinates(state, direction);
                    this._2CoordFieldsTextFieldA.setText(this.jniStrtoval.JNIMeterToString(lambert1Coords.getEasting()));
                    this._2CoordFieldsTextFieldB.setText(this.jniStrtoval.JNIMeterToString(lambert1Coords.getNorthing()));
                    break;
                }
                case 20: {
                    LambertConformalConic2 lambert2Coords = this.jniEngine.JNIGetLambertConformalConic2Coordinates(state, direction);
                    this._2CoordFieldsTextFieldA.setText(this.jniStrtoval.JNIMeterToString(lambert2Coords.getEasting()));
                    this._2CoordFieldsTextFieldB.setText(this.jniStrtoval.JNIMeterToString(lambert2Coords.getNorthing()));
                    break;
                }
                case 4: {
                    LocalCartesian loccartCoords = this.jniEngine.JNIGetLocalCartesianCoordinates(state, direction);
                    this._3CoordFieldsTextFieldA.setText(this.jniStrtoval.JNIMeterToString(loccartCoords.getX()));
                    this._3CoordFieldsTextFieldB.setText(this.jniStrtoval.JNIMeterToString(loccartCoords.getY()));
                    this._3CoordFieldsTextFieldC.setText(this.jniStrtoval.JNIMeterToString(loccartCoords.getZ()));
                    break;
                }
                case 21: {
                    Mercator mercatorCoords = this.jniEngine.JNIGetMercatorCoordinates(state, direction);
                    this._2CoordFieldsTextFieldA.setText(this.jniStrtoval.JNIMeterToString(mercatorCoords.getEasting()));
                    this._2CoordFieldsTextFieldB.setText(this.jniStrtoval.JNIMeterToString(mercatorCoords.getNorthing()));
                    break;
                }
                case 5: {
                    MGRS MGRSCoords = this.jniEngine.JNIGetMGRSCoordinates(state, direction);
                    this._3CoordFieldsTextFieldB.setText(MGRSCoords.getCoordinateString());
                    break;
                }
                case 22: {
                    MillerCylindrical millerCoords = this.jniEngine.JNIGetMillerCylindricalCoordinates(state, direction);
                    this._2CoordFieldsTextFieldA.setText(this.jniStrtoval.JNIMeterToString(millerCoords.getEasting()));
                    this._2CoordFieldsTextFieldB.setText(this.jniStrtoval.JNIMeterToString(millerCoords.getNorthing()));
                    break;
                }
                case 23: {
                    Mollweide mollweidCoords = this.jniEngine.JNIGetMollweideCoordinates(state, direction);
                    this._2CoordFieldsTextFieldA.setText(this.jniStrtoval.JNIMeterToString(mollweidCoords.getEasting()));
                    this._2CoordFieldsTextFieldB.setText(this.jniStrtoval.JNIMeterToString(mollweidCoords.getNorthing()));
                    break;
                }
                case 24: {
                    Neys neysCoords = this.jniEngine.JNIGetNeysCoordinates(state, direction);
                    this._2CoordFieldsTextFieldA.setText(this.jniStrtoval.JNIMeterToString(neysCoords.getEasting()));
                    this._2CoordFieldsTextFieldB.setText(this.jniStrtoval.JNIMeterToString(neysCoords.getNorthing()));
                    break;
                }
                case 25: {
                    NZMG NZMGCoords = this.jniEngine.JNIGetNZMGCoordinates(state, direction);
                    this._2CoordFieldsTextFieldA.setText(this.jniStrtoval.JNIMeterToString(NZMGCoords.getEasting()));
                    this._2CoordFieldsTextFieldB.setText(this.jniStrtoval.JNIMeterToString(NZMGCoords.getNorthing()));
                    break;
                }
                case 26: {
                    ObliqueMercator omercCoords = this.jniEngine.JNIGetObliqueMercatorCoordinates(state, direction);
                    this._2CoordFieldsTextFieldA.setText(this.jniStrtoval.JNIMeterToString(omercCoords.getEasting()));
                    this._2CoordFieldsTextFieldB.setText(this.jniStrtoval.JNIMeterToString(omercCoords.getNorthing()));
                    break;
                }
                case 27: {
                    Orthographic orthogrCoords = this.jniEngine.JNIGetOrthographicCoordinates(state, direction);
                    this._2CoordFieldsTextFieldA.setText(this.jniStrtoval.JNIMeterToString(orthogrCoords.getEasting()));
                    this._2CoordFieldsTextFieldB.setText(this.jniStrtoval.JNIMeterToString(orthogrCoords.getNorthing()));
                    break;
                }
                case 28: {
                    PolarStereographic polarstCoords = this.jniEngine.JNIGetPolarStereographicCoordinates(state, direction);
                    this._2CoordFieldsTextFieldA.setText(this.jniStrtoval.JNIMeterToString(polarstCoords.getEasting()));
                    this._2CoordFieldsTextFieldB.setText(this.jniStrtoval.JNIMeterToString(polarstCoords.getNorthing()));
                    break;
                }
                case 29: {
                    Polyconic polyconCoords = this.jniEngine.JNIGetPolyconicCoordinates(state, direction);
                    this._2CoordFieldsTextFieldA.setText(this.jniStrtoval.JNIMeterToString(polyconCoords.getEasting()));
                    this._2CoordFieldsTextFieldB.setText(this.jniStrtoval.JNIMeterToString(polyconCoords.getNorthing()));
                    break;
                }
                case 30: {
                    Sinusoidal sinusoidCoords = this.jniEngine.JNIGetSinusoidalCoordinates(state, direction);
                    this._2CoordFieldsTextFieldA.setText(this.jniStrtoval.JNIMeterToString(sinusoidCoords.getEasting()));
                    this._2CoordFieldsTextFieldB.setText(this.jniStrtoval.JNIMeterToString(sinusoidCoords.getNorthing()));
                    break;
                }
                case 31: {
                    Stereographic stereogrCoords = this.jniEngine.JNIGetStereographicCoordinates(state, direction);
                    this._2CoordFieldsTextFieldA.setText(this.jniStrtoval.JNIMeterToString(stereogrCoords.getEasting()));
                    this._2CoordFieldsTextFieldB.setText(this.jniStrtoval.JNIMeterToString(stereogrCoords.getNorthing()));
                    break;
                }
                case 32: {
                    TransverseCylindricalEqualArea trcyleqaCoords = this.jniEngine.JNIGetTransverseCylindricalEqualAreaCoordinates(state, direction);
                    this._2CoordFieldsTextFieldA.setText(this.jniStrtoval.JNIMeterToString(trcyleqaCoords.getEasting()));
                    this._2CoordFieldsTextFieldB.setText(this.jniStrtoval.JNIMeterToString(trcyleqaCoords.getNorthing()));
                    break;
                }
                case 33: {
                    TransverseMercator tranmercCoords = this.jniEngine.JNIGetTransverseMercatorCoordinates(state, direction);
                    this._2CoordFieldsTextFieldA.setText(this.jniStrtoval.JNIMeterToString(tranmercCoords.getEasting()));
                    this._2CoordFieldsTextFieldB.setText(this.jniStrtoval.JNIMeterToString(tranmercCoords.getNorthing()));
                    break;
                }
                case 34: {
                    VanDerGrinten grintenCoords = this.jniEngine.JNIGetVanDerGrintenCoordinates(state, direction);
                    this._2CoordFieldsTextFieldA.setText(this.jniStrtoval.JNIMeterToString(grintenCoords.getEasting()));
                    this._2CoordFieldsTextFieldB.setText(this.jniStrtoval.JNIMeterToString(grintenCoords.getNorthing()));
                    break;
                }
                case 8: {
                    UPS UPSCoords = this.jniEngine.JNIGetUPSCoordinates(state, direction);
                    this.hemisphere = UPSCoords.getHemisphere();
                    this._2CoordFieldsTextFieldA.setText(this.jniStrtoval.JNIMeterToString(UPSCoords.getEasting()));
                    this._2CoordFieldsTextFieldB.setText(this.jniStrtoval.JNIMeterToString(UPSCoords.getNorthing()));
                    break;
                }
                case 6: {
                    USNG USNGCoords = this.jniEngine.JNIGetUSNGCoordinates(state, direction);
                    this._3CoordFieldsTextFieldB.setText(USNGCoords.getCoordinateString());
                    break;
                }
                case 7: {
                    UTM UTMCoords = this.jniEngine.JNIGetUTMCoordinates(state, direction);
                    this.hemisphere = UTMCoords.getHemisphere();
                    this.zone = UTMCoords.getZoneCoord();
                    this._2CoordFieldsTextFieldA.setText(this.jniStrtoval.JNIMeterToString(UTMCoords.getEasting()));
                    this._2CoordFieldsTextFieldB.setText(this.jniStrtoval.JNIMeterToString(UTMCoords.getNorthing()));
                    break;
                }
            }
        }
        catch (GeotransError e) {
            this.jniStrtoval.setEngineError(true, e.getMessage());
            noErrors = false;
        }
        catch (JNIException e) {
            this.jniStrtoval.setJNIError(true, e.getMessage());
            noErrors = false;
        }
        return noErrors;
    }

    public void createCoordPanel(int projType) {
        this.setFormat();
        switch (projType) {
            case 3: {
                this.setThreeCoords();
                break;
            }
            case 0: {
                this._2CoordFieldsPanel.setVisible(false);
                this._3CoordFieldsPanel.setVisible(true);
                this.coordLayeredPane.moveToFront(this._3CoordFieldsPanel);
                this._3CoordFieldsLabelA.setVisible(true);
                this._3CoordFieldsLabelC.setVisible(true);
                this._3CoordFieldsTextFieldA.setVisible(true);
                this._3CoordFieldsTextFieldC.setVisible(true);
                this.setHeightFieldEditable();
                this._3CoordFieldsLabelA.setText("Longitude:");
                this._3CoordFieldsLabelB.setText("Latitude:");
                this._3CoordFieldsLabelC.setText("Height (m):");
                try {
                    this._3CoordFieldsTextFieldA.setText(this.jniStrtoval.JNILongitudeToString(0.0, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._3CoordFieldsTextFieldB.setText(this.jniStrtoval.JNILatitudeToString(0.0, this.useNSEW, this.useMinutes, this.useSeconds));
                }
                catch (GeotransError e) {
                    this.jniStrtoval.displayErrorMsg(this, e.getMessage());
                }
                catch (JNIException e) {
                    this.jniStrtoval.displayErrorMsg(this, e.getMessage());
                }
                this._3CoordFieldsTextFieldC.setText("0");
                break;
            }
            case 1: {
                this.setOneCoord();
                this._3CoordFieldsTextFieldB.setText("NGAA0000000000");
                break;
            }
            case 2: {
                this.setOneCoord();
                this._3CoordFieldsTextFieldB.setText("361HN37");
                break;
            }
            case 35: {
                this.setOneCoord();
                this._3CoordFieldsTextFieldB.setText("31NEA00");
                break;
            }
            case 5: {
                this.setOneCoord();
                this._3CoordFieldsTextFieldB.setText("31NEA0000000000");
                break;
            }
            case 11: {
                this.setOneCoord();
                this._3CoordFieldsTextFieldB.setText("SV 0000000000");
                break;
            }
            case 25: {
                this.setTwoCoords();
                this._2CoordFieldsTextFieldA.setText("2510000");
                this._2CoordFieldsTextFieldB.setText("6023150");
                break;
            }
            case 8: {
                this.setTwoCoords();
                this._2CoordFieldsTextFieldA.setText("2000000");
                this._2CoordFieldsTextFieldB.setText("2000000");
                break;
            }
            case 6: {
                this.setOneCoord();
                this._3CoordFieldsTextFieldB.setText("31NEA0000000000");
                break;
            }
            case 7: {
                this.setTwoCoords();
                this._2CoordFieldsTextFieldA.setText("500000");
                break;
            }
            case 4: {
                this.setThreeCoords();
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                this.setTwoCoords();
                break;
            }
        }
    }

    public void resetOutputErrors() {
        this.ce90TextField.setText("N/A");
        this.le90TextField.setText("N/A");
        this.se90TextField.setText("N/A");
    }

    public void reportOutputErrors(int state) {
        Accuracy outputErrors = this.jniEngine.JNIGetConversionErrors(state);
        double ce90 = outputErrors.getCE90();
        double le90 = outputErrors.getLE90();
        double se90 = outputErrors.getSE90();
        this.usePrevAccuracies = true;
        if (ce90 == -1.0) {
            this.ce90TextField.setText("Unk");
        } else {
            this.jniStrtoval.setNumberFormat(this.ce90TextField, ce90, 0);
        }
        if (!this._3dConversion) {
            this.le90TextField.setText("N/A");
            this.se90TextField.setText("N/A");
        } else {
            if (le90 == -1.0) {
                this.le90TextField.setText("Unk");
            } else {
                this.jniStrtoval.setNumberFormat(this.le90TextField, le90, 0);
            }
            if (se90 == -1.0) {
                this.se90TextField.setText("Unk");
            } else {
                this.jniStrtoval.setNumberFormat(this.se90TextField, se90, 0);
            }
        }
    }

    public void setAccuracy() {
        if (!this.usePrevAccuracies) {
            try {
                String ce90String = this.ce90TextField.getText().trim();
                String le90String = this.le90TextField.getText().trim();
                String se90String = this.se90TextField.getText().trim();
                double ce90 = ce90String.equals("Unk") || ce90String.equals("N/A") ? -1.0 : this.jniStrtoval.stringToDouble(ce90String, "Invalid CE 90");
                double le90 = le90String.equals("Unk") || le90String.equals("N/A") ? -1.0 : this.jniStrtoval.stringToDouble(le90String, "Invalid LE 90");
                double se90 = se90String.equals("Unk") || se90String.equals("N/A") ? -1.0 : this.jniStrtoval.stringToDouble(se90String, "Invalid SE 90");
                this.jniEngine.JNISetConversionErrors(1, ce90, le90, se90);
            }
            catch (GeotransError e) {
                this.jniStrtoval.displayErrorMsg(this, e.getMessage());
            }
        }
    }

    public void updateSrcErrors(boolean _3dConv) {
        this.le90TextField.setEditable(_3dConv);
        this.se90TextField.setEditable(_3dConv);
        this._3dConversion = _3dConv;
        this.updateAccuracy();
    }

    public void updateAccuracy() {
        try {
            long index = this.sourcesComboBox.getSelectedIndex() + 1;
            Accuracy accuracy = new JNISource().JNISourceAccuracy(index);
            this.usePrevAccuracies = false;
            double ce90 = accuracy.getCE90();
            double le90 = accuracy.getLE90();
            double se90 = accuracy.getSE90();
            if (ce90 == -1.0) {
                this.ce90TextField.setText("Unk");
            } else {
                this.jniStrtoval.setNumberFormat(this.ce90TextField, accuracy.getCE90(), 0);
            }
            if (!this._3dConversion) {
                this.le90TextField.setText("N/A");
                this.se90TextField.setText("N/A");
            } else {
                if (le90 == -1.0) {
                    this.le90TextField.setText("Unk");
                } else {
                    this.jniStrtoval.setNumberFormat(this.le90TextField, accuracy.getLE90(), 0);
                }
                if (se90 == -1.0) {
                    this.se90TextField.setText("Unk");
                } else {
                    this.jniStrtoval.setNumberFormat(this.se90TextField, accuracy.getSE90(), 0);
                }
            }
        }
        catch (GeotransError e) {
            this.jniStrtoval.displayErrorMsg(this, e.getMessage());
        }
        catch (JNIException e) {
            this.jniStrtoval.displayErrorMsg(this, e.getMessage());
        }
    }

    public void setHeightText(String height) {
        this._3CoordFieldsTextFieldC.setText(height);
    }

    public void setHeightFieldUneditable() {
        this._3CoordFieldsTextFieldC.setEditable(false);
    }

    public void setHeightFieldEditable() {
        this._3CoordFieldsTextFieldC.setEditable(true);
    }

    public void setHeightFieldEditable(boolean editable) {
        this._3CoordFieldsTextFieldC.setEditable(editable);
    }

    public void setHemisphere(char hemi) {
        this.hemisphere = hemi;
    }

    public void setZone(int z) {
        this.zone = z;
    }

    public char getHemisphere() {
        return this.hemisphere;
    }

    public long getZone() {
        return this.zone;
    }
}

