package GCPlugins::GCbooks::GCBol;

###################################################
#
#  Copyright 2005-2006 Tian
#
#  This file is part of GCstar.
#
#  GCstar is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCstar is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCstar; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;
use utf8;

use GCPlugins::GCbooks::GCbooksCommon;

{
    package GCPlugins::GCbooks::GCPluginBol;

    use base qw(GCPlugins::GCbooks::GCbooksPluginsBase);
    use URI::Escape;

    sub start
    {
        my ($self, $tagname, $attr, $attrseq, $origtext) = @_;
	
        $self->{inside}->{$tagname}++;

        if ($self->{parsingList})
        {

            if (($tagname eq 'a') && ($attr->{class} eq 'titoloscheda'))
            {
                $self->{itemIdx}++;
                $self->{itemsList}[$self->{itemIdx}]->{url} = "http://www.bol.it" . $attr->{href};
                $self->{isTitle} = 1 ;
            }
            elsif (($tagname eq 'a') && ($attr->{class} eq 'autorescheda'))
            {
                $self->{isAuthor} = 1 ;
            }
            elsif (($tagname eq 'div') && ($attr->{id} eq 'contentschedadati'))
            {
                $self->{isAnalyse} = 1 ;
            }
        }
        else
        {
            if (($tagname eq 'input') && ( $attr->{name} eq 'mailTitolo'))
            {
                $self->{curInfo}->{title} = $attr->{value};
            }
            elsif (($tagname eq 'input') && ( $attr->{name} eq 'mailEAN'))
            {
                $self->{curInfo}->{isbn} = $attr->{value};
            }
            elsif (($tagname eq 'input') && ( $attr->{name} eq 'mailEdizione'))
            {
                $self->{curInfo}->{edition} = $attr->{value};
            }
            elsif (($tagname eq 'input') && ( $attr->{name} eq 'mailFormato'))
            {
                $self->{curInfo}->{format} = $attr->{value};
            }
            elsif (($tagname eq 'input') && ( $attr->{name} eq 'mailAnnoPubbl'))
            {
                $self->{curInfo}->{publication} = $attr->{value};
            }
            elsif (($tagname eq 'input') && ( $attr->{name} eq 'mailLinguaPubbl'))
            {
                $self->{curInfo}->{language} = $attr->{value};
            }
            elsif (($tagname eq 'input') && ( $attr->{name} eq 'mailAutore'))
            {
                $self->{curInfo}->{authors} = $attr->{value};
                $self->{curInfo}->{authors} =~ s|, |,|gi;
            }
            elsif (($tagname eq 'input') && ( $attr->{name} eq 'mailEditore'))
            {
                $self->{curInfo}->{publisher} = $attr->{value};
            }
            elsif (($tagname eq 'a') && ($attr->{href} =~ m|/libri/autore\?tipoContrib=TR|i))
            {
                $self->{isTranslator} = 1 ;
            }
            elsif (($tagname eq 'h1') && ($attr->{class} eq 'schedah1'))
            {
                $self->{isCover} = 1 ;
            }
            elsif (($tagname eq 'img') && ($self->{isCover}) && ($self->{curInfo}->{cover} eq ''))
            {
                $self->{curInfo}->{cover} = "http://www.bol.it" . $attr->{src};
                $self->{curInfo}->{cover} =~ s|\n||gi;
                $self->{curInfo}->{cover} =~ s|\r||gi;
                $self->{isCover} = 0 ;
            }
            elsif (($tagname eq 'a') && ($attr->{name} eq 'ANNOTATION'))
            {
                $self->{isDescription} = 1 ;
            }
            elsif (($tagname eq 'font') && ($self->{isDescription}))
            {
                $self->{isDescription} = 2 ;
            }
            elsif (($tagname eq 'a') && ($attr->{name} eq 'addinfo'))
            {
                $self->{isGenre} = 1 ;
            }
            elsif (($tagname eq 'script') && ($self->{isGenre}))
            {
                $self->{isGenre} = 2 ;
            }
        }
    }

    sub end
    {
		my ($self, $tagname) = @_;

        $self->{inside}->{$tagname}--;
    }

    sub text
    {
        my ($self, $origtext) = @_;

        if ($self->{parsingList})
        {
            if ($self->{isTitle})
            {
                $self->{itemsList}[$self->{itemIdx}]->{title} = $origtext;
                $self->{isTitle} = 0 ;
            }
            elsif ($self->{isAuthor})
            {

                $self->{itemsList}[$self->{itemIdx}]->{authors} = $origtext;
                $self->{isAuthor} = 0 ;
            }
            elsif ($self->{isAnalyse})
            {
                my @array = split(/\|/,$origtext);

                $self->{itemsList}[$self->{itemIdx}]->{format} = $array[0];
                $self->{itemsList}[$self->{itemIdx}]->{format} =~ s/^\s+//;

                $self->{itemsList}[$self->{itemIdx}]->{publication} = $array[0];
                if ($array[3] ne '')
                {
                   $self->{itemsList}[$self->{itemIdx}]->{publication} = $array[3];
                   $self->{itemsList}[$self->{itemIdx}]->{publication} =~ s/^\s+//;
                   $self->{itemsList}[$self->{itemIdx}]->{edition} = $array[2];
                   $self->{itemsList}[$self->{itemIdx}]->{edition} =~ s/^\s+//;
                }
                else
                {
                   $self->{itemsList}[$self->{itemIdx}]->{publication} = $array[2];
                   $self->{itemsList}[$self->{itemIdx}]->{publication} =~ s/^\s+//;
                   $self->{itemsList}[$self->{itemIdx}]->{edition} = $array[1];
                   $self->{itemsList}[$self->{itemIdx}]->{edition} =~ s/^\s+//;
                }

                $self->{isAnalyse} = 0 ;
            }
        }
       	else
        {
            # Enleve les blancs en debut de chaine
            $origtext =~ s/^\s+//;
            # Enleve les blancs en fin de chaine
            $origtext =~ s/\s+$//g;
            if ($self->{isDescription} eq 2)
            {
                $self->{curInfo}->{description} = $origtext;
                $self->{isDescription} = 0 ;
            }
            elsif ($self->{isTranslator})
            {
                $self->{curInfo}->{translator} = $origtext;
                $self->{isTranslator} = 0 ;
            }
            elsif ($self->{isGenre} eq 2 )
            {
                my $found = index($origtext,"if(sottogenere[k][numero].c==\"");
                if ( $found >= 0 )
                {
                   $origtext = substr($origtext, $found +length('if(sottogenere[k][numero].c=="'),length($origtext)- $found -length('if(sottogenere[k][numero].c=="'));
                   $origtext = substr($origtext, 0, index($origtext,"\""));

                   my $html = $self->loadPage($self->{curInfo}->{$self->{urlField}});
                   my $found = index($html,"\"$origtext");
                   if ( $found >= 0 )
                   {
                      $html = substr($html, 0, $found);

                      my $found = index($html,"<img src=\"");
                      if ( $found >= 0 )
                      {
                         $html = substr($html, $found +length('<img src="'),length($html)- $found -length('<img src="'));

                         $html = reverse($html);
                         my @array = split(/"/,$html);

                         $self->{curInfo}->{genre} = reverse($array[1]);
                         $self->{isGenre} = 0 ;

                      }
                   }
                }
            }
            elsif (($origtext =~ m/EAN:/i) && ($origtext =~ m/\|/i))
            {
                my @array = split(/\|/,$origtext);

                # Enleve les blancs en debut de chaine
                $array[1] =~ s/^\s+//;
                # Enleve les blancs en fin de chaine
                $array[1] =~ s/\s+$//g;

                if ($array[1] ne '0' )
                {
                   $self->{curInfo}->{pages} = $array[1];
                }
            }
        }
    } 

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{hasField} = {
            title => 1,
            authors => 1,
            publication => 1,
            format => 1,
            edition => 1,
            serie => 0,
        };

        $self->{isTitle} = 0;
        $self->{isAuthor} = 0;
        $self->{isAnalyse} = 0;
        $self->{isDescription} = 0;
        $self->{isTranslator} = 0;
        $self->{isCover} = 0;
        $self->{isGenre} = 0;

        return $self;
    }

    sub preProcess
    {
        my ($self, $html) = @_;

        if ($self->{parsingList})
        {
            $html =~ s|<br><i>|<i>|gi;
        }
        else
        {
            my $found = index($html,'<a name="commenti">');
            if ( $found >= 0 )
            {
               $html = substr($html, 0, $found);
            }

            $html =~ s|<u>||gi;
            $html =~ s|<li>|\n* |gi;
            $html =~ s|<br>|\n|gi;
            $html =~ s|<br />|\n|gi;
            $html =~ s|<b>||gi;
            $html =~ s|</b>||gi;
            $html =~ s|<i>||gi;
            $html =~ s|</i>||gi;
            $html =~ s|<p>|\n|gi;
            $html =~ s|</p>||gi;
            $html =~ s|\x{92}|'|g;
            $html =~ s|&#146;|'|gi;
            $html =~ s|&#149;|*|gi;

        }
        
        return $html;
    }
    
    sub getSearchUrl
    {
		my ($self, $word) = @_;
	
        if ($self->{searchField} eq 'isbn')
        {
           return ('http://www.bol.it/libri/ricerca', ["crc" => "100", "tpric" => "40", "titolo" => "$word", "tpr" => "40"] );
        }
        else
        {
           $word =~ s/\+/ /g;
           return ('http://www.bol.it/libri/ricerca', ["crc" => "100", "tpric" => "20", "titolo" => "$word", "tpr" => "20"] );
        }

    }
    
    sub getItemUrl
    {
		my ($self, $url) = @_;
		
        return $url if $url;
        return 'http://www.bol.it';
    }

    sub getName
    {
        return "Bol";
    }
    
    sub getImageFile
    {
        return "Bol.png";
    }

    sub getCharset
    {
        my $self = shift;
        return "ISO-8859-15";
    }

    sub getAuthor
    {
        return 'TPF';
    }
    
    sub getLang
    {
        return 'IT';
    }

    sub getSearchFieldsArray
    {
        return ['ISBN', 'title'];
    }
}

1;
