#ifndef SERVER_H
#define SERVER_H

/**
 * Logiciel Gassst (Global Alignment Short Sequence Search Tool)
 * \file Server.h
 * \brief Class Server, responsable du partage des tches entre les threads
 * \author Damien Fleury
 * \version 5.2
 * \date 28/08/2008
 */


#include <pthread.h>

/**
 * Structure dfinissant une portion de graines  traiter 
 */
typedef struct
{
	/**
	 * Le numro de la premire graine de la portion
	 */
	int start;
	
	/**
	 * Le numro de la dernire graine de la portion
	 */
	int end;
} task;

/**
 * \class Server, Un objet permettant de rpartir le travail de recherche d'alignements entre diffrents threads
 * \brief Un objet Server gre l'ensemble des graines  traiter lors de la recherche, les threads vont 
 * demander une tche  l'objet Server qui va leur attribuer une partie de l'ensemble des graines.
 * Le Server va donc rpartir le travail le plus quitablement possible entre les diffrents threads 
 */
class Server
{
private:
	/**
	 * Le numro de la dernire graine  traiter
	 */
	int last_seed;
	
	/**
	 * La taille d'un ensemble de graines attribu lors d'une demande par un thread
	 */
	int size_task;
	
	/**
	 * Un indice permettant de rpertorier les graines qui n'ont pas encore t attribues  un thread
	 */
	int index;
	
	/**
	 * Le nombre de sous-ensembles de graines  attribuer aux threads
	 */
	int nb_part;
	
	/**
	 * Un verrou empchant les accs concurentiels aux variables du Server par les threads
	 */
	pthread_rwlock_t verrou_serveur;

public:
	/**
	 * Le constructeur par dfaut de Server
	 */
	Server();
	
	/**
	 * Le destructeur par dfaut de Server
	 */
	virtual ~Server();
	
	/**
	 * Le constructeur par recopie de Server
	 * \param s un objet Server
	 */
	Server(const Server& s);
	
	/**
	 * L'oprateur d'affectation de Server
	 * \param s un objet Server
	 * \return l'objet server
	 */
	Server& operator=(const Server& s);
	
	/**
	 * Constructeur de Server
	 * `param nbSeeds un entier correspondant au nombre total de graines  traiter
	 * \param nb_partitions un entier correspondant au nombre de partitions  faire avec l'ensemble des graines
	 */
	Server(int nbSeeds, int nb_partitions);
	
	/**
	 * Mthode permettant d'obtenir un sous-ensemble de graines  traiter
	 * \param t un pointeur vers une structure task, correspondant  une partition de l'ensemble des graines
	 * \return 1 si il reste des graines  traiter, on a dans ce cas affect en consquence les champs de la structure task pointe par t, 0 si toutes les graines ont t attribues, les champs de la structure pointe par t sont mis  -1
	 */
	int give_task(task* t);
	
	/**
	 * Mthode permettant de rinitialiser l'index du server
	 */
	void reset();
};

#endif
