namespace GalagoGtk.Tests
{
	using Gtk;
	using GtkSharp;
	using System;
	using Galago;
	using Galago.Gtk;

	public class TestPresenceIcon
	{
		private Button presenceButton;
		private Entry userEntry;
		private AccountComboBox accountList;
		private ServiceComboBox serviceList;
		private PresenceIcon presenceIconLarge;
		private PresenceIcon presenceIconSmall;

		public TestPresenceIcon()
		{
			Application.Init();

			DBus.Bus.GetSessionBus();

			if (!Galago.Global.Init("test-presence-icon"))
			{
				Application.Quit();
				return;
			}

			Window win = new Window("Galago Presence Test");
			win.BorderWidth = 12;

			win.DeleteEvent += new DeleteEventHandler(Window_Delete);

			VBox mainVBox = new VBox(false, 6);
			win.Add(mainVBox);

			HBox hbox = new HBox(false, 12);
			mainVBox.PackStart(hbox, true, true, 0);

			VBox vbox = new VBox(false, 6);
			hbox.PackStart(vbox, false, false, 0);

			SizeGroup sg = new SizeGroup(SizeGroupMode.Horizontal);

			EventBox eventBox = new EventBox();
			vbox.PackStart(eventBox, true, false, 0);

			presenceIconLarge = new PresenceIcon();
			presenceIconLarge.Size = Gtk.IconSize.Dnd;
			presenceIconLarge.Precedence = IconPrecedence.Generic;
			eventBox.Add(presenceIconLarge);

//			tooltips.SetTipFunc(eventBox, presenceIconLarge

			vbox = new VBox(false, 6);
			hbox.PackStart(vbox, true, true, 0);

			/* Add the Service box */
			hbox = AddBox(vbox, sg, "_Service:");
			serviceList = new ServiceComboBox();
			hbox.PackStart(serviceList, true, true, 0);

			/* Add the Account box */
			hbox = AddBox(vbox, sg, "_Account:");
			accountList = new AccountComboBox(true);
			accountList.ServicesComboBox = serviceList;
			hbox.PackStart(accountList, true, true, 0);

			/* Add the user entry */
			hbox = AddBox(vbox, sg, "_User:");
			userEntry = new Entry();
			hbox.PackStart(userEntry, true, true, 0);

			presenceIconSmall = new PresenceIcon();
			presenceIconSmall.Size = Gtk.IconSize.Menu;
			presenceIconLarge.Precedence = IconPrecedence.Generic;

			userEntry.Changed += new EventHandler(User_Changed);

			/* "Show Protocol Icon" checkbox */
			CheckButton check = new CheckButton("Show _protocol icon");
			vbox.PackStart(check, false, false, 0);

			check.Toggled += new EventHandler(ShowProtocolIcon_Toggled);

			HButtonBox bbox = new HButtonBox();
			bbox.Spacing = 6;
			bbox.Layout = ButtonBoxStyle.End;
			mainVBox.PackEnd(bbox, false, true, 0);

			Button closeButton = new Button(Gtk.Stock.Close);
			bbox.PackStart(closeButton, false, false, 0);

			closeButton.Clicked += new EventHandler(Close_Clicked);

			presenceButton = Button.NewWithLabel("Get Presence");
			presenceButton.Sensitive = false;
			bbox.PackStart(presenceButton, false, false, 0);

			presenceButton.Clicked += new EventHandler(GetPresence_Clicked);

			win.ShowAll();

			Application.Run();
		}

		private void Window_Delete(object obj, DeleteEventArgs args)
		{
			Application.Quit();
		}

		private void User_Changed(object obj, EventArgs args)
		{
			Entry entry = (Entry)obj;

			presenceButton.Sensitive = (entry.Text != "");
		}

		private void ShowProtocolIcon_Toggled(object obj, EventArgs args)
		{
			CheckButton check = (CheckButton)obj;
			IconPrecedence precedence;

			if (check.Active)
				precedence = IconPrecedence.Protocol;
			else
				precedence = IconPrecedence.Generic;

			presenceIconLarge.Precedence = precedence;
			presenceIconSmall.Precedence = precedence;
		}

		private void Close_Clicked(object obj, EventArgs args)
		{
			Application.Quit();
		}

		private void GetPresence_Clicked(object obj, EventArgs args)
		{
			Account account = accountList.Account;
			Account contact = null;

			string username = userEntry.Text;

			if (username != "")
				contact = account.GetContact(username);

			presenceIconLarge.Account = contact;
			presenceIconSmall.Account = contact;

			presenceIconLarge.Update();
			presenceIconSmall.Update();
		}

		private HBox AddBox(VBox parent, SizeGroup sg, string text)
		{
			HBox hbox = new HBox(false, 6);
			parent.PackStart(hbox, false, false, 0);

			Label label = new Label(text);
			label.SetAlignment(0.0f, 0.5f);
			hbox.PackStart(label, false, false, 0);
			sg.AddWidget(label);

			return hbox;
		}

		public static void Main(string[] args)
		{
			new TestPresenceIcon();
		}
	}
}
