/* GADMIN-DHCPD - An easy to use GTK+ frontend for ISC DHCPD.
 * Copyright (C) 2004 - 2008 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include "../config.h"
#include <gtk/gtk.h>
#include <stdio.h>
#include "widgets.h"
#include "functions.h"
#include "activate_button_clicked.h"

extern int activated;
extern char DHCPD_CONF_BUF[1024];
extern char LEASE_FILE_BUF[1024];



void activate_button_clicked(struct w *widgets)
{
    gchar *start, *test;

    if( activated )
      return;

    /* If the dhcpd.leases file doesnt exist it refuses to start */
    if( ! file_exists(LEASE_FILE_BUF) )
    {
	start = g_strdup_printf("touch %s", LEASE_FILE_BUF);
	run_command(start);
	g_free(start);
    }

    start = g_strdup_printf("%s -cf %s", DHCPD_BINARY, DHCPD_CONF_BUF);
    if( ! run_command(start) )
    {
        printf("Starting dhcpd failed\n");
        test = g_strdup_printf("%s -cf %s 2>&1", DHCPD_BINARY, DHCPD_CONF_BUF);
	run_command_show_err(test);
	g_free(test);

	/* No sence in starting a malfunctioning server at system boot */
	init_stop(widgets);
    }
    else
	init_start(widgets);
     
    g_free(start);
}
