/* MolproLib.c */
/**********************************************************************************************************
Copyright (c) 2002-2011 Abdul-Rahman Allouche. All rights reserved

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
documentation files (the Gabedit), to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in all copies or substantial portions
  of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
************************************************************************************************************/

#include "../../Config.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gtk/gtk.h>
#include <glib/gi18n.h>
#include "../Common/GabeditType.h"
#include "../Utils/Constants.h"
#include "../Utils/Utils.h"
#include "../Molpro/MolproLib.h"

/********************************************************************************/
static gint get_num_orb(gchar *orb)
{
 	gchar allorb[21] = {'E', 's','p','d','f','g','h','i','j','k','l',
				 'S','P','D','F','G','H','I','J','K','L'};
	gint i=0;

	for(i=0;i<21;i++)
	if(orb[0] == allorb[i])
		return i;
	return -1;
}
/********************************************************************************/
void get_basis_list(gchar* Symb,gchar* orb,gchar* outfile,gchar* errfile)
{
 	gchar *allorb[21] = {"ECP", "s","p","d","f","g","h","i","j","k","l",
				 "S","P","D","F","G","H","I","J","K","L"};
	FILE* fout=fopen(outfile,"w");  
	FILE* ferr=fopen(errfile,"w");  
        gchar *filename =  g_strdup_printf("%s/molprobasis",gabedit_directory());  
	FILE* fin = fopen(filename,"r");
	gchar t[BSIZE];
	gint numorb1=-1;
	gint numorb2=-1;
	gint j=0;
	gchar* symb = g_malloc(5*sizeof(gchar));
	gchar* bas = g_malloc(30*sizeof(gchar));
	gchar* dump = g_malloc(30*sizeof(gchar));
	gint orbok[21];
	gint nbas = 0;
	gchar* orbdown = g_strdup(orb);
	gchar* orbup = g_strdup(orb);

	g_strdown(orbdown);
	g_strup(orbup);

	if(!fin)
	{
		create_molpro_basis_file();
		fin = fopen(filename,"r");
	}
	if(!fin)
	{
		fprintf(ferr,_("Sorry the molprobasis is corrupted.\nPlease reinstall gabedit\n"));
		fclose(ferr);
		fclose(fout);
		return;
	}
        numorb1 = get_num_orb(orbup);
        numorb2 = get_num_orb(orbdown);

	/*	Debug("numorb1 = %d numorb2 = %d \n",numorb1,numorb2);*/
	fgets(t,BSIZE,fin); /* number of atoms */
	while(!feof(fin))
	{
		if(!fgets(t,BSIZE,fin))
			break;
		if(strstr(t,"Atom") && strstr(t,Symb) && sscanf(t,"%s %s",dump,symb)==2 && strcmp(Symb,symb) ==0 )
		{
			if(!fgets(t,BSIZE,fin))
				break;
			sscanf(t,"%d",&nbas);
			for(j=0;j<nbas;j++)
			{
				if(!fgets(t,BSIZE,fin))
					break;
			/*Debug("t=%s\n",t);*/
				sscanf(t,"%s %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d",bas,
					&orbok[0],&orbok[1],&orbok[2],&orbok[3],&orbok[4],&orbok[5],&orbok[6],&orbok[7],&orbok[8],&orbok[9],
					&orbok[10],&orbok[11],&orbok[12],&orbok[13],&orbok[14],&orbok[15],&orbok[16],&orbok[17],&orbok[18],
					&orbok[19],&orbok[20]);
			/* Debug("numorb1 = %d numorb2 = %d \n",numorb1,numorb2);*/
				if(numorb1>=0 && orbok[numorb1]!=0)
				{
						/* Debug("%s %s %s\n",Symb,allorb[numorb1],bas);*/
						fprintf(fout,"%s %s %s\n",Symb,allorb[numorb1],bas);
				}
				if(numorb2>=0 && orbok[numorb2]!=0)
						fprintf(fout,"%s %s %s\n",Symb,allorb[numorb2],bas);
			}
			break;
		}
	}
        /* Debug("End of reading Symb = %s %s \n",Symb,orb);*/

	fclose(ferr);
	fclose(fin);
	fclose(fout);
}
/********************************************************************************/
gboolean create_molpro_basis_file()
{
        gchar *filename =  g_strdup_printf("%s/molprobasis",gabedit_directory());  
	FILE* fout = fopen(filename,"w");

	g_free(filename);
	if(fout==NULL)
	{
		return FALSE;
	}
	fprintf(fout,"Natoms = 102\n");
	fprintf(fout,"Atom H\n");
	fprintf(fout,"137\n");
	fprintf(fout,"431G 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"631G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SV 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-pVDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VDZ 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VTZ 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pCV5Z 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ACV5Z 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pCVDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ACVDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pCVQZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ACVQZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pCVTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ACVTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pV5Z 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AV5Z 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pV6Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AV6Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVQZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVQZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pCV5Z 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"CV5Z 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pCVDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"CVDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pCVQZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"CVQZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pCVTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"CVTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pV5Z 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"V5Z 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pV6Z-old 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"V6Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVQZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VQZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"1P 0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"2P 0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3P 0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"1D 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"2D 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"1F 0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Chipman 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"d-aug-cc-pV5Z 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"d-aug-cc-pV6Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"d-aug-cc-pVDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"d-aug-cc-pVQZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"d-aug-cc-pVTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Xfit 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZ 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZP 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZ 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZP 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZP+ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-SV 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-SVP 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-SVP+ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-TZ 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP2-DFT-orb 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"GAMESS-pVTZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"GAMESS-VTZ 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G** 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G* 0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G 0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G** 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G* 0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G 0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G** 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G* 0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G 0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G** 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G* 0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G 0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31++G 0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311++G 0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G1P 0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G1P 0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G2P 0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G3P 0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G2P 0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G3P 0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31GD 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311GD 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H02 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H03 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H04 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H05 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H06 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H07 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H08 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H09 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H10 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HUZINAGA 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"midi 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"midi-bang 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini-scaled 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MINI 0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"pV6Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ROOS 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg1 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg2 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg3 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg4 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg5 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-2G 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO2G 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G* 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-6G 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G* 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"TZVP-DFT-orb 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"V08 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"V 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VANDUIJN 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"T6 0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"T 0  0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"TAYLOR 0  0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"T4 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"T3 0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom He\n");
	fprintf(fout,"90\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-pVDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VDZ 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VTZ 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pCV5Z 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ACV5Z 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pCVDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ACVDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pCVQZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ACVQZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pCVTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ACVTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pV5Z 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AV5Z 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVQZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVQZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pCV5Z 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"CV5Z 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pCVDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"CVDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pCVQZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"CVQZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pCVTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"CVTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pV5Z 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"V5Z 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVQZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VQZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"d-aug-cc-pV5Z 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"d-aug-cc-pVDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"d-aug-cc-pVQZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"d-aug-cc-pVTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Xfit 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP2-DFT-orb 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G** 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G* 0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G 0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G** 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G* 0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G 0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G** 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G* 0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G 0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G** 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G* 0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G 0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G1P 0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G1P 0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G2P 0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G3P 0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G2P 0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G3P 0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31GD 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311GD 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H03 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H04 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H05 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H06 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H07 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H08 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H09 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H10 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HUZINAGA 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"midi 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini-scaled 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ROOS 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-2G 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO2G 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G* 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-6G 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G* 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Li\n");
	fprintf(fout,"79\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-pVDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-TZv 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VDZ 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VTZ 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"V5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZP 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-SV 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-SVP 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-SVP+ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-TZ 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP2-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G** 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G* 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31++G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31+G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311++G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311+G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G1D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G1D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G2D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G2D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G3D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G3D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31GF 0  0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311GF 0  0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0 \n");
	fprintf(fout,"LI_3-21G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H07 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H08 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H09 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H10 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H11 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HUZINAGA 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"midi 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini-scaled 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge1 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge2 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge3 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2SDF 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ROOS 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg3 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-2G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO2G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G* 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-6G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G* 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Be\n");
	fprintf(fout,"78\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-pVDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-TZv 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VDZ 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VTZ 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"V5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-SV 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-SVP 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-SVP+ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-TZ 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP2-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"GAMESS-pVTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"GAMESS-VTZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G** 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G* 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31++G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31+G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311++G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311+G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G1D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G1D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G2D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G3D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G2D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G3D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31GF 0  0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311GF 0  0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0 \n");
	fprintf(fout,"H07 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H08 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H09 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H10 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H11 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HUZINAGA 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"midi 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini-scaled 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge1 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge2 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge3 0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2SDF 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ROOS 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg3 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-2G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO2G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G* 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-6G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G* 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom B\n");
	fprintf(fout,"129\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-TZv 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VTZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pCV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ACV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pCVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ACVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pCVQZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ACVQZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pCVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ACVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pV6Z 0  1  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AV6Z 0  1  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pCV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"CV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pCVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"CVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pCVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"CVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pCVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"CVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"V5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"4D 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3F 0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"2G 0  0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"1H 0  0  0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"1D 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"2D 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3D 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"1F 0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"2F 0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"1G 0  0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Chipman 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"d-aug-cc-pV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"d-aug-cc-pV6Z 0  1  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"d-aug-cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"d-aug-cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"d-aug-cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZP 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZP 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZP+ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-SV 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-SVP 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-SVP+ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-TZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP2-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"GAMESS-pVTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"GAMESS-VTZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G** 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G* 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31++G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31+G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311++G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311+G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G1D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G1D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G2D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G3D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G2D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G3D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31GF 0  0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311GF 0  0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0 \n");
	fprintf(fout,"H0603 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H0703 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H0804 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H0905 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H1006 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H1107 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HUZINAGA 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"midi 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini-scaled 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge2 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge3 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2SDF 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2MWB 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ROOS 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg3 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg4 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg5 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-2G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO2G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G* 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-6G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G* 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom C\n");
	fprintf(fout,"145\n");
	fprintf(fout,"631G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SV 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-TZv 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VTZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pCV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ACV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pCVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ACVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pCVQZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ACVQZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pCVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ACVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pV6Z 0  1  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AV6Z 0  1  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pCV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"CV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pCVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"CVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pCVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"CVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pCVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"CVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"V5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pV6Z-old 0  1  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"V6Z 0  1  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"4D 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3F 0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"2G 0  0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"1H 0  0  0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"1D 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"2D 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3D 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"1F 0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"2F 0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"1G 0  0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Chipman 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"d-aug-cc-pV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"d-aug-cc-pV6Z 0  1  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"d-aug-cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"d-aug-cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"d-aug-cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZP 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZP 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZP+ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-SV 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-SVP 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-SVP+ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-TZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP2-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"GAMESS-pVTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"GAMESS-VTZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G** 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G* 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31++G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31+G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311++G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311+G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G1D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G1D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G2D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G3D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G2D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G3D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31GF 0  0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311GF 0  0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0 \n");
	fprintf(fout,"H0603 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H0703 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H0804 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H0905 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H1006 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H1107 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HUZINAGA 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"midi 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"midi-bang 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini-scaled 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZ73 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge2 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge3 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2SDF 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2MWB 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"pV6Z 0  1  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ROOS 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg3 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg4 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg5 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-2G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO2G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G* 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-6G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G* 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"TZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"V1308 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"V 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VANDUIJN 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"T6 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"T 0  0  0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"TAYLOR 0  0  0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"T4 0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"T2 0  0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom N\n");
	fprintf(fout,"143\n");
	fprintf(fout,"631G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SV 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-TZv 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VTZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pCV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ACV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pCVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ACVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pCVQZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ACVQZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pCVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ACVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pV6Z 0  1  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AV6Z 0  1  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pCV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"CV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pCVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"CVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pCVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"CVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pCVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"CVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"V5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pV6Z-old 0  1  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"V6Z 0  1  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"4D 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3F 0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"2G 0  0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"1H 0  0  0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"1D 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"2D 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3D 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"1F 0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"2F 0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"1G 0  0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Chipman 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"d-aug-cc-pV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"d-aug-cc-pV6Z 0  1  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"d-aug-cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"d-aug-cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"d-aug-cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZP 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZP 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZP+ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-SV 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-SVP 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-SVP+ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-TZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP2-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"GAMESS-pVTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"GAMESS-VTZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G** 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G* 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31++G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31+G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311++G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311+G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G1D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G1D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G2D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G3D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G2D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G3D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31GF 0  0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311GF 0  0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0 \n");
	fprintf(fout,"H0703 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H0804 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H0905 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H1006 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H1107 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HUZINAGA 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"midi 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"midi-bang 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini-scaled 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge2 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge3 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2SDF 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2MWB 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"pV6Z 0  1  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ROOS 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0 \n");
	fprintf(fout,"rydberg1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg3 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg4 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg5 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-2G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO2G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G* 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-6G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G* 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"TZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"V1308 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"V 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VANDUIJN 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"T6 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"T 0  0  0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"TAYLOR 0  0  0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"T4 0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"T2 0  0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom O\n");
	fprintf(fout,"143\n");
	fprintf(fout,"631G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SV 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-TZv 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VTZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pCV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ACV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pCVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ACVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pCVQZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ACVQZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pCVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ACVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pV6Z 0  1  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AV6Z 0  1  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pCV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"CV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pCVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"CVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pCVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"CVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pCVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"CVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"V5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pV6Z-old 0  1  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"V6Z 0  1  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"4D 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3F 0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"2G 0  0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"1H 0  0  0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"1D 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"2D 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3D 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"1F 0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"2F 0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"1G 0  0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Chipman 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"d-aug-cc-pV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"d-aug-cc-pV6Z 0  1  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"d-aug-cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"d-aug-cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"d-aug-cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZP 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZP 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZP+ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-SV 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-SVP 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-SVP+ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-TZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP2-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"GAMESS-pVTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"GAMESS-VTZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G** 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G* 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31++G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31+G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311++G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311+G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G1D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G1D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G2D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G3D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G2D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G3D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31GF 0  0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311GF 0  0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0 \n");
	fprintf(fout,"H0703 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H0804 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H0905 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H1006 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H1107 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HUZINAGA 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"midi 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"midi-bang 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini-scaled 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge2 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge3 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2SDF 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2MWB 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"pV6Z 0  1  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ROOS 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg3 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg4 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg5 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-2G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO2G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G* 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-6G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G* 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"TZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"V1308 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"V 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VANDUIJN 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"T6 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"T 0  0  0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"TAYLOR 0  0  0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"T4 0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"T2 0  0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom F\n");
	fprintf(fout,"151\n");
	fprintf(fout,"631G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SV 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-TZv 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VTZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pCV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ACV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pCVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ACVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pCVQZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ACVQZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pCVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ACVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pV6Z 0  1  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AV6Z 0  1  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pCV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"CV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pCVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"CVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pCVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"CVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pCVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"CVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"V5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VDZ+ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"1DM 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"2DM 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3DM 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"1FM 0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"2FM 0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VTZ+ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"1DMT 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"2DMT 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3DMT 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"1FMT 0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"2FMT 0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"4D 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3F 0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"2G 0  0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"1H 0  0  0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"1D 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"2D 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3D 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"1F 0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"2F 0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"1G 0  0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Chipman 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"d-aug-cc-pV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"d-aug-cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"d-aug-cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"d-aug-cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZP 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZP 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZP+ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-SV 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-SVP 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-SVP+ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-TZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP2-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"GAMESS-pVTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"GAMESS-VTZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G** 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G* 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31++G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31+G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311++G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311+G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G1D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G1D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G2D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G3D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G2D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G3D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31GF 0  0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311GF 0  0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0 \n");
	fprintf(fout,"H0703 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H0804 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H0905 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H1006 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H1107 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HUZINAGA 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"midi 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"midi-bang 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini-scaled 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge2 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge3 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2SDF 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2MWB 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ROOS 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg3 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg4 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg5 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-2G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO2G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G* 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-6G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G* 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"TZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"V 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"V1308 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"FAVG 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"T6 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"T 0  0  0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"TAYLOR 0  0  0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"T4 0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"T2 0  0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Ne\n");
	fprintf(fout,"113\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-TZv 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VTZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pCV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ACV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pCVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ACVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pCVQZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ACVQZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pCVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ACVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pCV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"CV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pCVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"CVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pCVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"CVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pCVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"CVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"V5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"4D 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3F 0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"2G 0  0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"1H 0  0  0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"1D 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"2D 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3D 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"1F 0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"2F 0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"1G 0  0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"d-aug-cc-pV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"d-aug-cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"d-aug-cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"d-aug-cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZP 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZP+ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-SV 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-SVP 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-SVP+ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-TZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"GAMESS-pVTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"GAMESS-VTZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G** 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G* 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G1D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G1D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G2D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G3D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G2D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G3D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31GF 0  0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311GF 0  0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0 \n");
	fprintf(fout,"H1107 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HUZINAGA 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"midi 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini-scaled 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge2 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge3 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2MWB 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ROOS 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg3 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg4 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg5 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-2G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO2G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G* 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-6G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G* 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Na\n");
	fprintf(fout,"84\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-pVDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-TZv 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VTZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"GAMESS-VTZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31++G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31+G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311++G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311+G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G1D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G1D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G2D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G2D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G3D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G3D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31GF 0  0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311GF 0  0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H0905 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H1006 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H1107 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HUZINAGA 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"M1209P 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"M1209 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MC1209 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"midi 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini-scaled 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1810 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1811 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1910 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1911 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P2012 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"PARTRIDG 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1513 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1613 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1614 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1813 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P-1811 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P-1911 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P+1510 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P+1611 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge2 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge3 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10SDF 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ROOS 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-2G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO2G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G* 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G* 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Mg\n");
	fprintf(fout,"82\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-pVDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-TZv 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VTZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"V5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"GAMESS-VTZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31++G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31+G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311++G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311+G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G1D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G1D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G2D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G2D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G3D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G3D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31GF 0  0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311GF 0  0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H0905 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H1006 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H1107 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H1206 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HUZINAGA 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"M1209P 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"M1209 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini-scaled 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1709 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1810 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1811 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1911 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P2012 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"PARTRIDG 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1813 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1814 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1913 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1914 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P+1811 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge2 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge3 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10SDF 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ROOS 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-2G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO2G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G* 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G* 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Al\n");
	fprintf(fout,"93\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-TZv 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VTZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"V5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZP 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZP+ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP2-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"GAMESS-VTZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31++G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31+G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311++G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311+G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G1D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G1D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G2D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G2D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G3D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G3D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31GF 0  0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311GF 0  0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H0905 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H1006 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H1107 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H1209 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HUZINAGA 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"M1209 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"midi 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini-scaled 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1712 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1813 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1914 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P2015 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"PARTRIDG 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge2 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge3 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10SDF 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10MWB 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ROOS 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg4 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg5 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-2G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO2G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G* 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G* 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"TZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Si\n");
	fprintf(fout,"91\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-TZv 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VTZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"V5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZP 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZP+ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP2-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"GAMESS-VTZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31++G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31+G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311++G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311+G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G1D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G1D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G2D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G2D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G3D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G3D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31GF 0  0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311GF 0  0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H0905 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H1006 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H1107 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HUZINAGA 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"M1209 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"midi 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"midi-bang 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini-scaled 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1712 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1813 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1914 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P2015 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge2 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge3 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10SDF 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10MWB 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ROOS 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg4 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg5 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-2G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO2G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G* 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G* 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"TZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom P\n");
	fprintf(fout,"94\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-TZv 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VTZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"V5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZP 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZP+ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP2-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"GAMESS-VTZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31++G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31+G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311++G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311+G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G1D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G1D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G2D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G2D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G3D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G3D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31GF 0  0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311GF 0  0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H0905 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H1006 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H1107 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H1208 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HUZINAGA 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"M1209 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"midi 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"midi-bang 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini-scaled 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1712 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1813 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1914 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P-1813 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P-1914 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P2015 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge2 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge3 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10SDF 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10MWB 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ROOS 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg4 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg5 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-2G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO2G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G* 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G* 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"TZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom S\n");
	fprintf(fout,"94\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-TZv 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VTZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"V5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZP 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZP+ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP2-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"GAMESS-VTZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31++G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31+G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311++G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311+G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G1D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G1D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G2D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G2D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G3D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G3D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31GF 0  0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311GF 0  0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H0905 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H1006 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H1107 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H1208 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HUZINAGA 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"M1209 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"midi 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"midi-bang 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini-scaled 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1712 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1813 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1914 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P-1813 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P-1914 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P2015 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge2 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge3 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10SDF 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10MWB 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ROOS 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg4 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg5 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-2G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO2G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G* 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G* 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"TZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Cl\n");
	fprintf(fout,"95\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-TZv 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VTZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"V5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZP 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Dunning-DZP+ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP2-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"GAMESS-VTZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31++G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31+G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311++G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311+G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G1D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G1D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G2D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G2D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G3D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G3D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31GF 0  0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311GF 0  0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H0905 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H1006 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H1107 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H1208 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H1209 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HUZINAGA 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"M1209 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"midi 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"midi-bang 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini-scaled 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1712 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1813 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1914 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P-1813 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P-1914 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P2015 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge2 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge3 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10SDF 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10MWB 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ROOS 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg4 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"rydberg5 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-2G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO2G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G* 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G* 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"TZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Ar\n");
	fprintf(fout,"82\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-TZv 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VTZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pV5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"V5Z 0  1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP2-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"GAMESS-VTZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"3-21G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-21G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G** 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G* 0  0  0  0  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G 0  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G1D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G1D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G2D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G2D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-31G3D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"6-311G3D 0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H1209 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HUZINAGA 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"M1209 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"midi 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini-scaled 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"A1610 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1712 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1510 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1610 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1611 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1812 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1813 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1913 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P1914 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P2015 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge2 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge3 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10MWB 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ROOS 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-2G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO2G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G* 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G* 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"TZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom K\n");
	fprintf(fout,"34\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-pVDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-TZv 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VTZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZ-ECP2 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H1206 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HUZINAGA 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"midi 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini-scaled 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"W1208 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge2 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge3 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP18SHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP18SDF 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10MWB 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-2G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO2G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-6G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Ca\n");
	fprintf(fout,"33\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-pVDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-TZv 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VDZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VTZ 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP2 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H1206 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HUZINAGA 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"mini-scaled 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge2 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge3 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP18SHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP18SDF 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10MHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-2G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO2G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-6G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Sc\n");
	fprintf(fout,"48\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-TZv 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Bauschlicher-ANO 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP2-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HAY 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H090503 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H120604 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HUZINAGA 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P231608 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P211308 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P201209 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"PARTRIDG 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P211409 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P221409 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P231510 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P231511 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P211408 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"PSUPP 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge3 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10MHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10MDF 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"W140905 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"WACHTERS 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"W 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"WSUPP 0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"WP 0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Ti\n");
	fprintf(fout,"42\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-TZv 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Bauschlicher-ANO 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP2-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HAY 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H090503 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H120604 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HUZINAGA 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P201209 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"PARTRIDG 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"PSUPP 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge3 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10MHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10MDF 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP18MHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"W140905 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"WACHTERS 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"W 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"WSUPP 0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"WP 0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom V\n");
	fprintf(fout,"41\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-TZv 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Bauschlicher-ANO 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP2-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HAY 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H090503 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H120604 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HUZINAGA 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P201209 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"PARTRIDG 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"PSUPP 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge3 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10MHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10MDF 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"W140905 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"WACHTERS 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"W 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"WSUPP 0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"WP 0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Cr\n");
	fprintf(fout,"41\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-TZv 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Bauschlicher-ANO 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP2-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HAY 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H090503 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H120604 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HUZINAGA 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P201209 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"PARTRIDG 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"PSUPP 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge3 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10MHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10MDF 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"W140905 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"WACHTERS 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"W 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"WSUPP 0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"WP 0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Mn\n");
	fprintf(fout,"41\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-TZv 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Bauschlicher-ANO 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP2-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HAY 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H090503 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H120604 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HUZINAGA 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P201209 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"PARTRIDG 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"PSUPP 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge3 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10MHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10MDF 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"W140905 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"WACHTERS 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"W 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"WSUPP 0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"WP 0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Fe\n");
	fprintf(fout,"41\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-TZv 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Bauschlicher-ANO 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP2-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HAY 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H090503 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H120604 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HUZINAGA 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P201209 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"PARTRIDG 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"PSUPP 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge3 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10MHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10MDF 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"W140905 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"WACHTERS 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"W 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"WSUPP 0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"WP 0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Co\n");
	fprintf(fout,"41\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-TZv 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Bauschlicher-ANO 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP2-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HAY 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H090503 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H120604 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HUZINAGA 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P201209 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"PARTRIDG 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"PSUPP 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge3 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10MHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10MDF 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"W140905 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"WACHTERS 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"W 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"WSUPP 0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"WP 0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Ni\n");
	fprintf(fout,"41\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-TZv 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Bauschlicher-ANO 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP2-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HAY 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H090503 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H120604 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HUZINAGA 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P201209 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"PARTRIDG 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"PSUPP 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge3 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10MHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10MDF 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"W140905 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"WACHTERS 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"W 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"WSUPP 0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"WP 0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Cu\n");
	fprintf(fout,"50\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-TZv 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Bauschlicher-ANO 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP2-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HAY 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H090503 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H120604 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HUZINAGA 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P201209 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"PARTRIDG 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"PD 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"PARTRIDD 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"PSUPP 0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge3 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10MHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10MDF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28SHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28SDF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"W140905 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"WACHTERS 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"W 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"WS 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"WSUPP 0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"WP 0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"WSSUPP 0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"WSP 0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"WD 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"WDP 0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Zn\n");
	fprintf(fout,"33\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-TZv 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a2-Xfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP2-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H090503 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H120604 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"HUZINAGA 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"H 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P201209 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"P 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"PARTRIDG 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge3 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10MHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10MDF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MWB 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28SDF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Ga\n");
	fprintf(fout,"39\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-TZv 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Binning-SV 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Binning-SVP 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Binning-VTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Binning-VTZP 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28SDF 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MWB 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP18MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10MHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP10MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Ge\n");
	fprintf(fout,"37\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-TZv 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Binning-SV 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Binning-SVP 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Binning-VTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Binning-VTZP 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28SHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28SDF 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MWB 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom As\n");
	fprintf(fout,"36\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-TZv 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Binning-SV 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Binning-SVP 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Binning-VTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Binning-VTZP 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28SDF 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MWB 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Se\n");
	fprintf(fout,"36\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-TZv 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Binning-SV 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Binning-SVP 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Binning-VTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Binning-VTZP 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28SDF 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MWB 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Br\n");
	fprintf(fout,"37\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-TZv 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Binning-SV 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Binning-SVP 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Binning-VTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Binning-VTZP 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"midi-bang 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28SDF 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MWB 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Kr\n");
	fprintf(fout,"36\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-TZv 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Ahlrichs-VTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"aug-cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"AVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Binning-SV 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Binning-SVP 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Binning-VTZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Binning-VTZP 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VDZ 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VQZ 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"cc-pVTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"VTZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MWB 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO6G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Rb\n");
	fprintf(fout,"16\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP2 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP36SHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP36SDF 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MWB 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Sr\n");
	fprintf(fout,"19\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP2 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Partridge1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP36SHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP36SDF 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-2G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO2G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Y\n");
	fprintf(fout,"14\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Zr\n");
	fprintf(fout,"14\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Nb\n");
	fprintf(fout,"14\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Mo\n");
	fprintf(fout,"14\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Tc\n");
	fprintf(fout,"14\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Ru\n");
	fprintf(fout,"14\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Rh\n");
	fprintf(fout,"14\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Pd\n");
	fprintf(fout,"14\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Ag\n");
	fprintf(fout,"16\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP46SHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP46SDF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Cd\n");
	fprintf(fout,"14\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP46SDF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP46MWB 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom In\n");
	fprintf(fout,"15\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP46SDF 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP46MWB 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP36MWB 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MWB 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Sn\n");
	fprintf(fout,"12\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DGauss-a1-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP46SDF 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP46MWB 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Sb\n");
	fprintf(fout,"11\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP46SDF 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP46MWB 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Te\n");
	fprintf(fout,"11\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP46SDF 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP46MWB 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO-3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"STO3G 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom I\n");
	fprintf(fout,"11\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"midi-bang 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP46SDF 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP46MWB 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP46MDF 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Xe\n");
	fprintf(fout,"9\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DeMon-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"DZVP-DFT-orb 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP46MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP46MWB 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Cs\n");
	fprintf(fout,"10\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP2 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"midi 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP54SHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP54SDF 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP46MWB 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Ba\n");
	fprintf(fout,"12\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP2 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP54SDF 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP46MHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP46MHF_MP2 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP46MWB 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP46MWB_MP2 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom La\n");
	fprintf(fout,"10\n");
	fprintf(fout,"ECP1 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP46MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP46MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP47MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP47MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Ce\n");
	fprintf(fout,"8\n");
	fprintf(fout,"ECP28MHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MWB 1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP46MWB 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP47MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP47MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP48MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP48MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Pr\n");
	fprintf(fout,"6\n");
	fprintf(fout,"ECP28MHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MWB 1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP48MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP48MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP49MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP49MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Nd\n");
	fprintf(fout,"6\n");
	fprintf(fout,"ECP28MHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MWB 1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP49MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP49MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP50MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP50MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Pm\n");
	fprintf(fout,"6\n");
	fprintf(fout,"ECP28MHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MWB 1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP50MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP50MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP51MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP51MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Sm\n");
	fprintf(fout,"6\n");
	fprintf(fout,"ECP28MHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MWB 1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP51MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP51MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP52MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP52MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Eu\n");
	fprintf(fout,"6\n");
	fprintf(fout,"ECP28MHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MWB 1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP52MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP52MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP53MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP53MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Gd\n");
	fprintf(fout,"6\n");
	fprintf(fout,"ECP28MHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MWB 1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP53MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP53MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP54MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP54MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Tb\n");
	fprintf(fout,"6\n");
	fprintf(fout,"ECP28MHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MWB 1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP54MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP54MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP55MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP55MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Dy\n");
	fprintf(fout,"6\n");
	fprintf(fout,"ECP28MHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MWB 1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP55MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP55MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP56MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP56MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Ho\n");
	fprintf(fout,"6\n");
	fprintf(fout,"ECP28MHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MWB 1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP56MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP56MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP57MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP57MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Er\n");
	fprintf(fout,"6\n");
	fprintf(fout,"ECP28MHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MWB 1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP57MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP57MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP58MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP58MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Tm\n");
	fprintf(fout,"6\n");
	fprintf(fout,"ECP28MHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MWB 1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP58MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP58MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP59MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP59MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Yb\n");
	fprintf(fout,"9\n");
	fprintf(fout,"ECP28MHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28MWB 1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP28FMD 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP59MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP59MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MDF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP68MDF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Lu\n");
	fprintf(fout,"2\n");
	fprintf(fout,"ECP60MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Hf\n");
	fprintf(fout,"9\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Ta\n");
	fprintf(fout,"9\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom W\n");
	fprintf(fout,"9\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Re\n");
	fprintf(fout,"9\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Os\n");
	fprintf(fout,"9\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Ir\n");
	fprintf(fout,"9\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Pt\n");
	fprintf(fout,"8\n");
	fprintf(fout,"ECP1 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Au\n");
	fprintf(fout,"14\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP2 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP2 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"LANL2DZ 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MHF_MP2 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MWB_MP2 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MDF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP78SHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP78SDF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Hg\n");
	fprintf(fout,"11\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MHF_MP2 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MWB_MP2 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MDF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP78MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP78MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Tl\n");
	fprintf(fout,"11\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP78MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP78MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP68MWB 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MHF 1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MWB_MP2 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MDF 1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Pb\n");
	fprintf(fout,"6\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP78MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP78MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Bi\n");
	fprintf(fout,"6\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP1 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"MBS-ECP1 0  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP78MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP78MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Po\n");
	fprintf(fout,"4\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP78MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP78MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom At\n");
	fprintf(fout,"4\n");
	fprintf(fout,"Ahlrichs-Cfit 0  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP78MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP78MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Rn\n");
	fprintf(fout,"3\n");
	fprintf(fout,"ECP78MHF 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP78MWB 1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"SBKJC 1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Ac\n");
	fprintf(fout,"3\n");
	fprintf(fout,"ECP60MHF 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MWB 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP78MWB 1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Th\n");
	fprintf(fout,"3\n");
	fprintf(fout,"ECP60MHF 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MWB 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP78MWB 1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Pa\n");
	fprintf(fout,"3\n");
	fprintf(fout,"ECP60MHF 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MWB 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP78MWB 1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom U\n");
	fprintf(fout,"4\n");
	fprintf(fout,"LANL2DZ 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MHF 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MWB 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP78MWB 1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Np\n");
	fprintf(fout,"4\n");
	fprintf(fout,"LANL2DZ 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MHF 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MWB 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP78MWB 1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Pu\n");
	fprintf(fout,"4\n");
	fprintf(fout,"LANL2DZ 0  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MHF 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MWB 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP78MWB 1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Am\n");
	fprintf(fout,"3\n");
	fprintf(fout,"ECP60MHF 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MWB 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP78MWB 1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Cm\n");
	fprintf(fout,"3\n");
	fprintf(fout,"ECP60MHF 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MWB 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP78MWB 1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Bk\n");
	fprintf(fout,"3\n");
	fprintf(fout,"ECP60MHF 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MWB 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP78MWB 1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Cf\n");
	fprintf(fout,"3\n");
	fprintf(fout,"ECP60MHF 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MWB 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP78MWB 1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Es\n");
	fprintf(fout,"3\n");
	fprintf(fout,"ECP60MHF 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MWB 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP78MWB 1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Fm\n");
	fprintf(fout,"3\n");
	fprintf(fout,"ECP60MHF 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MWB 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP78MWB 1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Md\n");
	fprintf(fout,"3\n");
	fprintf(fout,"ECP60MHF 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MWB 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP78MWB 1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom No\n");
	fprintf(fout,"3\n");
	fprintf(fout,"ECP60MHF 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MWB 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP78MWB 1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Lr\n");
	fprintf(fout,"3\n");
	fprintf(fout,"ECP60MHF 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP60MWB 1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP78MWB 1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"Atom Ha\n");
	fprintf(fout,"3\n");
	fprintf(fout,"ECP92MHF 1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP92MDF 1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fprintf(fout,"ECP92MWB 1  1  1  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 \n");
	fclose(fout);
	return TRUE;
}
/********************************************************************************/
