/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.visualnet;

import hypergraph.graphApi.AttributeManager;
import hypergraph.graphApi.Edge;
import hypergraph.hyperbolic.LineRenderer;
import hypergraph.hyperbolic.ModelPoint;
import hypergraph.hyperbolic.TextRenderer;
import hypergraph.visualnet.EdgeRenderer;
import hypergraph.visualnet.GraphPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;

public class DefaultEdgeRenderer
extends JComponent
implements EdgeRenderer {
    private TextRenderer labelRenderer;
    private LineRenderer lineRenderer;
    private boolean labelVisible;
    protected GraphPanel graphPanel;
    protected BasicStroke lineStroke;

    public void setLabelRenderer(TextRenderer textRenderer) {
        this.labelRenderer = textRenderer;
    }

    public TextRenderer getLabelRenderer() {
        if (this.labelRenderer == null) {
            this.labelRenderer = this.graphPanel.getTextRenderer();
        }
        return this.labelRenderer;
    }

    public void setLineRenderer(LineRenderer lineRenderer) {
        this.lineRenderer = lineRenderer;
    }

    public LineRenderer getLineRenderer() {
        if (this.lineRenderer == null) {
            this.lineRenderer = this.graphPanel.getLineRenderer();
        }
        return this.lineRenderer;
    }

    public void setLabelVisible(boolean bl) {
        this.labelVisible = bl;
    }

    public boolean isLabelVisible() {
        return this.labelVisible;
    }

    public void configure(GraphPanel graphPanel, Edge edge) {
        Object object;
        Object object2;
        this.graphPanel = graphPanel;
        this.setBounds(0, 0, graphPanel.getWidth(), graphPanel.getHeight());
        AttributeManager attributeManager = graphPanel.getGraph().getAttributeManager();
        ModelPoint modelPoint = graphPanel.getGraphLayout().getGraphLayoutModel().getNodePosition(edge.getSource());
        ModelPoint modelPoint2 = graphPanel.getGraphLayout().getGraphLayoutModel().getNodePosition(edge.getTarget());
        if (modelPoint != null && modelPoint2 != null) {
            this.getLineRenderer().configure(graphPanel, modelPoint, modelPoint2);
            if (this.labelVisible) {
                object2 = (ModelPoint)modelPoint.clone();
                object = graphPanel.getModel().getTranslation(modelPoint, modelPoint2, 0.5);
                object.apply((ModelPoint)object2);
                this.getLabelRenderer().configure(graphPanel, (ModelPoint)object2, edge.getLabel());
                this.getLabelRenderer().setBackground(null);
                Color color = null;
                if (attributeManager != null) {
                    color = (Color)attributeManager.getAttribute("edge.textcolor", edge);
                }
                if (color != null) {
                    this.getLabelRenderer().setColor(color);
                }
            }
        }
        if (attributeManager != null) {
            object2 = null;
            object2 = (Color)attributeManager.getAttribute("edge.linecolor", edge);
            if (object2 != null) {
                if (edge.getSource().equals(graphPanel.getHoverElement()) || edge.getTarget().equals(graphPanel.getHoverElement()) || edge.equals(graphPanel.getHoverElement())) {
                    object2 = ((Color)object2).darker();
                }
                this.getLineRenderer().setColor((Color)object2);
            }
            object = (float[])attributeManager.getAttribute("edge.stroke", edge);
            float f = ((Float)attributeManager.getAttribute("edge.linewidth", edge)).floatValue();
            this.lineStroke = object != null && ((Object)object).length > 0 ? new BasicStroke(f, 0, 2, 10.0f, (float[])object, 0.0f) : (object != null && ((Object)object).length == 0 ? null : new BasicStroke(f, 0, 2));
        }
    }

    public void paint(Graphics graphics) {
        if (this.lineStroke == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(this.lineStroke);
        this.getLineRenderer().getComponent().paint(graphics);
        if (this.labelVisible) {
            graphics.translate(this.getLabelRenderer().getComponent().getX(), this.getLabelRenderer().getComponent().getY());
            this.getLabelRenderer().getComponent().paint(graphics);
        }
    }

    public Component getComponent() {
        return this;
    }
}

