#include "alertmanager.h"


namespace Alerts {
namespace Internal {
class AlertManagerPrivate
{
public:
    QList<IAlert *> m_Alerts;
};
}  // End namespace Internal
}  // end namespace Alerts

using namespace Alerts;


AlertManager::AlertManager(QObject *parent) :
        QObject(parent), d(0)
{
    d = new Internal::AlertManagerPrivate;
}

AlertManager::~AlertManager()
{
    if (d) {
        delete d;
        d = 0;
    }
}

bool AlertManager::addAlert(IAlert *alert)
{
    d->m_Alerts << alert;
}

bool AlertManager::userHasAlert(const QString &uuid) const
{
    foreach(const IAlert *a, d->m_Alerts) {
        if (uuid==a->receiverUuid())
            return true;
    }
    return false;
}

QList<IAlert *> AlertManager::userAlerts(const QString &uuid) const
{
    QList<IAlert *> list;
    foreach(IAlert *alert, d->m_Alerts) {
        if (uuid==alert->receiverUuid())
            list << alert;
    }
    return list;
}

bool AlertManager::executeUserAlerts(const QString &uuid)
{
    QList<IAlert *> list = userAlerts(uuid);
    foreach(IAlert *a, list) {
        /** \todo here */
    }
}
