//
// C++ Interface: midiinput
//
// Description: 
//
//
// Author: Predrag Viceic <viceic@net2000.ch>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef MIDIINPUT_H
#define MIDIINPUT_H

#include <qobject.h>

#include "defs.h"
#include "qstringlist.h"
#include "soundplayer.h"
#include "beatlinedata.h"
#include "midiinputevent.h"

/**
@author Predrag Viceic
*/
class MidiInput : public QObject
{
Q_OBJECT
public:
    struct noteAssignements_t{
        long start;
        long stop;
    };
    MidiInput(QObject *parent = 0, const char *name = 0);

    ~MidiInput();
    virtual void process()=0;
    virtual void printMessage(int msg)=0;
    virtual void setMidiChannel(int c)=0;
    virtual int openDevice(QString device)=0;
    virtual QString getSelectedDeviceString()=0;
    virtual QString getDefaultDeviceString()=0;
    virtual QStringList getDevices()=0;
    void setSoundPlayer(SoundPlayer* sp);
    void addMidiMonitor(QObject* mm);
    void removeMidiMonitor(QObject* mm);
    #ifdef HAS_PORTMIDI
        static MidiInput* instantiatePortMidi();
    #endif
    #ifdef HAS_ALSA
        static MidiInput* instantiateAlsaSeq();
    #endif
public slots:
    void setBeatlineData(QValueList <beatline_data> bld);


protected:    
    SoundPlayer* soundPlayer;
    noteAssignements_t* noteAssignements;
    QPtrList <QObject> midiMonitors;
    void emitMidiNote(int onoff, int note, int velocity);


protected:
    void playNote(int note);
};

#endif
