//
// C++ Implementation: 
//
// Description: 
//
//
// Author: Predrag Viceic <viceic@net2000.ch>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//


#include "alsaconfigdialog.h"

AlsaConfigDialog::AlsaConfigDialog(SoundPlayer* _soundPlayer,QWidget* parent, const char* name, bool modal, WFlags fl)
: AlsaConfigDialogBase(parent,name, modal,fl)
{
    soundPlayer=_soundPlayer;
}

AlsaConfigDialog::~AlsaConfigDialog()
{
}

/*$SPECIALIZATION$*/
void AlsaConfigDialog::accept()
{
  QString name=device_list->currentText();
  int frames=framesList->currentText().toInt();
  int periods=periodsSpin->value();
  int rate=sampleRateList->currentText().toInt();
  if(!name.contains("-----")){
    int ret=soundPlayer->setAlsaParameters(name,frames,periods,rate);
    if(ret==0){
        return_msg_label->setText("");
        QDialog::accept();
    }else{
        switch(ret){
            case -1:return_msg_label->setText("Error opening PCM device!");break;
            case -2:return_msg_label->setText("Can not configure this PCM device!");break;
            case -3:return_msg_label->setText("Error setting access!");break;
            case -4:return_msg_label->setText("Error setting format!");break;
            case -5:return_msg_label->setText("Error setting rate!");break;
            case -6:return_msg_label->setText("Error setting channels!");break;
            case -7:return_msg_label->setText("Error setting periods!");break;
            case -8:return_msg_label->setText("Error setting buffersize!");break;
            case -9:return_msg_label->setText("Error setting HW params!");break;
        }
   }
  }
}

/*!
    \fn MidiConfigDialog::exec () 
 */
int AlsaConfigDialog::exec () 
{
    device_list->clear();
    computeLatency();
    QStringList deviceList=soundPlayer->getAlsaInterfaces();
    device_list->insertStringList(deviceList);
    QString alsa_pcm_name=soundPlayer->getAlsaPcmName();
    device_list->setCurrentItem(0);
    for (int i=0;i<device_list->count();i++){
        if(device_list->text(i).contains(alsa_pcm_name+" ")) device_list->setCurrentItem(i);
    }
    
    return AlsaConfigDialogBase::exec();
}



