/*
  Copyright 2005, 2006, 2007 David Cad, Damien Stehl.

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; see the file COPYING.  If not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA.

  This program implements ideas from the paper "Floating-point LLL Revisited", 
  by Phong Nguyen and Damien Stehl, in the Proceedings of Eurocrypt'2005, 
  Springer-Verlag; and was partly inspired by Shoup's NTL library: 
  http://www.shoup.net/ntl/

*/

#ifndef HEURISTIC_H
#define HEURISTIC_H

#include "nr.h"
#include "matrix.h"


template<class ZT, class FT>
class heuristic//:public LLLmethod<ZT,FT>
{
protected:
  int shift;
  int prec;
  int kappa;
  ZZ_mat<ZT>*G;
  ZZ_mat<ZT>*B;
  ZZ_mat<ZT>*U;
  FP_mat<FT>*mu;
  FP_mat<FT>*r;
  FP_mat<FT>*appB;
  FP_mat<FT>*appSP;
  FP_NR<FT>*s;
  double eta,delta;
  FP_NR<FT> halfplus, onedothalfplus, ctt;

  virtual inline void GSO(int a, int zeros, int kappamax, int n,
		  Z_NR<ZT>& ztmp, FP_NR<FT>& tmp, FP_NR<FT>& rtmp, FP_NR<FT>& max,
		  int aa,int red);
  virtual inline int BabaiCall(int*alpha,int zeros,int kappamax,int var_k,
			       Z_NR<ZT>&ztmp,FP_NR<FT>& tmp, FP_NR<FT>& rtmp,
			       FP_NR<FT>& max,FP_NR<FT>&max2,FP_NR<FT>&max3,
			       int& newvec,int& newvecmax,int n);
public:
  virtual int Babai (int, int, int, int, 
	     Z_NR<ZT>&, FP_NR<FT>&, FP_NR<FT>&, FP_NR<FT>&, FP_NR<FT>&, FP_NR<FT>&,int);
  int LLL ();
  heuristic(ZZ_mat<ZT>*B,int precision=0,double eta=0.51,double delta=0.99);

  ZZ_mat<ZT>* GetBase();
  ~heuristic();
};
#include "heuristic.cpp"

#endif
