/** \file
 *  This C source file was generated by $ANTLR version 3.2 debian-5
 *
 *     -  From the grammar source file : RSP.g
 *     -                            On : 2011-09-11 15:48:51
 *     -                 for the lexer : RSPLexerLexer *
 * Editing it, at least manually, is not wise. 
 *
 * C language generator and runtime by Jim Idle, jimi|hereisanat|idle|dotgoeshere|ws.
 *
 *
*/
// [The "BSD licence"]
// Copyright (c) 2005-2009 Jim Idle, Temporal Wave LLC
// http://www.temporal-wave.com
// http://www.linkedin.com/in/jimidle
//
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. The name of the author may not be used to endorse or promote products
//    derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

/* -----------------------------------------
 * Include the ANTLR3 generated header file.
 */
#include    "RSPLexer.h"
/* ----------------------------------------- */


/** String literals used by RSPLexer that we must do things like MATCHS() with.
 *  C will normally just lay down 8 bit characters, and you can use L"xxx" to
 *  get wchar_t, but wchar_t is 16 bits on Windows, which is not UTF32 and so
 *  we perform this little trick of defining the literals as arrays of UINT32
 *  and passing in the address of these.
 */
static ANTLR3_UCHAR	lit_1[]  = { 0x61, 0x6E, 0x64,  ANTLR3_STRING_TERMINATOR};
static ANTLR3_UCHAR	lit_2[]  = { 0x6F, 0x72,  ANTLR3_STRING_TERMINATOR};
static ANTLR3_UCHAR	lit_3[]  = { 0x69, 0x6E, 0x63, 0x6C, 0x75, 0x64, 0x65, 0x73,  ANTLR3_STRING_TERMINATOR};
static ANTLR3_UCHAR	lit_4[]  = { 0x73, 0x74, 0x61, 0x72, 0x74, 0x73, 0x77, 0x69, 0x74, 0x68,  ANTLR3_STRING_TERMINATOR};
static ANTLR3_UCHAR	lit_5[]  = { 0x65, 0x6E, 0x64, 0x73, 0x77, 0x69, 0x74, 0x68,  ANTLR3_STRING_TERMINATOR};
static ANTLR3_UCHAR	lit_6[]  = { 0x3E, 0x3D,  ANTLR3_STRING_TERMINATOR};
static ANTLR3_UCHAR	lit_7[]  = { 0x3C, 0x3D,  ANTLR3_STRING_TERMINATOR};
static ANTLR3_UCHAR	lit_8[]  = { 0x62, 0x65, 0x66, 0x6F, 0x72, 0x65,  ANTLR3_STRING_TERMINATOR};
static ANTLR3_UCHAR	lit_9[]  = { 0x61, 0x66, 0x74, 0x65, 0x72,  ANTLR3_STRING_TERMINATOR};
static ANTLR3_UCHAR	lit_10[]  = { 0x64, 0x61, 0x79,  ANTLR3_STRING_TERMINATOR};
static ANTLR3_UCHAR	lit_11[]  = { 0x64, 0x61, 0x79, 0x73,  ANTLR3_STRING_TERMINATOR};
static ANTLR3_UCHAR	lit_12[]  = { 0x77, 0x65, 0x65, 0x6B,  ANTLR3_STRING_TERMINATOR};
static ANTLR3_UCHAR	lit_13[]  = { 0x77, 0x65, 0x65, 0x6B, 0x73,  ANTLR3_STRING_TERMINATOR};
static ANTLR3_UCHAR	lit_14[]  = { 0x6D, 0x6F, 0x6E, 0x74, 0x68,  ANTLR3_STRING_TERMINATOR};
static ANTLR3_UCHAR	lit_15[]  = { 0x6D, 0x6F, 0x6E, 0x74, 0x68, 0x73,  ANTLR3_STRING_TERMINATOR};
static ANTLR3_UCHAR	lit_16[]  = { 0x79, 0x65, 0x61, 0x72,  ANTLR3_STRING_TERMINATOR};
static ANTLR3_UCHAR	lit_17[]  = { 0x79, 0x65, 0x61, 0x72, 0x73,  ANTLR3_STRING_TERMINATOR};
static ANTLR3_UCHAR	lit_18[]  = { 0x74, 0x6F, 0x64, 0x61, 0x79,  ANTLR3_STRING_TERMINATOR};




/* MACROS that hide the C interface implementations from the
 * generated code, which makes it a little more understandable to the human eye.
 * I am very much against using C pre-processor macros for function calls and bits
 * of code as you cannot see what is happening when single stepping in debuggers
 * and so on. The exception (in my book at least) is for generated code, where you are
 * not maintaining it, but may wish to read and understand it. If you single step it, you know that input()
 * hides some indirect calls, but is always referring to the input stream. This is
 * probably more readable than ctx->input->istream->input(snarfle0->blarg) and allows me to rejig
 * the runtime interfaces without changing the generated code too often, without
 * confusing the reader of the generated output, who may not wish to know the gory
 * details of the interface inheritance.
 */
 
#define		CTX	ctx

/* Aids in accessing scopes for grammar programmers
 */
#undef	SCOPE_TYPE
#undef	SCOPE_STACK
#undef	SCOPE_TOP
#define	SCOPE_TYPE(scope)   pRSPLexer_##scope##_SCOPE
#define SCOPE_STACK(scope)  pRSPLexer_##scope##Stack
#define	SCOPE_TOP(scope)    ctx->pRSPLexer_##scope##Top
#define	SCOPE_SIZE(scope)		ctx->pRSPLexer_##scope##Stack_limit
#define SCOPE_INSTANCE(scope, i)	(ctx->SCOPE_STACK(scope)->get(ctx->SCOPE_STACK(scope),i))

 
/* Macros for accessing things in a lexer
 */
#undef	    LEXER
#undef	    RECOGNIZER		    
#undef	    RULEMEMO		    
#undef	    GETCHARINDEX
#undef	    GETLINE
#undef	    GETCHARPOSITIONINLINE
#undef	    EMIT
#undef	    EMITNEW
#undef	    MATCHC
#undef	    MATCHS
#undef	    MATCHRANGE
#undef	    LTOKEN
#undef	    HASFAILED
#undef	    FAILEDFLAG
#undef	    INPUT
#undef	    STRSTREAM
#undef	    LA
#undef	    HASEXCEPTION
#undef	    EXCEPTION
#undef	    CONSTRUCTEX
#undef	    CONSUME
#undef	    LRECOVER
#undef	    MARK
#undef	    REWIND
#undef	    REWINDLAST
#undef	    BACKTRACKING
#undef		MATCHANY
#undef		MEMOIZE
#undef		HAVEPARSEDRULE
#undef		GETTEXT
#undef		INDEX
#undef		SEEK
#undef		PUSHSTREAM
#undef		POPSTREAM
#undef		SETTEXT
#undef		SETTEXT8

#define	    LEXER					ctx->pLexer
#define	    RECOGNIZER			    LEXER->rec
#define		LEXSTATE				RECOGNIZER->state
#define		TOKSOURCE				LEXSTATE->tokSource
#define	    GETCHARINDEX()			LEXER->getCharIndex(LEXER)
#define	    GETLINE()				LEXER->getLine(LEXER)
#define	    GETTEXT()				LEXER->getText(LEXER)
#define	    GETCHARPOSITIONINLINE() LEXER->getCharPositionInLine(LEXER)
#define	    EMIT()					LEXSTATE->type = _type; LEXER->emit(LEXER)
#define	    EMITNEW(t)				LEXER->emitNew(LEXER, t)
#define	    MATCHC(c)				LEXER->matchc(LEXER, c)
#define	    MATCHS(s)				LEXER->matchs(LEXER, s)
#define	    MATCHRANGE(c1,c2)	    LEXER->matchRange(LEXER, c1, c2)
#define	    MATCHANY()				LEXER->matchAny(LEXER)
#define	    LTOKEN  				LEXSTATE->token
#define	    HASFAILED()				(LEXSTATE->failed == ANTLR3_TRUE)
#define	    BACKTRACKING			LEXSTATE->backtracking
#define	    FAILEDFLAG				LEXSTATE->failed
#define	    INPUT					LEXER->input
#define	    STRSTREAM				INPUT
#define		ISTREAM					INPUT->istream
#define		INDEX()					ISTREAM->index(ISTREAM)
#define		SEEK(n)					ISTREAM->seek(ISTREAM, n)
#define	    EOF_TOKEN				&(LEXSTATE->tokSource->eofToken)
#define	    HASEXCEPTION()			(LEXSTATE->error == ANTLR3_TRUE)
#define	    EXCEPTION				LEXSTATE->exception
#define	    CONSTRUCTEX()			RECOGNIZER->exConstruct(RECOGNIZER)
#define	    LRECOVER()				LEXER->recover(LEXER)
#define	    MARK()					ISTREAM->mark(ISTREAM)
#define	    REWIND(m)				ISTREAM->rewind(ISTREAM, m)
#define	    REWINDLAST()			ISTREAM->rewindLast(ISTREAM)
#define		MEMOIZE(ri,si)			RECOGNIZER->memoize(RECOGNIZER, ri, si)
#define		HAVEPARSEDRULE(r)		RECOGNIZER->alreadyParsedRule(RECOGNIZER, r)
#define		PUSHSTREAM(str)			LEXER->pushCharStream(LEXER, str)
#define		POPSTREAM()				LEXER->popCharStream(LEXER)
#define		SETTEXT(str)			LEXSTATE->text = str
#define		SKIP()					LEXSTATE->token = &(TOKSOURCE->skipToken)
#define		USER1					LEXSTATE->user1
#define		USER2					LEXSTATE->user2
#define		USER3					LEXSTATE->user3
#define		CUSTOM					LEXSTATE->custom
#define		RULEMEMO				LEXSTATE->ruleMemo
#define		DBG						RECOGNIZER->debugger

/* If we have been told we can rely on the standard 8 bit or 16 bit input
 * stream, then we can define our macros to use the direct pointers
 * in the input object, which is much faster than indirect calls. This
 * is really only significant to lexers with a lot of fragment rules (which
 * do not place LA(1) in a temporary at the moment) and even then
 * only if there is a lot of input (order of say 1M or so).
 */
#if	defined(ANTLR3_INLINE_INPUT_ASCII) || defined(ANTLR3_INLINE_INPUT_UTF16)

# ifdef	ANTLR3_INLINE_INPUT_ASCII

/* 8 bit "ASCII" (actually any 8 bit character set) */

#  define	    NEXTCHAR			((pANTLR3_UINT8)(INPUT->nextChar))
#  define	    DATAP				((pANTLR3_UINT8)(INPUT->data))

# else

#  define	    NEXTCHAR			((pANTLR3_UINT16)(INPUT->nextChar)) 
#  define	    DATAP				((pANTLR3_UINT16)(INPUT->data))

# endif

# define	    LA(n) ((NEXTCHAR + n) > (DATAP + INPUT->sizeBuf) ? ANTLR3_CHARSTREAM_EOF : (ANTLR3_UCHAR)(*(NEXTCHAR + n - 1)))
# define	    CONSUME()											\
{																	\
    if	(NEXTCHAR < (DATAP + INPUT->sizeBuf))						\
    {																\
		INPUT->charPositionInLine++;								\
		if  ((ANTLR3_UCHAR)(*NEXTCHAR) == INPUT->newlineChar)		\
		{															\
			INPUT->line++;											\
			INPUT->charPositionInLine	= 0;						\
			INPUT->currentLine		= (void *)(NEXTCHAR + 1);		\
		}															\
		INPUT->nextChar = (void *)(NEXTCHAR + 1);					\
    }																\
}

#else

// Pick up the input character by calling the input stream implementation.
//
#define	    CONSUME()				INPUT->istream->consume(INPUT->istream)
#define	    LA(n)					INPUT->istream->_LA(INPUT->istream, n)

#endif
#define		TOKTEXT(tok, txt)				tok, (pANTLR3_UINT8)txt

/* The 4 tokens defined below may well clash with your own #defines or token types. If so
 * then for the present you must use different names for your defines as these are hard coded
 * in the code generator. It would be better not to use such names internally, and maybe
 * we can change this in a forthcoming release. I deliberately do not #undef these
 * here as this will at least give you a redefined error somewhere if they clash.
 */
#define	    UP	    ANTLR3_TOKEN_UP
#define	    DOWN    ANTLR3_TOKEN_DOWN
#define	    EOR	    ANTLR3_TOKEN_EOR
#define	    INVALID ANTLR3_TOKEN_INVALID


/* =============================================================================
 * Functions to create and destroy scopes. First come the rule scopes, followed
 * by the global declared scopes.
 */



/* ============================================================================= */

/* =============================================================================
 * Start of recognizer
 */


/* Forward declare the locally static matching functions we have generated and any predicate functions.
 */
static ANTLR3_INLINE  void	mQUOTE    (pRSPLexer ctx);
static ANTLR3_INLINE  void	mLPAR    (pRSPLexer ctx);
static ANTLR3_INLINE  void	mRPAR    (pRSPLexer ctx);
static ANTLR3_INLINE  void	mAND    (pRSPLexer ctx);
static ANTLR3_INLINE  void	mOR    (pRSPLexer ctx);
static ANTLR3_INLINE  void	mNOT    (pRSPLexer ctx);
static ANTLR3_INLINE  void	mEQUAL    (pRSPLexer ctx);
static ANTLR3_INLINE  void	mINCLUDES    (pRSPLexer ctx);
static ANTLR3_INLINE  void	mSTARTSW    (pRSPLexer ctx);
static ANTLR3_INLINE  void	mENDSW    (pRSPLexer ctx);
static ANTLR3_INLINE  void	mGREATER    (pRSPLexer ctx);
static ANTLR3_INLINE  void	mLESS    (pRSPLexer ctx);
static ANTLR3_INLINE  void	mGTE    (pRSPLexer ctx);
static ANTLR3_INLINE  void	mLTE    (pRSPLexer ctx);
static ANTLR3_INLINE  void	mBEFORE    (pRSPLexer ctx);
static ANTLR3_INLINE  void	mAFTER    (pRSPLexer ctx);
static ANTLR3_INLINE  void	mDAY    (pRSPLexer ctx);
static ANTLR3_INLINE  void	mWEEK    (pRSPLexer ctx);
static ANTLR3_INLINE  void	mMONTH    (pRSPLexer ctx);
static ANTLR3_INLINE  void	mYEAR    (pRSPLexer ctx);
static ANTLR3_INLINE  void	mTODAY    (pRSPLexer ctx);
static ANTLR3_INLINE  void	mNEWLINE    (pRSPLexer ctx);
static ANTLR3_INLINE  void	mWS    (pRSPLexer ctx);
static ANTLR3_INLINE  void	mFIELD    (pRSPLexer ctx);
static ANTLR3_INLINE  void	mINT    (pRSPLexer ctx);
static ANTLR3_INLINE  void	mDATE    (pRSPLexer ctx);
static ANTLR3_INLINE  void	mSTR    (pRSPLexer ctx);
static ANTLR3_INLINE  void	mESCAPED    (pRSPLexer ctx);
static ANTLR3_INLINE  void	mDIGIT09    (pRSPLexer ctx);
static ANTLR3_INLINE  void	mDIGIT19    (pRSPLexer ctx);
static ANTLR3_INLINE  void	mTokens    (pRSPLexer ctx);
static void	RSPLexerFree(pRSPLexer ctx);

/* =========================================================================
 * Lexer matching rules end.
 * =========================================================================
 */



static void
RSPLexerFree  (pRSPLexer ctx)
{
    LEXER->free(LEXER);
    
    ANTLR3_FREE(ctx);
}

/** \brief Name of the grammar file that generated this code
 */
static const char fileName[] = "RSP.g";

/** \brief Return the name of the grammar file that generated this code.
 */
static const char * getGrammarFileName()
{
	return fileName;
}

/** \brief Create a new lexer called RSPLexer
 *
 * \param[in]    instream Pointer to an initialized input stream
 * \return 
 *     - Success pRSPLexer initialized for the lex start
 *     - Fail NULL
 */
ANTLR3_API pRSPLexer RSPLexerNew         
(pANTLR3_INPUT_STREAM instream)
{
	// See if we can create a new lexer with the standard constructor
	//
	return RSPLexerNewSSD(instream, NULL);
}

/** \brief Create a new lexer called RSPLexer
 *
 * \param[in]    instream Pointer to an initialized input stream
 * \param[state] state Previously created shared recognizer stat
 * \return 
 *     - Success pRSPLexer initialized for the lex start
 *     - Fail NULL
 */
ANTLR3_API pRSPLexer RSPLexerNewSSD         
(pANTLR3_INPUT_STREAM instream, pANTLR3_RECOGNIZER_SHARED_STATE state)
{
    pRSPLexer ctx; // Context structure we will build and return

    ctx = (pRSPLexer) ANTLR3_CALLOC(1, sizeof(RSPLexer));

    if  (ctx == NULL)
    {
        // Failed to allocate memory for lexer context
        return  NULL;
    }

    /* -------------------------------------------------------------------
     * Memory for basic structure is allocated, now to fill in
     * in base ANTLR3 structures. We initialize the function pointers
     * for the standard ANTLR3 lexer function set, but upon return
     * from here, the programmer may set the pointers to provide custom
     * implementations of each function. 
     *
     * We don't use the macros defined in RSPLexer.h here so you can get a sense
     * of what goes where.
     */
    
    /* Create a base lexer, using the supplied input stream
     */
    ctx->pLexer	= antlr3LexerNewStream(ANTLR3_SIZE_HINT, instream, state);
    
    /* Check that we allocated the memory correctly
     */
    if	(ctx->pLexer == NULL)
    {
		ANTLR3_FREE(ctx);
		return  NULL;
    }
    /* Install the implementation of our RSPLexer interface
     */
    ctx->mQUOTE	= mQUOTE;
    ctx->mLPAR	= mLPAR;
    ctx->mRPAR	= mRPAR;
    ctx->mAND	= mAND;
    ctx->mOR	= mOR;
    ctx->mNOT	= mNOT;
    ctx->mEQUAL	= mEQUAL;
    ctx->mINCLUDES	= mINCLUDES;
    ctx->mSTARTSW	= mSTARTSW;
    ctx->mENDSW	= mENDSW;
    ctx->mGREATER	= mGREATER;
    ctx->mLESS	= mLESS;
    ctx->mGTE	= mGTE;
    ctx->mLTE	= mLTE;
    ctx->mBEFORE	= mBEFORE;
    ctx->mAFTER	= mAFTER;
    ctx->mDAY	= mDAY;
    ctx->mWEEK	= mWEEK;
    ctx->mMONTH	= mMONTH;
    ctx->mYEAR	= mYEAR;
    ctx->mTODAY	= mTODAY;
    ctx->mNEWLINE	= mNEWLINE;
    ctx->mWS	= mWS;
    ctx->mFIELD	= mFIELD;
    ctx->mINT	= mINT;
    ctx->mDATE	= mDATE;
    ctx->mSTR	= mSTR;
    ctx->mESCAPED	= mESCAPED;
    ctx->mDIGIT09	= mDIGIT09;
    ctx->mDIGIT19	= mDIGIT19;
    ctx->mTokens	= mTokens;
    
    /** When the nextToken() call is made to this lexer's pANTLR3_TOKEN_SOURCE
     *  it will call mTokens() in this generated code, and will pass it the ctx
     * pointer of this lexer, not the context of the base lexer, so store that now.
     */
    ctx->pLexer->ctx	    = ctx;
    
    /**Install the token matching function
     */
    ctx->pLexer->mTokens = (void (*) (void *))(mTokens);
    
    ctx->getGrammarFileName	= getGrammarFileName;
    ctx->free		= RSPLexerFree;

    
    


    /* Return the newly built lexer to the caller
     */
    return  ctx;
}
 

/* =========================================================================
 * Functions to match the lexer grammar defined tokens from the input stream
 */

//   Comes from: 85:7: ( '\"' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start QUOTE
 *
 * Looks to match the characters the constitute the token QUOTE
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mQUOTE(pRSPLexer ctx)
{
	ANTLR3_UINT32	_type;

    _type	    = QUOTE;
       
    
    // RSP.g:85:7: ( '\"' )
    // RSP.g:85:9: '\"'
    {
        MATCHC('"'); 
        if  (HASEXCEPTION())
        {
            goto ruleQUOTEEx;
        }


    }

	LEXSTATE->type = _type;

    // This is where rules clean up and exit
    //
    goto ruleQUOTEEx; /* Prevent compiler warnings */
    ruleQUOTEEx: ;

}
// $ANTLR end QUOTE

//   Comes from: 86:6: ( '(' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start LPAR
 *
 * Looks to match the characters the constitute the token LPAR
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mLPAR(pRSPLexer ctx)
{
	ANTLR3_UINT32	_type;

    _type	    = LPAR;
       
    
    // RSP.g:86:6: ( '(' )
    // RSP.g:86:8: '('
    {
        MATCHC('('); 
        if  (HASEXCEPTION())
        {
            goto ruleLPAREx;
        }


    }

	LEXSTATE->type = _type;

    // This is where rules clean up and exit
    //
    goto ruleLPAREx; /* Prevent compiler warnings */
    ruleLPAREx: ;

}
// $ANTLR end LPAR

//   Comes from: 87:6: ( ')' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start RPAR
 *
 * Looks to match the characters the constitute the token RPAR
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mRPAR(pRSPLexer ctx)
{
	ANTLR3_UINT32	_type;

    _type	    = RPAR;
       
    
    // RSP.g:87:6: ( ')' )
    // RSP.g:87:8: ')'
    {
        MATCHC(')'); 
        if  (HASEXCEPTION())
        {
            goto ruleRPAREx;
        }


    }

	LEXSTATE->type = _type;

    // This is where rules clean up and exit
    //
    goto ruleRPAREx; /* Prevent compiler warnings */
    ruleRPAREx: ;

}
// $ANTLR end RPAR

//   Comes from: 89:5: ( 'and' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start AND
 *
 * Looks to match the characters the constitute the token AND
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mAND(pRSPLexer ctx)
{
	ANTLR3_UINT32	_type;

    _type	    = AND;
       
    
    // RSP.g:89:5: ( 'and' )
    // RSP.g:89:7: 'and'
    {
        MATCHS(lit_1); 
        if  (HASEXCEPTION())
        {
            goto ruleANDEx;
        }



    }

	LEXSTATE->type = _type;

    // This is where rules clean up and exit
    //
    goto ruleANDEx; /* Prevent compiler warnings */
    ruleANDEx: ;

}
// $ANTLR end AND

//   Comes from: 90:4: ( 'or' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start OR
 *
 * Looks to match the characters the constitute the token OR
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mOR(pRSPLexer ctx)
{
	ANTLR3_UINT32	_type;

    _type	    = OR;
       
    
    // RSP.g:90:4: ( 'or' )
    // RSP.g:90:6: 'or'
    {
        MATCHS(lit_2); 
        if  (HASEXCEPTION())
        {
            goto ruleOREx;
        }



    }

	LEXSTATE->type = _type;

    // This is where rules clean up and exit
    //
    goto ruleOREx; /* Prevent compiler warnings */
    ruleOREx: ;

}
// $ANTLR end OR

//   Comes from: 91:5: ( '!' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start NOT
 *
 * Looks to match the characters the constitute the token NOT
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mNOT(pRSPLexer ctx)
{
	ANTLR3_UINT32	_type;

    _type	    = NOT;
       
    
    // RSP.g:91:5: ( '!' )
    // RSP.g:91:7: '!'
    {
        MATCHC('!'); 
        if  (HASEXCEPTION())
        {
            goto ruleNOTEx;
        }


    }

	LEXSTATE->type = _type;

    // This is where rules clean up and exit
    //
    goto ruleNOTEx; /* Prevent compiler warnings */
    ruleNOTEx: ;

}
// $ANTLR end NOT

//   Comes from: 94:7: ( '=' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start EQUAL
 *
 * Looks to match the characters the constitute the token EQUAL
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mEQUAL(pRSPLexer ctx)
{
	ANTLR3_UINT32	_type;

    _type	    = EQUAL;
       
    
    // RSP.g:94:7: ( '=' )
    // RSP.g:94:9: '='
    {
        MATCHC('='); 
        if  (HASEXCEPTION())
        {
            goto ruleEQUALEx;
        }


    }

	LEXSTATE->type = _type;

    // This is where rules clean up and exit
    //
    goto ruleEQUALEx; /* Prevent compiler warnings */
    ruleEQUALEx: ;

}
// $ANTLR end EQUAL

//   Comes from: 97:9: ( 'includes' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start INCLUDES
 *
 * Looks to match the characters the constitute the token INCLUDES
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mINCLUDES(pRSPLexer ctx)
{
	ANTLR3_UINT32	_type;

    _type	    = INCLUDES;
       
    
    // RSP.g:97:9: ( 'includes' )
    // RSP.g:97:11: 'includes'
    {
        MATCHS(lit_3); 
        if  (HASEXCEPTION())
        {
            goto ruleINCLUDESEx;
        }



    }

	LEXSTATE->type = _type;

    // This is where rules clean up and exit
    //
    goto ruleINCLUDESEx; /* Prevent compiler warnings */
    ruleINCLUDESEx: ;

}
// $ANTLR end INCLUDES

//   Comes from: 98:9: ( 'startswith' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start STARTSW
 *
 * Looks to match the characters the constitute the token STARTSW
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mSTARTSW(pRSPLexer ctx)
{
	ANTLR3_UINT32	_type;

    _type	    = STARTSW;
       
    
    // RSP.g:98:9: ( 'startswith' )
    // RSP.g:98:11: 'startswith'
    {
        MATCHS(lit_4); 
        if  (HASEXCEPTION())
        {
            goto ruleSTARTSWEx;
        }



    }

	LEXSTATE->type = _type;

    // This is where rules clean up and exit
    //
    goto ruleSTARTSWEx; /* Prevent compiler warnings */
    ruleSTARTSWEx: ;

}
// $ANTLR end STARTSW

//   Comes from: 99:7: ( 'endswith' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start ENDSW
 *
 * Looks to match the characters the constitute the token ENDSW
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mENDSW(pRSPLexer ctx)
{
	ANTLR3_UINT32	_type;

    _type	    = ENDSW;
       
    
    // RSP.g:99:7: ( 'endswith' )
    // RSP.g:99:9: 'endswith'
    {
        MATCHS(lit_5); 
        if  (HASEXCEPTION())
        {
            goto ruleENDSWEx;
        }



    }

	LEXSTATE->type = _type;

    // This is where rules clean up and exit
    //
    goto ruleENDSWEx; /* Prevent compiler warnings */
    ruleENDSWEx: ;

}
// $ANTLR end ENDSW

//   Comes from: 102:9: ( '>' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start GREATER
 *
 * Looks to match the characters the constitute the token GREATER
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mGREATER(pRSPLexer ctx)
{
	ANTLR3_UINT32	_type;

    _type	    = GREATER;
       
    
    // RSP.g:102:9: ( '>' )
    // RSP.g:102:11: '>'
    {
        MATCHC('>'); 
        if  (HASEXCEPTION())
        {
            goto ruleGREATEREx;
        }


    }

	LEXSTATE->type = _type;

    // This is where rules clean up and exit
    //
    goto ruleGREATEREx; /* Prevent compiler warnings */
    ruleGREATEREx: ;

}
// $ANTLR end GREATER

//   Comes from: 103:6: ( '<' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start LESS
 *
 * Looks to match the characters the constitute the token LESS
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mLESS(pRSPLexer ctx)
{
	ANTLR3_UINT32	_type;

    _type	    = LESS;
       
    
    // RSP.g:103:6: ( '<' )
    // RSP.g:103:8: '<'
    {
        MATCHC('<'); 
        if  (HASEXCEPTION())
        {
            goto ruleLESSEx;
        }


    }

	LEXSTATE->type = _type;

    // This is where rules clean up and exit
    //
    goto ruleLESSEx; /* Prevent compiler warnings */
    ruleLESSEx: ;

}
// $ANTLR end LESS

//   Comes from: 104:5: ( '>=' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start GTE
 *
 * Looks to match the characters the constitute the token GTE
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mGTE(pRSPLexer ctx)
{
	ANTLR3_UINT32	_type;

    _type	    = GTE;
       
    
    // RSP.g:104:5: ( '>=' )
    // RSP.g:104:7: '>='
    {
        MATCHS(lit_6); 
        if  (HASEXCEPTION())
        {
            goto ruleGTEEx;
        }



    }

	LEXSTATE->type = _type;

    // This is where rules clean up and exit
    //
    goto ruleGTEEx; /* Prevent compiler warnings */
    ruleGTEEx: ;

}
// $ANTLR end GTE

//   Comes from: 105:5: ( '<=' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start LTE
 *
 * Looks to match the characters the constitute the token LTE
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mLTE(pRSPLexer ctx)
{
	ANTLR3_UINT32	_type;

    _type	    = LTE;
       
    
    // RSP.g:105:5: ( '<=' )
    // RSP.g:105:7: '<='
    {
        MATCHS(lit_7); 
        if  (HASEXCEPTION())
        {
            goto ruleLTEEx;
        }



    }

	LEXSTATE->type = _type;

    // This is where rules clean up and exit
    //
    goto ruleLTEEx; /* Prevent compiler warnings */
    ruleLTEEx: ;

}
// $ANTLR end LTE

//   Comes from: 108:8: ( 'before' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start BEFORE
 *
 * Looks to match the characters the constitute the token BEFORE
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mBEFORE(pRSPLexer ctx)
{
	ANTLR3_UINT32	_type;

    _type	    = BEFORE;
       
    
    // RSP.g:108:8: ( 'before' )
    // RSP.g:108:10: 'before'
    {
        MATCHS(lit_8); 
        if  (HASEXCEPTION())
        {
            goto ruleBEFOREEx;
        }



    }

	LEXSTATE->type = _type;

    // This is where rules clean up and exit
    //
    goto ruleBEFOREEx; /* Prevent compiler warnings */
    ruleBEFOREEx: ;

}
// $ANTLR end BEFORE

//   Comes from: 109:7: ( 'after' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start AFTER
 *
 * Looks to match the characters the constitute the token AFTER
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mAFTER(pRSPLexer ctx)
{
	ANTLR3_UINT32	_type;

    _type	    = AFTER;
       
    
    // RSP.g:109:7: ( 'after' )
    // RSP.g:109:9: 'after'
    {
        MATCHS(lit_9); 
        if  (HASEXCEPTION())
        {
            goto ruleAFTEREx;
        }



    }

	LEXSTATE->type = _type;

    // This is where rules clean up and exit
    //
    goto ruleAFTEREx; /* Prevent compiler warnings */
    ruleAFTEREx: ;

}
// $ANTLR end AFTER

//   Comes from: 110:5: ( 'day' | 'days' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start DAY
 *
 * Looks to match the characters the constitute the token DAY
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mDAY(pRSPLexer ctx)
{
	ANTLR3_UINT32	_type;

    _type	    = DAY;
       
    
    {
        //  RSP.g:110:5: ( 'day' | 'days' )
        
        ANTLR3_UINT32 alt1;

        alt1=2;

        switch ( LA(1) ) 
        {
        case 'd':
        	{
        		switch ( LA(2) ) 
        		{
        		case 'a':
        			{
        				switch ( LA(3) ) 
        				{
        				case 'y':
        					{
        						switch ( LA(4) ) 
        						{
        						case 's':
        							{
        								alt1=2;
        							}
        						    break;

        						default:
        						    alt1=1;}

        					}
        				    break;

        				default:
        				    CONSTRUCTEX();
        				    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        				    EXCEPTION->message      = (void *)"";
        				    EXCEPTION->decisionNum  = 1;
        				    EXCEPTION->state        = 2;


        				    goto ruleDAYEx;
        				}

        			}
        		    break;

        		default:
        		    CONSTRUCTEX();
        		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        		    EXCEPTION->message      = (void *)"";
        		    EXCEPTION->decisionNum  = 1;
        		    EXCEPTION->state        = 1;


        		    goto ruleDAYEx;
        		}

        	}
            break;

        default:
            CONSTRUCTEX();
            EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            EXCEPTION->message      = (void *)"";
            EXCEPTION->decisionNum  = 1;
            EXCEPTION->state        = 0;


            goto ruleDAYEx;
        }

        switch (alt1) 
        {
    	case 1:
    	    // RSP.g:110:7: 'day'
    	    {
    	        MATCHS(lit_10); 
    	        if  (HASEXCEPTION())
    	        {
    	            goto ruleDAYEx;
    	        }



    	    }
    	    break;
    	case 2:
    	    // RSP.g:110:15: 'days'
    	    {
    	        MATCHS(lit_11); 
    	        if  (HASEXCEPTION())
    	        {
    	            goto ruleDAYEx;
    	        }



    	    }
    	    break;

        }
    }
	LEXSTATE->type = _type;

    // This is where rules clean up and exit
    //
    goto ruleDAYEx; /* Prevent compiler warnings */
    ruleDAYEx: ;

}
// $ANTLR end DAY

//   Comes from: 111:6: ( 'week' | 'weeks' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start WEEK
 *
 * Looks to match the characters the constitute the token WEEK
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mWEEK(pRSPLexer ctx)
{
	ANTLR3_UINT32	_type;

    _type	    = WEEK;
       
    
    {
        //  RSP.g:111:6: ( 'week' | 'weeks' )
        
        ANTLR3_UINT32 alt2;

        alt2=2;

        switch ( LA(1) ) 
        {
        case 'w':
        	{
        		switch ( LA(2) ) 
        		{
        		case 'e':
        			{
        				switch ( LA(3) ) 
        				{
        				case 'e':
        					{
        						switch ( LA(4) ) 
        						{
        						case 'k':
        							{
        								switch ( LA(5) ) 
        								{
        								case 's':
        									{
        										alt2=2;
        									}
        								    break;

        								default:
        								    alt2=1;}

        							}
        						    break;

        						default:
        						    CONSTRUCTEX();
        						    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        						    EXCEPTION->message      = (void *)"";
        						    EXCEPTION->decisionNum  = 2;
        						    EXCEPTION->state        = 3;


        						    goto ruleWEEKEx;
        						}

        					}
        				    break;

        				default:
        				    CONSTRUCTEX();
        				    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        				    EXCEPTION->message      = (void *)"";
        				    EXCEPTION->decisionNum  = 2;
        				    EXCEPTION->state        = 2;


        				    goto ruleWEEKEx;
        				}

        			}
        		    break;

        		default:
        		    CONSTRUCTEX();
        		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        		    EXCEPTION->message      = (void *)"";
        		    EXCEPTION->decisionNum  = 2;
        		    EXCEPTION->state        = 1;


        		    goto ruleWEEKEx;
        		}

        	}
            break;

        default:
            CONSTRUCTEX();
            EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            EXCEPTION->message      = (void *)"";
            EXCEPTION->decisionNum  = 2;
            EXCEPTION->state        = 0;


            goto ruleWEEKEx;
        }

        switch (alt2) 
        {
    	case 1:
    	    // RSP.g:111:8: 'week'
    	    {
    	        MATCHS(lit_12); 
    	        if  (HASEXCEPTION())
    	        {
    	            goto ruleWEEKEx;
    	        }



    	    }
    	    break;
    	case 2:
    	    // RSP.g:111:17: 'weeks'
    	    {
    	        MATCHS(lit_13); 
    	        if  (HASEXCEPTION())
    	        {
    	            goto ruleWEEKEx;
    	        }



    	    }
    	    break;

        }
    }
	LEXSTATE->type = _type;

    // This is where rules clean up and exit
    //
    goto ruleWEEKEx; /* Prevent compiler warnings */
    ruleWEEKEx: ;

}
// $ANTLR end WEEK

//   Comes from: 112:7: ( 'month' | 'months' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start MONTH
 *
 * Looks to match the characters the constitute the token MONTH
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mMONTH(pRSPLexer ctx)
{
	ANTLR3_UINT32	_type;

    _type	    = MONTH;
       
    
    {
        //  RSP.g:112:7: ( 'month' | 'months' )
        
        ANTLR3_UINT32 alt3;

        alt3=2;

        switch ( LA(1) ) 
        {
        case 'm':
        	{
        		switch ( LA(2) ) 
        		{
        		case 'o':
        			{
        				switch ( LA(3) ) 
        				{
        				case 'n':
        					{
        						switch ( LA(4) ) 
        						{
        						case 't':
        							{
        								switch ( LA(5) ) 
        								{
        								case 'h':
        									{
        										switch ( LA(6) ) 
        										{
        										case 's':
        											{
        												alt3=2;
        											}
        										    break;

        										default:
        										    alt3=1;}

        									}
        								    break;

        								default:
        								    CONSTRUCTEX();
        								    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        								    EXCEPTION->message      = (void *)"";
        								    EXCEPTION->decisionNum  = 3;
        								    EXCEPTION->state        = 4;


        								    goto ruleMONTHEx;
        								}

        							}
        						    break;

        						default:
        						    CONSTRUCTEX();
        						    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        						    EXCEPTION->message      = (void *)"";
        						    EXCEPTION->decisionNum  = 3;
        						    EXCEPTION->state        = 3;


        						    goto ruleMONTHEx;
        						}

        					}
        				    break;

        				default:
        				    CONSTRUCTEX();
        				    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        				    EXCEPTION->message      = (void *)"";
        				    EXCEPTION->decisionNum  = 3;
        				    EXCEPTION->state        = 2;


        				    goto ruleMONTHEx;
        				}

        			}
        		    break;

        		default:
        		    CONSTRUCTEX();
        		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        		    EXCEPTION->message      = (void *)"";
        		    EXCEPTION->decisionNum  = 3;
        		    EXCEPTION->state        = 1;


        		    goto ruleMONTHEx;
        		}

        	}
            break;

        default:
            CONSTRUCTEX();
            EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            EXCEPTION->message      = (void *)"";
            EXCEPTION->decisionNum  = 3;
            EXCEPTION->state        = 0;


            goto ruleMONTHEx;
        }

        switch (alt3) 
        {
    	case 1:
    	    // RSP.g:112:9: 'month'
    	    {
    	        MATCHS(lit_14); 
    	        if  (HASEXCEPTION())
    	        {
    	            goto ruleMONTHEx;
    	        }



    	    }
    	    break;
    	case 2:
    	    // RSP.g:112:19: 'months'
    	    {
    	        MATCHS(lit_15); 
    	        if  (HASEXCEPTION())
    	        {
    	            goto ruleMONTHEx;
    	        }



    	    }
    	    break;

        }
    }
	LEXSTATE->type = _type;

    // This is where rules clean up and exit
    //
    goto ruleMONTHEx; /* Prevent compiler warnings */
    ruleMONTHEx: ;

}
// $ANTLR end MONTH

//   Comes from: 113:6: ( 'year' | 'years' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start YEAR
 *
 * Looks to match the characters the constitute the token YEAR
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mYEAR(pRSPLexer ctx)
{
	ANTLR3_UINT32	_type;

    _type	    = YEAR;
       
    
    {
        //  RSP.g:113:6: ( 'year' | 'years' )
        
        ANTLR3_UINT32 alt4;

        alt4=2;

        switch ( LA(1) ) 
        {
        case 'y':
        	{
        		switch ( LA(2) ) 
        		{
        		case 'e':
        			{
        				switch ( LA(3) ) 
        				{
        				case 'a':
        					{
        						switch ( LA(4) ) 
        						{
        						case 'r':
        							{
        								switch ( LA(5) ) 
        								{
        								case 's':
        									{
        										alt4=2;
        									}
        								    break;

        								default:
        								    alt4=1;}

        							}
        						    break;

        						default:
        						    CONSTRUCTEX();
        						    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        						    EXCEPTION->message      = (void *)"";
        						    EXCEPTION->decisionNum  = 4;
        						    EXCEPTION->state        = 3;


        						    goto ruleYEAREx;
        						}

        					}
        				    break;

        				default:
        				    CONSTRUCTEX();
        				    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        				    EXCEPTION->message      = (void *)"";
        				    EXCEPTION->decisionNum  = 4;
        				    EXCEPTION->state        = 2;


        				    goto ruleYEAREx;
        				}

        			}
        		    break;

        		default:
        		    CONSTRUCTEX();
        		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        		    EXCEPTION->message      = (void *)"";
        		    EXCEPTION->decisionNum  = 4;
        		    EXCEPTION->state        = 1;


        		    goto ruleYEAREx;
        		}

        	}
            break;

        default:
            CONSTRUCTEX();
            EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            EXCEPTION->message      = (void *)"";
            EXCEPTION->decisionNum  = 4;
            EXCEPTION->state        = 0;


            goto ruleYEAREx;
        }

        switch (alt4) 
        {
    	case 1:
    	    // RSP.g:113:8: 'year'
    	    {
    	        MATCHS(lit_16); 
    	        if  (HASEXCEPTION())
    	        {
    	            goto ruleYEAREx;
    	        }



    	    }
    	    break;
    	case 2:
    	    // RSP.g:113:17: 'years'
    	    {
    	        MATCHS(lit_17); 
    	        if  (HASEXCEPTION())
    	        {
    	            goto ruleYEAREx;
    	        }



    	    }
    	    break;

        }
    }
	LEXSTATE->type = _type;

    // This is where rules clean up and exit
    //
    goto ruleYEAREx; /* Prevent compiler warnings */
    ruleYEAREx: ;

}
// $ANTLR end YEAR

//   Comes from: 114:7: ( 'today' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start TODAY
 *
 * Looks to match the characters the constitute the token TODAY
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mTODAY(pRSPLexer ctx)
{
	ANTLR3_UINT32	_type;

    _type	    = TODAY;
       
    
    // RSP.g:114:7: ( 'today' )
    // RSP.g:114:9: 'today'
    {
        MATCHS(lit_18); 
        if  (HASEXCEPTION())
        {
            goto ruleTODAYEx;
        }



    }

	LEXSTATE->type = _type;

    // This is where rules clean up and exit
    //
    goto ruleTODAYEx; /* Prevent compiler warnings */
    ruleTODAYEx: ;

}
// $ANTLR end TODAY

//   Comes from: 116:9: ( ( '\\r' )? '\\n' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start NEWLINE
 *
 * Looks to match the characters the constitute the token NEWLINE
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mNEWLINE(pRSPLexer ctx)
{
	ANTLR3_UINT32	_type;

    _type	    = NEWLINE;
       
    
    // RSP.g:116:9: ( ( '\\r' )? '\\n' )
    // RSP.g:116:11: ( '\\r' )? '\\n'
    {

        // RSP.g:116:11: ( '\\r' )?
        {
            int alt5=2;
            switch ( LA(1) ) 
            {
                case '\r':
                	{
                		alt5=1;
                	}
                    break;
            }

            switch (alt5) 
            {
        	case 1:
        	    // RSP.g:116:11: '\\r'
        	    {
        	        MATCHC('\r'); 
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleNEWLINEEx;
        	        }


        	    }
        	    break;

            }
        }
        MATCHC('\n'); 
        if  (HASEXCEPTION())
        {
            goto ruleNEWLINEEx;
        }


    }

	LEXSTATE->type = _type;

    // This is where rules clean up and exit
    //
    goto ruleNEWLINEEx; /* Prevent compiler warnings */
    ruleNEWLINEEx: ;

}
// $ANTLR end NEWLINE

//   Comes from: 118:4: ( ( ' ' | '\\t' ) )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start WS
 *
 * Looks to match the characters the constitute the token WS
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mWS(pRSPLexer ctx)
{
	ANTLR3_UINT32	_type;

    _type	    = WS;
       
    
    // RSP.g:118:4: ( ( ' ' | '\\t' ) )
    // RSP.g:118:6: ( ' ' | '\\t' )
    {
        if ( LA(1) == '\t' || LA(1) == ' ' )
        {
            CONSUME();

        }
        else 
        {
            CONSTRUCTEX();
            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

            LRECOVER();    goto ruleWSEx;
        }

        {
             LEXSTATE->channel = HIDDEN; 
        }

    }

	LEXSTATE->type = _type;

    // This is where rules clean up and exit
    //
    goto ruleWSEx; /* Prevent compiler warnings */
    ruleWSEx: ;

}
// $ANTLR end WS

//   Comes from: 120:7: ( 'a' .. 'z' ( 'a' .. 'z' | '_' )* 'a' .. 'z' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start FIELD
 *
 * Looks to match the characters the constitute the token FIELD
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mFIELD(pRSPLexer ctx)
{
	ANTLR3_UINT32	_type;

    _type	    = FIELD;
       
    
    // RSP.g:120:7: ( 'a' .. 'z' ( 'a' .. 'z' | '_' )* 'a' .. 'z' )
    // RSP.g:120:9: 'a' .. 'z' ( 'a' .. 'z' | '_' )* 'a' .. 'z'
    {
        MATCHRANGE('a', 'z'); 
        if  (HASEXCEPTION())
        {
            goto ruleFIELDEx;
        }


        // RSP.g:120:18: ( 'a' .. 'z' | '_' )*

        for (;;)
        {
            int alt6=2;
            switch ( LA(1) ) 
            {
            case 'a':
            case 'b':
            case 'c':
            case 'd':
            case 'e':
            case 'f':
            case 'g':
            case 'h':
            case 'i':
            case 'j':
            case 'k':
            case 'l':
            case 'm':
            case 'n':
            case 'o':
            case 'p':
            case 'q':
            case 'r':
            case 's':
            case 't':
            case 'u':
            case 'v':
            case 'w':
            case 'x':
            case 'y':
            case 'z':
            	{
            		switch ( LA(2) ) 
            		{
            		case '_':
            		case 'a':
            		case 'b':
            		case 'c':
            		case 'd':
            		case 'e':
            		case 'f':
            		case 'g':
            		case 'h':
            		case 'i':
            		case 'j':
            		case 'k':
            		case 'l':
            		case 'm':
            		case 'n':
            		case 'o':
            		case 'p':
            		case 'q':
            		case 'r':
            		case 's':
            		case 't':
            		case 'u':
            		case 'v':
            		case 'w':
            		case 'x':
            		case 'y':
            		case 'z':
            			{
            				alt6=1;
            			}
            		    break;

            		}

            	}
                break;
            case '_':
            	{
            		alt6=1;
            	}
                break;

            }

            switch (alt6) 
            {
        	case 1:
        	    // RSP.g:
        	    {
        	        if ( LA(1) == '_' || ((LA(1) >= 'a') && (LA(1) <= 'z')) )
        	        {
        	            CONSUME();

        	        }
        	        else 
        	        {
        	            CONSTRUCTEX();
        	            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
        	            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

        	            LRECOVER();    goto ruleFIELDEx;
        	        }


        	    }
        	    break;

        	default:
        	    goto loop6;	/* break out of the loop */
        	    break;
            }
        }
        loop6: ; /* Jump out to here if this rule does not match */

        MATCHRANGE('a', 'z'); 
        if  (HASEXCEPTION())
        {
            goto ruleFIELDEx;
        }


    }

	LEXSTATE->type = _type;

    // This is where rules clean up and exit
    //
    goto ruleFIELDEx; /* Prevent compiler warnings */
    ruleFIELDEx: ;

}
// $ANTLR end FIELD

//   Comes from: 122:5: ( DIGIT19 ( DIGIT09 )* )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start INT
 *
 * Looks to match the characters the constitute the token INT
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mINT(pRSPLexer ctx)
{
	ANTLR3_UINT32	_type;

    _type	    = INT;
       
    
    // RSP.g:122:5: ( DIGIT19 ( DIGIT09 )* )
    // RSP.g:122:7: DIGIT19 ( DIGIT09 )*
    {
        /* 122:7: DIGIT19 ( DIGIT09 )* */
        mDIGIT19(ctx ); 
        if  (HASEXCEPTION())
        {
            goto ruleINTEx;
        }


        // RSP.g:122:15: ( DIGIT09 )*

        for (;;)
        {
            int alt7=2;
            switch ( LA(1) ) 
            {
            case '0':
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9':
            	{
            		alt7=1;
            	}
                break;

            }

            switch (alt7) 
            {
        	case 1:
        	    // RSP.g:122:15: DIGIT09
        	    {
        	        /* 122:15: DIGIT09 */
        	        mDIGIT09(ctx ); 
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleINTEx;
        	        }


        	    }
        	    break;

        	default:
        	    goto loop7;	/* break out of the loop */
        	    break;
            }
        }
        loop7: ; /* Jump out to here if this rule does not match */


    }

	LEXSTATE->type = _type;

    // This is where rules clean up and exit
    //
    goto ruleINTEx; /* Prevent compiler warnings */
    ruleINTEx: ;

}
// $ANTLR end INT

//   Comes from: 125:6: ( DIGIT19 DIGIT09 DIGIT09 DIGIT09 '-' ( '0' DIGIT19 | '1' '0' .. '2' ) '-' ( '0' DIGIT19 | '1' .. '2' DIGIT09 | '3' '0' .. '1' ) )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start DATE
 *
 * Looks to match the characters the constitute the token DATE
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mDATE(pRSPLexer ctx)
{
	ANTLR3_UINT32	_type;

    _type	    = DATE;
       
    
    // RSP.g:125:6: ( DIGIT19 DIGIT09 DIGIT09 DIGIT09 '-' ( '0' DIGIT19 | '1' '0' .. '2' ) '-' ( '0' DIGIT19 | '1' .. '2' DIGIT09 | '3' '0' .. '1' ) )
    // RSP.g:125:8: DIGIT19 DIGIT09 DIGIT09 DIGIT09 '-' ( '0' DIGIT19 | '1' '0' .. '2' ) '-' ( '0' DIGIT19 | '1' .. '2' DIGIT09 | '3' '0' .. '1' )
    {
        /* 125:8: DIGIT19 DIGIT09 DIGIT09 DIGIT09 '-' ( '0' DIGIT19 | '1' '0' .. '2' ) '-' ( '0' DIGIT19 | '1' .. '2' DIGIT09 | '3' '0' .. '1' ) */
        mDIGIT19(ctx ); 
        if  (HASEXCEPTION())
        {
            goto ruleDATEEx;
        }

        /* 125:8: DIGIT19 DIGIT09 DIGIT09 DIGIT09 '-' ( '0' DIGIT19 | '1' '0' .. '2' ) '-' ( '0' DIGIT19 | '1' .. '2' DIGIT09 | '3' '0' .. '1' ) */
        mDIGIT09(ctx ); 
        if  (HASEXCEPTION())
        {
            goto ruleDATEEx;
        }

        /* 125:8: DIGIT19 DIGIT09 DIGIT09 DIGIT09 '-' ( '0' DIGIT19 | '1' '0' .. '2' ) '-' ( '0' DIGIT19 | '1' .. '2' DIGIT09 | '3' '0' .. '1' ) */
        mDIGIT09(ctx ); 
        if  (HASEXCEPTION())
        {
            goto ruleDATEEx;
        }

        /* 125:8: DIGIT19 DIGIT09 DIGIT09 DIGIT09 '-' ( '0' DIGIT19 | '1' '0' .. '2' ) '-' ( '0' DIGIT19 | '1' .. '2' DIGIT09 | '3' '0' .. '1' ) */
        mDIGIT09(ctx ); 
        if  (HASEXCEPTION())
        {
            goto ruleDATEEx;
        }

        MATCHC('-'); 
        if  (HASEXCEPTION())
        {
            goto ruleDATEEx;
        }


        // RSP.g:125:44: ( '0' DIGIT19 | '1' '0' .. '2' )
        {
            int alt8=2;
            switch ( LA(1) ) 
            {
            case '0':
            	{
            		alt8=1;
            	}
                break;
            case '1':
            	{
            		alt8=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 8;
                EXCEPTION->state        = 0;


                goto ruleDATEEx;
            }

            switch (alt8) 
            {
        	case 1:
        	    // RSP.g:125:45: '0' DIGIT19
        	    {
        	        MATCHC('0'); 
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleDATEEx;
        	        }

        	        /* 125:45: '0' DIGIT19 */
        	        mDIGIT19(ctx ); 
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleDATEEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // RSP.g:125:59: '1' '0' .. '2'
        	    {
        	        MATCHC('1'); 
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleDATEEx;
        	        }

        	        MATCHRANGE('0', '2'); 
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleDATEEx;
        	        }


        	    }
        	    break;

            }
        }
        MATCHC('-'); 
        if  (HASEXCEPTION())
        {
            goto ruleDATEEx;
        }


        // RSP.g:125:77: ( '0' DIGIT19 | '1' .. '2' DIGIT09 | '3' '0' .. '1' )
        {
            int alt9=3;
            switch ( LA(1) ) 
            {
            case '0':
            	{
            		alt9=1;
            	}
                break;
            case '1':
            case '2':
            	{
            		alt9=2;
            	}
                break;
            case '3':
            	{
            		alt9=3;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 9;
                EXCEPTION->state        = 0;


                goto ruleDATEEx;
            }

            switch (alt9) 
            {
        	case 1:
        	    // RSP.g:125:78: '0' DIGIT19
        	    {
        	        MATCHC('0'); 
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleDATEEx;
        	        }

        	        /* 125:78: '0' DIGIT19 */
        	        mDIGIT19(ctx ); 
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleDATEEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // RSP.g:125:92: '1' .. '2' DIGIT09
        	    {
        	        MATCHRANGE('1', '2'); 
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleDATEEx;
        	        }

        	        /* 125:92: '1' .. '2' DIGIT09 */
        	        mDIGIT09(ctx ); 
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleDATEEx;
        	        }


        	    }
        	    break;
        	case 3:
        	    // RSP.g:125:111: '3' '0' .. '1'
        	    {
        	        MATCHC('3'); 
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleDATEEx;
        	        }

        	        MATCHRANGE('0', '1'); 
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleDATEEx;
        	        }


        	    }
        	    break;

            }
        }

    }

	LEXSTATE->type = _type;

    // This is where rules clean up and exit
    //
    goto ruleDATEEx; /* Prevent compiler warnings */
    ruleDATEEx: ;

}
// $ANTLR end DATE

//   Comes from: 133:2: ( QUOTE (reg=~ ( '\\\\' | '\"' ) | esc= ESCAPED )+ QUOTE )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start STR
 *
 * Looks to match the characters the constitute the token STR
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mSTR(pRSPLexer ctx)
{
	ANTLR3_UINT32	_type;
    pANTLR3_COMMON_TOKEN esc;
    ANTLR3_UINT32 reg;


    esc = NULL;

    _type	    = STR;
       
     pANTLR3_STRING unesc = GETTEXT()->factory->newRaw(GETTEXT()->factory); 
    
    // RSP.g:133:2: ( QUOTE (reg=~ ( '\\\\' | '\"' ) | esc= ESCAPED )+ QUOTE )
    // RSP.g:133:4: QUOTE (reg=~ ( '\\\\' | '\"' ) | esc= ESCAPED )+ QUOTE
    {
        /* 133:4: QUOTE (reg=~ ( '\\\\' | '\"' ) | esc= ESCAPED )+ QUOTE */
        mQUOTE(ctx ); 
        if  (HASEXCEPTION())
        {
            goto ruleSTREx;
        }

        // RSP.g:133:10: (reg=~ ( '\\\\' | '\"' ) | esc= ESCAPED )+
        {
            int cnt10=0;

            for (;;)
            {
                int alt10=3;
        	{
        	   /* dfaLoopbackState(k,edges,eotPredictsAlt,description,stateNumber,semPredState)
        	    */
        	    int LA10_0 = LA(1);
        	    if ( (((LA10_0 >= 0x0000) && (LA10_0 <= '!')) || ((LA10_0 >= '#') && (LA10_0 <= '[')) || ((LA10_0 >= ']') && (LA10_0 <= 0xFFFF))) ) 
        	    {
        	        alt10=1;
        	    }
        	    else if ( (LA10_0 == '\\') ) 
        	    {
        	        alt10=2;
        	    }

        	}
        	switch (alt10) 
        	{
        	    case 1:
        	        // RSP.g:133:12: reg=~ ( '\\\\' | '\"' )
        	        {
        	            reg= LA(1);
        	            if ( ((LA(1) >= 0x0000) && (LA(1) <= '!')) || ((LA(1) >= '#') && (LA(1) <= '[')) || ((LA(1) >= ']') && (LA(1) <= 0xFFFF)) )
        	            {
        	                CONSUME();

        	            }
        	            else 
        	            {
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
        	                EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

        	                LRECOVER();    goto ruleSTREx;
        	            }

        	            {
        	                 unesc->addc(unesc, reg); 
        	            }

        	        }
        	        break;
        	    case 2:
        	        // RSP.g:134:6: esc= ESCAPED
        	        {
        	            /* 134:6: esc= ESCAPED */
        	            {
        	                ANTLR3_MARKER escStart381 = GETCHARINDEX();
        	            mESCAPED(ctx ); 
        	                if  (HASEXCEPTION())
        	                {
        	                    goto ruleSTREx;
        	                }

        	                esc = LEXSTATE->tokFactory->newToken(LEXSTATE->tokFactory);
        	                esc->setType(esc, ANTLR3_TOKEN_INVALID);
        	                esc->setStartIndex(esc, escStart381);
        	                esc->setStopIndex(esc, GETCHARINDEX()-1);
        	                esc->input = INPUT;
        	            }
        	            {
        	                 unesc->appendS(unesc, GETTEXT()); 
        	            }

        	        }
        	        break;

        	    default:
        	    
        		if ( cnt10 >= 1 )
        		{
        		    goto loop10;
        		}
        		/* mismatchedSetEx()
        		 */
        		CONSTRUCTEX();
        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        		goto ruleSTREx;
        	}
        	cnt10++;
            }
            loop10: ;	/* Jump to here if this rule does not match */
        }
        /* 133:4: QUOTE (reg=~ ( '\\\\' | '\"' ) | esc= ESCAPED )+ QUOTE */
        mQUOTE(ctx ); 
        if  (HASEXCEPTION())
        {
            goto ruleSTREx;
        }

        {
             SETTEXT(unesc); 
        }

    }

	LEXSTATE->type = _type;

    // This is where rules clean up and exit
    //
    goto ruleSTREx; /* Prevent compiler warnings */
    ruleSTREx: ;

    esc = NULL;

}
// $ANTLR end STR

//   Comes from: 138:9: ( '\\\\' ( '\\\\' | '\"' ) )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start ESCAPED
 *
 * Looks to match the characters the constitute the token ESCAPED
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mESCAPED(pRSPLexer ctx)
{
	ANTLR3_UINT32	_type;

        
    // RSP.g:138:9: ( '\\\\' ( '\\\\' | '\"' ) )
    // RSP.g:138:11: '\\\\' ( '\\\\' | '\"' )
    {
        MATCHC('\\'); 
        if  (HASEXCEPTION())
        {
            goto ruleESCAPEDEx;
        }


        // RSP.g:139:3: ( '\\\\' | '\"' )
        {
            int alt11=2;
            switch ( LA(1) ) 
            {
            case '\\':
            	{
            		alt11=1;
            	}
                break;
            case '"':
            	{
            		alt11=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 11;
                EXCEPTION->state        = 0;


                goto ruleESCAPEDEx;
            }

            switch (alt11) 
            {
        	case 1:
        	    // RSP.g:139:5: '\\\\'
        	    {
        	        MATCHC('\\'); 
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleESCAPEDEx;
        	        }

        	        {
        	             SETTEXT(GETTEXT()->factory->newStr8(GETTEXT()->factory, (pANTLR3_UINT8)"\\")); 
        	        }

        	    }
        	    break;
        	case 2:
        	    // RSP.g:140:5: '\"'
        	    {
        	        MATCHC('"'); 
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleESCAPEDEx;
        	        }

        	        {
        	             SETTEXT(GETTEXT()->factory->newStr8(GETTEXT()->factory, (pANTLR3_UINT8)"\"")); 
        	        }

        	    }
        	    break;

            }
        }

    }



    // This is where rules clean up and exit
    //
    goto ruleESCAPEDEx; /* Prevent compiler warnings */
    ruleESCAPEDEx: ;

}
// $ANTLR end ESCAPED

//   Comes from: 145:9: ( '0' .. '9' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start DIGIT09
 *
 * Looks to match the characters the constitute the token DIGIT09
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mDIGIT09(pRSPLexer ctx)
{
	ANTLR3_UINT32	_type;

        
    // RSP.g:145:9: ( '0' .. '9' )
    // RSP.g:145:11: '0' .. '9'
    {
        MATCHRANGE('0', '9'); 
        if  (HASEXCEPTION())
        {
            goto ruleDIGIT09Ex;
        }


    }



    // This is where rules clean up and exit
    //
    goto ruleDIGIT09Ex; /* Prevent compiler warnings */
    ruleDIGIT09Ex: ;

}
// $ANTLR end DIGIT09

//   Comes from: 148:9: ( '1' .. '9' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start DIGIT19
 *
 * Looks to match the characters the constitute the token DIGIT19
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mDIGIT19(pRSPLexer ctx)
{
	ANTLR3_UINT32	_type;

        
    // RSP.g:148:9: ( '1' .. '9' )
    // RSP.g:148:11: '1' .. '9'
    {
        MATCHRANGE('1', '9'); 
        if  (HASEXCEPTION())
        {
            goto ruleDIGIT19Ex;
        }


    }



    // This is where rules clean up and exit
    //
    goto ruleDIGIT19Ex; /* Prevent compiler warnings */
    ruleDIGIT19Ex: ;

}
// $ANTLR end DIGIT19

/** This is the entry point in to the lexer from an object that
 *  wants to generate the next token, such as a pCOMMON_TOKEN_STREAM
 */
static void 
mTokens(pRSPLexer ctx)
{
    {
        //  RSP.g:1:8: ( QUOTE | LPAR | RPAR | AND | OR | NOT | EQUAL | INCLUDES | STARTSW | ENDSW | GREATER | LESS | GTE | LTE | BEFORE | AFTER | DAY | WEEK | MONTH | YEAR | TODAY | NEWLINE | WS | FIELD | INT | DATE | STR )
        
        ANTLR3_UINT32 alt12;

        alt12=27;

        switch ( LA(1) ) 
        {
        case '"':
        	{

        		{
        		    int LA12_1 = LA(2);
        		    if ( (((LA12_1 >= 0x0000) && (LA12_1 <= '!')) || ((LA12_1 >= '#') && (LA12_1 <= 0xFFFF))) ) 
        		    {
        		        alt12=27;
        		    }
        		    else 
        		    {
        		        alt12=1;    }
        		}
        	}
            break;
        case '(':
        	{
        		alt12=2;
        	}
            break;
        case ')':
        	{
        		alt12=3;
        	}
            break;
        case 'a':
        	{
        		switch ( LA(2) ) 
        		{
        		case 'n':
        			{
        				switch ( LA(3) ) 
        				{
        				case 'd':
        					{
        						switch ( LA(4) ) 
        						{
        						case '_':
        						case 'a':
        						case 'b':
        						case 'c':
        						case 'd':
        						case 'e':
        						case 'f':
        						case 'g':
        						case 'h':
        						case 'i':
        						case 'j':
        						case 'k':
        						case 'l':
        						case 'm':
        						case 'n':
        						case 'o':
        						case 'p':
        						case 'q':
        						case 'r':
        						case 's':
        						case 't':
        						case 'u':
        						case 'v':
        						case 'w':
        						case 'x':
        						case 'y':
        						case 'z':
        							{
        								alt12=24;
        							}
        						    break;

        						default:
        						    alt12=4;}

        					}
        				    break;

        				default:
        				    alt12=24;}

        			}
        		    break;
        		case 'f':
        			{
        				switch ( LA(3) ) 
        				{
        				case 't':
        					{
        						switch ( LA(4) ) 
        						{
        						case 'e':
        							{
        								switch ( LA(5) ) 
        								{
        								case 'r':
        									{
        										switch ( LA(6) ) 
        										{
        										case '_':
        										case 'a':
        										case 'b':
        										case 'c':
        										case 'd':
        										case 'e':
        										case 'f':
        										case 'g':
        										case 'h':
        										case 'i':
        										case 'j':
        										case 'k':
        										case 'l':
        										case 'm':
        										case 'n':
        										case 'o':
        										case 'p':
        										case 'q':
        										case 'r':
        										case 's':
        										case 't':
        										case 'u':
        										case 'v':
        										case 'w':
        										case 'x':
        										case 'y':
        										case 'z':
        											{
        												alt12=24;
        											}
        										    break;

        										default:
        										    alt12=16;}

        									}
        								    break;

        								default:
        								    alt12=24;}

        							}
        						    break;

        						default:
        						    alt12=24;}

        					}
        				    break;

        				default:
        				    alt12=24;}

        			}
        		    break;
        		case '_':
        		case 'a':
        		case 'b':
        		case 'c':
        		case 'd':
        		case 'e':
        		case 'g':
        		case 'h':
        		case 'i':
        		case 'j':
        		case 'k':
        		case 'l':
        		case 'm':
        		case 'o':
        		case 'p':
        		case 'q':
        		case 'r':
        		case 's':
        		case 't':
        		case 'u':
        		case 'v':
        		case 'w':
        		case 'x':
        		case 'y':
        		case 'z':
        			{
        				alt12=24;
        			}
        		    break;

        		default:
        		    CONSTRUCTEX();
        		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        		    EXCEPTION->message      = (void *)"";
        		    EXCEPTION->decisionNum  = 12;
        		    EXCEPTION->state        = 4;


        		    goto ruleTokensEx;
        		}

        	}
            break;
        case 'o':
        	{
        		switch ( LA(2) ) 
        		{
        		case 'r':
        			{
        				switch ( LA(3) ) 
        				{
        				case '_':
        				case 'a':
        				case 'b':
        				case 'c':
        				case 'd':
        				case 'e':
        				case 'f':
        				case 'g':
        				case 'h':
        				case 'i':
        				case 'j':
        				case 'k':
        				case 'l':
        				case 'm':
        				case 'n':
        				case 'o':
        				case 'p':
        				case 'q':
        				case 'r':
        				case 's':
        				case 't':
        				case 'u':
        				case 'v':
        				case 'w':
        				case 'x':
        				case 'y':
        				case 'z':
        					{
        						alt12=24;
        					}
        				    break;

        				default:
        				    alt12=5;}

        			}
        		    break;
        		case '_':
        		case 'a':
        		case 'b':
        		case 'c':
        		case 'd':
        		case 'e':
        		case 'f':
        		case 'g':
        		case 'h':
        		case 'i':
        		case 'j':
        		case 'k':
        		case 'l':
        		case 'm':
        		case 'n':
        		case 'o':
        		case 'p':
        		case 'q':
        		case 's':
        		case 't':
        		case 'u':
        		case 'v':
        		case 'w':
        		case 'x':
        		case 'y':
        		case 'z':
        			{
        				alt12=24;
        			}
        		    break;

        		default:
        		    CONSTRUCTEX();
        		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        		    EXCEPTION->message      = (void *)"";
        		    EXCEPTION->decisionNum  = 12;
        		    EXCEPTION->state        = 5;


        		    goto ruleTokensEx;
        		}

        	}
            break;
        case '!':
        	{
        		alt12=6;
        	}
            break;
        case '=':
        	{
        		alt12=7;
        	}
            break;
        case 'i':
        	{
        		switch ( LA(2) ) 
        		{
        		case 'n':
        			{
        				switch ( LA(3) ) 
        				{
        				case 'c':
        					{
        						switch ( LA(4) ) 
        						{
        						case 'l':
        							{
        								switch ( LA(5) ) 
        								{
        								case 'u':
        									{
        										switch ( LA(6) ) 
        										{
        										case 'd':
        											{
        												switch ( LA(7) ) 
        												{
        												case 'e':
        													{
        														switch ( LA(8) ) 
        														{
        														case 's':
        															{
        																switch ( LA(9) ) 
        																{
        																case '_':
        																case 'a':
        																case 'b':
        																case 'c':
        																case 'd':
        																case 'e':
        																case 'f':
        																case 'g':
        																case 'h':
        																case 'i':
        																case 'j':
        																case 'k':
        																case 'l':
        																case 'm':
        																case 'n':
        																case 'o':
        																case 'p':
        																case 'q':
        																case 'r':
        																case 's':
        																case 't':
        																case 'u':
        																case 'v':
        																case 'w':
        																case 'x':
        																case 'y':
        																case 'z':
        																	{
        																		alt12=24;
        																	}
        																    break;

        																default:
        																    alt12=8;}

        															}
        														    break;

        														default:
        														    alt12=24;}

        													}
        												    break;

        												default:
        												    alt12=24;}

        											}
        										    break;

        										default:
        										    alt12=24;}

        									}
        								    break;

        								default:
        								    alt12=24;}

        							}
        						    break;

        						default:
        						    alt12=24;}

        					}
        				    break;

        				default:
        				    alt12=24;}

        			}
        		    break;
        		case '_':
        		case 'a':
        		case 'b':
        		case 'c':
        		case 'd':
        		case 'e':
        		case 'f':
        		case 'g':
        		case 'h':
        		case 'i':
        		case 'j':
        		case 'k':
        		case 'l':
        		case 'm':
        		case 'o':
        		case 'p':
        		case 'q':
        		case 'r':
        		case 's':
        		case 't':
        		case 'u':
        		case 'v':
        		case 'w':
        		case 'x':
        		case 'y':
        		case 'z':
        			{
        				alt12=24;
        			}
        		    break;

        		default:
        		    CONSTRUCTEX();
        		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        		    EXCEPTION->message      = (void *)"";
        		    EXCEPTION->decisionNum  = 12;
        		    EXCEPTION->state        = 8;


        		    goto ruleTokensEx;
        		}

        	}
            break;
        case 's':
        	{
        		switch ( LA(2) ) 
        		{
        		case 't':
        			{
        				switch ( LA(3) ) 
        				{
        				case 'a':
        					{
        						switch ( LA(4) ) 
        						{
        						case 'r':
        							{
        								switch ( LA(5) ) 
        								{
        								case 't':
        									{
        										switch ( LA(6) ) 
        										{
        										case 's':
        											{
        												switch ( LA(7) ) 
        												{
        												case 'w':
        													{
        														switch ( LA(8) ) 
        														{
        														case 'i':
        															{
        																switch ( LA(9) ) 
        																{
        																case 't':
        																	{
        																		switch ( LA(10) ) 
        																		{
        																		case 'h':
        																			{
        																				switch ( LA(11) ) 
        																				{
        																				case '_':
        																				case 'a':
        																				case 'b':
        																				case 'c':
        																				case 'd':
        																				case 'e':
        																				case 'f':
        																				case 'g':
        																				case 'h':
        																				case 'i':
        																				case 'j':
        																				case 'k':
        																				case 'l':
        																				case 'm':
        																				case 'n':
        																				case 'o':
        																				case 'p':
        																				case 'q':
        																				case 'r':
        																				case 's':
        																				case 't':
        																				case 'u':
        																				case 'v':
        																				case 'w':
        																				case 'x':
        																				case 'y':
        																				case 'z':
        																					{
        																						alt12=24;
        																					}
        																				    break;

        																				default:
        																				    alt12=9;}

        																			}
        																		    break;

        																		default:
        																		    alt12=24;}

        																	}
        																    break;

        																default:
        																    alt12=24;}

        															}
        														    break;

        														default:
        														    alt12=24;}

        													}
        												    break;

        												default:
        												    alt12=24;}

        											}
        										    break;

        										default:
        										    alt12=24;}

        									}
        								    break;

        								default:
        								    alt12=24;}

        							}
        						    break;

        						default:
        						    alt12=24;}

        					}
        				    break;

        				default:
        				    alt12=24;}

        			}
        		    break;
        		case '_':
        		case 'a':
        		case 'b':
        		case 'c':
        		case 'd':
        		case 'e':
        		case 'f':
        		case 'g':
        		case 'h':
        		case 'i':
        		case 'j':
        		case 'k':
        		case 'l':
        		case 'm':
        		case 'n':
        		case 'o':
        		case 'p':
        		case 'q':
        		case 'r':
        		case 's':
        		case 'u':
        		case 'v':
        		case 'w':
        		case 'x':
        		case 'y':
        		case 'z':
        			{
        				alt12=24;
        			}
        		    break;

        		default:
        		    CONSTRUCTEX();
        		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        		    EXCEPTION->message      = (void *)"";
        		    EXCEPTION->decisionNum  = 12;
        		    EXCEPTION->state        = 9;


        		    goto ruleTokensEx;
        		}

        	}
            break;
        case 'e':
        	{
        		switch ( LA(2) ) 
        		{
        		case 'n':
        			{
        				switch ( LA(3) ) 
        				{
        				case 'd':
        					{
        						switch ( LA(4) ) 
        						{
        						case 's':
        							{
        								switch ( LA(5) ) 
        								{
        								case 'w':
        									{
        										switch ( LA(6) ) 
        										{
        										case 'i':
        											{
        												switch ( LA(7) ) 
        												{
        												case 't':
        													{
        														switch ( LA(8) ) 
        														{
        														case 'h':
        															{
        																switch ( LA(9) ) 
        																{
        																case '_':
        																case 'a':
        																case 'b':
        																case 'c':
        																case 'd':
        																case 'e':
        																case 'f':
        																case 'g':
        																case 'h':
        																case 'i':
        																case 'j':
        																case 'k':
        																case 'l':
        																case 'm':
        																case 'n':
        																case 'o':
        																case 'p':
        																case 'q':
        																case 'r':
        																case 's':
        																case 't':
        																case 'u':
        																case 'v':
        																case 'w':
        																case 'x':
        																case 'y':
        																case 'z':
        																	{
        																		alt12=24;
        																	}
        																    break;

        																default:
        																    alt12=10;}

        															}
        														    break;

        														default:
        														    alt12=24;}

        													}
        												    break;

        												default:
        												    alt12=24;}

        											}
        										    break;

        										default:
        										    alt12=24;}

        									}
        								    break;

        								default:
        								    alt12=24;}

        							}
        						    break;

        						default:
        						    alt12=24;}

        					}
        				    break;

        				default:
        				    alt12=24;}

        			}
        		    break;
        		case '_':
        		case 'a':
        		case 'b':
        		case 'c':
        		case 'd':
        		case 'e':
        		case 'f':
        		case 'g':
        		case 'h':
        		case 'i':
        		case 'j':
        		case 'k':
        		case 'l':
        		case 'm':
        		case 'o':
        		case 'p':
        		case 'q':
        		case 'r':
        		case 's':
        		case 't':
        		case 'u':
        		case 'v':
        		case 'w':
        		case 'x':
        		case 'y':
        		case 'z':
        			{
        				alt12=24;
        			}
        		    break;

        		default:
        		    CONSTRUCTEX();
        		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        		    EXCEPTION->message      = (void *)"";
        		    EXCEPTION->decisionNum  = 12;
        		    EXCEPTION->state        = 10;


        		    goto ruleTokensEx;
        		}

        	}
            break;
        case '>':
        	{
        		switch ( LA(2) ) 
        		{
        		case '=':
        			{
        				alt12=13;
        			}
        		    break;

        		default:
        		    alt12=11;}

        	}
            break;
        case '<':
        	{
        		switch ( LA(2) ) 
        		{
        		case '=':
        			{
        				alt12=14;
        			}
        		    break;

        		default:
        		    alt12=12;}

        	}
            break;
        case 'b':
        	{
        		switch ( LA(2) ) 
        		{
        		case 'e':
        			{
        				switch ( LA(3) ) 
        				{
        				case 'f':
        					{
        						switch ( LA(4) ) 
        						{
        						case 'o':
        							{
        								switch ( LA(5) ) 
        								{
        								case 'r':
        									{
        										switch ( LA(6) ) 
        										{
        										case 'e':
        											{
        												switch ( LA(7) ) 
        												{
        												case '_':
        												case 'a':
        												case 'b':
        												case 'c':
        												case 'd':
        												case 'e':
        												case 'f':
        												case 'g':
        												case 'h':
        												case 'i':
        												case 'j':
        												case 'k':
        												case 'l':
        												case 'm':
        												case 'n':
        												case 'o':
        												case 'p':
        												case 'q':
        												case 'r':
        												case 's':
        												case 't':
        												case 'u':
        												case 'v':
        												case 'w':
        												case 'x':
        												case 'y':
        												case 'z':
        													{
        														alt12=24;
        													}
        												    break;

        												default:
        												    alt12=15;}

        											}
        										    break;

        										default:
        										    alt12=24;}

        									}
        								    break;

        								default:
        								    alt12=24;}

        							}
        						    break;

        						default:
        						    alt12=24;}

        					}
        				    break;

        				default:
        				    alt12=24;}

        			}
        		    break;
        		case '_':
        		case 'a':
        		case 'b':
        		case 'c':
        		case 'd':
        		case 'f':
        		case 'g':
        		case 'h':
        		case 'i':
        		case 'j':
        		case 'k':
        		case 'l':
        		case 'm':
        		case 'n':
        		case 'o':
        		case 'p':
        		case 'q':
        		case 'r':
        		case 's':
        		case 't':
        		case 'u':
        		case 'v':
        		case 'w':
        		case 'x':
        		case 'y':
        		case 'z':
        			{
        				alt12=24;
        			}
        		    break;

        		default:
        		    CONSTRUCTEX();
        		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        		    EXCEPTION->message      = (void *)"";
        		    EXCEPTION->decisionNum  = 12;
        		    EXCEPTION->state        = 13;


        		    goto ruleTokensEx;
        		}

        	}
            break;
        case 'd':
        	{
        		switch ( LA(2) ) 
        		{
        		case 'a':
        			{
        				switch ( LA(3) ) 
        				{
        				case 'y':
        					{
        						switch ( LA(4) ) 
        						{
        						case 's':
        							{
        								switch ( LA(5) ) 
        								{
        								case '_':
        								case 'a':
        								case 'b':
        								case 'c':
        								case 'd':
        								case 'e':
        								case 'f':
        								case 'g':
        								case 'h':
        								case 'i':
        								case 'j':
        								case 'k':
        								case 'l':
        								case 'm':
        								case 'n':
        								case 'o':
        								case 'p':
        								case 'q':
        								case 'r':
        								case 's':
        								case 't':
        								case 'u':
        								case 'v':
        								case 'w':
        								case 'x':
        								case 'y':
        								case 'z':
        									{
        										alt12=24;
        									}
        								    break;

        								default:
        								    alt12=17;}

        							}
        						    break;
        						case '_':
        						case 'a':
        						case 'b':
        						case 'c':
        						case 'd':
        						case 'e':
        						case 'f':
        						case 'g':
        						case 'h':
        						case 'i':
        						case 'j':
        						case 'k':
        						case 'l':
        						case 'm':
        						case 'n':
        						case 'o':
        						case 'p':
        						case 'q':
        						case 'r':
        						case 't':
        						case 'u':
        						case 'v':
        						case 'w':
        						case 'x':
        						case 'y':
        						case 'z':
        							{
        								alt12=24;
        							}
        						    break;

        						default:
        						    alt12=17;}

        					}
        				    break;

        				default:
        				    alt12=24;}

        			}
        		    break;
        		case '_':
        		case 'b':
        		case 'c':
        		case 'd':
        		case 'e':
        		case 'f':
        		case 'g':
        		case 'h':
        		case 'i':
        		case 'j':
        		case 'k':
        		case 'l':
        		case 'm':
        		case 'n':
        		case 'o':
        		case 'p':
        		case 'q':
        		case 'r':
        		case 's':
        		case 't':
        		case 'u':
        		case 'v':
        		case 'w':
        		case 'x':
        		case 'y':
        		case 'z':
        			{
        				alt12=24;
        			}
        		    break;

        		default:
        		    CONSTRUCTEX();
        		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        		    EXCEPTION->message      = (void *)"";
        		    EXCEPTION->decisionNum  = 12;
        		    EXCEPTION->state        = 14;


        		    goto ruleTokensEx;
        		}

        	}
            break;
        case 'w':
        	{
        		switch ( LA(2) ) 
        		{
        		case 'e':
        			{
        				switch ( LA(3) ) 
        				{
        				case 'e':
        					{
        						switch ( LA(4) ) 
        						{
        						case 'k':
        							{
        								switch ( LA(5) ) 
        								{
        								case 's':
        									{
        										switch ( LA(6) ) 
        										{
        										case '_':
        										case 'a':
        										case 'b':
        										case 'c':
        										case 'd':
        										case 'e':
        										case 'f':
        										case 'g':
        										case 'h':
        										case 'i':
        										case 'j':
        										case 'k':
        										case 'l':
        										case 'm':
        										case 'n':
        										case 'o':
        										case 'p':
        										case 'q':
        										case 'r':
        										case 's':
        										case 't':
        										case 'u':
        										case 'v':
        										case 'w':
        										case 'x':
        										case 'y':
        										case 'z':
        											{
        												alt12=24;
        											}
        										    break;

        										default:
        										    alt12=18;}

        									}
        								    break;
        								case '_':
        								case 'a':
        								case 'b':
        								case 'c':
        								case 'd':
        								case 'e':
        								case 'f':
        								case 'g':
        								case 'h':
        								case 'i':
        								case 'j':
        								case 'k':
        								case 'l':
        								case 'm':
        								case 'n':
        								case 'o':
        								case 'p':
        								case 'q':
        								case 'r':
        								case 't':
        								case 'u':
        								case 'v':
        								case 'w':
        								case 'x':
        								case 'y':
        								case 'z':
        									{
        										alt12=24;
        									}
        								    break;

        								default:
        								    alt12=18;}

        							}
        						    break;

        						default:
        						    alt12=24;}

        					}
        				    break;

        				default:
        				    alt12=24;}

        			}
        		    break;
        		case '_':
        		case 'a':
        		case 'b':
        		case 'c':
        		case 'd':
        		case 'f':
        		case 'g':
        		case 'h':
        		case 'i':
        		case 'j':
        		case 'k':
        		case 'l':
        		case 'm':
        		case 'n':
        		case 'o':
        		case 'p':
        		case 'q':
        		case 'r':
        		case 's':
        		case 't':
        		case 'u':
        		case 'v':
        		case 'w':
        		case 'x':
        		case 'y':
        		case 'z':
        			{
        				alt12=24;
        			}
        		    break;

        		default:
        		    CONSTRUCTEX();
        		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        		    EXCEPTION->message      = (void *)"";
        		    EXCEPTION->decisionNum  = 12;
        		    EXCEPTION->state        = 15;


        		    goto ruleTokensEx;
        		}

        	}
            break;
        case 'm':
        	{
        		switch ( LA(2) ) 
        		{
        		case 'o':
        			{
        				switch ( LA(3) ) 
        				{
        				case 'n':
        					{
        						switch ( LA(4) ) 
        						{
        						case 't':
        							{
        								switch ( LA(5) ) 
        								{
        								case 'h':
        									{
        										switch ( LA(6) ) 
        										{
        										case 's':
        											{
        												switch ( LA(7) ) 
        												{
        												case '_':
        												case 'a':
        												case 'b':
        												case 'c':
        												case 'd':
        												case 'e':
        												case 'f':
        												case 'g':
        												case 'h':
        												case 'i':
        												case 'j':
        												case 'k':
        												case 'l':
        												case 'm':
        												case 'n':
        												case 'o':
        												case 'p':
        												case 'q':
        												case 'r':
        												case 's':
        												case 't':
        												case 'u':
        												case 'v':
        												case 'w':
        												case 'x':
        												case 'y':
        												case 'z':
        													{
        														alt12=24;
        													}
        												    break;

        												default:
        												    alt12=19;}

        											}
        										    break;
        										case '_':
        										case 'a':
        										case 'b':
        										case 'c':
        										case 'd':
        										case 'e':
        										case 'f':
        										case 'g':
        										case 'h':
        										case 'i':
        										case 'j':
        										case 'k':
        										case 'l':
        										case 'm':
        										case 'n':
        										case 'o':
        										case 'p':
        										case 'q':
        										case 'r':
        										case 't':
        										case 'u':
        										case 'v':
        										case 'w':
        										case 'x':
        										case 'y':
        										case 'z':
        											{
        												alt12=24;
        											}
        										    break;

        										default:
        										    alt12=19;}

        									}
        								    break;

        								default:
        								    alt12=24;}

        							}
        						    break;

        						default:
        						    alt12=24;}

        					}
        				    break;

        				default:
        				    alt12=24;}

        			}
        		    break;
        		case '_':
        		case 'a':
        		case 'b':
        		case 'c':
        		case 'd':
        		case 'e':
        		case 'f':
        		case 'g':
        		case 'h':
        		case 'i':
        		case 'j':
        		case 'k':
        		case 'l':
        		case 'm':
        		case 'n':
        		case 'p':
        		case 'q':
        		case 'r':
        		case 's':
        		case 't':
        		case 'u':
        		case 'v':
        		case 'w':
        		case 'x':
        		case 'y':
        		case 'z':
        			{
        				alt12=24;
        			}
        		    break;

        		default:
        		    CONSTRUCTEX();
        		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        		    EXCEPTION->message      = (void *)"";
        		    EXCEPTION->decisionNum  = 12;
        		    EXCEPTION->state        = 16;


        		    goto ruleTokensEx;
        		}

        	}
            break;
        case 'y':
        	{
        		switch ( LA(2) ) 
        		{
        		case 'e':
        			{
        				switch ( LA(3) ) 
        				{
        				case 'a':
        					{
        						switch ( LA(4) ) 
        						{
        						case 'r':
        							{
        								switch ( LA(5) ) 
        								{
        								case 's':
        									{
        										switch ( LA(6) ) 
        										{
        										case '_':
        										case 'a':
        										case 'b':
        										case 'c':
        										case 'd':
        										case 'e':
        										case 'f':
        										case 'g':
        										case 'h':
        										case 'i':
        										case 'j':
        										case 'k':
        										case 'l':
        										case 'm':
        										case 'n':
        										case 'o':
        										case 'p':
        										case 'q':
        										case 'r':
        										case 's':
        										case 't':
        										case 'u':
        										case 'v':
        										case 'w':
        										case 'x':
        										case 'y':
        										case 'z':
        											{
        												alt12=24;
        											}
        										    break;

        										default:
        										    alt12=20;}

        									}
        								    break;
        								case '_':
        								case 'a':
        								case 'b':
        								case 'c':
        								case 'd':
        								case 'e':
        								case 'f':
        								case 'g':
        								case 'h':
        								case 'i':
        								case 'j':
        								case 'k':
        								case 'l':
        								case 'm':
        								case 'n':
        								case 'o':
        								case 'p':
        								case 'q':
        								case 'r':
        								case 't':
        								case 'u':
        								case 'v':
        								case 'w':
        								case 'x':
        								case 'y':
        								case 'z':
        									{
        										alt12=24;
        									}
        								    break;

        								default:
        								    alt12=20;}

        							}
        						    break;

        						default:
        						    alt12=24;}

        					}
        				    break;

        				default:
        				    alt12=24;}

        			}
        		    break;
        		case '_':
        		case 'a':
        		case 'b':
        		case 'c':
        		case 'd':
        		case 'f':
        		case 'g':
        		case 'h':
        		case 'i':
        		case 'j':
        		case 'k':
        		case 'l':
        		case 'm':
        		case 'n':
        		case 'o':
        		case 'p':
        		case 'q':
        		case 'r':
        		case 's':
        		case 't':
        		case 'u':
        		case 'v':
        		case 'w':
        		case 'x':
        		case 'y':
        		case 'z':
        			{
        				alt12=24;
        			}
        		    break;

        		default:
        		    CONSTRUCTEX();
        		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        		    EXCEPTION->message      = (void *)"";
        		    EXCEPTION->decisionNum  = 12;
        		    EXCEPTION->state        = 17;


        		    goto ruleTokensEx;
        		}

        	}
            break;
        case 't':
        	{
        		switch ( LA(2) ) 
        		{
        		case 'o':
        			{
        				switch ( LA(3) ) 
        				{
        				case 'd':
        					{
        						switch ( LA(4) ) 
        						{
        						case 'a':
        							{
        								switch ( LA(5) ) 
        								{
        								case 'y':
        									{
        										switch ( LA(6) ) 
        										{
        										case '_':
        										case 'a':
        										case 'b':
        										case 'c':
        										case 'd':
        										case 'e':
        										case 'f':
        										case 'g':
        										case 'h':
        										case 'i':
        										case 'j':
        										case 'k':
        										case 'l':
        										case 'm':
        										case 'n':
        										case 'o':
        										case 'p':
        										case 'q':
        										case 'r':
        										case 's':
        										case 't':
        										case 'u':
        										case 'v':
        										case 'w':
        										case 'x':
        										case 'y':
        										case 'z':
        											{
        												alt12=24;
        											}
        										    break;

        										default:
        										    alt12=21;}

        									}
        								    break;

        								default:
        								    alt12=24;}

        							}
        						    break;

        						default:
        						    alt12=24;}

        					}
        				    break;

        				default:
        				    alt12=24;}

        			}
        		    break;
        		case '_':
        		case 'a':
        		case 'b':
        		case 'c':
        		case 'd':
        		case 'e':
        		case 'f':
        		case 'g':
        		case 'h':
        		case 'i':
        		case 'j':
        		case 'k':
        		case 'l':
        		case 'm':
        		case 'n':
        		case 'p':
        		case 'q':
        		case 'r':
        		case 's':
        		case 't':
        		case 'u':
        		case 'v':
        		case 'w':
        		case 'x':
        		case 'y':
        		case 'z':
        			{
        				alt12=24;
        			}
        		    break;

        		default:
        		    CONSTRUCTEX();
        		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        		    EXCEPTION->message      = (void *)"";
        		    EXCEPTION->decisionNum  = 12;
        		    EXCEPTION->state        = 18;


        		    goto ruleTokensEx;
        		}

        	}
            break;
        case '\n':
        case '\r':
        	{
        		alt12=22;
        	}
            break;
        case '\t':
        case ' ':
        	{
        		alt12=23;
        	}
            break;
        case 'c':
        case 'f':
        case 'g':
        case 'h':
        case 'j':
        case 'k':
        case 'l':
        case 'n':
        case 'p':
        case 'q':
        case 'r':
        case 'u':
        case 'v':
        case 'x':
        case 'z':
        	{
        		alt12=24;
        	}
            break;
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
        	{
        		switch ( LA(2) ) 
        		{
        		case '0':
        		case '1':
        		case '2':
        		case '3':
        		case '4':
        		case '5':
        		case '6':
        		case '7':
        		case '8':
        		case '9':
        			{
        				switch ( LA(3) ) 
        				{
        				case '0':
        				case '1':
        				case '2':
        				case '3':
        				case '4':
        				case '5':
        				case '6':
        				case '7':
        				case '8':
        				case '9':
        					{
        						switch ( LA(4) ) 
        						{
        						case '0':
        						case '1':
        						case '2':
        						case '3':
        						case '4':
        						case '5':
        						case '6':
        						case '7':
        						case '8':
        						case '9':
        							{
        								switch ( LA(5) ) 
        								{
        								case '-':
        									{
        										alt12=26;
        									}
        								    break;

        								default:
        								    alt12=25;}

        							}
        						    break;

        						default:
        						    alt12=25;}

        					}
        				    break;

        				default:
        				    alt12=25;}

        			}
        		    break;

        		default:
        		    alt12=25;}

        	}
            break;

        default:
            CONSTRUCTEX();
            EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            EXCEPTION->message      = (void *)"";
            EXCEPTION->decisionNum  = 12;
            EXCEPTION->state        = 0;


            goto ruleTokensEx;
        }

        switch (alt12) 
        {
    	case 1:
    	    // RSP.g:1:10: QUOTE
    	    {
    	        /* 1:10: QUOTE */
    	        mQUOTE(ctx ); 
    	        if  (HASEXCEPTION())
    	        {
    	            goto ruleTokensEx;
    	        }


    	    }
    	    break;
    	case 2:
    	    // RSP.g:1:16: LPAR
    	    {
    	        /* 1:16: LPAR */
    	        mLPAR(ctx ); 
    	        if  (HASEXCEPTION())
    	        {
    	            goto ruleTokensEx;
    	        }


    	    }
    	    break;
    	case 3:
    	    // RSP.g:1:21: RPAR
    	    {
    	        /* 1:21: RPAR */
    	        mRPAR(ctx ); 
    	        if  (HASEXCEPTION())
    	        {
    	            goto ruleTokensEx;
    	        }


    	    }
    	    break;
    	case 4:
    	    // RSP.g:1:26: AND
    	    {
    	        /* 1:26: AND */
    	        mAND(ctx ); 
    	        if  (HASEXCEPTION())
    	        {
    	            goto ruleTokensEx;
    	        }


    	    }
    	    break;
    	case 5:
    	    // RSP.g:1:30: OR
    	    {
    	        /* 1:30: OR */
    	        mOR(ctx ); 
    	        if  (HASEXCEPTION())
    	        {
    	            goto ruleTokensEx;
    	        }


    	    }
    	    break;
    	case 6:
    	    // RSP.g:1:33: NOT
    	    {
    	        /* 1:33: NOT */
    	        mNOT(ctx ); 
    	        if  (HASEXCEPTION())
    	        {
    	            goto ruleTokensEx;
    	        }


    	    }
    	    break;
    	case 7:
    	    // RSP.g:1:37: EQUAL
    	    {
    	        /* 1:37: EQUAL */
    	        mEQUAL(ctx ); 
    	        if  (HASEXCEPTION())
    	        {
    	            goto ruleTokensEx;
    	        }


    	    }
    	    break;
    	case 8:
    	    // RSP.g:1:43: INCLUDES
    	    {
    	        /* 1:43: INCLUDES */
    	        mINCLUDES(ctx ); 
    	        if  (HASEXCEPTION())
    	        {
    	            goto ruleTokensEx;
    	        }


    	    }
    	    break;
    	case 9:
    	    // RSP.g:1:52: STARTSW
    	    {
    	        /* 1:52: STARTSW */
    	        mSTARTSW(ctx ); 
    	        if  (HASEXCEPTION())
    	        {
    	            goto ruleTokensEx;
    	        }


    	    }
    	    break;
    	case 10:
    	    // RSP.g:1:60: ENDSW
    	    {
    	        /* 1:60: ENDSW */
    	        mENDSW(ctx ); 
    	        if  (HASEXCEPTION())
    	        {
    	            goto ruleTokensEx;
    	        }


    	    }
    	    break;
    	case 11:
    	    // RSP.g:1:66: GREATER
    	    {
    	        /* 1:66: GREATER */
    	        mGREATER(ctx ); 
    	        if  (HASEXCEPTION())
    	        {
    	            goto ruleTokensEx;
    	        }


    	    }
    	    break;
    	case 12:
    	    // RSP.g:1:74: LESS
    	    {
    	        /* 1:74: LESS */
    	        mLESS(ctx ); 
    	        if  (HASEXCEPTION())
    	        {
    	            goto ruleTokensEx;
    	        }


    	    }
    	    break;
    	case 13:
    	    // RSP.g:1:79: GTE
    	    {
    	        /* 1:79: GTE */
    	        mGTE(ctx ); 
    	        if  (HASEXCEPTION())
    	        {
    	            goto ruleTokensEx;
    	        }


    	    }
    	    break;
    	case 14:
    	    // RSP.g:1:83: LTE
    	    {
    	        /* 1:83: LTE */
    	        mLTE(ctx ); 
    	        if  (HASEXCEPTION())
    	        {
    	            goto ruleTokensEx;
    	        }


    	    }
    	    break;
    	case 15:
    	    // RSP.g:1:87: BEFORE
    	    {
    	        /* 1:87: BEFORE */
    	        mBEFORE(ctx ); 
    	        if  (HASEXCEPTION())
    	        {
    	            goto ruleTokensEx;
    	        }


    	    }
    	    break;
    	case 16:
    	    // RSP.g:1:94: AFTER
    	    {
    	        /* 1:94: AFTER */
    	        mAFTER(ctx ); 
    	        if  (HASEXCEPTION())
    	        {
    	            goto ruleTokensEx;
    	        }


    	    }
    	    break;
    	case 17:
    	    // RSP.g:1:100: DAY
    	    {
    	        /* 1:100: DAY */
    	        mDAY(ctx ); 
    	        if  (HASEXCEPTION())
    	        {
    	            goto ruleTokensEx;
    	        }


    	    }
    	    break;
    	case 18:
    	    // RSP.g:1:104: WEEK
    	    {
    	        /* 1:104: WEEK */
    	        mWEEK(ctx ); 
    	        if  (HASEXCEPTION())
    	        {
    	            goto ruleTokensEx;
    	        }


    	    }
    	    break;
    	case 19:
    	    // RSP.g:1:109: MONTH
    	    {
    	        /* 1:109: MONTH */
    	        mMONTH(ctx ); 
    	        if  (HASEXCEPTION())
    	        {
    	            goto ruleTokensEx;
    	        }


    	    }
    	    break;
    	case 20:
    	    // RSP.g:1:115: YEAR
    	    {
    	        /* 1:115: YEAR */
    	        mYEAR(ctx ); 
    	        if  (HASEXCEPTION())
    	        {
    	            goto ruleTokensEx;
    	        }


    	    }
    	    break;
    	case 21:
    	    // RSP.g:1:120: TODAY
    	    {
    	        /* 1:120: TODAY */
    	        mTODAY(ctx ); 
    	        if  (HASEXCEPTION())
    	        {
    	            goto ruleTokensEx;
    	        }


    	    }
    	    break;
    	case 22:
    	    // RSP.g:1:126: NEWLINE
    	    {
    	        /* 1:126: NEWLINE */
    	        mNEWLINE(ctx ); 
    	        if  (HASEXCEPTION())
    	        {
    	            goto ruleTokensEx;
    	        }


    	    }
    	    break;
    	case 23:
    	    // RSP.g:1:134: WS
    	    {
    	        /* 1:134: WS */
    	        mWS(ctx ); 
    	        if  (HASEXCEPTION())
    	        {
    	            goto ruleTokensEx;
    	        }


    	    }
    	    break;
    	case 24:
    	    // RSP.g:1:137: FIELD
    	    {
    	        /* 1:137: FIELD */
    	        mFIELD(ctx ); 
    	        if  (HASEXCEPTION())
    	        {
    	            goto ruleTokensEx;
    	        }


    	    }
    	    break;
    	case 25:
    	    // RSP.g:1:143: INT
    	    {
    	        /* 1:143: INT */
    	        mINT(ctx ); 
    	        if  (HASEXCEPTION())
    	        {
    	            goto ruleTokensEx;
    	        }


    	    }
    	    break;
    	case 26:
    	    // RSP.g:1:147: DATE
    	    {
    	        /* 1:147: DATE */
    	        mDATE(ctx ); 
    	        if  (HASEXCEPTION())
    	        {
    	            goto ruleTokensEx;
    	        }


    	    }
    	    break;
    	case 27:
    	    // RSP.g:1:152: STR
    	    {
    	        /* 1:152: STR */
    	        mSTR(ctx ); 
    	        if  (HASEXCEPTION())
    	        {
    	            goto ruleTokensEx;
    	        }


    	    }
    	    break;

        }
    }

    
    goto ruleTokensEx; /* Prevent compiler warnings */
ruleTokensEx: ;
}

/* =========================================================================
 * Lexer matching rules end.
 * =========================================================================
 */
/* End of Lexer code
 * ================================================
 * ================================================
 */ 


/* End of code
 * =============================================================================
 */
