/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver.runtime.java.lang;

public class Float_ {
    private Float_() {
    }

    public static Float valueOf(float val) {
        return new Float(val);
    }

    public static String toHexString(float f) {
        if (f != f) {
            return "NaN";
        }
        if (f == Float.POSITIVE_INFINITY) {
            return "Infinity";
        }
        if (f == Float.NEGATIVE_INFINITY) {
            return "-Infinity";
        }
        int bitValue = Float.floatToIntBits(f);
        boolean negative = (bitValue & Integer.MIN_VALUE) != 0;
        int exponent = (bitValue & 0x7F800000) >>> 23;
        int significand = (bitValue & 0x7FFFFF) << 1;
        if (exponent == 0 && significand == 0) {
            return negative ? "-0x0.0p0" : "0x0.0p0";
        }
        StringBuffer hexString = new StringBuffer(10);
        if (negative) {
            hexString.append("-0x");
        } else {
            hexString.append("0x");
        }
        if (exponent == 0) {
            hexString.append("0.");
            int fractionDigits = 6;
            while (significand != 0 && (significand & 0xF) == 0) {
                significand >>>= 4;
                --fractionDigits;
            }
            String hexSignificand = Integer.toHexString(significand);
            if (significand != 0 && fractionDigits > hexSignificand.length()) {
                int digitDiff = fractionDigits - hexSignificand.length();
                while (digitDiff-- != 0) {
                    hexString.append('0');
                }
            }
            hexString.append(hexSignificand);
            hexString.append("p-126");
        } else {
            hexString.append("1.");
            int fractionDigits = 6;
            while (significand != 0 && (significand & 0xF) == 0) {
                significand >>>= 4;
                --fractionDigits;
            }
            String hexSignificand = Integer.toHexString(significand);
            if (significand != 0 && fractionDigits > hexSignificand.length()) {
                int digitDiff = fractionDigits - hexSignificand.length();
                while (digitDiff-- != 0) {
                    hexString.append('0');
                }
            }
            hexString.append(hexSignificand);
            hexString.append('p');
            hexString.append(Integer.toString(exponent - 127));
        }
        return hexString.toString();
    }
}

