/* sw-backend.c generated by valac 0.13.4.11-4c506, the Vala compiler
 * generated from sw-backend.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Marco Barisione <marco.barisione@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <libsocialweb-client/libsocialweb-client-hack-for-vala.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <folks/folks-libsocialweb.h>


#define FOLKS_BACKENDS_SW_TYPE_BACKEND (folks_backends_sw_backend_get_type ())
#define FOLKS_BACKENDS_SW_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_SW_TYPE_BACKEND, FolksBackendsSwBackend))
#define FOLKS_BACKENDS_SW_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_SW_TYPE_BACKEND, FolksBackendsSwBackendClass))
#define FOLKS_BACKENDS_SW_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_SW_TYPE_BACKEND))
#define FOLKS_BACKENDS_SW_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_SW_TYPE_BACKEND))
#define FOLKS_BACKENDS_SW_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_SW_TYPE_BACKEND, FolksBackendsSwBackendClass))

typedef struct _FolksBackendsSwBackend FolksBackendsSwBackend;
typedef struct _FolksBackendsSwBackendClass FolksBackendsSwBackendClass;
typedef struct _FolksBackendsSwBackendPrivate FolksBackendsSwBackendPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _FolksBackendsSwBackendPrepareData FolksBackendsSwBackendPrepareData;
typedef struct _FolksBackendsSwBackendUnprepareData FolksBackendsSwBackendUnprepareData;

struct _FolksBackendsSwBackend {
	FolksBackend parent_instance;
	FolksBackendsSwBackendPrivate * priv;
};

struct _FolksBackendsSwBackendClass {
	FolksBackendClass parent_class;
};

struct _FolksBackendsSwBackendPrivate {
	gboolean _is_prepared;
	GStaticRecMutex __lock__is_prepared;
	gboolean _is_quiescent;
	SwClient* _client;
	GeeHashMap* _persona_stores;
	GeeMap* _persona_stores_ro;
};

struct _FolksBackendsSwBackendPrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsSwBackend* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	SwClient* _tmp2_;
	SwClient* _tmp3_;
	gboolean _tmp4_;
	GError * _inner_error_;
};

struct _FolksBackendsSwBackendUnprepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsSwBackend* self;
	GeeHashMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	GeeIterator* _tmp4_;
	GeeIterator* _tmp5_;
	GeeIterator* _store_it;
	GeeIterator* _tmp6_;
	gboolean _tmp7_;
	GeeIterator* _tmp8_;
	gpointer _tmp9_;
	FolksPersonaStore* store;
	FolksPersonaStore* _tmp10_;
	guint _tmp11_;
	FolksPersonaStore* _tmp12_;
	GeeHashMap* _tmp13_;
};


static gpointer folks_backends_sw_backend_parent_class = NULL;

GType folks_backends_sw_backend_get_type (void) G_GNUC_CONST;
#define FOLKS_BACKENDS_SW_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_BACKENDS_SW_TYPE_BACKEND, FolksBackendsSwBackendPrivate))
enum  {
	FOLKS_BACKENDS_SW_BACKEND_DUMMY_PROPERTY,
	FOLKS_BACKENDS_SW_BACKEND_NAME,
	FOLKS_BACKENDS_SW_BACKEND_PERSONA_STORES,
	FOLKS_BACKENDS_SW_BACKEND_IS_PREPARED,
	FOLKS_BACKENDS_SW_BACKEND_IS_QUIESCENT
};
FolksBackendsSwBackend* folks_backends_sw_backend_new (void);
FolksBackendsSwBackend* folks_backends_sw_backend_construct (GType object_type);
static void folks_backends_sw_backend_real_prepare_data_free (gpointer _data);
static void folks_backends_sw_backend_real_prepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_sw_backend_real_prepare_co (FolksBackendsSwBackendPrepareData* _data_);
static void _____lambda0_ (FolksBackendsSwBackend* self, SwClient* client, GList* services);
static void folks_backends_sw_backend_add_service (FolksBackendsSwBackend* self, const gchar* service_name);
static void ______lambda0__sw_client_get_services_callback (SwClient* client, GList* services, gpointer self);
static void folks_backends_sw_backend_real_unprepare_data_free (gpointer _data);
static void folks_backends_sw_backend_real_unprepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_sw_backend_real_unprepare_co (FolksBackendsSwBackendUnprepareData* _data_);
static void folks_backends_sw_backend_store_removed_cb (FolksBackendsSwBackend* self, FolksPersonaStore* store);
static void _folks_backends_sw_backend_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self);
static void folks_backends_sw_backend_finalize (GObject* obj);
static void _vala_folks_backends_sw_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


/**
   * {@inheritDoc}
   */
FolksBackendsSwBackend* folks_backends_sw_backend_construct (GType object_type) {
	FolksBackendsSwBackend * self = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeMap* _tmp2_;
	GeeMap* _tmp3_;
#line 59 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	self = (FolksBackendsSwBackend*) folks_backend_construct (object_type);
#line 61 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_PERSONA_STORE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 61 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_g_object_unref0 (self->priv->_persona_stores);
#line 61 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	self->priv->_persona_stores = _tmp0_;
#line 62 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_tmp1_ = self->priv->_persona_stores;
#line 62 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_tmp2_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp1_);
#line 62 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_tmp3_ = _tmp2_;
#line 62 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_g_object_unref0 (self->priv->_persona_stores_ro);
#line 62 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	self->priv->_persona_stores_ro = _tmp3_;
#line 59 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	return self;
#line 165 "sw-backend.c"
}


FolksBackendsSwBackend* folks_backends_sw_backend_new (void) {
#line 59 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	return folks_backends_sw_backend_construct (FOLKS_BACKENDS_SW_TYPE_BACKEND);
#line 172 "sw-backend.c"
}


static void folks_backends_sw_backend_real_prepare_data_free (gpointer _data) {
	FolksBackendsSwBackendPrepareData* _data_;
	_data_ = _data;
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_g_object_unref0 (_data_->self);
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	g_slice_free (FolksBackendsSwBackendPrepareData, _data_);
#line 183 "sw-backend.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	return self ? g_object_ref (self) : NULL;
#line 190 "sw-backend.c"
}


static void folks_backends_sw_backend_real_prepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsSwBackend * self;
	FolksBackendsSwBackendPrepareData* _data_;
	FolksBackendsSwBackend* _tmp0_;
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	self = (FolksBackendsSwBackend*) base;
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_data_ = g_slice_new0 (FolksBackendsSwBackendPrepareData);
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_sw_backend_real_prepare);
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_sw_backend_real_prepare_data_free);
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_data_->self = _tmp0_;
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	folks_backends_sw_backend_real_prepare_co (_data_);
#line 212 "sw-backend.c"
}


static void folks_backends_sw_backend_real_prepare_finish (FolksBackend* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsSwBackendPrepareData* _data_;
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		return;
#line 222 "sw-backend.c"
	}
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 226 "sw-backend.c"
}


/**
   * {@inheritDoc}
   */
static void _____lambda0_ (FolksBackendsSwBackend* self, SwClient* client, GList* services) {
	GList* _tmp0_;
#line 97 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	g_return_if_fail (client != NULL);
#line 99 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_tmp0_ = services;
#line 239 "sw-backend.c"
	{
		GList* service_name_collection = NULL;
		GList* service_name_it = NULL;
#line 99 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		service_name_collection = _tmp0_;
#line 99 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		for (service_name_it = service_name_collection; service_name_it != NULL; service_name_it = service_name_it->next) {
#line 247 "sw-backend.c"
			const gchar* service_name = NULL;
#line 99 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
			service_name = (const gchar*) service_name_it->data;
#line 251 "sw-backend.c"
			{
				const gchar* _tmp1_;
#line 100 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
				_tmp1_ = service_name;
#line 100 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
				folks_backends_sw_backend_add_service (self, _tmp1_);
#line 258 "sw-backend.c"
			}
		}
	}
#line 102 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	self->priv->_is_prepared = TRUE;
#line 103 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	g_object_notify ((GObject*) self, "is-prepared");
#line 105 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	self->priv->_is_quiescent = TRUE;
#line 106 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	g_object_notify ((GObject*) self, "is-quiescent");
#line 270 "sw-backend.c"
}


static void ______lambda0__sw_client_get_services_callback (SwClient* client, GList* services, gpointer self) {
#line 97 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_____lambda0_ (self, client, services);
#line 277 "sw-backend.c"
}


static gboolean folks_backends_sw_backend_real_prepare_co (FolksBackendsSwBackendPrepareData* _data_) {
#line 90 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	switch (_data_->_state_) {
#line 90 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		case 0:
#line 286 "sw-backend.c"
		goto _state_0;
		default:
#line 90 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		g_assert_not_reached ();
#line 291 "sw-backend.c"
	}
	_state_0:
	{
#line 92 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		_data_->_tmp0_ = _data_->self->priv->_is_prepared;
#line 92 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		g_static_rec_mutex_lock (&_data_->self->priv->__lock__is_prepared);
#line 299 "sw-backend.c"
		{
#line 94 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
			_data_->_tmp1_ = _data_->self->priv->_is_prepared;
#line 94 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
			if (!_data_->_tmp1_) {
#line 96 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
				_data_->_tmp2_ = sw_client_new ();
#line 96 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
				_g_object_unref0 (_data_->self->priv->_client);
#line 96 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
				_data_->self->priv->_client = _data_->_tmp2_;
#line 97 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
				_data_->_tmp3_ = _data_->self->priv->_client;
#line 97 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
				sw_client_get_services (_data_->_tmp3_, ______lambda0__sw_client_get_services_callback, _data_->self);
#line 315 "sw-backend.c"
			}
		}
		__finally0:
		{
#line 92 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
			_data_->_tmp4_ = _data_->self->priv->_is_prepared;
#line 92 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
			g_static_rec_mutex_unlock (&_data_->self->priv->__lock__is_prepared);
#line 324 "sw-backend.c"
		}
#line 92 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		if (_data_->_inner_error_ != NULL) {
#line 92 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 92 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
			g_error_free (_data_->_inner_error_);
#line 92 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
			if (_data_->_state_ == 0) {
#line 92 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 336 "sw-backend.c"
			} else {
#line 92 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 340 "sw-backend.c"
			}
#line 92 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
			g_object_unref (_data_->_async_result);
#line 92 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
			return FALSE;
#line 346 "sw-backend.c"
		}
	}
#line 90 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	if (_data_->_state_ == 0) {
#line 90 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 353 "sw-backend.c"
	} else {
#line 90 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 357 "sw-backend.c"
	}
#line 90 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	g_object_unref (_data_->_async_result);
#line 90 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	return FALSE;
#line 363 "sw-backend.c"
}


static void folks_backends_sw_backend_real_unprepare_data_free (gpointer _data) {
	FolksBackendsSwBackendUnprepareData* _data_;
	_data_ = _data;
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_g_object_unref0 (_data_->self);
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	g_slice_free (FolksBackendsSwBackendUnprepareData, _data_);
#line 374 "sw-backend.c"
}


static void folks_backends_sw_backend_real_unprepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsSwBackend * self;
	FolksBackendsSwBackendUnprepareData* _data_;
	FolksBackendsSwBackend* _tmp0_;
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	self = (FolksBackendsSwBackend*) base;
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_data_ = g_slice_new0 (FolksBackendsSwBackendUnprepareData);
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_sw_backend_real_unprepare);
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_sw_backend_real_unprepare_data_free);
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_data_->self = _tmp0_;
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	folks_backends_sw_backend_real_unprepare_co (_data_);
#line 396 "sw-backend.c"
}


static void folks_backends_sw_backend_real_unprepare_finish (FolksBackend* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsSwBackendUnprepareData* _data_;
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		return;
#line 406 "sw-backend.c"
	}
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 410 "sw-backend.c"
}


/**
   * {@inheritDoc}
   */
static void _folks_backends_sw_backend_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self) {
#line 119 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	folks_backends_sw_backend_store_removed_cb (self, _sender);
#line 420 "sw-backend.c"
}


static gboolean folks_backends_sw_backend_real_unprepare_co (FolksBackendsSwBackendUnprepareData* _data_) {
#line 115 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	switch (_data_->_state_) {
#line 115 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		case 0:
#line 429 "sw-backend.c"
		goto _state_0;
		default:
#line 115 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		g_assert_not_reached ();
#line 434 "sw-backend.c"
	}
	_state_0:
	{
#line 117 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		_data_->_tmp0_ = _data_->self->priv->_persona_stores;
#line 117 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		_data_->_tmp1_ = gee_map_get_values ((GeeMap*) _data_->_tmp0_);
#line 117 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		_data_->_tmp2_ = _data_->_tmp1_;
#line 117 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		_data_->_tmp3_ = _data_->_tmp2_;
#line 117 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		_data_->_tmp4_ = NULL;
#line 117 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		_data_->_tmp4_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp3_);
#line 117 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		_data_->_tmp5_ = _data_->_tmp4_;
#line 117 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		_g_object_unref0 (_data_->_tmp3_);
#line 117 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		_data_->_store_it = _data_->_tmp5_;
#line 117 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		while (TRUE) {
#line 117 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
			_data_->_tmp6_ = _data_->_store_it;
#line 117 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
			_data_->_tmp7_ = FALSE;
#line 117 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
			_data_->_tmp7_ = gee_iterator_next (_data_->_tmp6_);
#line 117 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
			if (!_data_->_tmp7_) {
#line 117 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
				break;
#line 468 "sw-backend.c"
			}
#line 117 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
			_data_->_tmp8_ = _data_->_store_it;
#line 117 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
			_data_->_tmp9_ = NULL;
#line 117 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
			_data_->_tmp9_ = gee_iterator_get (_data_->_tmp8_);
#line 117 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
			_data_->store = (FolksPersonaStore*) _data_->_tmp9_;
#line 119 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
			_data_->_tmp10_ = _data_->store;
#line 119 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
			_data_->_tmp11_ = 0U;
#line 119 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
			g_signal_parse_name ("removed", FOLKS_TYPE_PERSONA_STORE, &_data_->_tmp11_, NULL, FALSE);
#line 119 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
			g_signal_handlers_disconnect_matched (_data_->_tmp10_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _data_->_tmp11_, 0, NULL, (GCallback) _folks_backends_sw_backend_store_removed_cb_folks_persona_store_removed, _data_->self);
#line 120 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
			_data_->_tmp12_ = _data_->store;
#line 120 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
			g_signal_emit_by_name ((FolksBackend*) _data_->self, "persona-store-removed", _data_->_tmp12_);
#line 117 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
			_g_object_unref0 (_data_->store);
#line 492 "sw-backend.c"
		}
#line 117 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		_g_object_unref0 (_data_->_store_it);
#line 496 "sw-backend.c"
	}
#line 123 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_g_object_unref0 (_data_->self->priv->_client);
#line 123 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_data_->self->priv->_client = NULL;
#line 125 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_data_->_tmp13_ = _data_->self->priv->_persona_stores;
#line 125 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	gee_abstract_map_clear ((GeeAbstractMap*) _data_->_tmp13_);
#line 126 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	g_object_notify ((GObject*) _data_->self, "persona-stores");
#line 128 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_data_->self->priv->_is_quiescent = FALSE;
#line 129 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	g_object_notify ((GObject*) _data_->self, "is-quiescent");
#line 131 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_data_->self->priv->_is_prepared = FALSE;
#line 132 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	g_object_notify ((GObject*) _data_->self, "is-prepared");
#line 115 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	if (_data_->_state_ == 0) {
#line 115 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 520 "sw-backend.c"
	} else {
#line 115 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 524 "sw-backend.c"
	}
#line 115 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	g_object_unref (_data_->_async_result);
#line 115 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	return FALSE;
#line 530 "sw-backend.c"
}


static void folks_backends_sw_backend_add_service (FolksBackendsSwBackend* self, const gchar* service_name) {
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_ = NULL;
	FolksPersonaStore* _tmp3_;
	gboolean _tmp4_;
	SwClient* _tmp5_;
	const gchar* _tmp6_;
	SwClientService* _tmp7_ = NULL;
	SwClientService* _tmp8_;
	SwfPersonaStore* _tmp9_;
	SwfPersonaStore* _tmp10_;
	SwfPersonaStore* store;
	GeeHashMap* _tmp11_;
	SwfPersonaStore* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	SwfPersonaStore* _tmp15_;
	SwfPersonaStore* _tmp16_;
	SwfPersonaStore* _tmp17_;
#line 135 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	g_return_if_fail (self != NULL);
#line 135 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	g_return_if_fail (service_name != NULL);
#line 137 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_tmp0_ = self->priv->_persona_stores;
#line 137 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_tmp1_ = service_name;
#line 137 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
#line 137 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_tmp3_ = (FolksPersonaStore*) _tmp2_;
#line 137 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_tmp4_ = _tmp3_ != NULL;
#line 137 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_g_object_unref0 (_tmp3_);
#line 137 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	if (_tmp4_) {
#line 138 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		return;
#line 574 "sw-backend.c"
	}
#line 140 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_tmp5_ = self->priv->_client;
#line 140 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_tmp6_ = service_name;
#line 140 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_tmp7_ = sw_client_get_service (_tmp5_, _tmp6_);
#line 140 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_tmp8_ = _tmp7_;
#line 140 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_tmp9_ = swf_persona_store_new (_tmp8_);
#line 140 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_tmp10_ = _tmp9_;
#line 140 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_g_object_unref0 (_tmp8_);
#line 140 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	store = _tmp10_;
#line 141 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_tmp11_ = self->priv->_persona_stores;
#line 141 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_tmp12_ = store;
#line 141 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_tmp13_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp12_);
#line 141 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_tmp14_ = _tmp13_;
#line 141 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_tmp15_ = store;
#line 141 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp11_, _tmp14_, (FolksPersonaStore*) _tmp15_);
#line 142 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_tmp16_ = store;
#line 142 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	g_signal_connect_object ((FolksPersonaStore*) _tmp16_, "removed", (GCallback) _folks_backends_sw_backend_store_removed_cb_folks_persona_store_removed, self, 0);
#line 143 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_tmp17_ = store;
#line 143 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-added", (FolksPersonaStore*) _tmp17_);
#line 135 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_g_object_unref0 (store);
#line 614 "sw-backend.c"
}


static void folks_backends_sw_backend_store_removed_cb (FolksBackendsSwBackend* self, FolksPersonaStore* store) {
	FolksPersonaStore* _tmp0_;
	GeeHashMap* _tmp1_;
	FolksPersonaStore* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
#line 146 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	g_return_if_fail (self != NULL);
#line 146 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	g_return_if_fail (store != NULL);
#line 148 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_tmp0_ = store;
#line 148 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-removed", _tmp0_);
#line 149 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_tmp1_ = self->priv->_persona_stores;
#line 149 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_tmp2_ = store;
#line 149 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_tmp3_ = folks_persona_store_get_id (_tmp2_);
#line 149 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_tmp4_ = _tmp3_;
#line 149 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp1_, _tmp4_, NULL);
#line 642 "sw-backend.c"
}


static const gchar* folks_backends_sw_backend_real_get_name (FolksBackend* base) {
	const gchar* result;
	FolksBackendsSwBackend* self;
#line 45 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	self = (FolksBackendsSwBackend*) base;
#line 45 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	result = BACKEND_NAME;
#line 45 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	return result;
#line 655 "sw-backend.c"
}


static GeeMap* folks_backends_sw_backend_real_get_persona_stores (FolksBackend* base) {
	GeeMap* result;
	FolksBackendsSwBackend* self;
	GeeMap* _tmp0_;
#line 52 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	self = (FolksBackendsSwBackend*) base;
#line 52 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_tmp0_ = self->priv->_persona_stores_ro;
#line 52 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	result = _tmp0_;
#line 52 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	return result;
#line 671 "sw-backend.c"
}


static gboolean folks_backends_sw_backend_real_get_is_prepared (FolksBackend* base) {
	gboolean result;
	FolksBackendsSwBackend* self;
	gboolean _tmp0_;
#line 72 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	self = (FolksBackendsSwBackend*) base;
#line 72 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_tmp0_ = self->priv->_is_prepared;
#line 72 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	result = _tmp0_;
#line 72 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	return result;
#line 687 "sw-backend.c"
}


static gboolean folks_backends_sw_backend_real_get_is_quiescent (FolksBackend* base) {
	gboolean result;
	FolksBackendsSwBackend* self;
	gboolean _tmp0_;
#line 84 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	self = (FolksBackendsSwBackend*) base;
#line 84 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_tmp0_ = self->priv->_is_quiescent;
#line 84 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	result = _tmp0_;
#line 84 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	return result;
#line 703 "sw-backend.c"
}


static void folks_backends_sw_backend_class_init (FolksBackendsSwBackendClass * klass) {
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	folks_backends_sw_backend_parent_class = g_type_class_peek_parent (klass);
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	g_type_class_add_private (klass, sizeof (FolksBackendsSwBackendPrivate));
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	FOLKS_BACKEND_CLASS (klass)->prepare = folks_backends_sw_backend_real_prepare;
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	FOLKS_BACKEND_CLASS (klass)->prepare_finish = folks_backends_sw_backend_real_prepare_finish;
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	FOLKS_BACKEND_CLASS (klass)->unprepare = folks_backends_sw_backend_real_unprepare;
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	FOLKS_BACKEND_CLASS (klass)->unprepare_finish = folks_backends_sw_backend_real_unprepare_finish;
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	FOLKS_BACKEND_CLASS (klass)->get_name = folks_backends_sw_backend_real_get_name;
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	FOLKS_BACKEND_CLASS (klass)->get_persona_stores = folks_backends_sw_backend_real_get_persona_stores;
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	FOLKS_BACKEND_CLASS (klass)->get_is_prepared = folks_backends_sw_backend_real_get_is_prepared;
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	FOLKS_BACKEND_CLASS (klass)->get_is_quiescent = folks_backends_sw_backend_real_get_is_quiescent;
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_backends_sw_backend_get_property;
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	G_OBJECT_CLASS (klass)->finalize = folks_backends_sw_backend_finalize;
#line 732 "sw-backend.c"
	/**
	   * {@inheritDoc}
	   */
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_SW_BACKEND_NAME, "name");
#line 738 "sw-backend.c"
	/**
	   * {@inheritDoc}
	   */
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_SW_BACKEND_PERSONA_STORES, "persona-stores");
#line 744 "sw-backend.c"
	/**
	   * Whether this Backend has been prepared.
	   *
	   * See {@link Folks.Backend.is_prepared}.
	   */
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_SW_BACKEND_IS_PREPARED, "is-prepared");
#line 752 "sw-backend.c"
	/**
	   * Whether this Backend has reached a quiescent state.
	   *
	   * See {@link Folks.Backend.is_quiescent}.
	   *
	   * @since 0.6.2
	   */
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_SW_BACKEND_IS_QUIESCENT, "is-quiescent");
#line 762 "sw-backend.c"
}


static void folks_backends_sw_backend_instance_init (FolksBackendsSwBackend * self) {
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	self->priv = FOLKS_BACKENDS_SW_BACKEND_GET_PRIVATE (self);
#line 36 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	g_static_rec_mutex_init (&self->priv->__lock__is_prepared);
#line 36 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	self->priv->_is_prepared = FALSE;
#line 37 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	self->priv->_is_quiescent = FALSE;
#line 775 "sw-backend.c"
}


static void folks_backends_sw_backend_finalize (GObject* obj) {
	FolksBackendsSwBackend * self;
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	self = FOLKS_BACKENDS_SW_BACKEND (obj);
#line 36 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	g_static_rec_mutex_free (&self->priv->__lock__is_prepared);
#line 38 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_g_object_unref0 (self->priv->_client);
#line 39 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_g_object_unref0 (self->priv->_persona_stores);
#line 40 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	_g_object_unref0 (self->priv->_persona_stores_ro);
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	G_OBJECT_CLASS (folks_backends_sw_backend_parent_class)->finalize (obj);
#line 793 "sw-backend.c"
}


/**
 * A backend which connects to libsocialweb and creates a {@link PersonaStore}
 * for each service.
 */
GType folks_backends_sw_backend_get_type (void) {
	static volatile gsize folks_backends_sw_backend_type_id__volatile = 0;
	if (g_once_init_enter (&folks_backends_sw_backend_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksBackendsSwBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backends_sw_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackendsSwBackend), 0, (GInstanceInitFunc) folks_backends_sw_backend_instance_init, NULL };
		GType folks_backends_sw_backend_type_id;
		folks_backends_sw_backend_type_id = g_type_register_static (FOLKS_TYPE_BACKEND, "FolksBackendsSwBackend", &g_define_type_info, 0);
		g_once_init_leave (&folks_backends_sw_backend_type_id__volatile, folks_backends_sw_backend_type_id);
	}
	return folks_backends_sw_backend_type_id__volatile;
}


static void _vala_folks_backends_sw_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksBackendsSwBackend * self;
	self = FOLKS_BACKENDS_SW_BACKEND (object);
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
	switch (property_id) {
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		case FOLKS_BACKENDS_SW_BACKEND_NAME:
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		g_value_set_string (value, folks_backend_get_name ((FolksBackend*) self));
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		break;
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		case FOLKS_BACKENDS_SW_BACKEND_PERSONA_STORES:
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		g_value_set_object (value, folks_backend_get_persona_stores ((FolksBackend*) self));
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		break;
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		case FOLKS_BACKENDS_SW_BACKEND_IS_PREPARED:
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		g_value_set_boolean (value, folks_backend_get_is_prepared ((FolksBackend*) self));
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		break;
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		case FOLKS_BACKENDS_SW_BACKEND_IS_QUIESCENT:
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		g_value_set_boolean (value, folks_backend_get_is_quiescent ((FolksBackend*) self));
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		break;
#line 842 "sw-backend.c"
		default:
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 34 "/opt/gnome2/source/folks/backends/libsocialweb/sw-backend.vala"
		break;
#line 848 "sw-backend.c"
	}
}



