/* aggregation.c generated by valac 0.13.3, the Vala compiler
 * generated from aggregation.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Alban Crequy <alban.crequy@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <folks-test.h>
#include <libsocialweb-test.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <folks/folks.h>
#include <gee.h>


#define TYPE_AGGREGATION_TESTS (aggregation_tests_get_type ())
#define AGGREGATION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AGGREGATION_TESTS, AggregationTests))
#define AGGREGATION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AGGREGATION_TESTS, AggregationTestsClass))
#define IS_AGGREGATION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AGGREGATION_TESTS))
#define IS_AGGREGATION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AGGREGATION_TESTS))
#define AGGREGATION_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AGGREGATION_TESTS, AggregationTestsClass))

typedef struct _AggregationTests AggregationTests;
typedef struct _AggregationTestsClass AggregationTestsClass;
typedef struct _AggregationTestsPrivate AggregationTestsPrivate;
#define _libsocialweb_test_backend_unref0(var) ((var == NULL) ? NULL : (var = (libsocialweb_test_backend_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

struct _AggregationTests {
	FolksTestCase parent_instance;
	AggregationTestsPrivate * priv;
};

struct _AggregationTestsClass {
	FolksTestCaseClass parent_class;
};

struct _AggregationTestsPrivate {
	LibsocialwebTestBackend* _lsw_backend;
};

struct _Block1Data {
	int _ref_count_;
	AggregationTests * self;
	GMainLoop* main_loop;
	LibsocialwebTestLibsocialwebServiceTest* mysocialnetwork1;
	LibsocialwebTestLibsocialwebServiceTest* mysocialnetwork2;
	FolksIndividualAggregator* aggregator;
	FolksIndividual** individual_gathered;
	gint individual_gathered_length1;
	gint _individual_gathered_size_;
	GeeHashSet* personas;
};

struct _Block2Data {
	int _ref_count_;
	AggregationTests * self;
	gchar* path;
};

struct _Block3Data {
	int _ref_count_;
	AggregationTests * self;
	gchar* path;
};


static gpointer aggregation_tests_parent_class = NULL;

GType aggregation_tests_get_type (void) G_GNUC_CONST;
#define AGGREGATION_TESTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_AGGREGATION_TESTS, AggregationTestsPrivate))
enum  {
	AGGREGATION_TESTS_DUMMY_PROPERTY
};
#define AGGREGATION_TESTS_STORE_FILE_PATH "folks-test-libsocialweb-aggregation-store.ini"
#define AGGREGATION_TESTS_KF_RELATIONSHIPS_FILE_PATH "folks-test-libsocialweb-aggregation-relationships.ini"
AggregationTests* aggregation_tests_new (void);
AggregationTests* aggregation_tests_construct (GType object_type);
void aggregation_tests_test_aggregation_libsocialweb (AggregationTests* self);
static void _aggregation_tests_test_aggregation_libsocialweb_folks_test_case_test_method (gpointer self);
static void aggregation_tests_real_set_up (FolksTestCase* base);
static void aggregation_tests_real_tear_down (FolksTestCase* base);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void __lambda0_ (Block1Data* _data1_);
static void ___lambda0__libsocialweb_test_backend_ready (LibsocialwebTestBackend* _sender, gpointer self);
static gboolean __lambda1_ (AggregationTests* self);
static gboolean ___lambda1__gsource_func (gpointer self);
static void __lambda2_ (Block1Data* _data1_, const gchar* query, GHashTable* p, const gchar* path);
static void __lambda3_ (AggregationTests* self, const gchar* path);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static gboolean __lambda4_ (Block2Data* _data2_);
static gboolean ___lambda4__gsource_func (gpointer self);
static void ___lambda3__libsocialweb_test_libsocialweb_contact_view_test_start_called (LibsocialwebTestLibsocialwebContactViewTest* _sender, const gchar* path, gpointer self);
static void ___lambda2__libsocialweb_test_libsocialweb_service_test_open_view_called (LibsocialwebTestLibsocialwebServiceTest* _sender, const gchar* query, GHashTable* p, const gchar* path, gpointer self);
static void __lambda5_ (Block1Data* _data1_, const gchar* query, GHashTable* p, const gchar* path);
static void __lambda6_ (AggregationTests* self, const gchar* path);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static gboolean __lambda7_ (Block3Data* _data3_);
static gboolean ___lambda7__gsource_func (gpointer self);
static void ___lambda6__libsocialweb_test_libsocialweb_contact_view_test_start_called (LibsocialwebTestLibsocialwebContactViewTest* _sender, const gchar* path, gpointer self);
static void ___lambda5__libsocialweb_test_libsocialweb_service_test_open_view_called (LibsocialwebTestLibsocialwebServiceTest* _sender, const gchar* query, GHashTable* p, const gchar* path, gpointer self);
static void __lambda8_ (Block1Data* _data1_, GeeSet* added, GeeSet* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r);
static void _vala_array_add1 (FolksIndividual*** array, int* length, int* size, FolksIndividual* value);
static void ___lambda8__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static gboolean __lambda9_ (AggregationTests* self);
static gboolean ___lambda9__gsource_func (gpointer self);
static void __lambda10_ (Block1Data* _data1_, GeeSet* added, GeeSet* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r);
static void ___lambda10__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static gboolean __lambda11_ (Block1Data* _data1_);
static gboolean ___lambda11__gsource_func (gpointer self);
static gboolean __lambda12_ (AggregationTests* self);
static gboolean ___lambda12__gsource_func (gpointer self);
static void aggregation_tests_finalize (GObject* obj);
gint _vala_main (gchar** args, int args_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _aggregation_tests_test_aggregation_libsocialweb_folks_test_case_test_method (gpointer self) {
#line 40 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	aggregation_tests_test_aggregation_libsocialweb (self);
#line 155 "aggregation.c"
}


AggregationTests* aggregation_tests_construct (GType object_type) {
	AggregationTests * self = NULL;
	LibsocialwebTestBackend* _tmp0_;
#line 36 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	self = (AggregationTests*) folks_test_case_construct (object_type, "Aggregation");
#line 38 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp0_ = libsocialweb_test_backend_new ();
#line 38 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_libsocialweb_test_backend_unref0 (self->priv->_lsw_backend);
#line 38 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	self->priv->_lsw_backend = _tmp0_;
#line 40 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	folks_test_case_add_test ((FolksTestCase*) self, "libsocialweb aggregation", _aggregation_tests_test_aggregation_libsocialweb_folks_test_case_test_method, self);
#line 34 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	return self;
#line 174 "aggregation.c"
}


AggregationTests* aggregation_tests_new (void) {
#line 34 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	return aggregation_tests_construct (TYPE_AGGREGATION_TESTS);
#line 181 "aggregation.c"
}


static void aggregation_tests_real_set_up (FolksTestCase* base) {
	AggregationTests * self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* kf_relationships_path;
	gchar* _tmp2_;
	gchar* kf_relationships_data;
	GFile* _tmp3_ = NULL;
	GFile* kf_relationships_f;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* kf_path;
	GKeyFile* _tmp9_;
	GKeyFile* kf;
	GError * _inner_error_ = NULL;
#line 43 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	self = (AggregationTests*) base;
#line 46 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp0_ = g_get_tmp_dir ();
#line 46 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp1_ = g_build_filename (_tmp0_, AGGREGATION_TESTS_KF_RELATIONSHIPS_FILE_PATH, NULL, NULL);
#line 46 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	kf_relationships_path = _tmp1_;
#line 49 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_setenv ("FOLKS_BACKEND_KEY_FILE_PATH", kf_relationships_path, TRUE);
#line 51 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp2_ = g_strdup ("#\n");
#line 51 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	kf_relationships_data = _tmp2_;
#line 52 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp3_ = g_file_new_for_path (kf_relationships_path);
#line 52 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	kf_relationships_f = _tmp3_;
#line 218 "aggregation.c"
	{
		gint _tmp4_;
		gint _tmp5_;
#line 55 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp4_ = strlen (kf_relationships_data);
#line 55 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp5_ = _tmp4_;
#line 55 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		g_file_replace_contents (kf_relationships_f, kf_relationships_data, (gsize) _tmp5_, NULL, FALSE, G_FILE_CREATE_PRIVATE, NULL, NULL, &_inner_error_);
#line 55 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		if (_inner_error_ != NULL) {
#line 230 "aggregation.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp6_;
#line 53 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		e = _inner_error_;
#line 53 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_inner_error_ = NULL;
#line 61 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp6_ = e->message;
#line 61 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		g_error ("aggregation.vala:61: Could not write relationship file '%s': %s", kf_relationships_path, _tmp6_);
#line 53 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_g_error_free0 (e);
#line 249 "aggregation.c"
	}
	__finally0:
#line 53 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	if (_inner_error_ != NULL) {
#line 53 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_g_object_unref0 (kf_relationships_f);
#line 53 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_g_free0 (kf_relationships_data);
#line 53 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_g_free0 (kf_relationships_path);
#line 53 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 53 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		g_clear_error (&_inner_error_);
#line 53 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		return;
#line 266 "aggregation.c"
	}
#line 66 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp7_ = g_get_tmp_dir ();
#line 66 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp8_ = g_build_filename (_tmp7_, AGGREGATION_TESTS_STORE_FILE_PATH, NULL, NULL);
#line 66 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	kf_path = _tmp8_;
#line 69 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_remove (kf_path);
#line 71 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp9_ = g_key_file_new ();
#line 71 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	kf = _tmp9_;
#line 72 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_key_file_set_boolean (kf, "all-others", "enabled", FALSE);
#line 73 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_key_file_set_boolean (kf, "libsocialweb", "enabled", TRUE);
#line 74 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_key_file_set_boolean (kf, "key-file", "enabled", TRUE);
#line 286 "aggregation.c"
	{
		GFile* _tmp10_ = NULL;
		GFile* backend_f;
		gchar* _tmp11_ = NULL;
		gchar* data;
		gint _tmp12_;
		gint _tmp13_;
#line 78 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp10_ = g_file_new_for_path (kf_path);
#line 78 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		backend_f = _tmp10_;
#line 79 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp11_ = g_key_file_to_data (kf, NULL, NULL);
#line 79 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		data = _tmp11_;
#line 80 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp12_ = strlen (data);
#line 80 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp13_ = _tmp12_;
#line 80 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		g_file_replace_contents (backend_f, data, (gsize) _tmp13_, NULL, FALSE, G_FILE_CREATE_PRIVATE, NULL, NULL, &_inner_error_);
#line 80 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		if (_inner_error_ != NULL) {
#line 80 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_g_free0 (data);
#line 80 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_g_object_unref0 (backend_f);
#line 314 "aggregation.c"
			goto __catch1_g_error;
		}
#line 76 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_g_free0 (data);
#line 76 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_g_object_unref0 (backend_f);
#line 321 "aggregation.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp14_;
#line 76 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		e = _inner_error_;
#line 76 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_inner_error_ = NULL;
#line 86 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp14_ = e->message;
#line 86 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		g_error ("aggregation.vala:86: Could not write updated backend key file '%s': %s", kf_path, _tmp14_);
#line 76 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_g_error_free0 (e);
#line 338 "aggregation.c"
	}
	__finally1:
#line 76 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	if (_inner_error_ != NULL) {
#line 76 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_g_key_file_free0 (kf);
#line 76 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_g_free0 (kf_path);
#line 76 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_g_object_unref0 (kf_relationships_f);
#line 76 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_g_free0 (kf_relationships_data);
#line 76 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_g_free0 (kf_relationships_path);
#line 76 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 76 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		g_clear_error (&_inner_error_);
#line 76 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		return;
#line 359 "aggregation.c"
	}
#line 90 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_setenv ("FOLKS_BACKEND_STORE_KEY_FILE_PATH", kf_path, TRUE);
#line 43 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_g_key_file_free0 (kf);
#line 43 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_g_free0 (kf_path);
#line 43 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_g_object_unref0 (kf_relationships_f);
#line 43 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_g_free0 (kf_relationships_data);
#line 43 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_g_free0 (kf_relationships_path);
#line 373 "aggregation.c"
}


static void aggregation_tests_real_tear_down (FolksTestCase* base) {
	AggregationTests * self;
#line 94 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	self = (AggregationTests*) base;
#line 381 "aggregation.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 98 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 98 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	return _data1_;
#line 390 "aggregation.c"
}


static void block1_data_unref (Block1Data* _data1_) {
#line 98 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 98 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_g_object_unref0 (_data1_->self);
#line 98 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_g_object_unref0 (_data1_->personas);
#line 98 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_data1_->individual_gathered = (_vala_array_free (_data1_->individual_gathered, _data1_->individual_gathered_length1, (GDestroyNotify) g_object_unref), NULL);
#line 98 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_g_object_unref0 (_data1_->aggregator);
#line 98 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_g_object_unref0 (_data1_->mysocialnetwork2);
#line 98 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_g_object_unref0 (_data1_->mysocialnetwork1);
#line 98 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_g_main_loop_unref0 (_data1_->main_loop);
#line 98 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		g_slice_free (Block1Data, _data1_);
#line 413 "aggregation.c"
	}
}


static void __lambda0_ (Block1Data* _data1_) {
	AggregationTests * self;
	GMainLoop* _tmp0_;
#line 102 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	self = _data1_->self;
#line 104 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp0_ = _data1_->main_loop;
#line 104 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_main_loop_quit (_tmp0_);
#line 427 "aggregation.c"
}


static void ___lambda0__libsocialweb_test_backend_ready (LibsocialwebTestBackend* _sender, gpointer self) {
#line 102 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	__lambda0_ (self);
#line 434 "aggregation.c"
}


static gboolean __lambda1_ (AggregationTests* self) {
	gboolean result = FALSE;
#line 108 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_assert_not_reached ();
#line 106 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	return result;
#line 444 "aggregation.c"
}


static gboolean ___lambda1__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda1_ (self);
#line 106 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	return result;
#line 453 "aggregation.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 120 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 120 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	return _data2_;
#line 462 "aggregation.c"
}


static void block2_data_unref (Block2Data* _data2_) {
#line 120 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 120 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_g_object_unref0 (_data2_->self);
#line 120 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_g_free0 (_data2_->path);
#line 120 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		g_slice_free (Block2Data, _data2_);
#line 475 "aggregation.c"
	}
}


static gboolean __lambda4_ (Block2Data* _data2_) {
	AggregationTests * self;
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* text;
	const gchar* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* v;
	GError * _inner_error_ = NULL;
#line 122 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	self = _data2_->self;
#line 124 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp0_ = g_strdup ("([('mysocialnetwork1', 'garg', %x, " "{'id': ['garg'], 'name': ['Gargantua']})],)");
#line 124 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	text = _tmp0_;
#line 126 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp1_ = text;
#line 126 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp2_ = g_variant_new_parsed (_tmp1_, 1300792578, NULL);
#line 126 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp3_ = g_variant_ref_sink (_tmp2_);
#line 126 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	v = _tmp3_;
#line 504 "aggregation.c"
	{
		GDBusConnection* _tmp4_ = NULL;
		GDBusConnection* conn;
		GDBusConnection* _tmp5_;
		const gchar* _tmp6_;
		GVariant* _tmp7_;
#line 129 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp4_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
#line 129 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		conn = _tmp4_;
#line 129 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		if (_inner_error_ != NULL) {
#line 129 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 519 "aggregation.c"
				goto __catch2_g_io_error;
			}
			goto __catch2_g_error;
		}
#line 130 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp5_ = conn;
#line 130 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp6_ = _data2_->path;
#line 130 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp7_ = v;
#line 130 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		g_dbus_connection_emit_signal (_tmp5_, NULL, _tmp6_, "com.meego.libsocialweb.ContactView", "ContactsAdded", _tmp7_, &_inner_error_);
#line 130 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		if (_inner_error_ != NULL) {
#line 130 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_g_object_unref0 (conn);
#line 130 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 538 "aggregation.c"
				goto __catch2_g_io_error;
			}
			goto __catch2_g_error;
		}
#line 127 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_g_object_unref0 (conn);
#line 545 "aggregation.c"
	}
	goto __finally2;
	__catch2_g_io_error:
	{
		GError* e = NULL;
#line 127 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		e = _inner_error_;
#line 127 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_inner_error_ = NULL;
#line 136 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		g_assert_not_reached ();
#line 127 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_g_error_free0 (e);
#line 559 "aggregation.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
#line 127 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		e = _inner_error_;
#line 127 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_inner_error_ = NULL;
#line 140 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		g_assert_not_reached ();
#line 127 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_g_error_free0 (e);
#line 573 "aggregation.c"
	}
	__finally2:
#line 127 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	if (_inner_error_ != NULL) {
#line 127 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_g_variant_unref0 (v);
#line 127 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_g_free0 (text);
#line 127 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 127 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		g_clear_error (&_inner_error_);
#line 127 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		return FALSE;
#line 588 "aggregation.c"
	}
#line 142 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	result = FALSE;
#line 142 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_g_variant_unref0 (v);
#line 142 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_g_free0 (text);
#line 142 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	return result;
#line 598 "aggregation.c"
}


static gboolean ___lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda4_ (self);
#line 122 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	return result;
#line 607 "aggregation.c"
}


static void __lambda3_ (AggregationTests* self, const gchar* path) {
	Block2Data* _data2_;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
#line 120 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_return_if_fail (path != NULL);
#line 120 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 120 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_data2_->_ref_count_ = 1;
#line 120 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_data2_->self = g_object_ref (self);
#line 120 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp0_ = path;
#line 120 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 120 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_data2_->path = _tmp1_;
#line 122 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda4__gsource_func, block2_data_ref (_data2_), block2_data_unref);
#line 120 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	block2_data_unref (_data2_);
#line 120 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_data2_ = NULL;
#line 635 "aggregation.c"
}


static void ___lambda3__libsocialweb_test_libsocialweb_contact_view_test_start_called (LibsocialwebTestLibsocialwebContactViewTest* _sender, const gchar* path, gpointer self) {
#line 120 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	__lambda3_ (self, path);
#line 642 "aggregation.c"
}


static void __lambda2_ (Block1Data* _data1_, const gchar* query, GHashTable* p, const gchar* path) {
	AggregationTests * self;
	LibsocialwebTestLibsocialwebServiceTest* _tmp0_;
	GeeHashMap* _tmp1_;
	const gchar* _tmp2_;
	gpointer _tmp3_ = NULL;
	LibsocialwebTestLibsocialwebContactViewTest* _tmp4_;
#line 118 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	self = _data1_->self;
#line 118 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_return_if_fail (query != NULL);
#line 118 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_return_if_fail (p != NULL);
#line 118 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_return_if_fail (path != NULL);
#line 120 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp0_ = _data1_->mysocialnetwork1;
#line 120 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp1_ = _tmp0_->contact_views;
#line 120 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp2_ = path;
#line 120 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, _tmp2_);
#line 120 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp4_ = (LibsocialwebTestLibsocialwebContactViewTest*) _tmp3_;
#line 120 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_signal_connect_object (_tmp4_, "start-called", (GCallback) ___lambda3__libsocialweb_test_libsocialweb_contact_view_test_start_called, self, 0);
#line 120 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_g_object_unref0 (_tmp4_);
#line 675 "aggregation.c"
}


static void ___lambda2__libsocialweb_test_libsocialweb_service_test_open_view_called (LibsocialwebTestLibsocialwebServiceTest* _sender, const gchar* query, GHashTable* p, const gchar* path, gpointer self) {
#line 118 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	__lambda2_ (self, query, p, path);
#line 682 "aggregation.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 150 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 150 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	return _data3_;
#line 691 "aggregation.c"
}


static void block3_data_unref (Block3Data* _data3_) {
#line 150 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 150 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_g_object_unref0 (_data3_->self);
#line 150 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_g_free0 (_data3_->path);
#line 150 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		g_slice_free (Block3Data, _data3_);
#line 704 "aggregation.c"
	}
}


static gboolean __lambda7_ (Block3Data* _data3_) {
	AggregationTests * self;
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* text;
	const gchar* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* v;
	GError * _inner_error_ = NULL;
#line 152 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	self = _data3_->self;
#line 154 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp0_ = g_strdup ("([('mysocialnetwork2', 'panta', %x, " "{'id': ['panta'], 'name': ['Pantagruel']})],)");
#line 154 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	text = _tmp0_;
#line 156 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp1_ = text;
#line 156 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp2_ = g_variant_new_parsed (_tmp1_, 1300792579, NULL);
#line 156 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp3_ = g_variant_ref_sink (_tmp2_);
#line 156 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	v = _tmp3_;
#line 733 "aggregation.c"
	{
		GDBusConnection* _tmp4_ = NULL;
		GDBusConnection* conn;
		GDBusConnection* _tmp5_;
		const gchar* _tmp6_;
		GVariant* _tmp7_;
#line 159 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp4_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
#line 159 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		conn = _tmp4_;
#line 159 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		if (_inner_error_ != NULL) {
#line 159 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 748 "aggregation.c"
				goto __catch3_g_io_error;
			}
			goto __catch3_g_error;
		}
#line 160 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp5_ = conn;
#line 160 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp6_ = _data3_->path;
#line 160 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp7_ = v;
#line 160 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		g_dbus_connection_emit_signal (_tmp5_, NULL, _tmp6_, "com.meego.libsocialweb.ContactView", "ContactsAdded", _tmp7_, &_inner_error_);
#line 160 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		if (_inner_error_ != NULL) {
#line 160 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_g_object_unref0 (conn);
#line 160 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 767 "aggregation.c"
				goto __catch3_g_io_error;
			}
			goto __catch3_g_error;
		}
#line 157 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_g_object_unref0 (conn);
#line 774 "aggregation.c"
	}
	goto __finally3;
	__catch3_g_io_error:
	{
		GError* e = NULL;
#line 157 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		e = _inner_error_;
#line 157 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_inner_error_ = NULL;
#line 166 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		g_assert_not_reached ();
#line 157 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_g_error_free0 (e);
#line 788 "aggregation.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
#line 157 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		e = _inner_error_;
#line 157 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_inner_error_ = NULL;
#line 170 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		g_assert_not_reached ();
#line 157 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_g_error_free0 (e);
#line 802 "aggregation.c"
	}
	__finally3:
#line 157 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	if (_inner_error_ != NULL) {
#line 157 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_g_variant_unref0 (v);
#line 157 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_g_free0 (text);
#line 157 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 157 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		g_clear_error (&_inner_error_);
#line 157 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		return FALSE;
#line 817 "aggregation.c"
	}
#line 172 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	result = FALSE;
#line 172 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_g_variant_unref0 (v);
#line 172 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_g_free0 (text);
#line 172 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	return result;
#line 827 "aggregation.c"
}


static gboolean ___lambda7__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda7_ (self);
#line 152 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	return result;
#line 836 "aggregation.c"
}


static void __lambda6_ (AggregationTests* self, const gchar* path) {
	Block3Data* _data3_;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
#line 150 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_return_if_fail (path != NULL);
#line 150 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 150 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_data3_->_ref_count_ = 1;
#line 150 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_data3_->self = g_object_ref (self);
#line 150 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp0_ = path;
#line 150 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 150 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_data3_->path = _tmp1_;
#line 152 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda7__gsource_func, block3_data_ref (_data3_), block3_data_unref);
#line 150 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	block3_data_unref (_data3_);
#line 150 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_data3_ = NULL;
#line 864 "aggregation.c"
}


static void ___lambda6__libsocialweb_test_libsocialweb_contact_view_test_start_called (LibsocialwebTestLibsocialwebContactViewTest* _sender, const gchar* path, gpointer self) {
#line 150 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	__lambda6_ (self, path);
#line 871 "aggregation.c"
}


static void __lambda5_ (Block1Data* _data1_, const gchar* query, GHashTable* p, const gchar* path) {
	AggregationTests * self;
	LibsocialwebTestLibsocialwebServiceTest* _tmp0_;
	GeeHashMap* _tmp1_;
	const gchar* _tmp2_;
	gpointer _tmp3_ = NULL;
	LibsocialwebTestLibsocialwebContactViewTest* _tmp4_;
#line 148 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	self = _data1_->self;
#line 148 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_return_if_fail (query != NULL);
#line 148 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_return_if_fail (p != NULL);
#line 148 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_return_if_fail (path != NULL);
#line 150 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp0_ = _data1_->mysocialnetwork2;
#line 150 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp1_ = _tmp0_->contact_views;
#line 150 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp2_ = path;
#line 150 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, _tmp2_);
#line 150 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp4_ = (LibsocialwebTestLibsocialwebContactViewTest*) _tmp3_;
#line 150 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_signal_connect_object (_tmp4_, "start-called", (GCallback) ___lambda6__libsocialweb_test_libsocialweb_contact_view_test_start_called, self, 0);
#line 150 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_g_object_unref0 (_tmp4_);
#line 904 "aggregation.c"
}


static void ___lambda5__libsocialweb_test_libsocialweb_service_test_open_view_called (LibsocialwebTestLibsocialwebServiceTest* _sender, const gchar* query, GHashTable* p, const gchar* path, gpointer self) {
#line 148 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	__lambda5_ (self, query, p, path);
#line 911 "aggregation.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 183 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	return self ? g_object_ref (self) : NULL;
#line 918 "aggregation.c"
}


static void _vala_array_add1 (FolksIndividual*** array, int* length, int* size, FolksIndividual* value) {
#line 183 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	if ((*length) == (*size)) {
#line 183 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 183 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		*array = g_renew (FolksIndividual*, *array, (*size) + 1);
#line 929 "aggregation.c"
	}
#line 183 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	(*array)[(*length)++] = value;
#line 183 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	(*array)[*length] = NULL;
#line 935 "aggregation.c"
}


static void __lambda8_ (Block1Data* _data1_, GeeSet* added, GeeSet* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r) {
	AggregationTests * self;
	FolksIndividual** _tmp9_;
	gint _tmp9__length1;
#line 179 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	self = _data1_->self;
#line 179 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_return_if_fail (added != NULL);
#line 179 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_return_if_fail (removed != NULL);
#line 181 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_debug ("aggregation.vala:181: initial individuals_changed");
#line 951 "aggregation.c"
	{
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _i_it;
#line 182 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp0_ = added;
#line 182 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
#line 182 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_i_it = _tmp1_;
#line 182 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		while (TRUE) {
#line 964 "aggregation.c"
			GeeIterator* _tmp2_;
			gboolean _tmp3_ = FALSE;
			GeeIterator* _tmp4_;
			gpointer _tmp5_ = NULL;
			FolksIndividual* i;
			FolksIndividual** _tmp6_;
			gint _tmp6__length1;
			FolksIndividual* _tmp7_;
			FolksIndividual* _tmp8_;
#line 182 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp2_ = _i_it;
#line 182 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp3_ = gee_iterator_next (_tmp2_);
#line 182 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			if (!_tmp3_) {
#line 182 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
				break;
#line 982 "aggregation.c"
			}
#line 182 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp4_ = _i_it;
#line 182 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 182 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			i = (FolksIndividual*) _tmp5_;
#line 183 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp6_ = _data1_->individual_gathered;
#line 183 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp6__length1 = _data1_->individual_gathered_length1;
#line 183 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp7_ = i;
#line 183 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp8_ = _g_object_ref0 (_tmp7_);
#line 183 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_vala_array_add1 (&_data1_->individual_gathered, &_data1_->individual_gathered_length1, &_data1_->_individual_gathered_size_, _tmp8_);
#line 182 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_g_object_unref0 (i);
#line 1002 "aggregation.c"
		}
#line 182 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_g_object_unref0 (_i_it);
#line 1006 "aggregation.c"
	}
#line 184 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp9_ = _data1_->individual_gathered;
#line 184 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp9__length1 = _data1_->individual_gathered_length1;
#line 184 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	if (_tmp9__length1 >= 2) {
#line 1014 "aggregation.c"
		GMainLoop* _tmp10_;
#line 185 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp10_ = _data1_->main_loop;
#line 185 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		g_main_loop_quit (_tmp10_);
#line 1020 "aggregation.c"
	}
}


static void ___lambda8__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
#line 179 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	__lambda8_ (self, added, removed, message, actor, reason);
#line 1028 "aggregation.c"
}


static gboolean __lambda9_ (AggregationTests* self) {
	gboolean result = FALSE;
#line 191 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_assert_not_reached ();
#line 189 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	return result;
#line 1038 "aggregation.c"
}


static gboolean ___lambda9__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda9_ (self);
#line 189 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	return result;
#line 1047 "aggregation.c"
}


static void __lambda10_ (Block1Data* _data1_, GeeSet* added, GeeSet* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r) {
	AggregationTests * self;
	GeeSet* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeSet* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GeeSet* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GeeSet* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GMainLoop* _tmp28_;
#line 207 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	self = _data1_->self;
#line 207 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_return_if_fail (added != NULL);
#line 207 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_return_if_fail (removed != NULL);
#line 209 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp0_ = added;
#line 209 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
#line 209 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp2_ = _tmp1_;
#line 209 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp3_ = removed;
#line 209 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
#line 209 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp5_ = _tmp4_;
#line 209 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_debug ("aggregation.vala:209: individuals_changed after link: added:%u removed" \
":%u", (guint) _tmp2_, (guint) _tmp5_);
#line 211 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp6_ = added;
#line 211 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
#line 211 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp8_ = _tmp7_;
#line 211 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_assert (_tmp8_ == 1);
#line 212 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp9_ = removed;
#line 212 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp10_ = gee_collection_get_size ((GeeCollection*) _tmp9_);
#line 212 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp11_ = _tmp10_;
#line 212 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_assert (_tmp11_ == 2);
#line 1102 "aggregation.c"
	{
		GeeSet* _tmp12_;
		GeeIterator* _tmp13_ = NULL;
		GeeIterator* _i_it;
#line 214 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp12_ = added;
#line 214 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp13_ = gee_iterable_iterator ((GeeIterable*) _tmp12_);
#line 214 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_i_it = _tmp13_;
#line 214 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		while (TRUE) {
#line 1115 "aggregation.c"
			GeeIterator* _tmp14_;
			gboolean _tmp15_ = FALSE;
			GeeIterator* _tmp16_;
			gpointer _tmp17_ = NULL;
			FolksIndividual* i;
			FolksIndividual* _tmp18_;
			GeeSet* _tmp19_;
			GeeSet* _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			FolksIndividual* _tmp23_;
			GeeSet* _tmp24_;
			GeeSet* _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
#line 214 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp14_ = _i_it;
#line 214 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp15_ = gee_iterator_next (_tmp14_);
#line 214 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			if (!_tmp15_) {
#line 214 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
				break;
#line 1139 "aggregation.c"
			}
#line 214 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp16_ = _i_it;
#line 214 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp17_ = gee_iterator_get (_tmp16_);
#line 214 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			i = (FolksIndividual*) _tmp17_;
#line 216 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp18_ = i;
#line 216 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp19_ = folks_individual_get_personas (_tmp18_);
#line 216 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp20_ = _tmp19_;
#line 216 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp21_ = gee_collection_get_size ((GeeCollection*) _tmp20_);
#line 216 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp22_ = _tmp21_;
#line 216 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			g_assert (_tmp22_ == 3);
#line 217 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp23_ = i;
#line 217 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp24_ = folks_individual_get_personas (_tmp23_);
#line 217 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp25_ = _tmp24_;
#line 217 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp26_ = gee_collection_get_size ((GeeCollection*) _tmp25_);
#line 217 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp27_ = _tmp26_;
#line 217 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			g_debug ("aggregation.vala:217: individuals_changed: 1 individual containing %u " \
"personas", (guint) _tmp27_);
#line 214 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_g_object_unref0 (i);
#line 1173 "aggregation.c"
		}
#line 214 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_g_object_unref0 (_i_it);
#line 1177 "aggregation.c"
	}
#line 221 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp28_ = _data1_->main_loop;
#line 221 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_main_loop_quit (_tmp28_);
#line 1183 "aggregation.c"
}


static void ___lambda10__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
#line 207 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	__lambda10_ (self, added, removed, message, actor, reason);
#line 1190 "aggregation.c"
}


static gboolean __lambda11_ (Block1Data* _data1_) {
	AggregationTests * self;
	gboolean result = FALSE;
	FolksIndividualAggregator* _tmp0_;
	GeeHashSet* _tmp1_;
#line 243 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	self = _data1_->self;
#line 245 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp0_ = _data1_->aggregator;
#line 245 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp1_ = _data1_->personas;
#line 245 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	folks_individual_aggregator_link_personas (_tmp0_, (GeeSet*) _tmp1_, NULL, NULL);
#line 246 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	result = FALSE;
#line 246 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	return result;
#line 1211 "aggregation.c"
}


static gboolean ___lambda11__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda11_ (self);
#line 243 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	return result;
#line 1220 "aggregation.c"
}


static gboolean __lambda12_ (AggregationTests* self) {
	gboolean result = FALSE;
#line 251 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_assert_not_reached ();
#line 249 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	return result;
#line 1230 "aggregation.c"
}


static gboolean ___lambda12__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda12_ (self);
#line 249 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	return result;
#line 1239 "aggregation.c"
}


void aggregation_tests_test_aggregation_libsocialweb (AggregationTests* self) {
	Block1Data* _data1_;
	GMainLoop* _tmp0_;
	LibsocialwebTestBackend* _tmp1_;
	guint _tmp2_ = 0U;
	guint timer_id;
	LibsocialwebTestBackend* _tmp3_;
	GMainLoop* _tmp4_;
	guint _tmp5_;
	LibsocialwebTestBackend* _tmp6_;
	LibsocialwebTestLibsocialwebServiceTest* _tmp7_ = NULL;
	LibsocialwebTestBackend* _tmp8_;
	LibsocialwebTestLibsocialwebServiceTest* _tmp9_ = NULL;
	LibsocialwebTestLibsocialwebServiceTest* _tmp10_;
	LibsocialwebTestLibsocialwebServiceTest* _tmp11_;
	FolksIndividualAggregator* _tmp12_;
	FolksIndividual** _tmp13_ = NULL;
	FolksIndividualAggregator* _tmp14_;
	gulong _tmp15_ = 0UL;
	gulong handler_id;
	FolksIndividualAggregator* _tmp16_;
	guint _tmp17_ = 0U;
	GMainLoop* _tmp18_;
	guint _tmp19_;
	FolksIndividualAggregator* _tmp20_;
	gulong _tmp21_;
	FolksIndividual** _tmp22_;
	gint _tmp22__length1;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	FolksIndividual** _tmp25_;
	gint _tmp25__length1;
	FolksIndividual* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	gboolean _tmp33_;
	gboolean _tmp44_;
	FolksIndividualAggregator* _tmp45_;
	GeeHashSet* _tmp46_;
	GList* personas1;
	GList* personas2;
	GeeHashSet* _tmp71_;
	gint _tmp72_;
	gint _tmp73_;
	guint _tmp74_ = 0U;
	GMainLoop* _tmp75_;
	guint _tmp76_;
	LibsocialwebTestBackend* _tmp77_;
#line 98 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_return_if_fail (self != NULL);
#line 98 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 98 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_data1_->_ref_count_ = 1;
#line 98 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_data1_->self = g_object_ref (self);
#line 100 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 100 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_data1_->main_loop = _tmp0_;
#line 102 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp1_ = self->priv->_lsw_backend;
#line 102 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_signal_connect_data (_tmp1_, "ready", (GCallback) ___lambda0__libsocialweb_test_backend_ready, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 106 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp2_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, ___lambda1__gsource_func, g_object_ref (self), g_object_unref);
#line 106 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	timer_id = _tmp2_;
#line 110 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp3_ = self->priv->_lsw_backend;
#line 110 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	libsocialweb_test_backend_set_up (_tmp3_);
#line 111 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp4_ = _data1_->main_loop;
#line 111 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_main_loop_run (_tmp4_);
#line 112 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp5_ = timer_id;
#line 112 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_source_remove (_tmp5_);
#line 114 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp6_ = self->priv->_lsw_backend;
#line 114 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp7_ = libsocialweb_test_backend_add_service (_tmp6_, "mysocialnetwork1");
#line 114 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_data1_->mysocialnetwork1 = _tmp7_;
#line 115 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp8_ = self->priv->_lsw_backend;
#line 115 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp9_ = libsocialweb_test_backend_add_service (_tmp8_, "mysocialnetwork2");
#line 115 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_data1_->mysocialnetwork2 = _tmp9_;
#line 118 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp10_ = _data1_->mysocialnetwork1;
#line 118 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_signal_connect_data (_tmp10_, "open-view-called", (GCallback) ___lambda2__libsocialweb_test_libsocialweb_service_test_open_view_called, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 148 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp11_ = _data1_->mysocialnetwork2;
#line 148 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_signal_connect_data (_tmp11_, "open-view-called", (GCallback) ___lambda5__libsocialweb_test_libsocialweb_service_test_open_view_called, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 177 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp12_ = folks_individual_aggregator_new ();
#line 177 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_data1_->aggregator = _tmp12_;
#line 178 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp13_ = g_new0 (FolksIndividual*, 0 + 1);
#line 178 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_data1_->individual_gathered = _tmp13_;
#line 178 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_data1_->individual_gathered_length1 = 0;
#line 178 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_data1_->_individual_gathered_size_ = _data1_->individual_gathered_length1;
#line 179 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp14_ = _data1_->aggregator;
#line 179 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp15_ = g_signal_connect_data (_tmp14_, "individuals-changed", (GCallback) ___lambda8__folks_individual_aggregator_individuals_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 179 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	handler_id = _tmp15_;
#line 187 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp16_ = _data1_->aggregator;
#line 187 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	folks_individual_aggregator_prepare (_tmp16_, NULL, NULL);
#line 189 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp17_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, ___lambda9__gsource_func, g_object_ref (self), g_object_unref);
#line 189 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	timer_id = _tmp17_;
#line 193 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp18_ = _data1_->main_loop;
#line 193 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_main_loop_run (_tmp18_);
#line 194 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp19_ = timer_id;
#line 194 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_source_remove (_tmp19_);
#line 195 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp20_ = _data1_->aggregator;
#line 195 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp21_ = handler_id;
#line 195 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_signal_handler_disconnect ((GObject*) _tmp20_, _tmp21_);
#line 198 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp22_ = _data1_->individual_gathered;
#line 198 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp22__length1 = _data1_->individual_gathered_length1;
#line 198 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_assert (_tmp22__length1 == 2);
#line 200 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp25_ = _data1_->individual_gathered;
#line 200 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp25__length1 = _data1_->individual_gathered_length1;
#line 200 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp26_ = _tmp25_[0];
#line 200 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp27_ = folks_name_details_get_nickname (FOLKS_NAME_DETAILS (_tmp26_));
#line 200 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp28_ = _tmp27_;
#line 200 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	if (g_strcmp0 (_tmp28_, "Gargantua") == 0) {
#line 1401 "aggregation.c"
		FolksIndividual** _tmp29_;
		gint _tmp29__length1;
		FolksIndividual* _tmp30_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
#line 201 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp29_ = _data1_->individual_gathered;
#line 201 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp29__length1 = _data1_->individual_gathered_length1;
#line 201 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp30_ = _tmp29_[1];
#line 201 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp31_ = folks_name_details_get_nickname (FOLKS_NAME_DETAILS (_tmp30_));
#line 201 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp32_ = _tmp31_;
#line 201 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp24_ = g_strcmp0 (_tmp32_, "Pantagruel") == 0;
#line 1419 "aggregation.c"
	} else {
#line 200 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp24_ = FALSE;
#line 1423 "aggregation.c"
	}
#line 200 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp33_ = _tmp24_;
#line 200 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	if (_tmp33_) {
#line 200 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp23_ = TRUE;
#line 1431 "aggregation.c"
	} else {
		gboolean _tmp34_ = FALSE;
		FolksIndividual** _tmp35_;
		gint _tmp35__length1;
		FolksIndividual* _tmp36_;
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		gboolean _tmp43_;
#line 203 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp35_ = _data1_->individual_gathered;
#line 203 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp35__length1 = _data1_->individual_gathered_length1;
#line 203 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp36_ = _tmp35_[0];
#line 203 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp37_ = folks_name_details_get_nickname (FOLKS_NAME_DETAILS (_tmp36_));
#line 203 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp38_ = _tmp37_;
#line 203 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		if (g_strcmp0 (_tmp38_, "Pantagruel") == 0) {
#line 1452 "aggregation.c"
			FolksIndividual** _tmp39_;
			gint _tmp39__length1;
			FolksIndividual* _tmp40_;
			const gchar* _tmp41_;
			const gchar* _tmp42_;
#line 204 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp39_ = _data1_->individual_gathered;
#line 204 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp39__length1 = _data1_->individual_gathered_length1;
#line 204 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp40_ = _tmp39_[1];
#line 204 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp41_ = folks_name_details_get_nickname (FOLKS_NAME_DETAILS (_tmp40_));
#line 204 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp42_ = _tmp41_;
#line 204 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp34_ = g_strcmp0 (_tmp42_, "Gargantua") == 0;
#line 1470 "aggregation.c"
		} else {
#line 203 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp34_ = FALSE;
#line 1474 "aggregation.c"
		}
#line 203 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp43_ = _tmp34_;
#line 203 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp23_ = _tmp43_;
#line 1480 "aggregation.c"
	}
#line 199 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp44_ = _tmp23_;
#line 199 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_assert (_tmp44_);
#line 207 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp45_ = _data1_->aggregator;
#line 207 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_signal_connect_data (_tmp45_, "individuals-changed", (GCallback) ___lambda10__folks_individual_aggregator_individuals_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 225 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp46_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
#line 225 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_data1_->personas = _tmp46_;
#line 227 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	personas1 = NULL;
#line 1496 "aggregation.c"
	{
		FolksIndividual** _tmp47_;
		gint _tmp47__length1;
		FolksIndividual* _tmp48_;
		GeeSet* _tmp49_;
		GeeSet* _tmp50_;
		GeeIterator* _tmp51_ = NULL;
		GeeIterator* _p1_it;
#line 228 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp47_ = _data1_->individual_gathered;
#line 228 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp47__length1 = _data1_->individual_gathered_length1;
#line 228 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp48_ = _tmp47_[0];
#line 228 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp49_ = folks_individual_get_personas (_tmp48_);
#line 228 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp50_ = _tmp49_;
#line 228 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp51_ = gee_iterable_iterator ((GeeIterable*) _tmp50_);
#line 228 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_p1_it = _tmp51_;
#line 228 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		while (TRUE) {
#line 1521 "aggregation.c"
			GeeIterator* _tmp52_;
			gboolean _tmp53_ = FALSE;
			GeeIterator* _tmp54_;
			gpointer _tmp55_ = NULL;
			FolksPersona* p1;
			GeeHashSet* _tmp56_;
			FolksPersona* _tmp57_;
			FolksPersona* _tmp58_;
#line 228 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp52_ = _p1_it;
#line 228 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp53_ = gee_iterator_next (_tmp52_);
#line 228 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			if (!_tmp53_) {
#line 228 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
				break;
#line 1538 "aggregation.c"
			}
#line 228 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp54_ = _p1_it;
#line 228 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp55_ = gee_iterator_get (_tmp54_);
#line 228 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			p1 = (FolksPersona*) _tmp55_;
#line 230 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp56_ = _data1_->personas;
#line 230 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp57_ = p1;
#line 230 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp56_, _tmp57_);
#line 231 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp58_ = p1;
#line 231 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			personas1 = g_list_append (personas1, _tmp58_);
#line 228 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_g_object_unref0 (p1);
#line 1558 "aggregation.c"
		}
#line 228 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_g_object_unref0 (_p1_it);
#line 1562 "aggregation.c"
	}
#line 234 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	personas2 = NULL;
#line 1566 "aggregation.c"
	{
		FolksIndividual** _tmp59_;
		gint _tmp59__length1;
		FolksIndividual* _tmp60_;
		GeeSet* _tmp61_;
		GeeSet* _tmp62_;
		GeeIterator* _tmp63_ = NULL;
		GeeIterator* _p2_it;
#line 235 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp59_ = _data1_->individual_gathered;
#line 235 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp59__length1 = _data1_->individual_gathered_length1;
#line 235 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp60_ = _tmp59_[1];
#line 235 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp61_ = folks_individual_get_personas (_tmp60_);
#line 235 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp62_ = _tmp61_;
#line 235 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_tmp63_ = gee_iterable_iterator ((GeeIterable*) _tmp62_);
#line 235 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_p2_it = _tmp63_;
#line 235 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		while (TRUE) {
#line 1591 "aggregation.c"
			GeeIterator* _tmp64_;
			gboolean _tmp65_ = FALSE;
			GeeIterator* _tmp66_;
			gpointer _tmp67_ = NULL;
			FolksPersona* p2;
			GeeHashSet* _tmp68_;
			FolksPersona* _tmp69_;
			FolksPersona* _tmp70_;
#line 235 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp64_ = _p2_it;
#line 235 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp65_ = gee_iterator_next (_tmp64_);
#line 235 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			if (!_tmp65_) {
#line 235 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
				break;
#line 1608 "aggregation.c"
			}
#line 235 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp66_ = _p2_it;
#line 235 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp67_ = gee_iterator_get (_tmp66_);
#line 235 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			p2 = (FolksPersona*) _tmp67_;
#line 237 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp68_ = _data1_->personas;
#line 237 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp69_ = p2;
#line 237 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp68_, _tmp69_);
#line 238 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_tmp70_ = p2;
#line 238 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			personas2 = g_list_append (personas2, _tmp70_);
#line 235 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
			_g_object_unref0 (p2);
#line 1628 "aggregation.c"
		}
#line 235 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
		_g_object_unref0 (_p2_it);
#line 1632 "aggregation.c"
	}
#line 241 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp71_ = _data1_->personas;
#line 241 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp72_ = gee_collection_get_size ((GeeCollection*) _tmp71_);
#line 241 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp73_ = _tmp72_;
#line 241 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_assert (_tmp73_ == 2);
#line 243 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda11__gsource_func, block1_data_ref (_data1_), block1_data_unref);
#line 249 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp74_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, ___lambda12__gsource_func, g_object_ref (self), g_object_unref);
#line 249 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	timer_id = _tmp74_;
#line 253 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp75_ = _data1_->main_loop;
#line 253 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_main_loop_run (_tmp75_);
#line 254 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp76_ = timer_id;
#line 254 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_source_remove (_tmp76_);
#line 256 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp77_ = self->priv->_lsw_backend;
#line 256 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	libsocialweb_test_backend_tear_down (_tmp77_);
#line 98 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_g_list_free0 (personas2);
#line 98 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_g_list_free0 (personas1);
#line 98 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	block1_data_unref (_data1_);
#line 98 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_data1_ = NULL;
#line 1668 "aggregation.c"
}


static void aggregation_tests_class_init (AggregationTestsClass * klass) {
#line 26 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	aggregation_tests_parent_class = g_type_class_peek_parent (klass);
#line 26 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_type_class_add_private (klass, sizeof (AggregationTestsPrivate));
#line 26 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	FOLKS_TEST_CASE_CLASS (klass)->set_up = aggregation_tests_real_set_up;
#line 26 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	FOLKS_TEST_CASE_CLASS (klass)->tear_down = aggregation_tests_real_tear_down;
#line 26 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	G_OBJECT_CLASS (klass)->finalize = aggregation_tests_finalize;
#line 1683 "aggregation.c"
}


static void aggregation_tests_instance_init (AggregationTests * self) {
#line 26 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	self->priv = AGGREGATION_TESTS_GET_PRIVATE (self);
#line 1690 "aggregation.c"
}


static void aggregation_tests_finalize (GObject* obj) {
	AggregationTests * self;
#line 26 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	self = AGGREGATION_TESTS (obj);
#line 28 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_libsocialweb_test_backend_unref0 (self->priv->_lsw_backend);
#line 26 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	G_OBJECT_CLASS (aggregation_tests_parent_class)->finalize (obj);
#line 1702 "aggregation.c"
}


GType aggregation_tests_get_type (void) {
	static volatile gsize aggregation_tests_type_id__volatile = 0;
	if (g_once_init_enter (&aggregation_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AggregationTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) aggregation_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AggregationTests), 0, (GInstanceInitFunc) aggregation_tests_instance_init, NULL };
		GType aggregation_tests_type_id;
		aggregation_tests_type_id = g_type_register_static (FOLKS_TYPE_TEST_CASE, "AggregationTests", &g_define_type_info, 0);
		g_once_init_leave (&aggregation_tests_type_id__volatile, aggregation_tests_type_id);
	}
	return aggregation_tests_type_id__volatile;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GTestSuite* _tmp0_ = NULL;
	GTestSuite* root;
	AggregationTests* _tmp1_;
	AggregationTests* _tmp2_;
	GTestSuite* _tmp3_ = NULL;
#line 262 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_test_init (&args_length1, &args, NULL);
#line 264 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp0_ = g_test_get_root ();
#line 264 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	root = _tmp0_;
#line 265 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp1_ = aggregation_tests_new ();
#line 265 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp2_ = _tmp1_;
#line 265 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_tmp3_ = folks_test_case_get_suite ((FolksTestCase*) _tmp2_);
#line 265 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_test_suite_add_suite (root, _tmp3_);
#line 265 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	_g_object_unref0 (_tmp2_);
#line 267 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_test_run ();
#line 269 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	result = 0;
#line 269 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	return result;
#line 1747 "aggregation.c"
}


int main (int argc, char ** argv) {
#line 260 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	g_type_init ();
#line 260 "/debian/rgs/devel/folks/tests/libsocialweb/aggregation.vala"
	return _vala_main (argv, argc);
#line 1756 "aggregation.c"
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



