/* tpf-persona.c generated by valac 0.13.1.106-1068, the Vala compiler
 * generated from tpf-persona.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <telepathy-glib/telepathy-glib.h>


#define TPF_TYPE_PERSONA (tpf_persona_get_type ())
#define TPF_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TPF_TYPE_PERSONA, TpfPersona))
#define TPF_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TPF_TYPE_PERSONA, TpfPersonaClass))
#define TPF_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TPF_TYPE_PERSONA))
#define TPF_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TPF_TYPE_PERSONA))
#define TPF_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TPF_TYPE_PERSONA, TpfPersonaClass))

typedef struct _TpfPersona TpfPersona;
typedef struct _TpfPersonaClass TpfPersonaClass;
typedef struct _TpfPersonaPrivate TpfPersonaPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TPF_TYPE_PERSONA_STORE (tpf_persona_store_get_type ())
#define TPF_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TPF_TYPE_PERSONA_STORE, TpfPersonaStore))
#define TPF_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TPF_TYPE_PERSONA_STORE, TpfPersonaStoreClass))
#define TPF_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TPF_TYPE_PERSONA_STORE))
#define TPF_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TPF_TYPE_PERSONA_STORE))
#define TPF_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TPF_TYPE_PERSONA_STORE, TpfPersonaStoreClass))

typedef struct _TpfPersonaStore TpfPersonaStore;
typedef struct _TpfPersonaStoreClass TpfPersonaStoreClass;
typedef struct _TpfPersonaChangeGroupData TpfPersonaChangeGroupData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

struct _TpfPersona {
	FolksPersona parent_instance;
	TpfPersonaPrivate * priv;
};

struct _TpfPersonaClass {
	FolksPersonaClass parent_class;
};

struct _TpfPersonaPrivate {
	GeeHashSet* _groups;
	GeeSet* _groups_ro;
	gboolean _is_favourite;
	gchar* _alias;
	GeeHashMultiMap* _im_addresses;
	gboolean _is_constructed;
	gboolean _is_in_contact_list;
	GLoadableIcon* _avatar;
	FolksPresenceType _presence_type;
	gchar* _presence_status;
	gchar* _presence_message;
	TpContact* _contact;
};

struct _TpfPersonaChangeGroupData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersona* self;
	gchar* group;
	gboolean is_member;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	FolksPersonaStore* _tmp3_;
	FolksPersonaStore* _tmp4_;
	TpfPersonaStore* _tmp5_;
	TpfPersonaStore* store;
	TpfPersonaStore* _tmp6_;
	const gchar* _tmp7_;
	gboolean _tmp8_;
};

struct _Block1Data {
	int _ref_count_;
	TpAccount* account_found;
	TpConnection* conn;
};


static gpointer tpf_persona_parent_class = NULL;
static FolksAliasDetailsIface* tpf_persona_folks_alias_details_parent_iface = NULL;
static FolksAvatarDetailsIface* tpf_persona_folks_avatar_details_parent_iface = NULL;
static FolksFavouriteDetailsIface* tpf_persona_folks_favourite_details_parent_iface = NULL;
static FolksGroupDetailsIface* tpf_persona_folks_group_details_parent_iface = NULL;
static FolksImDetailsIface* tpf_persona_folks_im_details_parent_iface = NULL;
static FolksPresenceDetailsIface* tpf_persona_folks_presence_details_parent_iface = NULL;

GType tpf_persona_get_type (void) G_GNUC_CONST;
#define TPF_PERSONA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TPF_TYPE_PERSONA, TpfPersonaPrivate))
enum  {
	TPF_PERSONA_DUMMY_PROPERTY,
	TPF_PERSONA_IS_IN_CONTACT_LIST,
	TPF_PERSONA_AVATAR,
	TPF_PERSONA_PRESENCE_TYPE,
	TPF_PERSONA_PRESENCE_STATUS,
	TPF_PERSONA_PRESENCE_MESSAGE,
	TPF_PERSONA_LINKABLE_PROPERTIES,
	TPF_PERSONA_WRITEABLE_PROPERTIES,
	TPF_PERSONA_ALIAS,
	TPF_PERSONA_IS_FAVOURITE,
	TPF_PERSONA_IM_ADDRESSES,
	TPF_PERSONA_GROUPS,
	TPF_PERSONA_CONTACT
};
static void tpf_persona_real_change_group_data_free (gpointer _data);
static void tpf_persona_real_change_group (FolksGroupDetails* base, const gchar* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_real_change_group_co (TpfPersonaChangeGroupData* _data_);
static gboolean _tpf_persona_change_group (TpfPersona* self, const gchar* group, gboolean is_member);
GType tpf_persona_store_get_type (void) G_GNUC_CONST;
void _tpf_persona_store_change_group_membership (TpfPersonaStore* self, FolksPersona* persona, const gchar* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _tpf_persona_store_change_group_membership_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static void tpf_persona_change_group_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
TpfPersona* tpf_persona_new (TpContact* contact, TpfPersonaStore* store);
TpfPersona* tpf_persona_construct (GType object_type, TpContact* contact, TpfPersonaStore* store);
static TpAccount* _tpf_persona_account_for_connection (TpConnection* conn);
static void _lambda16_ (GObject* s, GParamSpec* p, TpfPersona* self);
TpContact* tpf_persona_get_contact (TpfPersona* self);
static void __lambda16__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda17_ (GObject* s, GParamSpec* p, TpfPersona* self);
static void _tpf_persona_contact_notify_avatar (TpfPersona* self);
static void __lambda17__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda18_ (GObject* s, GParamSpec* p, TpfPersona* self);
static void _tpf_persona_contact_notify_presence_message (TpfPersona* self);
static void __lambda18__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda19_ (GObject* s, GParamSpec* p, TpfPersona* self);
static void _tpf_persona_contact_notify_presence_type (TpfPersona* self);
static void __lambda19__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda20_ (GObject* s, GParamSpec* p, TpfPersona* self);
static void _tpf_persona_contact_notify_presence_status (TpfPersona* self);
static void __lambda20__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda21_ (TpfPersonaStore* s, const gchar* group, GList* added, GList* removed, TpfPersona* self);
static void __lambda21__tpf_persona_store_group_members_changed (TpfPersonaStore* _sender, const gchar* group, GList* added, GList* removed, gpointer self);
static void _lambda22_ (TpfPersonaStore* s, const gchar* group, GError* _error_, TpfPersona* self);
static void __lambda22__tpf_persona_store_group_removed (TpfPersonaStore* _sender, const gchar* group, GError* _error_, gpointer self);
TpfPersona* tpf_persona_new_from_cache (TpfPersonaStore* store, const gchar* uid, const gchar* iid, const gchar* im_address, const gchar* protocol, GeeHashSet* groups, gboolean is_favourite, const gchar* alias, gboolean is_in_contact_list, gboolean is_user, GLoadableIcon* avatar);
TpfPersona* tpf_persona_construct_from_cache (GType object_type, TpfPersonaStore* store, const gchar* uid, const gchar* iid, const gchar* im_address, const gchar* protocol, GeeHashSet* groups, gboolean is_favourite, const gchar* alias, gboolean is_in_contact_list, gboolean is_user, GLoadableIcon* avatar);
void tpf_persona_set_is_in_contact_list (TpfPersona* self, gboolean value);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void _lambda15_ (TpAccount* l, Block1Data* _data1_);
static void __lambda15__gfunc (gconstpointer data, gpointer self);
static FolksPresenceType _tpf_persona_folks_presence_type_from_tp (TpConnectionPresenceType type);
gboolean tpf_persona_get_is_in_contact_list (TpfPersona* self);
void tpf_persona_store_change_alias (TpfPersonaStore* self, TpfPersona* persona, const gchar* alias, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_alias_finish (TpfPersonaStore* self, GAsyncResult* _res_);
void tpf_persona_store_change_is_favourite (TpfPersonaStore* self, FolksPersona* persona, gboolean is_favourite, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_is_favourite_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static void tpf_persona_set_contact (TpfPersona* self, TpContact* value);
static void tpf_persona_finalize (GObject* obj);
static void _vala_tpf_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tpf_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const gchar* TPF_PERSONA__linkable_properties[1] = {"im-addresses"};
static const gchar* TPF_PERSONA__writeable_properties[3] = {"alias", "is-favourite", "groups"};

static void tpf_persona_real_change_group_data_free (gpointer _data) {
	TpfPersonaChangeGroupData* _data_;
	_data_ = _data;
	_g_free0 (_data_->group);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaChangeGroupData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void tpf_persona_real_change_group (FolksGroupDetails* base, const gchar* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersona * self;
	TpfPersonaChangeGroupData* _data_;
	TpfPersona* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	self = (TpfPersona*) base;
	_data_ = g_slice_new0 (TpfPersonaChangeGroupData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_real_change_group);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_real_change_group_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = group;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->group = _tmp2_;
	_tmp3_ = is_member;
	_data_->is_member = _tmp3_;
	tpf_persona_real_change_group_co (_data_);
}


static void tpf_persona_real_change_group_finish (FolksGroupDetails* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaChangeGroupData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Add or remove the Persona from the specified group.
   *
   * See {@link Folks.GroupDetails.change_group}.
   */
static void tpf_persona_change_group_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaChangeGroupData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_real_change_group_co (_data_);
}


static gboolean tpf_persona_real_change_group_co (TpfPersonaChangeGroupData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->group;
	_data_->_tmp1_ = _data_->is_member;
	_data_->_tmp2_ = FALSE;
	_data_->_tmp2_ = _tpf_persona_change_group (_data_->self, _data_->_tmp0_, _data_->_tmp1_);
	if (_data_->_tmp2_) {
		_data_->_tmp3_ = folks_persona_get_store ((FolksPersona*) _data_->self);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = _g_object_ref0 (TPF_PERSONA_STORE (_data_->_tmp4_));
		_data_->store = _data_->_tmp5_;
		_data_->_tmp6_ = _data_->store;
		_data_->_tmp7_ = _data_->group;
		_data_->_tmp8_ = _data_->is_member;
		_data_->_state_ = 1;
		_tpf_persona_store_change_group_membership (_data_->_tmp6_, (FolksPersona*) _data_->self, _data_->_tmp7_, _data_->_tmp8_, tpf_persona_change_group_ready, _data_);
		return FALSE;
		_state_1:
		_tpf_persona_store_change_group_membership_finish (_data_->_tmp6_, _data_->_res_);
		_g_object_unref0 (_data_->store);
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gboolean _tpf_persona_change_group (TpfPersona* self, const gchar* group, gboolean is_member) {
	gboolean result = FALSE;
	gboolean changed;
	gboolean _tmp0_;
	gboolean _tmp9_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (group != NULL, FALSE);
	changed = FALSE;
	_tmp0_ = is_member;
	if (_tmp0_) {
		GeeHashSet* _tmp1_;
		const gchar* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp1_ = self->priv->_groups;
		_tmp2_ = group;
		_tmp3_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp1_, _tmp2_);
		if (!_tmp3_) {
			GeeHashSet* _tmp4_;
			const gchar* _tmp5_;
			_tmp4_ = self->priv->_groups;
			_tmp5_ = group;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, _tmp5_);
			changed = TRUE;
		}
	} else {
		GeeHashSet* _tmp6_;
		const gchar* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp6_ = self->priv->_groups;
		_tmp7_ = group;
		_tmp8_ = gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp6_, _tmp7_);
		changed = _tmp8_;
	}
	_tmp9_ = changed;
	if (_tmp9_ == TRUE) {
		const gchar* _tmp10_;
		gboolean _tmp11_;
		_tmp10_ = group;
		_tmp11_ = is_member;
		g_signal_emit_by_name ((FolksGroupDetails*) self, "group-changed", _tmp10_, _tmp11_);
	}
	result = changed;
	return result;
}


/**
   * Create a new persona.
   *
   * Create a new persona for the {@link PersonaStore} `store`, representing
   * the Telepathy contact given by `contact`.
   *
   * @param contact the Telepathy contact being represented by the persona
   * @param store the persona store to place the persona in
   */
static void _lambda16_ (GObject* s, GParamSpec* p, TpfPersona* self) {
	const gchar* _tmp0_;
	TpContact* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->_alias;
	_tmp1_ = self->priv->_contact;
	g_object_get (_tmp1_, "alias", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp0_, _tmp4_) != 0;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		TpContact* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp6_ = self->priv->_contact;
		g_object_get (_tmp6_, "alias", &_tmp7_, NULL);
		_tmp8_ = _tmp7_;
		_g_free0 (self->priv->_alias);
		self->priv->_alias = _tmp8_;
		g_object_notify ((GObject*) self, "alias");
	}
}


static void __lambda16__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda16_ (_sender, pspec, self);
}


static void _lambda17_ (GObject* s, GParamSpec* p, TpfPersona* self) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tpf_persona_contact_notify_avatar (self);
}


static void __lambda17__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda17_ (_sender, pspec, self);
}


static void _lambda18_ (GObject* s, GParamSpec* p, TpfPersona* self) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tpf_persona_contact_notify_presence_message (self);
}


static void __lambda18__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda18_ (_sender, pspec, self);
}


static void _lambda19_ (GObject* s, GParamSpec* p, TpfPersona* self) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tpf_persona_contact_notify_presence_type (self);
}


static void __lambda19__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda19_ (_sender, pspec, self);
}


static void _lambda20_ (GObject* s, GParamSpec* p, TpfPersona* self) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tpf_persona_contact_notify_presence_status (self);
}


static void __lambda20__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda20_ (_sender, pspec, self);
}


static void _lambda21_ (TpfPersonaStore* s, const gchar* group, GList* added, GList* removed, TpfPersona* self) {
	GList* _tmp0_;
	GList* _tmp1_ = NULL;
	GList* _tmp3_;
	GList* _tmp4_ = NULL;
	g_return_if_fail (s != NULL);
	g_return_if_fail (group != NULL);
	_tmp0_ = added;
	_tmp1_ = g_list_find (_tmp0_, self);
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = group;
		_tpf_persona_change_group (self, _tmp2_, TRUE);
	}
	_tmp3_ = removed;
	_tmp4_ = g_list_find (_tmp3_, self);
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		_tmp5_ = group;
		_tpf_persona_change_group (self, _tmp5_, FALSE);
	}
}


static void __lambda21__tpf_persona_store_group_members_changed (TpfPersonaStore* _sender, const gchar* group, GList* added, GList* removed, gpointer self) {
	_lambda21_ (_sender, group, added, removed, self);
}


static void _lambda22_ (TpfPersonaStore* s, const gchar* group, GError* _error_, TpfPersona* self) {
	gboolean _tmp0_ = FALSE;
	GError* _tmp1_;
	gboolean _tmp9_;
	g_return_if_fail (s != NULL);
	g_return_if_fail (group != NULL);
	_tmp1_ = _error_;
	if (_tmp1_ != NULL) {
		gboolean _tmp2_ = FALSE;
		GError* _tmp3_;
		GQuark _tmp4_;
		GQuark _tmp5_ = 0U;
		gboolean _tmp8_;
		_tmp3_ = _error_;
		_tmp4_ = _tmp3_->domain;
		_tmp5_ = tp_dbus_errors_quark ();
		if (_tmp4_ != _tmp5_) {
			_tmp2_ = TRUE;
		} else {
			GError* _tmp6_;
			gint _tmp7_;
			_tmp6_ = _error_;
			_tmp7_ = _tmp6_->code;
			_tmp2_ = _tmp7_ != ((gint) TP_DBUS_ERROR_OBJECT_REMOVED);
		}
		_tmp8_ = _tmp2_;
		_tmp0_ = _tmp8_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp9_ = _tmp0_;
	if (_tmp9_) {
		GError* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp10_ = _error_;
		_tmp11_ = _tmp10_->message;
		g_debug ("tpf-persona.vala:354: Group invalidated: %s", _tmp11_);
		_tmp12_ = group;
		_tpf_persona_change_group (self, _tmp12_, FALSE);
	}
}


static void __lambda22__tpf_persona_store_group_removed (TpfPersonaStore* _sender, const gchar* group, GError* _error_, gpointer self) {
	_lambda22_ (_sender, group, _error_, self);
}


TpfPersona* tpf_persona_construct (GType object_type, TpContact* contact, TpfPersonaStore* store) {
	TpfPersona * self = NULL;
	TpContact* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* id;
	TpContact* _tmp2_;
	TpConnection* _tmp3_ = NULL;
	TpConnection* _tmp4_;
	TpConnection* connection;
	TpConnection* _tmp5_;
	TpAccount* _tmp6_ = NULL;
	TpAccount* account;
	TpfPersonaStore* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	TpfPersonaStore* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* uid;
	TpContact* _tmp15_;
	const gchar* _tmp16_ = NULL;
	TpContact* _tmp17_;
	const gchar* _tmp18_;
	TpAccount* _tmp19_;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	TpfPersonaStore* _tmp27_;
	TpContact* _tmp28_;
	guint _tmp29_ = 0U;
	guint _tmp30_;
	TpConnection* _tmp31_;
	guint _tmp32_ = 0U;
	guint _tmp33_;
	TpContact* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	GeeHashMultiMap* _tmp37_;
	GeeHashSet* _tmp50_;
	GeeHashSet* _tmp51_;
	GeeSet* _tmp52_;
	GeeSet* _tmp53_;
	TpContact* _tmp54_;
	TpContact* _tmp55_;
	TpContact* _tmp56_;
	TpContact* _tmp57_;
	FolksPersonaStore* _tmp58_;
	FolksPersonaStore* _tmp59_;
	FolksPersonaStore* _tmp60_;
	FolksPersonaStore* _tmp61_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (contact != NULL, NULL);
	g_return_val_if_fail (store != NULL, NULL);
	_tmp0_ = contact;
	_tmp1_ = tp_contact_get_identifier (_tmp0_);
	id = _tmp1_;
	_tmp2_ = contact;
	g_object_get (_tmp2_, "connection", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	connection = _tmp4_;
	_tmp5_ = connection;
	_tmp6_ = _tpf_persona_account_for_connection (_tmp5_);
	account = _tmp6_;
	_tmp7_ = store;
	_tmp8_ = folks_persona_store_get_type_id ((FolksPersonaStore*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = store;
	_tmp11_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = id;
	_tmp14_ = folks_persona_build_uid (_tmp9_, _tmp12_, _tmp13_);
	uid = _tmp14_;
	_tmp15_ = contact;
	_tmp16_ = tp_contact_get_alias (_tmp15_);
	_tmp17_ = contact;
	_tmp18_ = id;
	_tmp19_ = account;
	_tmp20_ = tp_account_get_protocol (_tmp19_);
	_tmp21_ = g_strconcat (_tmp20_, ":", NULL);
	_tmp22_ = _tmp21_;
	_tmp23_ = id;
	_tmp24_ = g_strconcat (_tmp22_, _tmp23_, NULL);
	_tmp25_ = _tmp24_;
	_tmp26_ = uid;
	_tmp27_ = store;
	_tmp28_ = contact;
	g_object_get (_tmp28_, "handle", &_tmp29_, NULL);
	_tmp30_ = _tmp29_;
	_tmp31_ = connection;
	g_object_get (_tmp31_, "self-handle", &_tmp32_, NULL);
	_tmp33_ = _tmp32_;
	self = (TpfPersona*) g_object_new (object_type, "alias", _tmp16_, "contact", _tmp17_, "display-id", _tmp18_, "iid", _tmp25_, "uid", _tmp26_, "store", _tmp27_, "is-user", _tmp30_ == _tmp33_, NULL);
	_g_free0 (_tmp25_);
	_g_free0 (_tmp22_);
	_tmp34_ = contact;
	g_signal_connect_object ((GObject*) _tmp34_, "notify::alias", (GCallback) __lambda16__g_object_notify, self, 0);
	_tmp35_ = uid;
	_tmp36_ = id;
	g_debug ("tpf-persona.vala:285: Creating new Tpf.Persona '%s' for service-specif" \
"ic UID '%s': %p", _tmp35_, _tmp36_, self);
	self->priv->_is_constructed = TRUE;
	_tmp37_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_IM_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	_g_object_unref0 (self->priv->_im_addresses);
	self->priv->_im_addresses = _tmp37_;
	{
		const gchar* _tmp38_;
		TpAccount* _tmp39_;
		const gchar* _tmp40_ = NULL;
		gchar* _tmp41_ = NULL;
		gchar* im_addr;
		const gchar* _tmp42_;
		FolksImFieldDetails* _tmp43_;
		FolksImFieldDetails* im_fd;
		GeeHashMultiMap* _tmp44_;
		TpAccount* _tmp45_;
		const gchar* _tmp46_ = NULL;
		FolksImFieldDetails* _tmp47_;
		_tmp38_ = id;
		_tmp39_ = account;
		_tmp40_ = tp_account_get_protocol (_tmp39_);
		_tmp41_ = folks_im_details_normalise_im_address (_tmp38_, _tmp40_, &_inner_error_);
		im_addr = _tmp41_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == FOLKS_IM_DETAILS_ERROR) {
				goto __catch0_folks_im_details_error;
			}
			_g_free0 (uid);
			_g_object_unref0 (account);
			_g_object_unref0 (connection);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp42_ = im_addr;
		_tmp43_ = folks_im_field_details_new (_tmp42_, NULL);
		im_fd = _tmp43_;
		_tmp44_ = self->priv->_im_addresses;
		_tmp45_ = account;
		_tmp46_ = tp_account_get_protocol (_tmp45_);
		_tmp47_ = im_fd;
		gee_multi_map_set ((GeeMultiMap*) _tmp44_, _tmp46_, _tmp47_);
		_g_object_unref0 (im_fd);
		_g_free0 (im_addr);
	}
	goto __finally0;
	__catch0_folks_im_details_error:
	{
		GError* e = NULL;
		GError* _tmp48_;
		const gchar* _tmp49_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp48_ = e;
		_tmp49_ = _tmp48_->message;
		g_warning ("tpf-persona.vala:305: %s", _tmp49_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_free0 (uid);
		_g_object_unref0 (account);
		_g_object_unref0 (connection);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp50_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	_g_object_unref0 (self->priv->_groups);
	self->priv->_groups = _tmp50_;
	_tmp51_ = self->priv->_groups;
	_tmp52_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp51_);
	_tmp53_ = _tmp52_;
	_g_object_unref0 (self->priv->_groups_ro);
	self->priv->_groups_ro = _tmp53_;
	_tmp54_ = contact;
	g_signal_connect_object ((GObject*) _tmp54_, "notify::avatar-file", (GCallback) __lambda17__g_object_notify, self, 0);
	_tpf_persona_contact_notify_avatar (self);
	_tmp55_ = contact;
	g_signal_connect_object ((GObject*) _tmp55_, "notify::presence-message", (GCallback) __lambda18__g_object_notify, self, 0);
	_tmp56_ = contact;
	g_signal_connect_object ((GObject*) _tmp56_, "notify::presence-type", (GCallback) __lambda19__g_object_notify, self, 0);
	_tmp57_ = contact;
	g_signal_connect_object ((GObject*) _tmp57_, "notify::presence-status", (GCallback) __lambda20__g_object_notify, self, 0);
	_tpf_persona_contact_notify_presence_message (self);
	_tpf_persona_contact_notify_presence_type (self);
	_tpf_persona_contact_notify_presence_status (self);
	_tmp58_ = folks_persona_get_store ((FolksPersona*) self);
	_tmp59_ = _tmp58_;
	g_signal_connect_object (TPF_PERSONA_STORE (_tmp59_), "group-members-changed", (GCallback) __lambda21__tpf_persona_store_group_members_changed, self, 0);
	_tmp60_ = folks_persona_get_store ((FolksPersona*) self);
	_tmp61_ = _tmp60_;
	g_signal_connect_object (TPF_PERSONA_STORE (_tmp61_), "group-removed", (GCallback) __lambda22__tpf_persona_store_group_removed, self, 0);
	_g_free0 (uid);
	_g_object_unref0 (account);
	_g_object_unref0 (connection);
	return self;
}


TpfPersona* tpf_persona_new (TpContact* contact, TpfPersonaStore* store) {
	return tpf_persona_construct (TPF_TYPE_PERSONA, contact, store);
}


/**
   * Create a new persona for the {@link PersonaStore} `store`, representing
   * a cached contact for which we currently have no Telepathy contact.
   *
   * @param store The persona store to place the persona in.
   * @param uid The cached UID of the persona.
   * @param iid The cached IID of the persona.
   * @param im_address The cached IM address of the persona (excluding
   * protocol).
   * @param protocol The cached protocol of the persona.
   * @param groups The cached set of groups the persona is in.
   * @param is_favourite Whether the persona is a favourite.
   * @param alias The cached alias for the persona.
   * @param is_in_contact_list Whether the persona is in the user's contact
   * list.
   * @param is_user Whether the persona is the user.
   * @param avatar The icon for the persona's cached avatar, or `null` if they
   * have no avatar.
   * @return A new {@link Tpf.Persona} representing the cached persona.
   *
   * @since 0.6.0
   */
TpfPersona* tpf_persona_construct_from_cache (GType object_type, TpfPersonaStore* store, const gchar* uid, const gchar* iid, const gchar* im_address, const gchar* protocol, GeeHashSet* groups, gboolean is_favourite, const gchar* alias, gboolean is_in_contact_list, gboolean is_user, GLoadableIcon* avatar) {
	TpfPersona * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	TpfPersonaStore* _tmp3_;
	gboolean _tmp4_;
	const gchar* _tmp5_;
	GeeHashMultiMap* _tmp6_;
	const gchar* _tmp7_;
	FolksImFieldDetails* _tmp8_;
	FolksImFieldDetails* im_fd;
	GeeHashMultiMap* _tmp9_;
	const gchar* _tmp10_;
	FolksImFieldDetails* _tmp11_;
	GeeHashSet* _tmp12_;
	GeeHashSet* _tmp13_;
	GeeHashSet* _tmp14_;
	GeeSet* _tmp15_;
	GeeSet* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	GLoadableIcon* _tmp21_;
	g_return_val_if_fail (store != NULL, NULL);
	g_return_val_if_fail (uid != NULL, NULL);
	g_return_val_if_fail (iid != NULL, NULL);
	g_return_val_if_fail (im_address != NULL, NULL);
	g_return_val_if_fail (protocol != NULL, NULL);
	g_return_val_if_fail (groups != NULL, NULL);
	g_return_val_if_fail (alias != NULL, NULL);
	_tmp0_ = im_address;
	_tmp1_ = iid;
	_tmp2_ = uid;
	_tmp3_ = store;
	_tmp4_ = is_user;
	self = (TpfPersona*) g_object_new (object_type, "contact", NULL, "display-id", _tmp0_, "iid", _tmp1_, "uid", _tmp2_, "store", _tmp3_, "is-user", _tmp4_, NULL);
	_tmp5_ = uid;
	g_debug ("tpf-persona.vala:394: Creating new Tpf.Persona '%s' from cache: %p", _tmp5_, self);
	_tmp6_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_IM_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	_g_object_unref0 (self->priv->_im_addresses);
	self->priv->_im_addresses = _tmp6_;
	_tmp7_ = im_address;
	_tmp8_ = folks_im_field_details_new (_tmp7_, NULL);
	im_fd = _tmp8_;
	_tmp9_ = self->priv->_im_addresses;
	_tmp10_ = protocol;
	_tmp11_ = im_fd;
	gee_multi_map_set ((GeeMultiMap*) _tmp9_, _tmp10_, _tmp11_);
	_tmp12_ = groups;
	_tmp13_ = _g_object_ref0 (_tmp12_);
	_g_object_unref0 (self->priv->_groups);
	self->priv->_groups = _tmp13_;
	_tmp14_ = self->priv->_groups;
	_tmp15_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp14_);
	_tmp16_ = _tmp15_;
	_g_object_unref0 (self->priv->_groups_ro);
	self->priv->_groups_ro = _tmp16_;
	_tmp17_ = alias;
	_tmp18_ = g_strdup (_tmp17_);
	_g_free0 (self->priv->_alias);
	self->priv->_alias = _tmp18_;
	_tmp19_ = is_favourite;
	self->priv->_is_favourite = _tmp19_;
	_tmp20_ = is_in_contact_list;
	tpf_persona_set_is_in_contact_list (self, _tmp20_);
	_tmp21_ = avatar;
	folks_avatar_details_set_avatar ((FolksAvatarDetails*) self, _tmp21_);
	folks_presence_details_set_presence_type ((FolksPresenceDetails*) self, FOLKS_PRESENCE_TYPE_OFFLINE);
	folks_presence_details_set_presence_message ((FolksPresenceDetails*) self, "");
	_g_object_unref0 (im_fd);
	return self;
}


TpfPersona* tpf_persona_new_from_cache (TpfPersonaStore* store, const gchar* uid, const gchar* iid, const gchar* im_address, const gchar* protocol, GeeHashSet* groups, gboolean is_favourite, const gchar* alias, gboolean is_in_contact_list, gboolean is_user, GLoadableIcon* avatar) {
	return tpf_persona_construct_from_cache (TPF_TYPE_PERSONA, store, uid, iid, im_address, protocol, groups, is_favourite, alias, is_in_contact_list, is_user, avatar);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->account_found);
		_g_object_unref0 (_data1_->conn);
		g_slice_free (Block1Data, _data1_);
	}
}


static void _lambda15_ (TpAccount* l, Block1Data* _data1_) {
	TpAccount* _tmp0_;
	TpAccount* account;
	TpAccount* _tmp1_;
	TpConnection* _tmp2_ = NULL;
	TpConnection* _tmp3_;
	TpConnection* _tmp4_;
	TpConnection* _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (l != NULL);
	_tmp0_ = l;
	account = TP_ACCOUNT (_tmp0_);
	_tmp1_ = account;
	g_object_get (_tmp1_, "connection", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = _data1_->conn;
	_tmp6_ = _tmp4_ == _tmp5_;
	_g_object_unref0 (_tmp4_);
	if (_tmp6_) {
		TpAccount* _tmp7_;
		TpAccount* _tmp8_;
		_tmp7_ = account;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_g_object_unref0 (_data1_->account_found);
		_data1_->account_found = _tmp8_;
		return;
	}
}


static void __lambda15__gfunc (gconstpointer data, gpointer self) {
	_lambda15_ (data, self);
}


static TpAccount* _tpf_persona_account_for_connection (TpConnection* conn) {
	TpAccount* result = NULL;
	Block1Data* _data1_;
	TpConnection* _tmp0_;
	TpConnection* _tmp1_;
	TpAccountManager* _tmp2_ = NULL;
	TpAccountManager* manager;
	TpAccountManager* _tmp3_;
	GList* _tmp4_ = NULL;
	GList* accounts;
	GList* _tmp5_;
	TpAccount* _tmp6_;
	TpAccount* _tmp7_;
	g_return_val_if_fail (conn != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_tmp0_ = conn;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data1_->conn = _tmp1_;
	_tmp2_ = tp_account_manager_dup ();
	manager = _tmp2_;
	_tmp3_ = manager;
	_tmp4_ = tp_account_manager_get_valid_accounts (_tmp3_);
	accounts = _tmp4_;
	_data1_->account_found = NULL;
	_tmp5_ = accounts;
	g_list_foreach (_tmp5_, __lambda15__gfunc, _data1_);
	_tmp6_ = _data1_->account_found;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	result = _tmp7_;
	_g_list_free0 (accounts);
	_g_object_unref0 (manager);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}


static void _tpf_persona_contact_notify_presence_message (TpfPersona* self) {
	TpContact* _tmp0_;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_contact;
	_tmp1_ = tp_contact_get_presence_message (_tmp0_);
	folks_presence_details_set_presence_message ((FolksPresenceDetails*) self, _tmp1_);
}


static void _tpf_persona_contact_notify_presence_type (TpfPersona* self) {
	TpContact* _tmp0_;
	TpConnectionPresenceType _tmp1_ = 0;
	FolksPresenceType _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_contact;
	_tmp1_ = tp_contact_get_presence_type (_tmp0_);
	_tmp2_ = _tpf_persona_folks_presence_type_from_tp (_tmp1_);
	folks_presence_details_set_presence_type ((FolksPresenceDetails*) self, _tmp2_);
}


static void _tpf_persona_contact_notify_presence_status (TpfPersona* self) {
	TpContact* _tmp0_;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_contact;
	_tmp1_ = tp_contact_get_presence_status (_tmp0_);
	folks_presence_details_set_presence_status ((FolksPresenceDetails*) self, _tmp1_);
}


static FolksPresenceType _tpf_persona_folks_presence_type_from_tp (TpConnectionPresenceType type) {
	FolksPresenceType result = 0;
	TpConnectionPresenceType _tmp0_;
	_tmp0_ = type;
	switch (_tmp0_) {
		case TP_CONNECTION_PRESENCE_TYPE_AVAILABLE:
		{
			result = FOLKS_PRESENCE_TYPE_AVAILABLE;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_AWAY:
		{
			result = FOLKS_PRESENCE_TYPE_AWAY;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_BUSY:
		{
			result = FOLKS_PRESENCE_TYPE_BUSY;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_ERROR:
		{
			result = FOLKS_PRESENCE_TYPE_ERROR;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_EXTENDED_AWAY:
		{
			result = FOLKS_PRESENCE_TYPE_EXTENDED_AWAY;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_HIDDEN:
		{
			result = FOLKS_PRESENCE_TYPE_HIDDEN;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_OFFLINE:
		{
			result = FOLKS_PRESENCE_TYPE_OFFLINE;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_UNKNOWN:
		{
			result = FOLKS_PRESENCE_TYPE_UNKNOWN;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_UNSET:
		{
			result = FOLKS_PRESENCE_TYPE_UNSET;
			return result;
		}
		default:
		{
			result = FOLKS_PRESENCE_TYPE_UNKNOWN;
			return result;
		}
	}
}


static void _tpf_persona_contact_notify_avatar (TpfPersona* self) {
	TpContact* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_;
	GFile* file;
	GIcon* icon;
	GFile* _tmp3_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	GLoadableIcon* _tmp8_;
	GLoadableIcon* _tmp9_;
	gboolean _tmp11_;
	gboolean _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_contact;
	g_object_get (_tmp0_, "avatar-file", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	file = _tmp2_;
	icon = NULL;
	_tmp3_ = file;
	if (_tmp3_ != NULL) {
		GFile* _tmp4_;
		GFileIcon* _tmp5_;
		_tmp4_ = file;
		_tmp5_ = (GFileIcon*) g_file_icon_new (_tmp4_);
		_g_object_unref0 (icon);
		icon = (GIcon*) _tmp5_;
	}
	_tmp8_ = folks_avatar_details_get_avatar ((FolksAvatarDetails*) self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == NULL) {
		_tmp7_ = TRUE;
	} else {
		GIcon* _tmp10_;
		_tmp10_ = icon;
		_tmp7_ = _tmp10_ == NULL;
	}
	_tmp11_ = _tmp7_;
	if (_tmp11_) {
		_tmp6_ = TRUE;
	} else {
		GLoadableIcon* _tmp12_;
		GLoadableIcon* _tmp13_;
		GIcon* _tmp14_;
		gboolean _tmp15_ = FALSE;
		_tmp12_ = folks_avatar_details_get_avatar ((FolksAvatarDetails*) self);
		_tmp13_ = _tmp12_;
		_tmp14_ = icon;
		_tmp15_ = g_icon_equal ((GIcon*) _tmp13_, _tmp14_);
		_tmp6_ = !_tmp15_;
	}
	_tmp16_ = _tmp6_;
	if (_tmp16_) {
		GIcon* _tmp17_;
		_tmp17_ = icon;
		folks_avatar_details_set_avatar ((FolksAvatarDetails*) self, G_LOADABLE_ICON (_tmp17_));
	}
	_g_object_unref0 (icon);
	_g_object_unref0 (file);
}


gboolean tpf_persona_get_is_in_contact_list (TpfPersona* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_in_contact_list;
	result = _tmp0_;
	return result;
}


void tpf_persona_set_is_in_contact_list (TpfPersona* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_in_contact_list = _tmp0_;
	g_object_notify ((GObject *) self, "is-in-contact-list");
}


static GLoadableIcon* tpf_persona_real_get_avatar (FolksAvatarDetails* base) {
	GLoadableIcon* result;
	TpfPersona* self;
	GLoadableIcon* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_avatar;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_avatar (FolksAvatarDetails* base, GLoadableIcon* value) {
	TpfPersona* self;
	GLoadableIcon* _tmp0_;
	GLoadableIcon* _tmp1_;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_avatar);
	self->priv->_avatar = _tmp1_;
	g_object_notify ((GObject *) self, "avatar");
}


static FolksPresenceType tpf_persona_real_get_presence_type (FolksPresenceDetails* base) {
	FolksPresenceType result;
	TpfPersona* self;
	FolksPresenceType _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_presence_type;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_presence_type (FolksPresenceDetails* base, FolksPresenceType value) {
	TpfPersona* self;
	FolksPresenceType _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	self->priv->_presence_type = _tmp0_;
	g_object_notify ((GObject *) self, "presence-type");
}


static const gchar* tpf_persona_real_get_presence_status (FolksPresenceDetails* base) {
	const gchar* result;
	TpfPersona* self;
	const gchar* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_presence_status;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_presence_status (FolksPresenceDetails* base, const gchar* value) {
	TpfPersona* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_presence_status);
	self->priv->_presence_status = _tmp1_;
	g_object_notify ((GObject *) self, "presence-status");
}


static const gchar* tpf_persona_real_get_presence_message (FolksPresenceDetails* base) {
	const gchar* result;
	TpfPersona* self;
	const gchar* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_presence_message;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_presence_message (FolksPresenceDetails* base, const gchar* value) {
	TpfPersona* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_presence_message);
	self->priv->_presence_message = _tmp1_;
	g_object_notify ((GObject *) self, "presence-message");
}


static gchar** tpf_persona_real_get_linkable_properties (FolksPersona* base, int* result_length1) {
	gchar** result;
	TpfPersona* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	self = (TpfPersona*) base;
	_tmp0_ = TPF_PERSONA__linkable_properties;
	_tmp0__length1 = G_N_ELEMENTS (TPF_PERSONA__linkable_properties);
	if (result_length1) {
		*result_length1 = _tmp0__length1;
	}
	result = _tmp0_;
	return result;
}


static gchar** tpf_persona_real_get_writeable_properties (FolksPersona* base, int* result_length1) {
	gchar** result;
	TpfPersona* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	self = (TpfPersona*) base;
	_tmp0_ = TPF_PERSONA__writeable_properties;
	_tmp0__length1 = G_N_ELEMENTS (TPF_PERSONA__writeable_properties);
	if (result_length1) {
		*result_length1 = _tmp0__length1;
	}
	result = _tmp0_;
	return result;
}


static const gchar* tpf_persona_real_get_alias (FolksAliasDetails* base) {
	const gchar* result;
	TpfPersona* self;
	const gchar* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_alias;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_alias (FolksAliasDetails* base, const gchar* value) {
	TpfPersona* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_alias;
	_tmp1_ = value;
	if (g_strcmp0 (_tmp0_, _tmp1_) == 0) {
		return;
	}
	_tmp2_ = self->priv->_is_constructed;
	if (_tmp2_) {
		FolksPersonaStore* _tmp3_;
		FolksPersonaStore* _tmp4_;
		const gchar* _tmp5_;
		_tmp3_ = folks_persona_get_store ((FolksPersona*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = value;
		tpf_persona_store_change_alias (TPF_PERSONA_STORE (_tmp4_), self, _tmp5_, NULL, NULL);
	}
	_tmp6_ = value;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 (self->priv->_alias);
	self->priv->_alias = _tmp7_;
	g_object_notify ((GObject *) self, "alias");
}


static gboolean tpf_persona_real_get_is_favourite (FolksFavouriteDetails* base) {
	gboolean result;
	TpfPersona* self;
	gboolean _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_is_favourite;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_is_favourite (FolksFavouriteDetails* base, gboolean value) {
	TpfPersona* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp6_;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_is_favourite;
	_tmp1_ = value;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = self->priv->_is_constructed;
	if (_tmp2_) {
		FolksPersonaStore* _tmp3_;
		FolksPersonaStore* _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = folks_persona_get_store ((FolksPersona*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = value;
		tpf_persona_store_change_is_favourite (TPF_PERSONA_STORE (_tmp4_), (FolksPersona*) self, _tmp5_, NULL, NULL);
	}
	_tmp6_ = value;
	self->priv->_is_favourite = _tmp6_;
	g_object_notify ((GObject *) self, "is-favourite");
}


static GeeMultiMap* tpf_persona_real_get_im_addresses (FolksImDetails* base) {
	GeeMultiMap* result;
	TpfPersona* self;
	GeeHashMultiMap* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_im_addresses;
	result = (GeeMultiMap*) _tmp0_;
	return result;
}


static void tpf_persona_real_set_im_addresses (FolksImDetails* base, GeeMultiMap* value) {
	TpfPersona* self;
	self = (TpfPersona*) base;
	g_object_notify ((GObject *) self, "im-addresses");
}


static GeeSet* tpf_persona_real_get_groups (FolksGroupDetails* base) {
	GeeSet* result;
	TpfPersona* self;
	GeeSet* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_groups_ro;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_groups (FolksGroupDetails* base, GeeSet* value) {
	TpfPersona* self;
	self = (TpfPersona*) base;
	{
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _group_it;
		_tmp0_ = value;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
		_group_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			gboolean _tmp3_ = FALSE;
			GeeIterator* _tmp4_;
			gpointer _tmp5_ = NULL;
			gchar* group;
			GeeHashSet* _tmp6_;
			const gchar* _tmp7_;
			gboolean _tmp8_ = FALSE;
			_tmp2_ = _group_it;
			_tmp3_ = gee_iterator_next (_tmp2_);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = _group_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			group = (gchar*) _tmp5_;
			_tmp6_ = self->priv->_groups;
			_tmp7_ = group;
			_tmp8_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp6_, _tmp7_);
			if (_tmp8_ == FALSE) {
				const gchar* _tmp9_;
				_tmp9_ = group;
				_tpf_persona_change_group (self, _tmp9_, TRUE);
			}
			_g_free0 (group);
		}
		_g_object_unref0 (_group_it);
	}
	{
		GeeHashSet* _tmp10_;
		GeeIterator* _tmp11_ = NULL;
		GeeIterator* _group_it;
		_tmp10_ = self->priv->_groups;
		_tmp11_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp10_);
		_group_it = _tmp11_;
		while (TRUE) {
			GeeIterator* _tmp12_;
			gboolean _tmp13_ = FALSE;
			GeeIterator* _tmp14_;
			gpointer _tmp15_ = NULL;
			gchar* group;
			GeeSet* _tmp16_;
			const gchar* _tmp17_;
			gboolean _tmp18_ = FALSE;
			_tmp12_ = _group_it;
			_tmp13_ = gee_iterator_next (_tmp12_);
			if (!_tmp13_) {
				break;
			}
			_tmp14_ = _group_it;
			_tmp15_ = gee_iterator_get (_tmp14_);
			group = (gchar*) _tmp15_;
			_tmp16_ = value;
			_tmp17_ = group;
			_tmp18_ = gee_collection_contains ((GeeCollection*) _tmp16_, _tmp17_);
			if (_tmp18_ == FALSE) {
				const gchar* _tmp19_;
				_tmp19_ = group;
				_tpf_persona_change_group (self, _tmp19_, TRUE);
			}
			_g_free0 (group);
		}
		_g_object_unref0 (_group_it);
	}
	g_object_notify ((GObject*) self, "groups");
	g_object_notify ((GObject *) self, "groups");
}


TpContact* tpf_persona_get_contact (TpfPersona* self) {
	TpContact* result;
	TpContact* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_contact;
	result = _tmp0_;
	return result;
}


static void tpf_persona_set_contact (TpfPersona* self, TpContact* value) {
	TpContact* _tmp0_;
	TpContact* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_contact);
	self->priv->_contact = _tmp1_;
	g_object_notify ((GObject *) self, "contact");
}


static void tpf_persona_class_init (TpfPersonaClass * klass) {
	tpf_persona_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TpfPersonaPrivate));
	FOLKS_PERSONA_CLASS (klass)->get_linkable_properties = tpf_persona_real_get_linkable_properties;
	FOLKS_PERSONA_CLASS (klass)->get_writeable_properties = tpf_persona_real_get_writeable_properties;
	G_OBJECT_CLASS (klass)->get_property = _vala_tpf_persona_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tpf_persona_set_property;
	G_OBJECT_CLASS (klass)->finalize = tpf_persona_finalize;
	/**
	   * Whether the Persona is in the user's contact list.
	   *
	   * This will be true for most {@link Folks.Persona}s, but may not be true for
	   * personas where {@link Folks.Persona.is_user} is true. If it's false in
	   * this case, it means that the persona has been retrieved from the Telepathy
	   * connection, but has not been added to the user's contact list.
	   *
	   * @since 0.3.5
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_IS_IN_CONTACT_LIST, g_param_spec_boolean ("is-in-contact-list", "is-in-contact-list", "is-in-contact-list", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * An avatar for the Persona.
	   *
	   * See {@link Folks.AvatarDetails.avatar}.
	   *
	   * @since 0.6.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_AVATAR, "avatar");
	/**
	   * The Persona's presence type.
	   *
	   * See {@link Folks.PresenceDetails.presence_type}.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_PRESENCE_TYPE, "presence-type");
	/**
	   * The Persona's presence status.
	   *
	   * See {@link Folks.PresenceDetails.presence_status}.
	   *
	   * @since 0.6.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_PRESENCE_STATUS, "presence-status");
	/**
	   * The Persona's presence message.
	   *
	   * See {@link Folks.PresenceDetails.presence_message}.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_PRESENCE_MESSAGE, "presence-message");
	/**
	   * The names of the Persona's linkable properties.
	   *
	   * See {@link Folks.Persona.linkable_properties}.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_LINKABLE_PROPERTIES, "linkable-properties");
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_WRITEABLE_PROPERTIES, "writeable-properties");
	/**
	   * An alias for the Persona.
	   *
	   * See {@link Folks.AliasDetails.alias}.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_ALIAS, "alias");
	/**
	   * Whether this Persona is a user-defined favourite.
	   *
	   * See {@link Folks.FavouriteDetails.is_favourite}.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_IS_FAVOURITE, "is-favourite");
	/**
	   * A mapping of IM protocol to an (unordered) set of IM addresses.
	   *
	   * See {@link Folks.ImDetails.im_addresses}.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_IM_ADDRESSES, "im-addresses");
	/**
	   * A mapping of group ID to whether the contact is a member.
	   *
	   * See {@link Folks.GroupDetails.groups}.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_GROUPS, "groups");
	/**
	   * The Telepathy contact represented by this persona.
	   *
	   * Note that this may be `null` if the {@link PersonaStore} providing this
	   * {@link Persona} isn't currently available (e.g. due to not being connected
	   * to the network). In this case, most other properties of the {@link Persona}
	   * are being retrieved from a cache and may not be current (though there's no
	   * way to tell this).
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_CONTACT, g_param_spec_object ("contact", "contact", "contact", tp_contact_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void tpf_persona_folks_alias_details_interface_init (FolksAliasDetailsIface * iface) {
	tpf_persona_folks_alias_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_alias = tpf_persona_real_get_alias;
	iface->set_alias = tpf_persona_real_set_alias;
}


static void tpf_persona_folks_avatar_details_interface_init (FolksAvatarDetailsIface * iface) {
	tpf_persona_folks_avatar_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_avatar = tpf_persona_real_get_avatar;
	iface->set_avatar = tpf_persona_real_set_avatar;
}


static void tpf_persona_folks_favourite_details_interface_init (FolksFavouriteDetailsIface * iface) {
	tpf_persona_folks_favourite_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_is_favourite = tpf_persona_real_get_is_favourite;
	iface->set_is_favourite = tpf_persona_real_set_is_favourite;
}


static void tpf_persona_folks_group_details_interface_init (FolksGroupDetailsIface * iface) {
	tpf_persona_folks_group_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_group = (void (*)(FolksGroupDetails*, const gchar*, gboolean, GError**)) tpf_persona_real_change_group;
	iface->change_group_finish = tpf_persona_real_change_group_finish;
	iface->get_groups = tpf_persona_real_get_groups;
	iface->set_groups = tpf_persona_real_set_groups;
}


static void tpf_persona_folks_im_details_interface_init (FolksImDetailsIface * iface) {
	tpf_persona_folks_im_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_im_addresses = tpf_persona_real_get_im_addresses;
	iface->set_im_addresses = tpf_persona_real_set_im_addresses;
}


static void tpf_persona_folks_presence_details_interface_init (FolksPresenceDetailsIface * iface) {
	tpf_persona_folks_presence_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_presence_type = tpf_persona_real_get_presence_type;
	iface->set_presence_type = tpf_persona_real_set_presence_type;
	iface->get_presence_status = tpf_persona_real_get_presence_status;
	iface->set_presence_status = tpf_persona_real_set_presence_status;
	iface->get_presence_message = tpf_persona_real_get_presence_message;
	iface->set_presence_message = tpf_persona_real_set_presence_message;
}


static void tpf_persona_instance_init (TpfPersona * self) {
	self->priv = TPF_PERSONA_GET_PRIVATE (self);
	self->priv->_is_constructed = FALSE;
}


static void tpf_persona_finalize (GObject* obj) {
	TpfPersona * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	self = TPF_PERSONA (obj);
	_tmp0_ = folks_persona_get_uid ((FolksPersona*) self);
	_tmp1_ = _tmp0_;
	g_debug ("tpf-persona.vala:421: Destroying Tpf.Persona '%s': %p", _tmp1_, self);
	_g_object_unref0 (self->priv->_groups);
	_g_object_unref0 (self->priv->_groups_ro);
	_g_free0 (self->priv->_alias);
	_g_object_unref0 (self->priv->_im_addresses);
	_g_object_unref0 (self->priv->_avatar);
	_g_free0 (self->priv->_presence_status);
	_g_free0 (self->priv->_presence_message);
	_g_object_unref0 (self->priv->_contact);
	G_OBJECT_CLASS (tpf_persona_parent_class)->finalize (obj);
}


/**
 * A persona subclass which represents a single instant messaging contact from
 * Telepathy.
 */
GType tpf_persona_get_type (void) {
	static volatile gsize tpf_persona_type_id__volatile = 0;
	if (g_once_init_enter (&tpf_persona_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TpfPersonaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tpf_persona_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TpfPersona), 0, (GInstanceInitFunc) tpf_persona_instance_init, NULL };
		static const GInterfaceInfo folks_alias_details_info = { (GInterfaceInitFunc) tpf_persona_folks_alias_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_avatar_details_info = { (GInterfaceInitFunc) tpf_persona_folks_avatar_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_favourite_details_info = { (GInterfaceInitFunc) tpf_persona_folks_favourite_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_group_details_info = { (GInterfaceInitFunc) tpf_persona_folks_group_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_im_details_info = { (GInterfaceInitFunc) tpf_persona_folks_im_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_presence_details_info = { (GInterfaceInitFunc) tpf_persona_folks_presence_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType tpf_persona_type_id;
		tpf_persona_type_id = g_type_register_static (FOLKS_TYPE_PERSONA, "TpfPersona", &g_define_type_info, 0);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_ALIAS_DETAILS, &folks_alias_details_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_AVATAR_DETAILS, &folks_avatar_details_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_FAVOURITE_DETAILS, &folks_favourite_details_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_GROUP_DETAILS, &folks_group_details_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_IM_DETAILS, &folks_im_details_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_PRESENCE_DETAILS, &folks_presence_details_info);
		g_once_init_leave (&tpf_persona_type_id__volatile, tpf_persona_type_id);
	}
	return tpf_persona_type_id__volatile;
}


static void _vala_tpf_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TpfPersona * self;
	self = TPF_PERSONA (object);
	switch (property_id) {
		case TPF_PERSONA_IS_IN_CONTACT_LIST:
		g_value_set_boolean (value, tpf_persona_get_is_in_contact_list (self));
		break;
		case TPF_PERSONA_AVATAR:
		g_value_set_object (value, folks_avatar_details_get_avatar ((FolksAvatarDetails*) self));
		break;
		case TPF_PERSONA_PRESENCE_TYPE:
		g_value_set_enum (value, folks_presence_details_get_presence_type ((FolksPresenceDetails*) self));
		break;
		case TPF_PERSONA_PRESENCE_STATUS:
		g_value_set_string (value, folks_presence_details_get_presence_status ((FolksPresenceDetails*) self));
		break;
		case TPF_PERSONA_PRESENCE_MESSAGE:
		g_value_set_string (value, folks_presence_details_get_presence_message ((FolksPresenceDetails*) self));
		break;
		case TPF_PERSONA_LINKABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_get_linkable_properties ((FolksPersona*) self, &length));
		}
		break;
		case TPF_PERSONA_WRITEABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_get_writeable_properties ((FolksPersona*) self, &length));
		}
		break;
		case TPF_PERSONA_ALIAS:
		g_value_set_string (value, folks_alias_details_get_alias ((FolksAliasDetails*) self));
		break;
		case TPF_PERSONA_IS_FAVOURITE:
		g_value_set_boolean (value, folks_favourite_details_get_is_favourite ((FolksFavouriteDetails*) self));
		break;
		case TPF_PERSONA_IM_ADDRESSES:
		g_value_set_object (value, folks_im_details_get_im_addresses ((FolksImDetails*) self));
		break;
		case TPF_PERSONA_GROUPS:
		g_value_set_object (value, folks_group_details_get_groups ((FolksGroupDetails*) self));
		break;
		case TPF_PERSONA_CONTACT:
		g_value_set_object (value, tpf_persona_get_contact (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_tpf_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TpfPersona * self;
	self = TPF_PERSONA (object);
	switch (property_id) {
		case TPF_PERSONA_IS_IN_CONTACT_LIST:
		tpf_persona_set_is_in_contact_list (self, g_value_get_boolean (value));
		break;
		case TPF_PERSONA_AVATAR:
		folks_avatar_details_set_avatar ((FolksAvatarDetails*) self, g_value_get_object (value));
		break;
		case TPF_PERSONA_PRESENCE_TYPE:
		folks_presence_details_set_presence_type ((FolksPresenceDetails*) self, g_value_get_enum (value));
		break;
		case TPF_PERSONA_PRESENCE_STATUS:
		folks_presence_details_set_presence_status ((FolksPresenceDetails*) self, g_value_get_string (value));
		break;
		case TPF_PERSONA_PRESENCE_MESSAGE:
		folks_presence_details_set_presence_message ((FolksPresenceDetails*) self, g_value_get_string (value));
		break;
		case TPF_PERSONA_ALIAS:
		folks_alias_details_set_alias ((FolksAliasDetails*) self, g_value_get_string (value));
		break;
		case TPF_PERSONA_IS_FAVOURITE:
		folks_favourite_details_set_is_favourite ((FolksFavouriteDetails*) self, g_value_get_boolean (value));
		break;
		case TPF_PERSONA_IM_ADDRESSES:
		folks_im_details_set_im_addresses ((FolksImDetails*) self, g_value_get_object (value));
		break;
		case TPF_PERSONA_GROUPS:
		folks_group_details_set_groups ((FolksGroupDetails*) self, g_value_get_object (value));
		break;
		case TPF_PERSONA_CONTACT:
		tpf_persona_set_contact (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



