/* utils.c generated by valac 0.12.0, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <folks/folks.h>
#include <stdarg.h>
#include <stdio.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define FOLKS_INSPECT_TYPE_UTILS (folks_inspect_utils_get_type ())
#define FOLKS_INSPECT_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_UTILS, FolksInspectUtils))
#define FOLKS_INSPECT_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_UTILS, FolksInspectUtilsClass))
#define FOLKS_INSPECT_IS_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_UTILS))
#define FOLKS_INSPECT_IS_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_UTILS))
#define FOLKS_INSPECT_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_UTILS, FolksInspectUtilsClass))

typedef struct _FolksInspectUtils FolksInspectUtils;
typedef struct _FolksInspectUtilsClass FolksInspectUtilsClass;
typedef struct _FolksInspectUtilsPrivate FolksInspectUtilsPrivate;

#define FOLKS_INSPECT_TYPE_COMMAND (folks_inspect_command_get_type ())
#define FOLKS_INSPECT_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommand))
#define FOLKS_INSPECT_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))
#define FOLKS_INSPECT_IS_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_IS_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_COMMAND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))

typedef struct _FolksInspectCommand FolksInspectCommand;
typedef struct _FolksInspectCommandClass FolksInspectCommandClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define FOLKS_INSPECT_TYPE_CLIENT (folks_inspect_client_get_type ())
#define FOLKS_INSPECT_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClient))
#define FOLKS_INSPECT_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))
#define FOLKS_INSPECT_IS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_IS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))

typedef struct _FolksInspectClient FolksInspectClient;
typedef struct _FolksInspectClientClass FolksInspectClientClass;
typedef struct _FolksInspectClientPrivate FolksInspectClientPrivate;
typedef struct _FolksInspectParamSpecUtils FolksInspectParamSpecUtils;

struct _FolksInspectUtils {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FolksInspectUtilsPrivate * priv;
};

struct _FolksInspectUtilsClass {
	GTypeClass parent_class;
	void (*finalize) (FolksInspectUtils *self);
};

struct _FolksInspectClient {
	GObject parent_instance;
	FolksInspectClientPrivate * priv;
	GeeHashMap* commands;
};

struct _FolksInspectClientClass {
	GObjectClass parent_class;
};

struct _FolksInspectParamSpecUtils {
	GParamSpec parent_instance;
};


static gpointer folks_inspect_utils_parent_class = NULL;
static guint folks_inspect_utils_indentation;
static guint folks_inspect_utils_indentation = (guint) 0;
static gchar* folks_inspect_utils_indentation_string;
static gchar* folks_inspect_utils_indentation_string = NULL;
static GeeMapIterator* folks_inspect_utils_command_name_iter;
static GeeMapIterator* folks_inspect_utils_command_name_iter = NULL;
static GeeMapIterator* folks_inspect_utils_individual_id_iter;
static GeeMapIterator* folks_inspect_utils_individual_id_iter = NULL;
static GeeIterator* folks_inspect_utils_persona_uid_iter;
static GeeIterator* folks_inspect_utils_persona_uid_iter = NULL;
static GeeIterator* folks_inspect_utils_backend_name_iter;
static GeeIterator* folks_inspect_utils_backend_name_iter = NULL;
static GeeMapIterator* folks_inspect_utils_persona_store_id_iter;
static GeeMapIterator* folks_inspect_utils_persona_store_id_iter = NULL;
extern FolksInspectClient* main_client;

gpointer folks_inspect_utils_ref (gpointer instance);
void folks_inspect_utils_unref (gpointer instance);
GParamSpec* folks_inspect_param_spec_utils (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void folks_inspect_value_set_utils (GValue* value, gpointer v_object);
void folks_inspect_value_take_utils (GValue* value, gpointer v_object);
gpointer folks_inspect_value_get_utils (const GValue* value);
GType folks_inspect_utils_get_type (void) G_GNUC_CONST;
enum  {
	FOLKS_INSPECT_UTILS_DUMMY_PROPERTY
};
gpointer folks_inspect_command_ref (gpointer instance);
void folks_inspect_command_unref (gpointer instance);
GParamSpec* folks_inspect_param_spec_command (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void folks_inspect_value_set_command (GValue* value, gpointer v_object);
void folks_inspect_value_take_command (GValue* value, gpointer v_object);
gpointer folks_inspect_value_get_command (const GValue* value);
GType folks_inspect_command_get_type (void) G_GNUC_CONST;
void folks_inspect_utils_init (void);
static void folks_inspect_utils_transform_object_to_string (GValue* src, GValue* dest);
static void _folks_inspect_utils_transform_object_to_string_gvalue_transform (GValue* src_value, GValue* dest_value);
static void folks_inspect_utils_transform_persona_store_to_string (GValue* src, GValue* dest);
static void _folks_inspect_utils_transform_persona_store_to_string_gvalue_transform (GValue* src_value, GValue* dest_value);
static void folks_inspect_utils_transform_string_array_to_string (GValue* src, GValue* dest);
static void _folks_inspect_utils_transform_string_array_to_string_gvalue_transform (GValue* src_value, GValue* dest_value);
void folks_inspect_utils_indent (void);
void folks_inspect_utils_unindent (void);
void folks_inspect_utils_print_line (const gchar* format, ...);
void folks_inspect_utils_print_individual (FolksIndividual* individual, gboolean show_personas);
static gchar* folks_inspect_utils_property_to_string (GType object_type, const gchar* prop_name, GValue* prop_value);
void folks_inspect_utils_print_persona (FolksPersona* persona);
void folks_inspect_utils_print_persona_store (FolksPersonaStore* store, gboolean show_personas);
gchar* folks_inspect_utils_transform_value_to_string (GValue* prop_value);
gchar* folks_inspect_utils_command_name_completion_cb (const gchar* word, gint state);
GType folks_inspect_client_get_type (void) G_GNUC_CONST;
gchar* folks_inspect_utils_individual_id_completion_cb (const gchar* word, gint state);
FolksIndividualAggregator* folks_inspect_client_get_aggregator (FolksInspectClient* self);
gchar* folks_inspect_utils_persona_uid_completion_cb (const gchar* word, gint state);
gchar* folks_inspect_utils_backend_name_completion_cb (const gchar* word, gint state);
FolksBackendStore* folks_inspect_client_get_backend_store (FolksInspectClient* self);
gchar* folks_inspect_utils_persona_store_id_completion_cb (const gchar* word, gint state);
FolksInspectUtils* folks_inspect_utils_new (void);
FolksInspectUtils* folks_inspect_utils_construct (GType object_type);
static void folks_inspect_utils_finalize (FolksInspectUtils* obj);


static void _folks_inspect_utils_transform_object_to_string_gvalue_transform (GValue* src_value, GValue* dest_value) {
	folks_inspect_utils_transform_object_to_string (src_value, dest_value);
}


static void _folks_inspect_utils_transform_persona_store_to_string_gvalue_transform (GValue* src_value, GValue* dest_value) {
	folks_inspect_utils_transform_persona_store_to_string (src_value, dest_value);
}


static void _folks_inspect_utils_transform_string_array_to_string_gvalue_transform (GValue* src_value, GValue* dest_value) {
	folks_inspect_utils_transform_string_array_to_string (src_value, dest_value);
}


void folks_inspect_utils_init (void) {
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("");
	_g_free0 (folks_inspect_utils_indentation_string);
	folks_inspect_utils_indentation_string = _tmp0_;
	g_value_register_transform_func (G_TYPE_OBJECT, G_TYPE_STRING, _folks_inspect_utils_transform_object_to_string_gvalue_transform);
	g_value_register_transform_func (FOLKS_TYPE_PERSONA_STORE, G_TYPE_STRING, _folks_inspect_utils_transform_persona_store_to_string_gvalue_transform);
	g_value_register_transform_func (G_TYPE_STRV, G_TYPE_STRING, _folks_inspect_utils_transform_string_array_to_string_gvalue_transform);
}


static void folks_inspect_utils_transform_object_to_string (GValue* src, GValue* dest) {
	GValue _dest = {0};
	GValue dest_tmp = {0};
	GObject* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GValue _tmp2_;
	GValue _tmp3_ = {0};
	g_value_init (&dest_tmp, G_TYPE_STRING);
	_tmp0_ = g_value_get_object (src);
	_tmp1_ = g_strdup_printf ("%p", _tmp0_);
	g_value_take_string (&dest_tmp, _tmp1_);
	if (G_IS_VALUE (&dest_tmp)) {
		g_value_init (&_tmp3_, G_VALUE_TYPE (&dest_tmp));
		g_value_copy (&dest_tmp, &_tmp3_);
	} else {
		_tmp3_ = dest_tmp;
	}
	_tmp2_ = _tmp3_;
	G_IS_VALUE (&_dest) ? (g_value_unset (&_dest), NULL) : NULL;
	_dest = _tmp2_;
	G_IS_VALUE (&dest_tmp) ? (g_value_unset (&dest_tmp), NULL) : NULL;
	if (dest) {
		*dest = _dest;
	} else {
		G_IS_VALUE (&_dest) ? (g_value_unset (&_dest), NULL) : NULL;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void folks_inspect_utils_transform_persona_store_to_string (GValue* src, GValue* dest) {
	GValue _dest = {0};
	GValue dest_tmp = {0};
	GObject* _tmp0_ = NULL;
	FolksPersonaStore* _tmp1_;
	FolksPersonaStore* store;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GValue _tmp6_;
	GValue _tmp7_ = {0};
	g_value_init (&dest_tmp, G_TYPE_STRING);
	_tmp0_ = g_value_get_object (src);
	_tmp1_ = _g_object_ref0 (FOLKS_PERSONA_STORE (_tmp0_));
	store = _tmp1_;
	_tmp2_ = folks_persona_store_get_type_id (store);
	_tmp3_ = folks_persona_store_get_id (store);
	_tmp4_ = folks_persona_store_get_display_name (store);
	_tmp5_ = g_strdup_printf ("%p: %s, %s (%s)", store, _tmp2_, _tmp3_, _tmp4_);
	g_value_take_string (&dest_tmp, _tmp5_);
	if (G_IS_VALUE (&dest_tmp)) {
		g_value_init (&_tmp7_, G_VALUE_TYPE (&dest_tmp));
		g_value_copy (&dest_tmp, &_tmp7_);
	} else {
		_tmp7_ = dest_tmp;
	}
	_tmp6_ = _tmp7_;
	G_IS_VALUE (&_dest) ? (g_value_unset (&_dest), NULL) : NULL;
	_dest = _tmp6_;
	_g_object_unref0 (store);
	G_IS_VALUE (&dest_tmp) ? (g_value_unset (&dest_tmp), NULL) : NULL;
	if (dest) {
		*dest = _dest;
	} else {
		G_IS_VALUE (&_dest) ? (g_value_unset (&_dest), NULL) : NULL;
	}
}


static void folks_inspect_utils_transform_string_array_to_string (GValue* src, GValue* dest) {
	GValue _dest = {0};
	GValue dest_tmp = {0};
	void* _tmp0_ = NULL;
	gchar** array;
	gint array_length1;
	gint _array_size_;
	gchar* _tmp1_;
	gchar* output;
	gboolean first;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GValue _tmp9_;
	GValue _tmp10_ = {0};
	g_value_init (&dest_tmp, G_TYPE_STRING);
	_tmp0_ = g_value_get_boxed (src);
	array = (gchar**) _tmp0_;
	array_length1 = -1;
	_array_size_ = -1;
	_tmp1_ = g_strdup ("{ ");
	output = _tmp1_;
	first = TRUE;
	{
		gchar** element_collection;
		int element_collection_length1;
		int element_it;
		element_collection = array;
		element_collection_length1 = array_length1;
		for (element_it = 0; element_it < array_length1; element_it = element_it + 1) {
			gchar* _tmp2_;
			gchar* element;
			_tmp2_ = g_strdup (element_collection[element_it]);
			element = _tmp2_;
			{
				gchar* _tmp4_ = NULL;
				gchar* _tmp5_;
				gchar* _tmp6_;
				if (first == FALSE) {
					gchar* _tmp3_;
					_tmp3_ = g_strconcat (output, ", ", NULL);
					_g_free0 (output);
					output = _tmp3_;
				}
				_tmp4_ = g_strdup_printf ("'%s'", element);
				_tmp5_ = _tmp4_;
				_tmp6_ = g_strconcat (output, _tmp5_, NULL);
				_g_free0 (output);
				output = _tmp6_;
				_g_free0 (_tmp5_);
				first = FALSE;
				_g_free0 (element);
			}
		}
	}
	_tmp7_ = g_strconcat (output, " }", NULL);
	_g_free0 (output);
	output = _tmp7_;
	_tmp8_ = g_strdup (output);
	g_value_take_string (&dest_tmp, _tmp8_);
	if (G_IS_VALUE (&dest_tmp)) {
		g_value_init (&_tmp10_, G_VALUE_TYPE (&dest_tmp));
		g_value_copy (&dest_tmp, &_tmp10_);
	} else {
		_tmp10_ = dest_tmp;
	}
	_tmp9_ = _tmp10_;
	G_IS_VALUE (&_dest) ? (g_value_unset (&_dest), NULL) : NULL;
	_dest = _tmp9_;
	_g_free0 (output);
	G_IS_VALUE (&dest_tmp) ? (g_value_unset (&dest_tmp), NULL) : NULL;
	if (dest) {
		*dest = _dest;
	} else {
		G_IS_VALUE (&_dest) ? (g_value_unset (&_dest), NULL) : NULL;
	}
}


void folks_inspect_utils_indent (void) {
	gchar* _tmp0_ = NULL;
	folks_inspect_utils_indentation = folks_inspect_utils_indentation + ((guint) 2);
	_tmp0_ = g_strnfill ((gsize) folks_inspect_utils_indentation, ' ');
	_g_free0 (folks_inspect_utils_indentation_string);
	folks_inspect_utils_indentation_string = _tmp0_;
}


void folks_inspect_utils_unindent (void) {
	gchar* _tmp0_ = NULL;
	folks_inspect_utils_indentation = folks_inspect_utils_indentation - ((guint) 2);
	_tmp0_ = g_strnfill ((gsize) folks_inspect_utils_indentation, ' ');
	_g_free0 (folks_inspect_utils_indentation_string);
	folks_inspect_utils_indentation_string = _tmp0_;
}


void folks_inspect_utils_print_line (const gchar* format, ...) {
	va_list valist;
	gchar* _tmp0_ = NULL;
	gchar* output;
	g_return_if_fail (format != NULL);
	va_start (valist, format);
	_tmp0_ = g_strdup_vprintf (format, valist);
	output = _tmp0_;
	fprintf (stdout, "%s%s\n", folks_inspect_utils_indentation_string, output);
	_g_free0 (output);
	va_end (valist);
}


void folks_inspect_utils_print_individual (FolksIndividual* individual, gboolean show_personas) {
	const gchar* _tmp0_ = NULL;
	GeeSet* _tmp1_ = NULL;
	gint _tmp2_;
	GObjectClass* _tmp3_ = NULL;
	guint _tmp4_;
	GParamSpec** _tmp5_ = NULL;
	GParamSpec** properties;
	gint properties_length1;
	gint _properties_size_;
	g_return_if_fail (individual != NULL);
	_tmp0_ = folks_individual_get_id (individual);
	_tmp1_ = folks_individual_get_personas (individual);
	_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
	folks_inspect_utils_print_line ("Individual '%s' with %u personas:", _tmp0_, (guint) _tmp2_);
	_tmp3_ = G_OBJECT_GET_CLASS ((GObject*) individual);
	_tmp5_ = g_object_class_list_properties (_tmp3_, &_tmp4_);
	properties = _tmp5_;
	properties_length1 = _tmp4_;
	_properties_size_ = _tmp4_;
	folks_inspect_utils_indent ();
	{
		GParamSpec** pspec_collection;
		int pspec_collection_length1;
		int pspec_it;
		pspec_collection = properties;
		pspec_collection_length1 = properties_length1;
		for (pspec_it = 0; pspec_it < properties_length1; pspec_it = pspec_it + 1) {
			GParamSpec* pspec;
			pspec = pspec_collection[pspec_it];
			{
				GValue prop_value = {0};
				gchar* output_string = NULL;
				gboolean _tmp6_ = FALSE;
				GValue _tmp8_ = {0};
				GValue _tmp9_ = {0};
				const gchar* _tmp10_ = NULL;
				GType _tmp11_;
				const gchar* _tmp12_ = NULL;
				gchar* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				if (show_personas == TRUE) {
					const gchar* _tmp7_ = NULL;
					_tmp7_ = g_param_spec_get_name (pspec);
					_tmp6_ = g_strcmp0 (_tmp7_, "personas") == 0;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					_g_free0 (output_string);
					G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
					continue;
				}
				g_value_init (&_tmp8_, pspec->value_type);
				_tmp9_ = _tmp8_;
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
				prop_value = _tmp9_;
				_tmp10_ = g_param_spec_get_name (pspec);
				g_object_get_property ((GObject*) individual, _tmp10_, &prop_value);
				_tmp11_ = G_TYPE_FROM_INSTANCE ((GObject*) individual);
				_tmp12_ = g_param_spec_get_name (pspec);
				_tmp13_ = folks_inspect_utils_property_to_string (_tmp11_, _tmp12_, &prop_value);
				_g_free0 (output_string);
				output_string = _tmp13_;
				_tmp14_ = g_param_spec_get_nick (pspec);
				folks_inspect_utils_print_line ("%-20s  %s", _tmp14_, output_string);
				_g_free0 (output_string);
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
			}
		}
	}
	if (show_personas == TRUE) {
		folks_inspect_utils_print_line ("");
		folks_inspect_utils_print_line ("Personas:");
		folks_inspect_utils_indent ();
		{
			GeeSet* _tmp15_ = NULL;
			GeeIterator* _tmp16_ = NULL;
			GeeIterator* _persona_it;
			_tmp15_ = folks_individual_get_personas (individual);
			_tmp16_ = gee_iterable_iterator ((GeeIterable*) _tmp15_);
			_persona_it = _tmp16_;
			while (TRUE) {
				gboolean _tmp17_;
				gpointer _tmp18_ = NULL;
				FolksPersona* persona;
				_tmp17_ = gee_iterator_next (_persona_it);
				if (!_tmp17_) {
					break;
				}
				_tmp18_ = gee_iterator_get (_persona_it);
				persona = (FolksPersona*) _tmp18_;
				folks_inspect_utils_print_persona (persona);
				_g_object_unref0 (persona);
			}
			_g_object_unref0 (_persona_it);
		}
		folks_inspect_utils_unindent ();
	}
	folks_inspect_utils_unindent ();
}


void folks_inspect_utils_print_persona (FolksPersona* persona) {
	const gchar* _tmp0_ = NULL;
	GObjectClass* _tmp1_ = NULL;
	guint _tmp2_;
	GParamSpec** _tmp3_ = NULL;
	GParamSpec** properties;
	gint properties_length1;
	gint _properties_size_;
	g_return_if_fail (persona != NULL);
	_tmp0_ = folks_persona_get_uid (persona);
	folks_inspect_utils_print_line ("Persona '%s':", _tmp0_);
	_tmp1_ = G_OBJECT_GET_CLASS ((GObject*) persona);
	_tmp3_ = g_object_class_list_properties (_tmp1_, &_tmp2_);
	properties = _tmp3_;
	properties_length1 = _tmp2_;
	_properties_size_ = _tmp2_;
	folks_inspect_utils_indent ();
	{
		GParamSpec** pspec_collection;
		int pspec_collection_length1;
		int pspec_it;
		pspec_collection = properties;
		pspec_collection_length1 = properties_length1;
		for (pspec_it = 0; pspec_it < properties_length1; pspec_it = pspec_it + 1) {
			GParamSpec* pspec;
			pspec = pspec_collection[pspec_it];
			{
				GValue prop_value = {0};
				gchar* output_string = NULL;
				GValue _tmp4_ = {0};
				GValue _tmp5_ = {0};
				const gchar* _tmp6_ = NULL;
				GType _tmp7_;
				const gchar* _tmp8_ = NULL;
				gchar* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				g_value_init (&_tmp4_, pspec->value_type);
				_tmp5_ = _tmp4_;
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
				prop_value = _tmp5_;
				_tmp6_ = g_param_spec_get_name (pspec);
				g_object_get_property ((GObject*) persona, _tmp6_, &prop_value);
				_tmp7_ = G_TYPE_FROM_INSTANCE ((GObject*) persona);
				_tmp8_ = g_param_spec_get_name (pspec);
				_tmp9_ = folks_inspect_utils_property_to_string (_tmp7_, _tmp8_, &prop_value);
				_g_free0 (output_string);
				output_string = _tmp9_;
				_tmp10_ = g_param_spec_get_nick (pspec);
				folks_inspect_utils_print_line ("%-20s  %s", _tmp10_, output_string);
				_g_free0 (output_string);
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
			}
		}
	}
	folks_inspect_utils_unindent ();
}


void folks_inspect_utils_print_persona_store (FolksPersonaStore* store, gboolean show_personas) {
	const gchar* _tmp0_ = NULL;
	GeeMap* _tmp1_ = NULL;
	gint _tmp2_;
	GObjectClass* _tmp3_ = NULL;
	guint _tmp4_;
	GParamSpec** _tmp5_ = NULL;
	GParamSpec** properties;
	gint properties_length1;
	gint _properties_size_;
	g_return_if_fail (store != NULL);
	_tmp0_ = folks_persona_store_get_id (store);
	_tmp1_ = folks_persona_store_get_personas (store);
	_tmp2_ = gee_map_get_size (_tmp1_);
	folks_inspect_utils_print_line ("Persona store '%s' with %u personas:", _tmp0_, (guint) _tmp2_);
	_tmp3_ = G_OBJECT_GET_CLASS ((GObject*) store);
	_tmp5_ = g_object_class_list_properties (_tmp3_, &_tmp4_);
	properties = _tmp5_;
	properties_length1 = _tmp4_;
	_properties_size_ = _tmp4_;
	folks_inspect_utils_indent ();
	{
		GParamSpec** pspec_collection;
		int pspec_collection_length1;
		int pspec_it;
		pspec_collection = properties;
		pspec_collection_length1 = properties_length1;
		for (pspec_it = 0; pspec_it < properties_length1; pspec_it = pspec_it + 1) {
			GParamSpec* pspec;
			pspec = pspec_collection[pspec_it];
			{
				GValue prop_value = {0};
				gchar* output_string = NULL;
				gboolean _tmp6_ = FALSE;
				GValue _tmp8_ = {0};
				GValue _tmp9_ = {0};
				const gchar* _tmp10_ = NULL;
				GType _tmp11_;
				const gchar* _tmp12_ = NULL;
				gchar* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				if (show_personas == TRUE) {
					const gchar* _tmp7_ = NULL;
					_tmp7_ = g_param_spec_get_name (pspec);
					_tmp6_ = g_strcmp0 (_tmp7_, "personas") == 0;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					_g_free0 (output_string);
					G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
					continue;
				}
				g_value_init (&_tmp8_, pspec->value_type);
				_tmp9_ = _tmp8_;
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
				prop_value = _tmp9_;
				_tmp10_ = g_param_spec_get_name (pspec);
				g_object_get_property ((GObject*) store, _tmp10_, &prop_value);
				_tmp11_ = G_TYPE_FROM_INSTANCE ((GObject*) store);
				_tmp12_ = g_param_spec_get_name (pspec);
				_tmp13_ = folks_inspect_utils_property_to_string (_tmp11_, _tmp12_, &prop_value);
				_g_free0 (output_string);
				output_string = _tmp13_;
				_tmp14_ = g_param_spec_get_nick (pspec);
				folks_inspect_utils_print_line ("%-20s  %s", _tmp14_, output_string);
				_g_free0 (output_string);
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
			}
		}
	}
	if (show_personas == TRUE) {
		folks_inspect_utils_print_line ("");
		folks_inspect_utils_print_line ("Personas:");
		folks_inspect_utils_indent ();
		{
			GeeMap* _tmp15_ = NULL;
			GeeCollection* _tmp16_ = NULL;
			GeeCollection* _tmp17_;
			GeeIterator* _tmp18_ = NULL;
			GeeIterator* _tmp19_;
			GeeIterator* _persona_it;
			_tmp15_ = folks_persona_store_get_personas (store);
			_tmp16_ = gee_map_get_values (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = gee_iterable_iterator ((GeeIterable*) _tmp17_);
			_tmp19_ = _tmp18_;
			_g_object_unref0 (_tmp17_);
			_persona_it = _tmp19_;
			while (TRUE) {
				gboolean _tmp20_;
				gpointer _tmp21_ = NULL;
				FolksPersona* persona;
				_tmp20_ = gee_iterator_next (_persona_it);
				if (!_tmp20_) {
					break;
				}
				_tmp21_ = gee_iterator_get (_persona_it);
				persona = (FolksPersona*) _tmp21_;
				folks_inspect_utils_print_persona (persona);
				_g_object_unref0 (persona);
			}
			_g_object_unref0 (_persona_it);
		}
		folks_inspect_utils_unindent ();
	}
	folks_inspect_utils_unindent ();
}


static gchar* g_date_time_to_string (GDateTime* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}


static gchar* folks_inspect_utils_property_to_string (GType object_type, const gchar* prop_name, GValue* prop_value) {
	gchar* result = NULL;
	gchar* output_string = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gchar* _tmp123_ = NULL;
	g_return_val_if_fail (prop_name != NULL, NULL);
	_tmp1_ = g_type_is_a (object_type, FOLKS_TYPE_INDIVIDUAL);
	if (_tmp1_) {
		_tmp0_ = g_strcmp0 (prop_name, "personas") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GObject* _tmp2_ = NULL;
		GeeSet* _tmp3_;
		GeeSet* personas;
		gint _tmp4_;
		gchar* _tmp5_ = NULL;
		_tmp2_ = g_value_get_object (prop_value);
		_tmp3_ = _g_object_ref0 (GEE_SET (_tmp2_));
		personas = _tmp3_;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) personas);
		_tmp5_ = g_strdup_printf ("List of %u personas", (guint) _tmp4_);
		result = _tmp5_;
		_g_object_unref0 (personas);
		_g_free0 (output_string);
		return result;
	} else {
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_;
		_tmp7_ = g_type_is_a (object_type, FOLKS_TYPE_PERSONA_STORE);
		if (_tmp7_) {
			_tmp6_ = g_strcmp0 (prop_name, "personas") == 0;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			GObject* _tmp8_ = NULL;
			GeeMap* _tmp9_;
			GeeMap* personas;
			gint _tmp10_;
			gchar* _tmp11_ = NULL;
			_tmp8_ = g_value_get_object (prop_value);
			_tmp9_ = _g_object_ref0 (GEE_MAP (_tmp8_));
			personas = _tmp9_;
			_tmp10_ = gee_map_get_size (personas);
			_tmp11_ = g_strdup_printf ("Set of %u personas", (guint) _tmp10_);
			result = _tmp11_;
			_g_object_unref0 (personas);
			_g_free0 (output_string);
			return result;
		} else {
			gboolean _tmp12_ = FALSE;
			if (g_strcmp0 (prop_name, "groups") == 0) {
				_tmp12_ = TRUE;
			} else {
				_tmp12_ = g_strcmp0 (prop_name, "local-ids") == 0;
			}
			if (_tmp12_) {
				GObject* _tmp13_ = NULL;
				GeeSet* _tmp14_;
				GeeSet* groups;
				gchar* _tmp15_;
				gboolean first;
				gchar* _tmp23_;
				_tmp13_ = g_value_get_object (prop_value);
				_tmp14_ = _g_object_ref0 (GEE_SET (_tmp13_));
				groups = _tmp14_;
				_tmp15_ = g_strdup ("{ ");
				_g_free0 (output_string);
				output_string = _tmp15_;
				first = TRUE;
				{
					GeeIterator* _tmp16_ = NULL;
					GeeIterator* _group_it;
					_tmp16_ = gee_iterable_iterator ((GeeIterable*) groups);
					_group_it = _tmp16_;
					while (TRUE) {
						gboolean _tmp17_;
						gpointer _tmp18_ = NULL;
						gchar* group;
						gchar* _tmp20_ = NULL;
						gchar* _tmp21_;
						gchar* _tmp22_;
						_tmp17_ = gee_iterator_next (_group_it);
						if (!_tmp17_) {
							break;
						}
						_tmp18_ = gee_iterator_get (_group_it);
						group = (gchar*) _tmp18_;
						if (first == FALSE) {
							gchar* _tmp19_;
							_tmp19_ = g_strconcat (output_string, ", ", NULL);
							_g_free0 (output_string);
							output_string = _tmp19_;
						}
						_tmp20_ = g_strdup_printf ("'%s'", group);
						_tmp21_ = _tmp20_;
						_tmp22_ = g_strconcat (output_string, _tmp21_, NULL);
						_g_free0 (output_string);
						output_string = _tmp22_;
						_g_free0 (_tmp21_);
						first = FALSE;
						_g_free0 (group);
					}
					_g_object_unref0 (_group_it);
				}
				_tmp23_ = g_strconcat (output_string, " }", NULL);
				_g_free0 (output_string);
				output_string = _tmp23_;
				result = output_string;
				_g_object_unref0 (groups);
				return result;
			} else {
				if (g_strcmp0 (prop_name, "avatar") == 0) {
					gchar* ret;
					GObject* _tmp24_ = NULL;
					GFile* _tmp25_;
					GFile* avatar;
					ret = NULL;
					_tmp24_ = g_value_get_object (prop_value);
					_tmp25_ = _g_object_ref0 (G_FILE (_tmp24_));
					avatar = _tmp25_;
					if (avatar != NULL) {
						gchar* _tmp26_ = NULL;
						_tmp26_ = g_file_get_uri (avatar);
						_g_free0 (ret);
						ret = _tmp26_;
					}
					result = ret;
					_g_object_unref0 (avatar);
					_g_free0 (output_string);
					return result;
				} else {
					if (g_strcmp0 (prop_name, "im-addresses") == 0) {
						GObject* _tmp27_ = NULL;
						GeeMultiMap* _tmp28_;
						GeeMultiMap* im_addresses;
						gchar* _tmp29_;
						gboolean first;
						gchar* _tmp49_;
						_tmp27_ = g_value_get_object (prop_value);
						_tmp28_ = _g_object_ref0 (GEE_MULTI_MAP (_tmp27_));
						im_addresses = _tmp28_;
						_tmp29_ = g_strdup ("{ ");
						_g_free0 (output_string);
						output_string = _tmp29_;
						first = TRUE;
						{
							GeeSet* _tmp30_ = NULL;
							GeeSet* _tmp31_;
							GeeIterator* _tmp32_ = NULL;
							GeeIterator* _tmp33_;
							GeeIterator* _protocol_it;
							_tmp30_ = gee_multi_map_get_keys (im_addresses);
							_tmp31_ = _tmp30_;
							_tmp32_ = gee_iterable_iterator ((GeeIterable*) _tmp31_);
							_tmp33_ = _tmp32_;
							_g_object_unref0 (_tmp31_);
							_protocol_it = _tmp33_;
							while (TRUE) {
								gboolean _tmp34_;
								gpointer _tmp35_ = NULL;
								gchar* protocol;
								gchar* _tmp37_ = NULL;
								gchar* _tmp38_;
								gchar* _tmp39_;
								GeeCollection* _tmp40_ = NULL;
								GeeCollection* addresses;
								gboolean _first;
								gchar* _tmp48_;
								_tmp34_ = gee_iterator_next (_protocol_it);
								if (!_tmp34_) {
									break;
								}
								_tmp35_ = gee_iterator_get (_protocol_it);
								protocol = (gchar*) _tmp35_;
								if (first == FALSE) {
									gchar* _tmp36_;
									_tmp36_ = g_strconcat (output_string, ", ", NULL);
									_g_free0 (output_string);
									output_string = _tmp36_;
								}
								_tmp37_ = g_strdup_printf ("'%s' : { ", protocol);
								_tmp38_ = _tmp37_;
								_tmp39_ = g_strconcat (output_string, _tmp38_, NULL);
								_g_free0 (output_string);
								output_string = _tmp39_;
								_g_free0 (_tmp38_);
								first = FALSE;
								_tmp40_ = gee_multi_map_get (im_addresses, protocol);
								addresses = _tmp40_;
								_first = TRUE;
								{
									GeeIterator* _tmp41_ = NULL;
									GeeIterator* _a_it;
									_tmp41_ = gee_iterable_iterator ((GeeIterable*) addresses);
									_a_it = _tmp41_;
									while (TRUE) {
										gboolean _tmp42_;
										gpointer _tmp43_ = NULL;
										gchar* a;
										gchar* _tmp45_ = NULL;
										gchar* _tmp46_;
										gchar* _tmp47_;
										_tmp42_ = gee_iterator_next (_a_it);
										if (!_tmp42_) {
											break;
										}
										_tmp43_ = gee_iterator_get (_a_it);
										a = (gchar*) _tmp43_;
										if (_first == FALSE) {
											gchar* _tmp44_;
											_tmp44_ = g_strconcat (output_string, ", ", NULL);
											_g_free0 (output_string);
											output_string = _tmp44_;
										}
										_tmp45_ = g_strdup_printf ("'%s'", (const gchar*) a);
										_tmp46_ = _tmp45_;
										_tmp47_ = g_strconcat (output_string, _tmp46_, NULL);
										_g_free0 (output_string);
										output_string = _tmp47_;
										_g_free0 (_tmp46_);
										_first = FALSE;
										_g_free0 (a);
									}
									_g_object_unref0 (_a_it);
								}
								_tmp48_ = g_strconcat (output_string, " }", NULL);
								_g_free0 (output_string);
								output_string = _tmp48_;
								_g_object_unref0 (addresses);
								_g_free0 (protocol);
							}
							_g_object_unref0 (_protocol_it);
						}
						_tmp49_ = g_strconcat (output_string, " }", NULL);
						_g_free0 (output_string);
						output_string = _tmp49_;
						result = output_string;
						_g_object_unref0 (im_addresses);
						return result;
					} else {
						const gchar* _tmp50_ = NULL;
						_tmp50_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_WEB_SERVICE_ADDRESSES);
						if (g_strcmp0 (prop_name, _tmp50_) == 0) {
							GObject* _tmp51_ = NULL;
							GeeMultiMap* _tmp52_;
							GeeMultiMap* web_service_addresses;
							gchar* _tmp53_;
							gboolean first;
							gchar* _tmp73_;
							_tmp51_ = g_value_get_object (prop_value);
							_tmp52_ = _g_object_ref0 (GEE_MULTI_MAP (_tmp51_));
							web_service_addresses = _tmp52_;
							_tmp53_ = g_strdup ("{ ");
							_g_free0 (output_string);
							output_string = _tmp53_;
							first = TRUE;
							{
								GeeSet* _tmp54_ = NULL;
								GeeSet* _tmp55_;
								GeeIterator* _tmp56_ = NULL;
								GeeIterator* _tmp57_;
								GeeIterator* _web_service_it;
								_tmp54_ = gee_multi_map_get_keys (web_service_addresses);
								_tmp55_ = _tmp54_;
								_tmp56_ = gee_iterable_iterator ((GeeIterable*) _tmp55_);
								_tmp57_ = _tmp56_;
								_g_object_unref0 (_tmp55_);
								_web_service_it = _tmp57_;
								while (TRUE) {
									gboolean _tmp58_;
									gpointer _tmp59_ = NULL;
									gchar* web_service;
									gchar* _tmp61_ = NULL;
									gchar* _tmp62_;
									gchar* _tmp63_;
									GeeCollection* _tmp64_ = NULL;
									GeeCollection* addresses;
									gboolean _first;
									gchar* _tmp72_;
									_tmp58_ = gee_iterator_next (_web_service_it);
									if (!_tmp58_) {
										break;
									}
									_tmp59_ = gee_iterator_get (_web_service_it);
									web_service = (gchar*) _tmp59_;
									if (first == FALSE) {
										gchar* _tmp60_;
										_tmp60_ = g_strconcat (output_string, ", ", NULL);
										_g_free0 (output_string);
										output_string = _tmp60_;
									}
									_tmp61_ = g_strdup_printf ("'%s' : { ", web_service);
									_tmp62_ = _tmp61_;
									_tmp63_ = g_strconcat (output_string, _tmp62_, NULL);
									_g_free0 (output_string);
									output_string = _tmp63_;
									_g_free0 (_tmp62_);
									first = FALSE;
									_tmp64_ = gee_multi_map_get (web_service_addresses, web_service);
									addresses = _tmp64_;
									_first = TRUE;
									{
										GeeIterator* _tmp65_ = NULL;
										GeeIterator* _a_it;
										_tmp65_ = gee_iterable_iterator ((GeeIterable*) addresses);
										_a_it = _tmp65_;
										while (TRUE) {
											gboolean _tmp66_;
											gpointer _tmp67_ = NULL;
											gchar* a;
											gchar* _tmp69_ = NULL;
											gchar* _tmp70_;
											gchar* _tmp71_;
											_tmp66_ = gee_iterator_next (_a_it);
											if (!_tmp66_) {
												break;
											}
											_tmp67_ = gee_iterator_get (_a_it);
											a = (gchar*) _tmp67_;
											if (_first == FALSE) {
												gchar* _tmp68_;
												_tmp68_ = g_strconcat (output_string, ", ", NULL);
												_g_free0 (output_string);
												output_string = _tmp68_;
											}
											_tmp69_ = g_strdup_printf ("'%s'", (const gchar*) a);
											_tmp70_ = _tmp69_;
											_tmp71_ = g_strconcat (output_string, _tmp70_, NULL);
											_g_free0 (output_string);
											output_string = _tmp71_;
											_g_free0 (_tmp70_);
											_first = FALSE;
											_g_free0 (a);
										}
										_g_object_unref0 (_a_it);
									}
									_tmp72_ = g_strconcat (output_string, " }", NULL);
									_g_free0 (output_string);
									output_string = _tmp72_;
									_g_object_unref0 (addresses);
									_g_free0 (web_service);
								}
								_g_object_unref0 (_web_service_it);
							}
							_tmp73_ = g_strconcat (output_string, " }", NULL);
							_g_free0 (output_string);
							output_string = _tmp73_;
							result = output_string;
							_g_object_unref0 (web_service_addresses);
							return result;
						} else {
							gboolean _tmp74_ = FALSE;
							gboolean _tmp75_ = FALSE;
							if (g_strcmp0 (prop_name, "email-addresses") == 0) {
								_tmp75_ = TRUE;
							} else {
								_tmp75_ = g_strcmp0 (prop_name, "phone-numbers") == 0;
							}
							if (_tmp75_) {
								_tmp74_ = TRUE;
							} else {
								_tmp74_ = g_strcmp0 (prop_name, "urls") == 0;
							}
							if (_tmp74_) {
								gchar* _tmp76_;
								gboolean first;
								GObject* _tmp77_ = NULL;
								GeeSet* _tmp78_;
								GeeSet* prop_list;
								gchar* _tmp85_;
								_tmp76_ = g_strdup ("{ ");
								_g_free0 (output_string);
								output_string = _tmp76_;
								first = TRUE;
								_tmp77_ = g_value_get_object (prop_value);
								_tmp78_ = _g_object_ref0 (GEE_SET (_tmp77_));
								prop_list = _tmp78_;
								{
									GeeIterator* _tmp79_ = NULL;
									GeeIterator* _p_it;
									_tmp79_ = gee_iterable_iterator ((GeeIterable*) prop_list);
									_p_it = _tmp79_;
									while (TRUE) {
										gboolean _tmp80_;
										gpointer _tmp81_ = NULL;
										FolksFieldDetails* p;
										const gchar* _tmp83_ = NULL;
										gchar* _tmp84_;
										_tmp80_ = gee_iterator_next (_p_it);
										if (!_tmp80_) {
											break;
										}
										_tmp81_ = gee_iterator_get (_p_it);
										p = (FolksFieldDetails*) _tmp81_;
										if (!first) {
											gchar* _tmp82_;
											_tmp82_ = g_strconcat (output_string, ", ", NULL);
											_g_free0 (output_string);
											output_string = _tmp82_;
										}
										_tmp83_ = folks_field_details_get_value (p);
										_tmp84_ = g_strconcat (output_string, _tmp83_, NULL);
										_g_free0 (output_string);
										output_string = _tmp84_;
										first = FALSE;
										_g_object_unref0 (p);
									}
									_g_object_unref0 (_p_it);
								}
								_tmp85_ = g_strconcat (output_string, " }", NULL);
								_g_free0 (output_string);
								output_string = _tmp85_;
								result = output_string;
								_g_object_unref0 (prop_list);
								return result;
							} else {
								if (g_strcmp0 (prop_name, "birthday") == 0) {
									void* _tmp86_ = NULL;
									GDateTime* dobj;
									_tmp86_ = g_value_get_boxed (prop_value);
									dobj = (GDateTime*) _tmp86_;
									if (dobj != NULL) {
										gchar* _tmp87_ = NULL;
										_tmp87_ = g_date_time_to_string (dobj);
										result = _tmp87_;
										_g_free0 (output_string);
										return result;
									} else {
										gchar* _tmp88_;
										_tmp88_ = g_strdup ("");
										result = _tmp88_;
										_g_free0 (output_string);
										return result;
									}
								} else {
									if (g_strcmp0 (prop_name, "postal-addresses") == 0) {
										gchar* _tmp89_;
										gboolean first;
										GObject* _tmp90_ = NULL;
										GeeSet* _tmp91_;
										GeeSet* prop_list;
										gchar* _tmp99_;
										_tmp89_ = g_strdup ("{ ");
										_g_free0 (output_string);
										output_string = _tmp89_;
										first = TRUE;
										_tmp90_ = g_value_get_object (prop_value);
										_tmp91_ = _g_object_ref0 (GEE_SET (_tmp90_));
										prop_list = _tmp91_;
										{
											GeeIterator* _tmp92_ = NULL;
											GeeIterator* _p_it;
											_tmp92_ = gee_iterable_iterator ((GeeIterable*) prop_list);
											_p_it = _tmp92_;
											while (TRUE) {
												gboolean _tmp93_;
												gpointer _tmp94_ = NULL;
												FolksPostalAddress* p;
												gchar* _tmp96_ = NULL;
												gchar* _tmp97_;
												gchar* _tmp98_;
												_tmp93_ = gee_iterator_next (_p_it);
												if (!_tmp93_) {
													break;
												}
												_tmp94_ = gee_iterator_get (_p_it);
												p = (FolksPostalAddress*) _tmp94_;
												if (!first) {
													gchar* _tmp95_;
													_tmp95_ = g_strconcat (output_string, ". ", NULL);
													_g_free0 (output_string);
													output_string = _tmp95_;
												}
												_tmp96_ = folks_postal_address_to_string (p);
												_tmp97_ = _tmp96_;
												_tmp98_ = g_strconcat (output_string, _tmp97_, NULL);
												_g_free0 (output_string);
												output_string = _tmp98_;
												_g_free0 (_tmp97_);
												first = FALSE;
												_g_object_unref0 (p);
											}
											_g_object_unref0 (_p_it);
										}
										_tmp99_ = g_strconcat (output_string, " }", NULL);
										_g_free0 (output_string);
										output_string = _tmp99_;
										result = output_string;
										_g_object_unref0 (prop_list);
										return result;
									} else {
										if (g_strcmp0 (prop_name, "notes") == 0) {
											GObject* _tmp100_ = NULL;
											GeeSet* _tmp101_;
											GeeSet* notes;
											gchar* _tmp102_;
											gboolean first;
											gchar* _tmp109_;
											_tmp100_ = g_value_get_object (prop_value);
											_tmp101_ = _g_object_ref0 (GEE_SET (_tmp100_));
											notes = _tmp101_;
											_tmp102_ = g_strdup ("{ ");
											_g_free0 (output_string);
											output_string = _tmp102_;
											first = TRUE;
											{
												GeeIterator* _tmp103_ = NULL;
												GeeIterator* _note_it;
												_tmp103_ = gee_iterable_iterator ((GeeIterable*) notes);
												_note_it = _tmp103_;
												while (TRUE) {
													gboolean _tmp104_;
													gpointer _tmp105_ = NULL;
													FolksNote* note;
													const gchar* _tmp107_ = NULL;
													gchar* _tmp108_;
													_tmp104_ = gee_iterator_next (_note_it);
													if (!_tmp104_) {
														break;
													}
													_tmp105_ = gee_iterator_get (_note_it);
													note = (FolksNote*) _tmp105_;
													if (!first) {
														gchar* _tmp106_;
														_tmp106_ = g_strconcat (output_string, ", ", NULL);
														_g_free0 (output_string);
														output_string = _tmp106_;
													}
													_tmp107_ = folks_note_get_uid (note);
													_tmp108_ = g_strconcat (output_string, _tmp107_, NULL);
													_g_free0 (output_string);
													output_string = _tmp108_;
													first = FALSE;
													_g_object_unref0 (note);
												}
												_g_object_unref0 (_note_it);
											}
											_tmp109_ = g_strconcat (output_string, " }", NULL);
											_g_free0 (output_string);
											output_string = _tmp109_;
											result = output_string;
											_g_object_unref0 (notes);
											return result;
										} else {
											if (g_strcmp0 (prop_name, "roles") == 0) {
												GObject* _tmp110_ = NULL;
												GeeSet* _tmp111_;
												GeeSet* roles;
												gchar* _tmp112_;
												gboolean first;
												gchar* _tmp120_;
												_tmp110_ = g_value_get_object (prop_value);
												_tmp111_ = _g_object_ref0 (GEE_SET (_tmp110_));
												roles = _tmp111_;
												_tmp112_ = g_strdup ("{ ");
												_g_free0 (output_string);
												output_string = _tmp112_;
												first = TRUE;
												{
													GeeIterator* _tmp113_ = NULL;
													GeeIterator* _role_it;
													_tmp113_ = gee_iterable_iterator ((GeeIterable*) roles);
													_role_it = _tmp113_;
													while (TRUE) {
														gboolean _tmp114_;
														gpointer _tmp115_ = NULL;
														FolksRole* role;
														gchar* _tmp117_ = NULL;
														gchar* _tmp118_;
														gchar* _tmp119_;
														_tmp114_ = gee_iterator_next (_role_it);
														if (!_tmp114_) {
															break;
														}
														_tmp115_ = gee_iterator_get (_role_it);
														role = (FolksRole*) _tmp115_;
														if (!first) {
															gchar* _tmp116_;
															_tmp116_ = g_strconcat (output_string, ", ", NULL);
															_g_free0 (output_string);
															output_string = _tmp116_;
														}
														_tmp117_ = folks_role_to_string (role);
														_tmp118_ = _tmp117_;
														_tmp119_ = g_strconcat (output_string, _tmp118_, NULL);
														_g_free0 (output_string);
														output_string = _tmp119_;
														_g_free0 (_tmp118_);
														first = FALSE;
														_g_object_unref0 (role);
													}
													_g_object_unref0 (_role_it);
												}
												_tmp120_ = g_strconcat (output_string, " }", NULL);
												_g_free0 (output_string);
												output_string = _tmp120_;
												result = output_string;
												_g_object_unref0 (roles);
												return result;
											} else {
												if (g_strcmp0 (prop_name, "structured-name") == 0) {
													GObject* _tmp121_ = NULL;
													FolksStructuredName* sn;
													gchar* ret;
													_tmp121_ = g_value_get_object (prop_value);
													sn = FOLKS_STRUCTURED_NAME (_tmp121_);
													ret = NULL;
													if (sn != NULL) {
														gchar* _tmp122_ = NULL;
														_tmp122_ = folks_structured_name_to_string (sn);
														_g_free0 (ret);
														ret = _tmp122_;
													}
													result = ret;
													_g_free0 (output_string);
													return result;
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp123_ = folks_inspect_utils_transform_value_to_string (prop_value);
	result = _tmp123_;
	_g_free0 (output_string);
	return result;
}


gchar* folks_inspect_utils_transform_value_to_string (GValue* prop_value) {
	gchar* result = NULL;
	GType _tmp0_;
	gboolean _tmp1_;
	_tmp0_ = G_VALUE_TYPE (prop_value);
	_tmp1_ = g_value_type_transformable (_tmp0_, G_TYPE_STRING);
	if (_tmp1_) {
		GValue string_value = {0};
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		g_value_init (&string_value, G_TYPE_STRING);
		g_value_transform (prop_value, &string_value);
		_tmp2_ = g_value_get_string (&string_value);
		_tmp3_ = g_strdup (_tmp2_);
		result = _tmp3_;
		G_IS_VALUE (&string_value) ? (g_value_unset (&string_value), NULL) : NULL;
		return result;
	} else {
		GType _tmp4_;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		_tmp4_ = G_VALUE_TYPE (prop_value);
		_tmp5_ = g_type_name (_tmp4_);
		_tmp6_ = g_type_name (G_TYPE_STRING);
		_tmp7_ = g_strdup_printf ("Can't convert from type '%s' to '%s'", _tmp5_, _tmp6_);
		result = _tmp7_;
		return result;
	}
}


gchar* folks_inspect_utils_command_name_completion_cb (const gchar* word, gint state) {
	gchar* result = NULL;
	g_return_val_if_fail (word != NULL, NULL);
	if (state == 0) {
		GeeMapIterator* _tmp0_ = NULL;
		_tmp0_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) main_client->commands);
		_g_object_unref0 (folks_inspect_utils_command_name_iter);
		folks_inspect_utils_command_name_iter = _tmp0_;
	}
	while (TRUE) {
		gboolean _tmp1_;
		gpointer _tmp2_ = NULL;
		gchar* command_name;
		gboolean _tmp3_;
		_tmp1_ = gee_map_iterator_next (folks_inspect_utils_command_name_iter);
		if (!(_tmp1_ == TRUE)) {
			break;
		}
		_tmp2_ = gee_map_iterator_get_key (folks_inspect_utils_command_name_iter);
		command_name = (gchar*) _tmp2_;
		_tmp3_ = g_str_has_prefix (command_name, word);
		if (_tmp3_) {
			result = command_name;
			return result;
		}
		_g_free0 (command_name);
	}
	_g_object_unref0 (folks_inspect_utils_command_name_iter);
	folks_inspect_utils_command_name_iter = NULL;
	result = NULL;
	return result;
}


gchar* folks_inspect_utils_individual_id_completion_cb (const gchar* word, gint state) {
	gchar* result = NULL;
	g_return_val_if_fail (word != NULL, NULL);
	if (state == 0) {
		FolksIndividualAggregator* _tmp0_ = NULL;
		GeeMap* _tmp1_ = NULL;
		GeeMapIterator* _tmp2_ = NULL;
		_tmp0_ = folks_inspect_client_get_aggregator (main_client);
		_tmp1_ = folks_individual_aggregator_get_individuals (_tmp0_);
		_tmp2_ = gee_map_map_iterator (_tmp1_);
		_g_object_unref0 (folks_inspect_utils_individual_id_iter);
		folks_inspect_utils_individual_id_iter = _tmp2_;
	}
	while (TRUE) {
		gboolean _tmp3_;
		gpointer _tmp4_ = NULL;
		gchar* id;
		gboolean _tmp5_;
		_tmp3_ = gee_map_iterator_next (folks_inspect_utils_individual_id_iter);
		if (!(_tmp3_ == TRUE)) {
			break;
		}
		_tmp4_ = gee_map_iterator_get_key (folks_inspect_utils_individual_id_iter);
		id = (gchar*) _tmp4_;
		_tmp5_ = g_str_has_prefix (id, word);
		if (_tmp5_) {
			result = id;
			return result;
		}
		_g_free0 (id);
	}
	_g_object_unref0 (folks_inspect_utils_individual_id_iter);
	folks_inspect_utils_individual_id_iter = NULL;
	result = NULL;
	return result;
}


gchar* folks_inspect_utils_persona_uid_completion_cb (const gchar* word, gint state) {
	gchar* result = NULL;
	g_return_val_if_fail (word != NULL, NULL);
	if (state == 0) {
		FolksIndividualAggregator* _tmp0_ = NULL;
		GeeMap* _tmp1_ = NULL;
		GeeMapIterator* _tmp2_ = NULL;
		_tmp0_ = folks_inspect_client_get_aggregator (main_client);
		_tmp1_ = folks_individual_aggregator_get_individuals (_tmp0_);
		_tmp2_ = gee_map_map_iterator (_tmp1_);
		_g_object_unref0 (folks_inspect_utils_individual_id_iter);
		folks_inspect_utils_individual_id_iter = _tmp2_;
		_g_object_unref0 (folks_inspect_utils_persona_uid_iter);
		folks_inspect_utils_persona_uid_iter = NULL;
	}
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		gpointer _tmp5_ = NULL;
		FolksIndividual* individual;
		if (folks_inspect_utils_persona_uid_iter != NULL) {
			_tmp3_ = TRUE;
		} else {
			gboolean _tmp4_;
			_tmp4_ = gee_map_iterator_next (folks_inspect_utils_individual_id_iter);
			_tmp3_ = _tmp4_ == TRUE;
		}
		if (!_tmp3_) {
			break;
		}
		_tmp5_ = gee_map_iterator_get_value (folks_inspect_utils_individual_id_iter);
		individual = (FolksIndividual*) _tmp5_;
		if (folks_inspect_utils_persona_uid_iter == NULL) {
			GeeSet* _tmp6_ = NULL;
			GeeIterator* _tmp7_ = NULL;
			g_assert (individual != NULL);
			_tmp6_ = folks_individual_get_personas (individual);
			_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
			_g_object_unref0 (folks_inspect_utils_persona_uid_iter);
			folks_inspect_utils_persona_uid_iter = _tmp7_;
		}
		while (TRUE) {
			gboolean _tmp8_;
			gpointer _tmp9_ = NULL;
			FolksPersona* persona;
			const gchar* _tmp10_ = NULL;
			gboolean _tmp11_;
			_tmp8_ = gee_iterator_next (folks_inspect_utils_persona_uid_iter);
			if (!_tmp8_) {
				break;
			}
			_tmp9_ = gee_iterator_get (folks_inspect_utils_persona_uid_iter);
			persona = (FolksPersona*) _tmp9_;
			_tmp10_ = folks_persona_get_uid (persona);
			_tmp11_ = g_str_has_prefix (_tmp10_, word);
			if (_tmp11_) {
				const gchar* _tmp12_ = NULL;
				gchar* _tmp13_;
				_tmp12_ = folks_persona_get_uid (persona);
				_tmp13_ = g_strdup (_tmp12_);
				result = _tmp13_;
				_g_object_unref0 (persona);
				_g_object_unref0 (individual);
				return result;
			}
			_g_object_unref0 (persona);
		}
		_g_object_unref0 (folks_inspect_utils_persona_uid_iter);
		folks_inspect_utils_persona_uid_iter = NULL;
		_g_object_unref0 (individual);
	}
	_g_object_unref0 (folks_inspect_utils_individual_id_iter);
	folks_inspect_utils_individual_id_iter = NULL;
	result = NULL;
	return result;
}


gchar* folks_inspect_utils_backend_name_completion_cb (const gchar* word, gint state) {
	gchar* result = NULL;
	g_return_val_if_fail (word != NULL, NULL);
	if (state == 0) {
		FolksBackendStore* _tmp0_ = NULL;
		GeeCollection* _tmp1_ = NULL;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_ = NULL;
		_tmp0_ = folks_inspect_client_get_backend_store (main_client);
		_tmp1_ = folks_backend_store_list_backends (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_g_object_unref0 (folks_inspect_utils_backend_name_iter);
		folks_inspect_utils_backend_name_iter = _tmp3_;
		_g_object_unref0 (_tmp2_);
	}
	while (TRUE) {
		gboolean _tmp4_;
		gpointer _tmp5_ = NULL;
		FolksBackend* backend;
		const gchar* _tmp6_ = NULL;
		gboolean _tmp7_;
		_tmp4_ = gee_iterator_next (folks_inspect_utils_backend_name_iter);
		if (!(_tmp4_ == TRUE)) {
			break;
		}
		_tmp5_ = gee_iterator_get (folks_inspect_utils_backend_name_iter);
		backend = (FolksBackend*) _tmp5_;
		_tmp6_ = folks_backend_get_name (backend);
		_tmp7_ = g_str_has_prefix (_tmp6_, word);
		if (_tmp7_) {
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			_tmp8_ = folks_backend_get_name (backend);
			_tmp9_ = g_strdup (_tmp8_);
			result = _tmp9_;
			_g_object_unref0 (backend);
			return result;
		}
		_g_object_unref0 (backend);
	}
	_g_object_unref0 (folks_inspect_utils_backend_name_iter);
	folks_inspect_utils_backend_name_iter = NULL;
	result = NULL;
	return result;
}


gchar* folks_inspect_utils_persona_store_id_completion_cb (const gchar* word, gint state) {
	gchar* result = NULL;
	g_return_val_if_fail (word != NULL, NULL);
	if (state == 0) {
		FolksBackendStore* _tmp0_ = NULL;
		GeeCollection* _tmp1_ = NULL;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_ = NULL;
		_tmp0_ = folks_inspect_client_get_backend_store (main_client);
		_tmp1_ = folks_backend_store_list_backends (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_g_object_unref0 (folks_inspect_utils_backend_name_iter);
		folks_inspect_utils_backend_name_iter = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_g_object_unref0 (folks_inspect_utils_persona_store_id_iter);
		folks_inspect_utils_persona_store_id_iter = NULL;
	}
	while (TRUE) {
		gboolean _tmp4_ = FALSE;
		if (folks_inspect_utils_persona_store_id_iter != NULL) {
			_tmp4_ = TRUE;
		} else {
			gboolean _tmp5_;
			_tmp5_ = gee_iterator_next (folks_inspect_utils_backend_name_iter);
			_tmp4_ = _tmp5_ == TRUE;
		}
		if (!_tmp4_) {
			break;
		}
		if (folks_inspect_utils_persona_store_id_iter == NULL) {
			gpointer _tmp6_ = NULL;
			FolksBackend* backend;
			GeeMap* _tmp7_ = NULL;
			GeeMapIterator* _tmp8_ = NULL;
			_tmp6_ = gee_iterator_get (folks_inspect_utils_backend_name_iter);
			backend = (FolksBackend*) _tmp6_;
			_tmp7_ = folks_backend_get_persona_stores (backend);
			_tmp8_ = gee_map_map_iterator (_tmp7_);
			_g_object_unref0 (folks_inspect_utils_persona_store_id_iter);
			folks_inspect_utils_persona_store_id_iter = _tmp8_;
			_g_object_unref0 (backend);
		}
		while (TRUE) {
			gboolean _tmp9_;
			gpointer _tmp10_ = NULL;
			gchar* id;
			gboolean _tmp11_;
			_tmp9_ = gee_map_iterator_next (folks_inspect_utils_persona_store_id_iter);
			if (!(_tmp9_ == TRUE)) {
				break;
			}
			_tmp10_ = gee_map_iterator_get_key (folks_inspect_utils_persona_store_id_iter);
			id = (gchar*) _tmp10_;
			_tmp11_ = g_str_has_prefix (id, word);
			if (_tmp11_) {
				result = id;
				return result;
			}
			_g_free0 (id);
		}
		_g_object_unref0 (folks_inspect_utils_persona_store_id_iter);
		folks_inspect_utils_persona_store_id_iter = NULL;
	}
	_g_object_unref0 (folks_inspect_utils_backend_name_iter);
	folks_inspect_utils_backend_name_iter = NULL;
	result = NULL;
	return result;
}


FolksInspectUtils* folks_inspect_utils_construct (GType object_type) {
	FolksInspectUtils* self = NULL;
	self = (FolksInspectUtils*) g_type_create_instance (object_type);
	return self;
}


FolksInspectUtils* folks_inspect_utils_new (void) {
	return folks_inspect_utils_construct (FOLKS_INSPECT_TYPE_UTILS);
}


static void folks_inspect_value_utils_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void folks_inspect_value_utils_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		folks_inspect_utils_unref (value->data[0].v_pointer);
	}
}


static void folks_inspect_value_utils_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = folks_inspect_utils_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer folks_inspect_value_utils_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* folks_inspect_value_utils_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		FolksInspectUtils* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = folks_inspect_utils_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* folks_inspect_value_utils_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	FolksInspectUtils** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = folks_inspect_utils_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* folks_inspect_param_spec_utils (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	FolksInspectParamSpecUtils* spec;
	g_return_val_if_fail (g_type_is_a (object_type, FOLKS_INSPECT_TYPE_UTILS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer folks_inspect_value_get_utils (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FOLKS_INSPECT_TYPE_UTILS), NULL);
	return value->data[0].v_pointer;
}


void folks_inspect_value_set_utils (GValue* value, gpointer v_object) {
	FolksInspectUtils* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FOLKS_INSPECT_TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FOLKS_INSPECT_TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		folks_inspect_utils_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		folks_inspect_utils_unref (old);
	}
}


void folks_inspect_value_take_utils (GValue* value, gpointer v_object) {
	FolksInspectUtils* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FOLKS_INSPECT_TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FOLKS_INSPECT_TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		folks_inspect_utils_unref (old);
	}
}


static void folks_inspect_utils_class_init (FolksInspectUtilsClass * klass) {
	gchar* _tmp0_;
	folks_inspect_utils_parent_class = g_type_class_peek_parent (klass);
	FOLKS_INSPECT_UTILS_CLASS (klass)->finalize = folks_inspect_utils_finalize;
	_tmp0_ = g_strdup ("");
	folks_inspect_utils_indentation_string = _tmp0_;
}


static void folks_inspect_utils_instance_init (FolksInspectUtils * self) {
	self->ref_count = 1;
}


static void folks_inspect_utils_finalize (FolksInspectUtils* obj) {
	FolksInspectUtils * self;
	self = FOLKS_INSPECT_UTILS (obj);
}


GType folks_inspect_utils_get_type (void) {
	static volatile gsize folks_inspect_utils_type_id__volatile = 0;
	if (g_once_init_enter (&folks_inspect_utils_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { folks_inspect_value_utils_init, folks_inspect_value_utils_free_value, folks_inspect_value_utils_copy_value, folks_inspect_value_utils_peek_pointer, "p", folks_inspect_value_utils_collect_value, "p", folks_inspect_value_utils_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (FolksInspectUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_inspect_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksInspectUtils), 0, (GInstanceInitFunc) folks_inspect_utils_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType folks_inspect_utils_type_id;
		folks_inspect_utils_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FolksInspectUtils", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&folks_inspect_utils_type_id__volatile, folks_inspect_utils_type_id);
	}
	return folks_inspect_utils_type_id__volatile;
}


gpointer folks_inspect_utils_ref (gpointer instance) {
	FolksInspectUtils* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void folks_inspect_utils_unref (gpointer instance) {
	FolksInspectUtils* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FOLKS_INSPECT_UTILS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



