/* duplicated-phones.c generated by valac 0.12.0, the Vala compiler
 * generated from duplicated-phones.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <folks-test.h>
#include <tracker-test.h>
#include <folks/folks.h>
#include <stdlib.h>
#include <string.h>
#include <folks/folks-tracker.h>
#include <gio/gio.h>
#include <gee.h>


#define TYPE_DUPLICATED_PHONES_TESTS (duplicated_phones_tests_get_type ())
#define DUPLICATED_PHONES_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DUPLICATED_PHONES_TESTS, DuplicatedPhonesTests))
#define DUPLICATED_PHONES_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DUPLICATED_PHONES_TESTS, DuplicatedPhonesTestsClass))
#define IS_DUPLICATED_PHONES_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DUPLICATED_PHONES_TESTS))
#define IS_DUPLICATED_PHONES_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DUPLICATED_PHONES_TESTS))
#define DUPLICATED_PHONES_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DUPLICATED_PHONES_TESTS, DuplicatedPhonesTestsClass))

typedef struct _DuplicatedPhonesTests DuplicatedPhonesTests;
typedef struct _DuplicatedPhonesTestsClass DuplicatedPhonesTestsClass;
typedef struct _DuplicatedPhonesTestsPrivate DuplicatedPhonesTestsPrivate;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _tracker_test_backend_unref0(var) ((var == NULL) ? NULL : (var = (tracker_test_backend_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _DuplicatedPhonesTestsTestDuplicatedPhonesAsyncData DuplicatedPhonesTestsTestDuplicatedPhonesAsyncData;
typedef struct _DuplicatedPhonesTestsTryToAddData DuplicatedPhonesTestsTryToAddData;
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _DuplicatedPhonesTestsAddPersonasData DuplicatedPhonesTestsAddPersonasData;

struct _DuplicatedPhonesTests {
	FolksTestCase parent_instance;
	DuplicatedPhonesTestsPrivate * priv;
};

struct _DuplicatedPhonesTestsClass {
	FolksTestCaseClass parent_class;
};

struct _DuplicatedPhonesTestsPrivate {
	GMainLoop* _main_loop;
	TrackerTestBackend* _tracker_backend;
	FolksIndividualAggregator* _aggregator;
	gchar* _persona_fullname_1;
	gchar* _persona_fullname_2;
	gchar* _phone_1;
	gboolean _added_personas;
	GStaticRecMutex __lock__added_personas;
	gchar* _individual_id_1;
	gchar* _individual_id_2;
	TrfPersonaStore* _pstore;
};

struct _DuplicatedPhonesTestsTestDuplicatedPhonesAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DuplicatedPhonesTests* self;
	FolksBackendStore* _tmp0_;
	FolksBackendStore* store;
	FolksIndividualAggregator* _tmp1_;
	GeeMap* _tmp2_;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	GeeIterator* _tmp5_;
	GeeIterator* _tmp6_;
	GeeIterator* _backend_it;
	gboolean _tmp7_;
	gpointer _tmp8_;
	FolksBackend* backend;
	GeeMap* _tmp9_;
	gpointer _tmp10_;
	GError * e;
	GError * _inner_error_;
};

struct _DuplicatedPhonesTestsTryToAddData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DuplicatedPhonesTests* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_;
};

struct _DuplicatedPhonesTestsAddPersonasData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DuplicatedPhonesTests* self;
	GHashTable* _tmp0_;
	GHashTable* details1;
	GHashTable* _tmp1_;
	GHashTable* details2;
	GValue* val;
	GValue _tmp2_;
	GValue _tmp3_;
	GValue _tmp4_;
	GValue* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GValue* _tmp8_;
	GValue _tmp9_;
	GValue _tmp10_;
	GValue _tmp11_;
	GValue* _tmp12_;
	GeeHashSet* _tmp13_;
	GeeHashSet* phones1;
	FolksFieldDetails* _tmp14_;
	FolksFieldDetails* phone_1;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	GValue* _tmp17_;
	GValue _tmp18_;
	GValue _tmp19_;
	GValue _tmp20_;
	GValue* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	GValue* _tmp24_;
	GValue _tmp25_;
	GValue _tmp26_;
	GValue _tmp27_;
	GValue* _tmp28_;
	GeeHashSet* _tmp29_;
	GeeHashSet* phones2;
	FolksFieldDetails* _tmp30_;
	FolksFieldDetails* phone_2;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	GValue* _tmp33_;
	FolksPersona* _tmp34_;
	FolksPersona* _tmp35_;
	FolksPersona* _tmp36_;
	FolksPersona* _tmp37_;
	GError * e;
	GError * _inner_error_;
};


static gpointer duplicated_phones_tests_parent_class = NULL;

GType duplicated_phones_tests_get_type (void) G_GNUC_CONST;
#define DUPLICATED_PHONES_TESTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DUPLICATED_PHONES_TESTS, DuplicatedPhonesTestsPrivate))
enum  {
	DUPLICATED_PHONES_TESTS_DUMMY_PROPERTY
};
DuplicatedPhonesTests* duplicated_phones_tests_new (void);
DuplicatedPhonesTests* duplicated_phones_tests_construct (GType object_type);
void duplicated_phones_tests_test_duplicated_phones (DuplicatedPhonesTests* self);
static void _duplicated_phones_tests_test_duplicated_phones_folks_test_case_test_method (gpointer self);
static void duplicated_phones_tests_real_set_up (FolksTestCase* base);
static void duplicated_phones_tests_real_tear_down (FolksTestCase* base);
static void _duplicated_phones_tests_test_duplicated_phones_async (DuplicatedPhonesTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _duplicated_phones_tests_test_duplicated_phones_finish (DuplicatedPhonesTests* self, GAsyncResult* _res_);
static gboolean _lambda0_ (DuplicatedPhonesTests* self);
static gboolean __lambda0__gsource_func (gpointer self);
static void _duplicated_phones_tests_test_duplicated_phones_async_data_free (gpointer _data);
static gboolean _duplicated_phones_tests_test_duplicated_phones_async_co (DuplicatedPhonesTestsTestDuplicatedPhonesAsyncData* data);
static void _duplicated_phones_tests_test_duplicated_phones_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _duplicated_phones_tests_individuals_changed_cb (DuplicatedPhonesTests* self, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason);
static void __duplicated_phones_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static void _duplicated_phones_tests_notify_pstore_cb (DuplicatedPhonesTests* self, GObject* _pstore, GParamSpec* ps);
static void __duplicated_phones_tests_notify_pstore_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _duplicated_phones_tests_try_to_add (DuplicatedPhonesTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _duplicated_phones_tests_try_to_add_finish (DuplicatedPhonesTests* self, GAsyncResult* _res_);
static void _duplicated_phones_tests_try_to_add_data_free (gpointer _data);
static gboolean _duplicated_phones_tests_try_to_add_co (DuplicatedPhonesTestsTryToAddData* data);
static void _duplicated_phones_tests_add_personas (DuplicatedPhonesTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _duplicated_phones_tests_add_personas_finish (DuplicatedPhonesTests* self, GAsyncResult* _res_);
static void _duplicated_phones_tests_try_to_add_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _duplicated_phones_tests_add_personas_data_free (gpointer _data);
static gboolean _duplicated_phones_tests_add_personas_co (DuplicatedPhonesTestsAddPersonasData* data);
static void _g_free0_ (gpointer var);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
static GValue* _g_value_dup (GValue* self);
static void _duplicated_phones_tests_add_personas_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void duplicated_phones_tests_finalize (GObject* obj);
gint _vala_main (gchar** args, int args_length1);


static void _duplicated_phones_tests_test_duplicated_phones_folks_test_case_test_method (gpointer self) {
	duplicated_phones_tests_test_duplicated_phones (self);
}


DuplicatedPhonesTests* duplicated_phones_tests_construct (GType object_type) {
	DuplicatedPhonesTests * self = NULL;
	TrackerTestBackend* _tmp0_ = NULL;
	self = (DuplicatedPhonesTests*) folks_test_case_construct (object_type, "DuplicatedPhonesTests");
	_tmp0_ = tracker_test_backend_new ();
	_tracker_test_backend_unref0 (self->priv->_tracker_backend);
	self->priv->_tracker_backend = _tmp0_;
	folks_test_case_add_test ((FolksTestCase*) self, "test adding 2 personas with the same phone number ", _duplicated_phones_tests_test_duplicated_phones_folks_test_case_test_method, self);
	return self;
}


DuplicatedPhonesTests* duplicated_phones_tests_new (void) {
	return duplicated_phones_tests_construct (TYPE_DUPLICATED_PHONES_TESTS);
}


static void duplicated_phones_tests_real_set_up (FolksTestCase* base) {
	DuplicatedPhonesTests * self;
	self = (DuplicatedPhonesTests*) base;
}


static void duplicated_phones_tests_real_tear_down (FolksTestCase* base) {
	DuplicatedPhonesTests * self;
	self = (DuplicatedPhonesTests*) base;
	tracker_test_backend_tear_down (self->priv->_tracker_backend);
}


static gboolean _lambda0_ (DuplicatedPhonesTests* self) {
	gboolean result = FALSE;
	g_main_loop_quit (self->priv->_main_loop);
	g_assert_not_reached ();
	return result;
}


static gboolean __lambda0__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda0_ (self);
	return result;
}


void duplicated_phones_tests_test_duplicated_phones (DuplicatedPhonesTests* self) {
	GMainLoop* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->_main_loop);
	self->priv->_main_loop = _tmp0_;
	_duplicated_phones_tests_test_duplicated_phones_async (self, NULL, NULL);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, __lambda0__gsource_func, g_object_ref (self), g_object_unref);
	g_main_loop_run (self->priv->_main_loop);
	g_assert (g_strcmp0 (self->priv->_individual_id_1, "") != 0);
	g_assert (g_strcmp0 (self->priv->_individual_id_2, "") != 0);
}


static void _duplicated_phones_tests_test_duplicated_phones_async_data_free (gpointer _data) {
	DuplicatedPhonesTestsTestDuplicatedPhonesAsyncData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (DuplicatedPhonesTestsTestDuplicatedPhonesAsyncData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _duplicated_phones_tests_test_duplicated_phones_async (DuplicatedPhonesTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DuplicatedPhonesTestsTestDuplicatedPhonesAsyncData* _data_;
	_data_ = g_slice_new0 (DuplicatedPhonesTestsTestDuplicatedPhonesAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _duplicated_phones_tests_test_duplicated_phones_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _duplicated_phones_tests_test_duplicated_phones_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_duplicated_phones_tests_test_duplicated_phones_async_co (_data_);
}


static void _duplicated_phones_tests_test_duplicated_phones_finish (DuplicatedPhonesTests* self, GAsyncResult* _res_) {
	DuplicatedPhonesTestsTestDuplicatedPhonesAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _duplicated_phones_tests_test_duplicated_phones_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DuplicatedPhonesTestsTestDuplicatedPhonesAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	_duplicated_phones_tests_test_duplicated_phones_async_co (data);
}


static void __duplicated_phones_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	_duplicated_phones_tests_individuals_changed_cb (self, added, removed, message, actor, reason);
}


static void __duplicated_phones_tests_notify_pstore_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_duplicated_phones_tests_notify_pstore_cb (self, _sender, pspec);
}


static gboolean _duplicated_phones_tests_test_duplicated_phones_async_co (DuplicatedPhonesTestsTestDuplicatedPhonesAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = folks_backend_store_dup ();
	data->store = data->_tmp0_;
	data->_state_ = 1;
	folks_backend_store_prepare (data->store, _duplicated_phones_tests_test_duplicated_phones_async_ready, data);
	return FALSE;
	_state_1:
	folks_backend_store_prepare_finish (data->store, data->_res_);
	data->_tmp1_ = NULL;
	data->_tmp1_ = folks_individual_aggregator_new ();
	_g_object_unref0 (data->self->priv->_aggregator);
	data->self->priv->_aggregator = data->_tmp1_;
	g_signal_connect_object (data->self->priv->_aggregator, "individuals-changed", (GCallback) __duplicated_phones_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed, data->self, 0);
	data->_state_ = 2;
	folks_individual_aggregator_prepare (data->self->priv->_aggregator, _duplicated_phones_tests_test_duplicated_phones_async_ready, data);
	return FALSE;
	_state_2:
	folks_individual_aggregator_prepare_finish (data->self->priv->_aggregator, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	_g_object_unref0 (data->self->priv->_pstore);
	data->self->priv->_pstore = NULL;
	{
		data->_tmp2_ = NULL;
		data->_tmp2_ = folks_backend_store_get_enabled_backends (data->store);
		data->_tmp3_ = NULL;
		data->_tmp3_ = gee_map_get_values (data->_tmp2_);
		data->_tmp4_ = data->_tmp3_;
		data->_tmp5_ = NULL;
		data->_tmp5_ = gee_iterable_iterator ((GeeIterable*) data->_tmp4_);
		data->_tmp6_ = data->_tmp5_;
		_g_object_unref0 (data->_tmp4_);
		data->_backend_it = data->_tmp6_;
		while (TRUE) {
			data->_tmp7_ = gee_iterator_next (data->_backend_it);
			if (!data->_tmp7_) {
				break;
			}
			data->_tmp8_ = NULL;
			data->_tmp8_ = gee_iterator_get (data->_backend_it);
			data->backend = (FolksBackend*) data->_tmp8_;
			data->_tmp9_ = NULL;
			data->_tmp9_ = folks_backend_get_persona_stores (data->backend);
			data->_tmp10_ = NULL;
			data->_tmp10_ = gee_map_get (data->_tmp9_, "tracker");
			_g_object_unref0 (data->self->priv->_pstore);
			data->self->priv->_pstore = TRF_PERSONA_STORE ((FolksPersonaStore*) data->_tmp10_);
			if (data->self->priv->_pstore != NULL) {
				_g_object_unref0 (data->backend);
				break;
			}
			_g_object_unref0 (data->backend);
		}
		_g_object_unref0 (data->_backend_it);
	}
	g_assert (data->self->priv->_pstore != NULL);
	g_signal_connect_object ((GObject*) data->self->priv->_pstore, "notify::is-prepared", (GCallback) __duplicated_phones_tests_notify_pstore_cb_g_object_notify, data->self, 0);
	_duplicated_phones_tests_try_to_add (data->self, NULL, NULL);
	goto __finally0;
	__catch0_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("duplicated-phones.vala:99: Error when calling prepare: %s\n", data->e->message);
		_g_error_free0 (data->e);
	}
	__finally0:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (data->store);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void _duplicated_phones_tests_individuals_changed_cb (DuplicatedPhonesTests* self, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason) {
	gboolean _tmp9_ = FALSE;
	gint _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	{
		GeeIterator* _tmp0_ = NULL;
		GeeIterator* _i_it;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) added);
		_i_it = _tmp0_;
		while (TRUE) {
			gboolean _tmp1_;
			gpointer _tmp2_ = NULL;
			FolksIndividual* i;
			const gchar* _tmp3_ = NULL;
			_tmp1_ = gee_iterator_next (_i_it);
			if (!_tmp1_) {
				break;
			}
			_tmp2_ = gee_iterator_get (_i_it);
			i = (FolksIndividual*) _tmp2_;
			_tmp3_ = folks_name_details_get_full_name ((FolksNameDetails*) i);
			if (g_strcmp0 (_tmp3_, self->priv->_persona_fullname_1) == 0) {
				const gchar* _tmp4_ = NULL;
				gchar* _tmp5_;
				_tmp4_ = folks_individual_get_id (i);
				_tmp5_ = g_strdup (_tmp4_);
				_g_free0 (self->priv->_individual_id_1);
				self->priv->_individual_id_1 = _tmp5_;
			} else {
				const gchar* _tmp6_ = NULL;
				_tmp6_ = folks_name_details_get_full_name ((FolksNameDetails*) i);
				if (g_strcmp0 (_tmp6_, self->priv->_persona_fullname_2) == 0) {
					const gchar* _tmp7_ = NULL;
					gchar* _tmp8_;
					_tmp7_ = folks_individual_get_id (i);
					_tmp8_ = g_strdup (_tmp7_);
					_g_free0 (self->priv->_individual_id_2);
					self->priv->_individual_id_2 = _tmp8_;
				}
			}
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
	if (g_strcmp0 (self->priv->_individual_id_1, "") != 0) {
		_tmp9_ = g_strcmp0 (self->priv->_individual_id_2, "") != 0;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		g_main_loop_quit (self->priv->_main_loop);
	}
	_tmp10_ = gee_collection_get_size ((GeeCollection*) removed);
	g_assert (_tmp10_ == 0);
}


static void _duplicated_phones_tests_notify_pstore_cb (DuplicatedPhonesTests* self, GObject* _pstore, GParamSpec* ps) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (_pstore != NULL);
	g_return_if_fail (ps != NULL);
	_duplicated_phones_tests_try_to_add (self, NULL, NULL);
}


static void _duplicated_phones_tests_try_to_add_data_free (gpointer _data) {
	DuplicatedPhonesTestsTryToAddData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (DuplicatedPhonesTestsTryToAddData, data);
}


static void _duplicated_phones_tests_try_to_add (DuplicatedPhonesTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DuplicatedPhonesTestsTryToAddData* _data_;
	_data_ = g_slice_new0 (DuplicatedPhonesTestsTryToAddData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _duplicated_phones_tests_try_to_add);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _duplicated_phones_tests_try_to_add_data_free);
	_data_->self = _g_object_ref0 (self);
	_duplicated_phones_tests_try_to_add_co (_data_);
}


static void _duplicated_phones_tests_try_to_add_finish (DuplicatedPhonesTests* self, GAsyncResult* _res_) {
	DuplicatedPhonesTestsTryToAddData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _duplicated_phones_tests_try_to_add_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DuplicatedPhonesTestsTryToAddData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	_duplicated_phones_tests_try_to_add_co (data);
}


static gboolean _duplicated_phones_tests_try_to_add_co (DuplicatedPhonesTestsTryToAddData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		g_static_rec_mutex_lock (&data->self->priv->__lock__added_personas);
		data->_tmp1_ = folks_persona_store_get_is_prepared ((FolksPersonaStore*) data->self->priv->_pstore);
		if (data->_tmp1_) {
			data->_tmp0_ = data->self->priv->_added_personas == FALSE;
		} else {
			data->_tmp0_ = FALSE;
		}
		if (data->_tmp0_) {
			data->self->priv->_added_personas = TRUE;
			data->_state_ = 1;
			_duplicated_phones_tests_add_personas (data->self, _duplicated_phones_tests_try_to_add_ready, data);
			return FALSE;
			_state_1:
			_duplicated_phones_tests_add_personas_finish (data->self, data->_res_);
		}
		__finally1:
		g_static_rec_mutex_unlock (&data->self->priv->__lock__added_personas);
		if (data->_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void _duplicated_phones_tests_add_personas_data_free (gpointer _data) {
	DuplicatedPhonesTestsAddPersonasData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (DuplicatedPhonesTestsAddPersonasData, data);
}


static void _duplicated_phones_tests_add_personas (DuplicatedPhonesTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DuplicatedPhonesTestsAddPersonasData* _data_;
	_data_ = g_slice_new0 (DuplicatedPhonesTestsAddPersonasData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _duplicated_phones_tests_add_personas);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _duplicated_phones_tests_add_personas_data_free);
	_data_->self = _g_object_ref0 (self);
	_duplicated_phones_tests_add_personas_co (_data_);
}


static void _duplicated_phones_tests_add_personas_finish (DuplicatedPhonesTests* self, GAsyncResult* _res_) {
	DuplicatedPhonesTestsAddPersonasData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Add 2 personas with the same phone number. Although
   * Tracker forbids creating inserting 2 nco:PhoneNumber,
   * using the same nco:phoneNumber, our Trf.PersonaStore should
   * be able to detect the existence of a given Phone Number and
   * re-use that instead of trying to create a new one.
   */
static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static void __vala_GValue_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


static void _duplicated_phones_tests_add_personas_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DuplicatedPhonesTestsAddPersonasData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	_duplicated_phones_tests_add_personas_co (data);
}


static gboolean _duplicated_phones_tests_add_personas_co (DuplicatedPhonesTestsAddPersonasData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, __vala_GValue_free0_);
	data->details1 = data->_tmp0_;
	data->_tmp1_ = NULL;
	data->_tmp1_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, __vala_GValue_free0_);
	data->details2 = data->_tmp1_;
	memset (&data->_tmp2_, 0, sizeof (GValue));
	g_value_init (&data->_tmp2_, G_TYPE_STRING);
	memset (&data->_tmp3_, 0, sizeof (GValue));
	data->_tmp3_ = data->_tmp2_;
	data->_tmp4_ = data->_tmp3_;
	data->_tmp5_ = __g_value_dup0 (&data->_tmp4_);
	__vala_GValue_free0 (data->val);
	data->val = data->_tmp5_;
	G_IS_VALUE (&data->_tmp4_) ? (g_value_unset (&data->_tmp4_), NULL) : NULL;
	g_value_set_string (data->val, data->self->priv->_persona_fullname_1);
	data->_tmp6_ = NULL;
	data->_tmp6_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_FULL_NAME);
	data->_tmp7_ = g_strdup (data->_tmp6_);
	data->_tmp8_ = data->val;
	data->val = NULL;
	g_hash_table_insert (data->details1, data->_tmp7_, data->_tmp8_);
	memset (&data->_tmp9_, 0, sizeof (GValue));
	g_value_init (&data->_tmp9_, GEE_TYPE_SET);
	memset (&data->_tmp10_, 0, sizeof (GValue));
	data->_tmp10_ = data->_tmp9_;
	data->_tmp11_ = data->_tmp10_;
	data->_tmp12_ = __g_value_dup0 (&data->_tmp11_);
	__vala_GValue_free0 (data->val);
	data->val = data->_tmp12_;
	G_IS_VALUE (&data->_tmp11_) ? (g_value_unset (&data->_tmp11_), NULL) : NULL;
	data->_tmp13_ = NULL;
	data->_tmp13_ = gee_hash_set_new (FOLKS_TYPE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	data->phones1 = data->_tmp13_;
	data->_tmp14_ = NULL;
	data->_tmp14_ = folks_field_details_new (data->self->priv->_phone_1);
	data->phone_1 = data->_tmp14_;
	gee_abstract_collection_add ((GeeAbstractCollection*) data->phones1, data->phone_1);
	g_value_set_object (data->val, (GObject*) data->phones1);
	data->_tmp15_ = NULL;
	data->_tmp15_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_PHONE_NUMBERS);
	data->_tmp16_ = g_strdup (data->_tmp15_);
	data->_tmp17_ = data->val;
	data->val = NULL;
	g_hash_table_insert (data->details1, data->_tmp16_, data->_tmp17_);
	memset (&data->_tmp18_, 0, sizeof (GValue));
	g_value_init (&data->_tmp18_, G_TYPE_STRING);
	memset (&data->_tmp19_, 0, sizeof (GValue));
	data->_tmp19_ = data->_tmp18_;
	data->_tmp20_ = data->_tmp19_;
	data->_tmp21_ = __g_value_dup0 (&data->_tmp20_);
	__vala_GValue_free0 (data->val);
	data->val = data->_tmp21_;
	G_IS_VALUE (&data->_tmp20_) ? (g_value_unset (&data->_tmp20_), NULL) : NULL;
	g_value_set_string (data->val, data->self->priv->_persona_fullname_2);
	data->_tmp22_ = NULL;
	data->_tmp22_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_FULL_NAME);
	data->_tmp23_ = g_strdup (data->_tmp22_);
	data->_tmp24_ = data->val;
	data->val = NULL;
	g_hash_table_insert (data->details2, data->_tmp23_, data->_tmp24_);
	memset (&data->_tmp25_, 0, sizeof (GValue));
	g_value_init (&data->_tmp25_, GEE_TYPE_SET);
	memset (&data->_tmp26_, 0, sizeof (GValue));
	data->_tmp26_ = data->_tmp25_;
	data->_tmp27_ = data->_tmp26_;
	data->_tmp28_ = __g_value_dup0 (&data->_tmp27_);
	__vala_GValue_free0 (data->val);
	data->val = data->_tmp28_;
	G_IS_VALUE (&data->_tmp27_) ? (g_value_unset (&data->_tmp27_), NULL) : NULL;
	data->_tmp29_ = NULL;
	data->_tmp29_ = gee_hash_set_new (FOLKS_TYPE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	data->phones2 = data->_tmp29_;
	data->_tmp30_ = NULL;
	data->_tmp30_ = folks_field_details_new (data->self->priv->_phone_1);
	data->phone_2 = data->_tmp30_;
	gee_abstract_collection_add ((GeeAbstractCollection*) data->phones2, data->phone_2);
	g_value_set_object (data->val, (GObject*) data->phones2);
	data->_tmp31_ = NULL;
	data->_tmp31_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_PHONE_NUMBERS);
	data->_tmp32_ = g_strdup (data->_tmp31_);
	data->_tmp33_ = data->val;
	data->val = NULL;
	g_hash_table_insert (data->details2, data->_tmp32_, data->_tmp33_);
	data->_state_ = 1;
	folks_individual_aggregator_add_persona_from_details (data->self->priv->_aggregator, NULL, (FolksPersonaStore*) data->self->priv->_pstore, data->details1, _duplicated_phones_tests_add_personas_ready, data);
	return FALSE;
	_state_1:
	data->_tmp34_ = NULL;
	data->_tmp34_ = folks_individual_aggregator_add_persona_from_details_finish (data->self->priv->_aggregator, data->_res_, &data->_inner_error_);
	data->_tmp35_ = data->_tmp34_;
	_g_object_unref0 (data->_tmp35_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
			goto __catch2_folks_individual_aggregator_error;
		}
		_g_object_unref0 (data->phone_2);
		_g_object_unref0 (data->phones2);
		_g_object_unref0 (data->phone_1);
		_g_object_unref0 (data->phones1);
		__vala_GValue_free0 (data->val);
		_g_hash_table_unref0 (data->details2);
		_g_hash_table_unref0 (data->details1);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->_state_ = 2;
	folks_individual_aggregator_add_persona_from_details (data->self->priv->_aggregator, NULL, (FolksPersonaStore*) data->self->priv->_pstore, data->details2, _duplicated_phones_tests_add_personas_ready, data);
	return FALSE;
	_state_2:
	data->_tmp36_ = NULL;
	data->_tmp36_ = folks_individual_aggregator_add_persona_from_details_finish (data->self->priv->_aggregator, data->_res_, &data->_inner_error_);
	data->_tmp37_ = data->_tmp36_;
	_g_object_unref0 (data->_tmp37_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
			goto __catch2_folks_individual_aggregator_error;
		}
		_g_object_unref0 (data->phone_2);
		_g_object_unref0 (data->phones2);
		_g_object_unref0 (data->phone_1);
		_g_object_unref0 (data->phones1);
		__vala_GValue_free0 (data->val);
		_g_hash_table_unref0 (data->details2);
		_g_hash_table_unref0 (data->details1);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	goto __finally2;
	__catch2_folks_individual_aggregator_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("duplicated-phones.vala:202: [AddPersonaError] add_persona_from_details" \
": %s\n", data->e->message);
		_g_error_free0 (data->e);
	}
	__finally2:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->phone_2);
		_g_object_unref0 (data->phones2);
		_g_object_unref0 (data->phone_1);
		_g_object_unref0 (data->phones1);
		__vala_GValue_free0 (data->val);
		_g_hash_table_unref0 (data->details2);
		_g_hash_table_unref0 (data->details1);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (data->phone_2);
	_g_object_unref0 (data->phones2);
	_g_object_unref0 (data->phone_1);
	_g_object_unref0 (data->phones1);
	__vala_GValue_free0 (data->val);
	_g_hash_table_unref0 (data->details2);
	_g_hash_table_unref0 (data->details1);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void duplicated_phones_tests_class_init (DuplicatedPhonesTestsClass * klass) {
	duplicated_phones_tests_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DuplicatedPhonesTestsPrivate));
	FOLKS_TEST_CASE_CLASS (klass)->set_up = duplicated_phones_tests_real_set_up;
	FOLKS_TEST_CASE_CLASS (klass)->tear_down = duplicated_phones_tests_real_tear_down;
	G_OBJECT_CLASS (klass)->finalize = duplicated_phones_tests_finalize;
}


static void duplicated_phones_tests_instance_init (DuplicatedPhonesTests * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	self->priv = DUPLICATED_PHONES_TESTS_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("persona #1");
	self->priv->_persona_fullname_1 = _tmp0_;
	_tmp1_ = g_strdup ("persona #2");
	self->priv->_persona_fullname_2 = _tmp1_;
	_tmp2_ = g_strdup ("1-800-123-456");
	self->priv->_phone_1 = _tmp2_;
	g_static_rec_mutex_init (&self->priv->__lock__added_personas);
	self->priv->_added_personas = FALSE;
	_tmp3_ = g_strdup ("");
	self->priv->_individual_id_1 = _tmp3_;
	_tmp4_ = g_strdup ("");
	self->priv->_individual_id_2 = _tmp4_;
}


static void duplicated_phones_tests_finalize (GObject* obj) {
	DuplicatedPhonesTests * self;
	self = DUPLICATED_PHONES_TESTS (obj);
	_g_main_loop_unref0 (self->priv->_main_loop);
	_tracker_test_backend_unref0 (self->priv->_tracker_backend);
	_g_object_unref0 (self->priv->_aggregator);
	_g_free0 (self->priv->_persona_fullname_1);
	_g_free0 (self->priv->_persona_fullname_2);
	_g_free0 (self->priv->_phone_1);
	g_static_rec_mutex_free (&self->priv->__lock__added_personas);
	_g_free0 (self->priv->_individual_id_1);
	_g_free0 (self->priv->_individual_id_2);
	_g_object_unref0 (self->priv->_pstore);
	G_OBJECT_CLASS (duplicated_phones_tests_parent_class)->finalize (obj);
}


GType duplicated_phones_tests_get_type (void) {
	static volatile gsize duplicated_phones_tests_type_id__volatile = 0;
	if (g_once_init_enter (&duplicated_phones_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DuplicatedPhonesTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) duplicated_phones_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DuplicatedPhonesTests), 0, (GInstanceInitFunc) duplicated_phones_tests_instance_init, NULL };
		GType duplicated_phones_tests_type_id;
		duplicated_phones_tests_type_id = g_type_register_static (FOLKS_TYPE_TEST_CASE, "DuplicatedPhonesTests", &g_define_type_info, 0);
		g_once_init_leave (&duplicated_phones_tests_type_id__volatile, duplicated_phones_tests_type_id);
	}
	return duplicated_phones_tests_type_id__volatile;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GTestSuite* _tmp0_ = NULL;
	GTestSuite* root;
	DuplicatedPhonesTests* _tmp1_ = NULL;
	DuplicatedPhonesTests* _tmp2_;
	GTestSuite* _tmp3_ = NULL;
	g_test_init (&args_length1, &args, NULL);
	_tmp0_ = g_test_get_root ();
	root = _tmp0_;
	_tmp1_ = duplicated_phones_tests_new ();
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_test_case_get_suite ((FolksTestCase*) _tmp2_);
	g_test_suite_add_suite (root, _tmp3_);
	_g_object_unref0 (_tmp2_);
	g_test_run ();
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}



