# Copyright (C) 1998-2011 by Barry A. Warsaw
#
# This file is part of flufl.bounce
#
# flufl.bounce is free software: you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by the
# Free Software Foundation, version 3 of the License.
#
# flufl.bounce is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
# for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with flufl.bounce.  If not, see <http://www.gnu.org/licenses/>.

"""Parse bounce messages generated by Exim.

Exim adds an X-Failed-Recipients: header to bounce messages containing
an `addresslist' of failed addresses.

"""

from __future__ import absolute_import, unicode_literals

__metaclass__ = type
__all__ = [
    'Exim',
    ]


from email.utils import getaddresses
from zope.interface import implements

from flufl.bounce.interfaces import IBounceDetector, NoTemporaryFailures



class Exim:
    """Parse bounce messages generated by Exim."""

    implements(IBounceDetector)

    def process(self, msg):
        """See `IBounceDetector`."""
        all = msg.get_all('x-failed-recipients', [])
        return (NoTemporaryFailures,
                set(address for name, address in getaddresses(all)))
