// Princeton Instruments WinSpec SPE Format
// Licence: Lesser GNU Public License 2.1 (LGPL) 
// $Id: winspec_spe.h 379 2008-01-14 14:57:55Z wojdyr $

// According to the format specification, SPE format has several versions 
// (v1.43, v1.6 and the newest v2.25). But we need not implement every version 
// of it, because it's backward compatible.
// The official programs to deal with this format is WinView/WinSpec.
//     
// Implementation is based on the file format specification sent us by 
// David Hovis (the documents came with his equipment) 
// and source code of a program written by Pablo Bianucci.

#ifndef WINSPEC_SPE_DATASET_H
#define WINSPEC_SPE_DATASET_H
#include "xylib.h"

namespace xylib {

    struct spe_calib;

    class WinspecSpeDataSet : public DataSet
    {
        OBLIGATORY_DATASET_MEMBERS(WinspecSpeDataSet)
        
    protected:
        Column* get_calib_column(const spe_calib *calib, int dim);
        void read_calib(std::istream &f, spe_calib &calib);
    }; 

} // namespace
#endif // WINSPEC_SPE_DATASET_H

