#!/bin/sh
#
#	fhist - file history and comparison tools
#	Copyright (C) 1993, 1994, 1998, 2003, 2004 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: Test the fcomp command
#

work=/tmp/$$
PAGER=cat
export PAGER
LINES=24
export LINES
COLS=80
export COLS

fail()
{
	set +x
	echo FAILED test of the fcomp command 1>&2
	cd $here
	rm -rf $work
	exit 1
}
pass()
{
	set +x
	echo PASSED 1>&2
	cd $here
	rm -rf $work
	exit 0
}
trap "fail" 1 2 3 15

#
# use the built-in error messages
#
FHIST_MESSAGE_LIBRARY=$$work/no-such-dir
export FHIST_MESSAGE_LIBRARY
unset LANG
unset LANGUAGE

here=`pwd`
if test $? -ne 0 ; then exit 1; fi
mkdir $work
if test $? -ne 0 ; then exit 1; fi
cd $work
if test $? -ne 0 ; then fail; fi

if [ "$1" != "" ]; then bin=$here/$1/bin; else bin=$here/bin; fi

#
# file A
#
cat > a << 'fubar'
.\"
.\"	aegis - project change supervisor
.\"	Copyright (C) 1991, 1992, 2003, 2004 Peter Miller.
.\"	All rights reserved.
.\"
.\"	This program is free software; you can redistribute it and/or modify
.\"	it under the terms of the GNU General Public License as published by
.\"	the Free Software Foundation; either version 1, or (at your option)
.\"	any later version.
.\"
.\"	This program is distributed in the hope that it will be useful,
.\"	but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"	GNU General Public License for more details.
.\"
.\"	You should have received a copy of the GNU General Public License
.\"	along with this program; if not, write to the Free Software
.\"	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
.\"
.\" MANIFEST: User Guide, The Change Development Cycle, The Administrator
.\"
.bp
.nh 2 "The Administrator"
.LP
The previous discussion of developers, reviewers and integrators
has covered many aspects of the production of software using the aegis program.
The administrator has responsibility for everything they don't,
but there is very little left.
.LP
These responsibilities include:
.LP
\(bu access control:
The administrator adds and removes all categories of user,
including administrators.
This is on a per-project basis,
and has nothing to do with 
.UX
user administration.
This simply nominates which users may do what.
.LP
\(bu change creation:
The administrator adds (and sometimes removes) changes to the system.
At later stages,
developers may alter some attributes of the change,
such as the description,
to say what they fixed.
.LP
\(bu project creation:
The aegis program does not limit who may create projects,
but when a project is created the user who created the project
is set to be the administrator of that project.
.LP
All of these things will be examined 
.nh 3 "The First Change"
.LP
Many things need to happen before
development can begin on
the first change;
the projecty must be created,
the staff but be given access permissions,
the chang must be created.
.E(
alex% \fBaenpr example -dir /projects/example\fP
aegis: project "example": project directory "/projects/example"
aegis: project "example": created
alex%
.E)
words
.E(
description = "Aegis Documentation Example Project";
developer_may_review = false;
developer_may_integrate = false;
reviewer_may_integrate = false;
.E)
words
.E(
alex% \fBaepa fred -p example\fP
aegis: project "example": attributes changed
alex% \fBael p\fP
List of Projects

Project Directory               Description
------- -----------             -------------
example /projects/example       Aegis Documentation Example
                                Project
alex%
.E)
words
.E(
alex% \fBaend pat jan sam -p example\fP
aegis: project "example": user "pat" is now a developer
aegis: project "example": user "jan" is now a developer
aegis: project "example": user "sam" is now a developer
alex%
.E)
words
.E(
alex% \fBaenr robyn jan -p example\fP
aegis: project "example": user "robyn" is now a reviewer
aegis: project "example": user "jan" is now a reviewer
alex%
.E)
words
.E(
alex% \fBaeni isa -p example\fP
aegis: project "example": user "isa" is now an integrator
alex%
.E)
words
.E(
brief_description = "Create initial skeleton.";
description = "A simple calculator using native \e
floating point precision.  \e
The four basic arithmetic operators to be provided, \e
using conventional infix notation.  \e
Parentheses and negation also required.";
cause = internal_enhancement;
.E)
words
.E(
alex% \fBaenc ncf -p example\fP
aegis: project "example": change 1: created
alex%
.E)
words
.nh 3 "The Second Change"
.LP
words
.E(
brief_description = "file names on command line";
description = "Optional input and output files may be \e
specified on the command line.";
cause = internal_bug;
.E)
.LP
words
.E(
alex% \fBaenc ncf -p example\fP
aegis: project "example": change 2: created
alex%
.E)
words
.nh 3 "The Third Change"
.LP
words
.E(
brief_description = "add variables";
description = "Enhance the grammar to allow variables.  \e
Only single letter variable names are required.";
cause = internal_enhancement;
.E)
.LP
words
.E(
alex% \fBaenc ncf -p example\fP
aegis: project "example": change 3: created
alex%
.E)
words
.nh 3 "The Fourth Change"
.LP
words
.E(
brief_description = "add powers";
description = "Enhance the grammar to allow exponentiation.  \e
No error checking required.";
cause = internal_enhancement;
.E)
.LP
words
.E(
alex% \fBaenc ncf -p example\fP
aegis: project "example": change 4: created
alex%
.E)
words
.nh 3 "Administrator Command Summary"
.LP
Only a few of the aegis commands available to administrators have
been used in this example.
The following table (very tersely) describes the aegis commands most useful to administrators.
.sp
.TS
center,tab(;);
l l.
Command;Description
_
aenpr;New Project
aerpr;Remove Project
aena;New Administrator
aera;Remove Administrator
aeni;New Integrator
aeri;Remove Integrator
aend;New Developer
aerd;Remove Developer
aenrv;New Reviewer
aerrv;Remove Reviewer
aenc;New Change
aencu;New Change Undo
aepa;Project Attributes
aeca;Change Attributes
ael;List Stuff
.TE
.LP
You will want to read the manual entries for all of these commands.
Note that all aegis commands have a
.I \-Help
option,
which will give a result very similar to the
corresponding
.I man (1)
output.
Most aegis commands also have a
.I \-List
option,
which usually lists interesting context sensitive information.
fubar
if test $? -ne 0 ; then fail; fi
cp a b
if test $? -ne 0 ; then fail; fi

#
# difference it
#
$bin/fcomp a b > c 2>&1
if test $? -ne 0 ; then exit 1; fi

#
# This is what it should look like
#
cat > ok << 'fubar'
Files "a" and "b" are identical
fubar
if test $? -ne 0 ; then exit 1; fi
diff ok c
if test $? -ne 0 ; then exit 1; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
