/*
 * Copyright (c) 2003, 2006 Matteo Frigo
 * Copyright (c) 2003, 2006 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sun Jul  2 15:59:17 EDT 2006 */

#include "codelet-rdft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_hc2hc -fma -reorder-insns -schedule-for-pipeline -compact -variables 4 -pipeline-latency 4 -twiddle-log3 -precompute-twiddles -n 4 -dit -name hf2_4 -include hf.h */

/*
 * This function contains 24 FP additions, 16 FP multiplications,
 * (or, 16 additions, 8 multiplications, 8 fused multiply/add),
 * 29 stack variables, and 16 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.9 2006-02-12 23:34:12 athena Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_hc2hc.ml,v 1.16 2006-02-12 23:34:12 athena Exp $
 */

#include "hf.h"

static const R *hf2_4(R *rio, R *iio, const R *W, stride ios, INT m, INT dist)
{
     INT i;
     for (i = m - 2; i > 0; i = i - 2, rio = rio + dist, iio = iio - dist, W = W + 4, MAKE_VOLATILE_STRIDE(ios)) {
	  E TA, Tz;
	  {
	       E T2, T6, T3, T5;
	       T2 = W[0];
	       T6 = W[3];
	       T3 = W[2];
	       T5 = W[1];
	       {
		    E T1, Tx, Tm, Ts, Tf, Th, Td, Tg, Tp, Tw;
		    {
			 E Tj, Tl, Tb, T7, Tk, Tr, Ta, T4;
			 T1 = rio[0];
			 Ta = T2 * T6;
			 T4 = T2 * T3;
			 Tj = rio[WS(ios, 3)];
			 Tl = iio[0];
			 Tb = FNMS(T5, T3, Ta);
			 T7 = FMA(T5, T6, T4);
			 Tk = T3 * Tj;
			 Tr = T3 * Tl;
			 Tx = iio[-WS(ios, 3)];
			 {
			      E T8, Tc, T9, Tv;
			      T8 = rio[WS(ios, 2)];
			      Tm = FMA(T6, Tl, Tk);
			      Ts = FNMS(T6, Tj, Tr);
			      Tc = iio[-WS(ios, 1)];
			      T9 = T7 * T8;
			      Tf = rio[WS(ios, 1)];
			      Th = iio[-WS(ios, 2)];
			      Tv = T7 * Tc;
			      Td = FMA(Tb, Tc, T9);
			      Tg = T2 * Tf;
			      Tp = T2 * Th;
			      Tw = FNMS(Tb, T8, Tv);
			 }
		    }
		    {
			 E To, Te, Ti, Tq, Ty, Tn, Tt, Tu;
			 To = T1 - Td;
			 Te = T1 + Td;
			 Ti = FMA(T5, Th, Tg);
			 Tq = FNMS(T5, Tf, Tp);
			 Ty = Tw + Tx;
			 TA = Tx - Tw;
			 Tn = Ti + Tm;
			 Tz = Tm - Ti;
			 Tt = Tq - Ts;
			 Tu = Tq + Ts;
			 rio[0] = Te + Tn;
			 iio[-WS(ios, 2)] = Te - Tn;
			 iio[0] = Tu + Ty;
			 rio[WS(ios, 2)] = Tu - Ty;
			 rio[WS(ios, 1)] = To + Tt;
			 iio[-WS(ios, 3)] = To - Tt;
		    }
	       }
	  }
	  iio[-WS(ios, 1)] = Tz + TA;
	  rio[WS(ios, 3)] = Tz - TA;
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_CEXP, 0, 1},
     {TW_CEXP, 0, 3},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 4, "hf2_4", twinstr, &GENUS, {16, 8, 8, 0}, 0, 0, 0 };

void X(codelet_hf2_4) (planner *p) {
     X(khc2hc_register) (p, hf2_4, &desc);
}
#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_hc2hc -compact -variables 4 -pipeline-latency 4 -twiddle-log3 -precompute-twiddles -n 4 -dit -name hf2_4 -include hf.h */

/*
 * This function contains 24 FP additions, 16 FP multiplications,
 * (or, 16 additions, 8 multiplications, 8 fused multiply/add),
 * 21 stack variables, and 16 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.9 2006-02-12 23:34:12 athena Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_hc2hc.ml,v 1.16 2006-02-12 23:34:12 athena Exp $
 */

#include "hf.h"

static const R *hf2_4(R *rio, R *iio, const R *W, stride ios, INT m, INT dist)
{
     INT i;
     for (i = m - 2; i > 0; i = i - 2, rio = rio + dist, iio = iio - dist, W = W + 4, MAKE_VOLATILE_STRIDE(ios)) {
	  E T2, T4, T3, T5, T6, T8;
	  T2 = W[0];
	  T4 = W[1];
	  T3 = W[2];
	  T5 = W[3];
	  T6 = FMA(T2, T3, T4 * T5);
	  T8 = FNMS(T4, T3, T2 * T5);
	  {
	       E T1, Th, Tl, Tp, Ta, To, Te, Tk, Tf, Tg;
	       T1 = rio[0];
	       Tf = rio[WS(ios, 3)];
	       Tg = iio[0];
	       Th = FMA(T3, Tf, T5 * Tg);
	       Tl = FNMS(T5, Tf, T3 * Tg);
	       Tp = iio[-WS(ios, 3)];
	       {
		    E T7, T9, Tc, Td;
		    T7 = rio[WS(ios, 2)];
		    T9 = iio[-WS(ios, 1)];
		    Ta = FMA(T6, T7, T8 * T9);
		    To = FNMS(T8, T7, T6 * T9);
		    Tc = rio[WS(ios, 1)];
		    Td = iio[-WS(ios, 2)];
		    Te = FMA(T2, Tc, T4 * Td);
		    Tk = FNMS(T4, Tc, T2 * Td);
	       }
	       {
		    E Tb, Ti, Tn, Tq;
		    Tb = T1 + Ta;
		    Ti = Te + Th;
		    iio[-WS(ios, 2)] = Tb - Ti;
		    rio[0] = Tb + Ti;
		    Tn = Tk + Tl;
		    Tq = To + Tp;
		    rio[WS(ios, 2)] = Tn - Tq;
		    iio[0] = Tn + Tq;
	       }
	       {
		    E Tj, Tm, Tr, Ts;
		    Tj = T1 - Ta;
		    Tm = Tk - Tl;
		    iio[-WS(ios, 3)] = Tj - Tm;
		    rio[WS(ios, 1)] = Tj + Tm;
		    Tr = Th - Te;
		    Ts = Tp - To;
		    rio[WS(ios, 3)] = Tr - Ts;
		    iio[-WS(ios, 1)] = Tr + Ts;
	       }
	  }
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_CEXP, 0, 1},
     {TW_CEXP, 0, 3},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 4, "hf2_4", twinstr, &GENUS, {16, 8, 8, 0}, 0, 0, 0 };

void X(codelet_hf2_4) (planner *p) {
     X(khc2hc_register) (p, hf2_4, &desc);
}
#endif				/* HAVE_FMA */
