/*
 * Decompiled with CFR 0.152.
 */
package fix;

import fix.Base64Coder;
import fix.ErrorWindow;
import fix.HttpClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.RepaintManager;

public class Sender {
    private String rec = "";
    private String comm = "";
    private String server = "";
    private String user = "";
    private String id = "";
    private String akey = "";
    private String skey = "";
    public String boundary = "";
    private String md5AuthId = "";
    public HttpClient hc = null;
    private BufferedReader fromServer = null;
    private String fileName = "";
    private File file = null;
    private FileInputStream is = null;
    private boolean debug = false;
    private long seek = -1L;
    private String sid = null;
    private ErrorWindow er = null;
    private boolean mime = false;
    private boolean isCanceled = false;

    public Sender(String string, String string2, String string3, boolean bl, String string4, String string5, String string6, String string7, String string8, ErrorWindow errorWindow, boolean bl2) {
        this.rec = string;
        this.file = new File(string2);
        this.fileName = this.file.getName();
        this.comm = string3;
        this.server = string4;
        this.user = string5;
        this.id = string6;
        this.akey = string7;
        this.skey = string8;
        this.er = errorWindow;
        this.mime = bl;
        this.debug = bl2;
        this.isCanceled = false;
    }

    public boolean send(JProgressBar jProgressBar, JLabel jLabel) {
        jProgressBar.setVisible(true);
        RepaintManager.currentManager(jProgressBar).paintDirtyRegions();
        this.hc = new HttpClient(this.er, this.debug);
        this.hc.connect(this.server);
        try {
            this.fromServer = new BufferedReader(new InputStreamReader(this.hc.getSocket().getInputStream()));
        }
        catch (IOException iOException) {
            this.er.setMess("Unable to read input stream. No connection established!", iOException);
            return false;
        }
        this.seek = this.checkFileLengthOnServer();
        if (this.seek == -1L) {
            return false;
        }
        boolean bl = false;
        bl = this.sendPostHeaders();
        if (!bl) {
            return false;
        }
        try {
            long l = this.file.length();
            long l2 = 0L;
            int n = 0;
            byte[] byArray = new byte[16384];
            this.is = new FileInputStream(this.file);
            this.is.skip(this.seek);
            l2 = this.seek;
            while ((n = this.is.read(byArray, 0, byArray.length)) != -1) {
                if (this.isCanceled) {
                    this.fromServer.close();
                    this.is.close();
                    this.hc.out.flush();
                    this.hc.out.close();
                    this.isCanceled = false;
                    return false;
                }
                this.hc.send(byArray, 0, n);
                jProgressBar.setValue((int)((double)(l2 += (long)n) * 100.0 / (double)l) * 2);
                RepaintManager.currentManager(jProgressBar).paintDirtyRegions();
            }
        }
        catch (IOException iOException) {
            this.er.setMess("File could not be sent: " + iOException.getMessage(), iOException);
            return false;
        }
        this.hc.send("\r\n\r\n--" + this.boundary + "--" + "\r\n");
        jLabel.setText("waiting for server confirmation");
        RepaintManager.currentManager(jLabel).paintDirtyRegions();
        String string = null;
        String string2 = "";
        string = this.hc.receive(this.fromServer);
        if (string.startsWith("HTTP")) {
            string2 = string.split("\\r\\n")[0].split(" ")[2];
        } else if (string == null) {
            string2 = "no response";
        }
        this.er.setMess("File uploaded successful! Server answered: " + string2, "Done", null);
        System.out.println("result: " + string2);
        try {
            this.fromServer.close();
            this.is.close();
            this.hc.out.flush();
            this.hc.out.close();
        }
        catch (IOException iOException) {
            this.er.setMess("Streams could not be closed, please restart Client.", iOException);
            return false;
        }
        return true;
    }

    private long checkFileLengthOnServer() {
        String string = "";
        try {
            string = URLEncoder.encode(this.fileName, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return -1L;
        }
        if (!this.hc.isConnected) {
            this.er.setMess("Not connected. Cannot request file length.", null);
            return -1L;
        }
        String string2 = "HEAD " + this.hc.getURLifProxified();
        this.hc.addRequestProperty("Host", this.hc.getHost() + ":" + this.hc.getPort());
        this.hc.addRequestProperty("User-Agent", "F*IX");
        this.hc.addRequestProperty("Connection", "keep-alive");
        string2 = string2 + "/fop/" + this.rec + "/" + this.user + "/" + string + "??&ID=" + this.id + (!this.skey.equals("") ? "&SKEY=" + this.skey : "") + " HTTP/1.1\r\n" + this.hc.getRequestProperties();
        this.hc.send(string2 + "\r\n");
        string2 = this.hc.receive(this.fromServer);
        String string3 = null;
        long l = -1L;
        long l2 = 0L;
        try {
            if (Pattern.compile("^HTTP\\/[0-9]\\.[0-9]\\s*200\\s*OK").matcher(string2).find()) {
                string3 = this.hc.getResponseProperty("CONTENT-LENGTH");
                if (string3 == null) {
                    this.er.setMess("Unexpected response from server! 'Content-Length' header missing?", null);
                    return -1L;
                }
                l = Long.parseLong(string3);
                string3 = this.hc.getResponseProperty("X-SIZE");
                if (string3 != null) {
                    l2 = Long.parseLong(string3);
                    if (this.file.length() != l2) {
                        l = 0L;
                    }
                }
                return l;
            }
            this.er.setMess("Unexpected response from server '" + string2 + "'", null);
            return -1L;
        }
        catch (NumberFormatException numberFormatException) {
            this.er.setMess("Unable to parse HTTP header. Expected a number.", numberFormatException);
            return -1L;
        }
    }

    public boolean sendPostHeaders() {
        int n = 40;
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2++;
            byArray[n3] = (byte)(byArray[n3] + (byte)(Math.random() * 256.0));
        }
        this.boundary = String.valueOf(Base64Coder.encode(byArray));
        String string = "application/octet-stream";
        if (this.mime) {
            string = "application/x-mime";
        }
        long l = 0L;
        long l2 = this.file.length() - this.seek;
        l += this.hc.addRequestProperty("Content-Disposition", "form-data; name=\"FROM\"\r\n\r\n" + this.user + "\r\n--" + this.boundary);
        l += this.hc.addRequestProperty("Content-Disposition", "form-data; name=\"TO\"\r\n\r\n" + this.rec + "\r\n--" + this.boundary);
        l += this.hc.addRequestProperty("Content-Disposition", "form-data; name=\"ID\"\r\n\r\n" + this.id + "\r\n--" + this.boundary);
        if (this.akey != null && !this.akey.equals("")) {
            l += this.hc.addRequestProperty("Content-Disposition", "form-data; name=\"AKEY\"\r\n\r\n" + this.akey + "\r\n--" + this.boundary);
        }
        if (this.skey != null && !this.skey.equals("")) {
            l += this.hc.addRequestProperty("Content-Disposition", "form-data; name=\"SKEY\"\r\n\r\n" + this.skey + "\r\n--" + this.boundary);
        }
        if (this.comm != null && !this.comm.equals("")) {
            l += this.hc.addRequestProperty("Content-Disposition", "form-data; name=\"COMMENT\"\r\n\r\n" + this.comm + "\r\n--" + this.boundary);
        }
        if (this.seek > 0L) {
            l += this.hc.addRequestProperty("Content-Disposition", "form-data; name=\"SEEK\"\r\n\r\n" + this.seek + "\r\n--" + this.boundary);
        }
        l += this.hc.addRequestProperty("Content-Disposition", "form-data; name=\"FILE\"; filename=\"" + this.fileName + "\"");
        l += this.hc.addRequestProperty("Content-Type", string);
        l += this.hc.addRequestProperty("Content-Length", l2 + "");
        l += (long)(this.boundary.length() * 2 + 12) + l2;
        if (this.hc.isConnected) {
            String string2 = "POST " + this.hc.getURLifProxified();
            this.hc.prependRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary + "\r\n\r\n--" + this.boundary);
            this.hc.prependRequestProperty("Content-Length", l + "");
            this.hc.prependRequestProperty("Connection", "close");
            this.hc.prependRequestProperty("User-Agent", "F*IX");
            this.hc.prependRequestProperty("Host", this.hc.getHost() + ":" + this.hc.getPort());
            string2 = string2 + "/fup HTTP/1.1\r\n" + this.hc.getRequestProperties();
            this.hc.send(string2 + "\r\n");
            return true;
        }
        this.er.setMess("Not connected. Cannot send POST headers.", null);
        return false;
    }

    public void cancelSend() {
        this.isCanceled = true;
    }
}

