#include <assert.h>
#include "rules.h"

char* correct =
"Version: 1.1\n"
"\tLayout Name: ru\n"
"\tLayout Description: Russian\n"
"\tLayout Languages: rus\n"
"\t\tVariant Name: phonetic\n"
"\t\tVariant Description: Russian (phonetic)\n"
"\t\tVariant Languages: \n"
"\t\tVariant Name: phonetic_winkeys\n"
"\t\tVariant Description: Russian (phonetic WinKeys)\n"
"\t\tVariant Languages: \n"
"\t\tVariant Name: typewriter\n"
"\t\tVariant Description: Russian (typewriter)\n"
"\t\tVariant Languages: \n"
"\t\tVariant Name: legacy\n"
"\t\tVariant Description: Russian (legacy)\n"
"\t\tVariant Languages: \n"
"\t\tVariant Name: typewriter-legacy\n"
"\t\tVariant Description: Russian (typewriter, legacy)\n"
"\t\tVariant Languages: \n"
"\t\tVariant Name: tt\n"
"\t\tVariant Description: Tatar\n"
"\t\tVariant Languages: tat\n"
"\t\tVariant Name: os_legacy\n"
"\t\tVariant Description: Ossetian (legacy)\n"
"\t\tVariant Languages: oss\n"
"\t\tVariant Name: os_winkeys\n"
"\t\tVariant Description: Ossetian (WinKeys)\n"
"\t\tVariant Languages: oss\n"
"\t\tVariant Name: cv\n"
"\t\tVariant Description: Chuvash\n"
"\t\tVariant Languages: chv\n"
"\t\tVariant Name: cv_latin\n"
"\t\tVariant Description: Chuvash (Latin)\n"
"\t\tVariant Languages: chv\n"
"\t\tVariant Name: udm\n"
"\t\tVariant Description: Udmurt\n"
"\t\tVariant Languages: udm\n"
"\t\tVariant Name: kom\n"
"\t\tVariant Description: Komi\n"
"\t\tVariant Languages: kom\n"
"\t\tVariant Name: sah\n"
"\t\tVariant Description: Yakut\n"
"\t\tVariant Languages: sah\n"
"\t\tVariant Name: xal\n"
"\t\tVariant Description: Kalmyk\n"
"\t\tVariant Languages: xal\n"
"\t\tVariant Name: dos\n"
"\t\tVariant Description: Russian (DOS)\n"
"\t\tVariant Languages: \n"
"\t\tVariant Name: srp\n"
"\t\tVariant Description: Serbian (Russia)\n"
"\t\tVariant Languages: rus,srp\n"
"\t\tVariant Name: bak\n"
"\t\tVariant Description: Bashkirian\n"
"\t\tVariant Languages: bak\n"
"\t\tVariant Name: chm\n"
"\t\tVariant Description: Mari\n"
"\t\tVariant Languages: chm\n"
"\t\tVariant Name: chu\n"
"\t\tVariant Description: Church Slavonic\n"
"\t\tVariant Languages: chu\n"
"\t\tVariant Name: ruu\n"
"\t\tVariant Description: Russian (with Ukrainian-Belorussian layout)\n"
"\t\tVariant Languages: rus,ukr,bel\n"
"\tLayout Name: us\n"
"\tLayout Description: English (US)\n"
"\tLayout Languages: eng\n"
"\t\tVariant Name: chr\n"
"\t\tVariant Description: Cherokee\n"
"\t\tVariant Languages: chr\n"
"\t\tVariant Name: euro\n"
"\t\tVariant Description: English (US, with euro on 5)\n"
"\t\tVariant Languages: \n"
"\t\tVariant Name: intl\n"
"\t\tVariant Description: English (US, international with dead keys)\n"
"\t\tVariant Languages: \n"
"\t\tVariant Name: alt-intl\n"
"\t\tVariant Description: English (US, alternative international)\n"
"\t\tVariant Languages: \n"
"\t\tVariant Name: colemak\n"
"\t\tVariant Description: English (Colemak)\n"
"\t\tVariant Languages: \n"
"\t\tVariant Name: dvorak\n"
"\t\tVariant Description: English (Dvorak)\n"
"\t\tVariant Languages: \n"
"\t\tVariant Name: dvorak-intl\n"
"\t\tVariant Description: English (Dvorak international with dead keys)\n"
"\t\tVariant Languages: \n"
"\t\tVariant Name: dvorak-alt-intl\n"
"\t\tVariant Description: English (Dvorak alternative international no dead keys)\n"
"\t\tVariant Languages: \n"
"\t\tVariant Name: dvorak-l\n"
"\t\tVariant Description: English (left handed Dvorak)\n"
"\t\tVariant Languages: \n"
"\t\tVariant Name: dvorak-r\n"
"\t\tVariant Description: English (right handed Dvorak)\n"
"\t\tVariant Languages: \n"
"\t\tVariant Name: dvorak-classic\n"
"\t\tVariant Description: English (classic Dvorak)\n"
"\t\tVariant Languages: \n"
"\t\tVariant Name: dvp\n"
"\t\tVariant Description: English (programmer Dvorak)\n"
"\t\tVariant Languages: \n"
"\t\tVariant Name: rus\n"
"\t\tVariant Description: Russian (US, phonetic)\n"
"\t\tVariant Languages: rus\n"
"\t\tVariant Name: mac\n"
"\t\tVariant Description: English (Macintosh)\n"
"\t\tVariant Languages: \n"
"\t\tVariant Name: altgr-intl\n"
"\t\tVariant Description: English (international AltGr dead keys)\n"
"\t\tVariant Languages: eng,fra,ger\n"
"\t\tVariant Name: olpc2\n"
"\t\tVariant Description: English (layout toggle on multiply/divide key)\n"
"\t\tVariant Languages: \n"
"\t\tVariant Name: hbs\n"
"\t\tVariant Description: Serbo-Croatian (US)\n"
"\t\tVariant Languages: eng,bos,hbs,hrv,srp\n"
"\tLayout Name: ad\n"
"\tLayout Description: Catalan\n"
"\tLayout Languages: cat\n"
"\tLayout Name: apl\n"
"\tLayout Description: APL Keyboard Symbols\n"
"\tLayout Languages: eng\n"
"\tModel Name: pc101\n"
"\tModel Description: Generic 101-key PC\n"
"\tModel Vendor: Generic\n"
"\tOption Group Name: grp\n"
"\tOption Group Description: Key(s) to change layout\n"
"\tOption Group Exclusive: 0\n"
"\t\tOption Name: grp:switch\n"
"\t\tOption Description: Right Alt (while pressed)\n"
"\t\tOption Name: grp:lswitch\n"
"\t\tOption Description: Left Alt (while pressed)\n"
"\t\tOption Name: grp:lwin_switch\n"
"\t\tOption Description: Left Win (while pressed)\n"
"\t\tOption Name: grp:rwin_switch\n"
"\t\tOption Description: Right Win (while pressed)\n"
"\t\tOption Name: grp:win_switch\n"
"\t\tOption Description: Any Win key (while pressed)\n"
"\t\tOption Name: grp:caps_switch\n"
"\t\tOption Description: Caps Lock (while pressed), Alt+Caps Lock does the original capslock action\n"
"\t\tOption Name: grp:rctrl_switch\n"
"\t\tOption Description: Right Ctrl (while pressed)\n"
"\t\tOption Name: grp:toggle\n"
"\t\tOption Description: Right Alt\n"
"\t\tOption Name: grp:lalt_toggle\n"
"\t\tOption Description: Left Alt\n"
"\t\tOption Name: grp:caps_toggle\n"
"\t\tOption Description: Caps Lock\n"
"\t\tOption Name: grp:shift_caps_toggle\n"
"\t\tOption Description: Shift+Caps Lock\n"
"\t\tOption Name: grp:shift_caps_switch\n"
"\t\tOption Description: Caps Lock (to first layout), Shift+Caps Lock (to last layout)\n"
"\t\tOption Name: grp:win_menu_switch\n"
"\t\tOption Description: Left Win (to first layout), Right Win/Menu (to last layout)\n"
"\t\tOption Name: grp:lctrl_rctrl_switch\n"
"\t\tOption Description: Left Ctrl (to first layout), Right Ctrl (to last layout)\n"
"\t\tOption Name: grp:alt_caps_toggle\n"
"\t\tOption Description: Alt+Caps Lock\n"
"\t\tOption Name: grp:shifts_toggle\n"
"\t\tOption Description: Both Shift keys together\n"
"\t\tOption Name: grp:alts_toggle\n"
"\t\tOption Description: Both Alt keys together\n"
"\t\tOption Name: grp:ctrls_toggle\n"
"\t\tOption Description: Both Ctrl keys together\n"
"\t\tOption Name: grp:ctrl_shift_toggle\n"
"\t\tOption Description: Ctrl+Shift\n"
"\t\tOption Name: grp:lctrl_lshift_toggle\n"
"\t\tOption Description: Left Ctrl+Left Shift\n"
"\t\tOption Name: grp:rctrl_rshift_toggle\n"
"\t\tOption Description: Right Ctrl+Right Shift\n"
"\t\tOption Name: grp:ctrl_alt_toggle\n"
"\t\tOption Description: Alt+Ctrl\n"
"\t\tOption Name: grp:alt_shift_toggle\n"
"\t\tOption Description: Alt+Shift\n"
"\t\tOption Name: grp:alt_space_toggle\n"
"\t\tOption Description: Alt+Space\n"
"\t\tOption Name: grp:menu_toggle\n"
"\t\tOption Description: Menu\n"
"\t\tOption Name: grp:lwin_toggle\n"
"\t\tOption Description: Left Win\n"
"\t\tOption Name: grp:rwin_toggle\n"
"\t\tOption Description: Right Win\n"
"\t\tOption Name: grp:lshift_toggle\n"
"\t\tOption Description: Left Shift\n"
"\t\tOption Name: grp:rshift_toggle\n"
"\t\tOption Description: Right Shift\n"
"\t\tOption Name: grp:lctrl_toggle\n"
"\t\tOption Description: Left Ctrl\n"
"\t\tOption Name: grp:rctrl_toggle\n"
"\t\tOption Description: Right Ctrl\n"
"\t\tOption Name: grp:sclk_toggle\n"
"\t\tOption Description: Scroll Lock\n"
"\t\tOption Name: grp:lctrl_lwin_rctrl_menu\n"
"\t\tOption Description: LeftCtrl+LeftWin (to first layout), RightCtrl+Menu (to second layout)\n"
"\tOption Group Name: lv3\n"
"\tOption Group Description: Key to choose 3rd level\n"
"\tOption Group Exclusive: 0\n"
"\t\tOption Name: lv3:switch\n"
"\t\tOption Description: Right Ctrl\n"
"\t\tOption Name: lv3:menu_switch\n"
"\t\tOption Description: Menu\n"
"\t\tOption Name: lv3:win_switch\n"
"\t\tOption Description: Any Win key\n"
"\t\tOption Name: lv3:lwin_switch\n"
"\t\tOption Description: Left Win\n"
"\t\tOption Name: lv3:rwin_switch\n"
"\t\tOption Description: Right Win\n"
"\t\tOption Name: lv3:alt_switch\n"
"\t\tOption Description: Any Alt key\n"
"\t\tOption Name: lv3:lalt_switch\n"
"\t\tOption Description: Left Alt\n"
"\t\tOption Name: lv3:ralt_switch\n"
"\t\tOption Description: Right Alt\n"
"\t\tOption Name: lv3:ralt_switch_multikey\n"
"\t\tOption Description: Right Alt, Shift+Right Alt key is Multi_Key\n"
"\t\tOption Name: lv3:ralt_alt\n"
"\t\tOption Description: Right Alt key never chooses 3rd level\n"
"\t\tOption Name: lv3:enter_switch\n"
"\t\tOption Description: Enter on keypad\n"
"\t\tOption Name: lv3:caps_switch\n"
"\t\tOption Description: Caps Lock\n"
"\t\tOption Name: lv3:bksl_switch\n"
"\t\tOption Description: Backslash\n"
"\t\tOption Name: lv3:lsgt_switch\n"
"\t\tOption Description: >\n"
"\t\tOption Name: lv3:caps_switch_latch\n"
"\t\tOption Description: Caps Lock (chooses 3rd level, latches when pressed together with another 3rd-level-chooser)\n"
"\t\tOption Name: lv3:bksl_switch_latch\n"
"\t\tOption Description: Backslash (chooses 3rd level, latches when pressed together with another 3rd-level-chooser)\n"
"\t\tOption Name: lv3:lsgt_switch_latch\n"
"\t\tOption Description: (chooses 3rd level, latches when pressed together with another 3rd-level-chooser)";

int main(int argc, char* argv[])
{
    FcitxXkbRules* rules = FcitxXkbReadRules(argv[1]);
    char* result = FcitxXkbRulesToReadableString(rules);
    printf("%s\n", result);
    assert(strcmp(correct, result) == 0);
    free(result);
    FcitxXkbRulesFree(rules);
    
    return 0;
}