/*
 * $Id: chip_gen_ppi.c,v 1.21 2009-06-03 11:34:03 vrsieh Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h> 

#include "fixme.h"

#include "chip_gen_ppi.h"

struct cpssp {
	/*
	 * Config
	 */

	/*
	 * Signals
	 */
	struct sig_boolean_or *port_gate2;

	/*
	 * State
	 */
	unsigned int state_power;
	unsigned char state_in4;
	unsigned char state_in5;

#define STATE

#define NAME		chip_ppi_io
#define NAME_(x)	chip_ppi_io_ ## x
#define SNAME		"chip_ppi_io"
#include "arch_ppi.c"
#undef SNAME
#undef NAME_
#undef NAME

#undef STATE
};

extern inline unsigned char
chip_ppi_io_in4_get(struct cpssp *cpssp)
{
	return cpssp->state_in4;
}

extern inline unsigned char
chip_ppi_io_in5_get(struct cpssp *cpssp)
{
	return cpssp->state_in5;
}

static inline void
chip_ppi_io_out0_set(struct cpssp *cpssp, unsigned char val)
{
	sig_boolean_or_set(cpssp->port_gate2, cpssp, val);
}

extern inline void
chip_ppi_io_out1_set(struct cpssp *cpssp, unsigned char val)
{
	/* speaker */
}

#define BEHAVIOR

#define NAME		chip_ppi_io
#define NAME_(x)	chip_ppi_io_ ## x
#define SNAME		"chip_ppi_io"
#include "arch_ppi.c"
#undef SNAME
#undef NAME_
#undef NAME

#undef BEHAVIOR

static void
chip_gen_ppi_power_set(void *_css, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _css;

	cpssp->state_power = val;
}

static void
chip_gen_ppi_in4_set(void *_css, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _css;
	unsigned char _val = (unsigned char) val;	

	cpssp->state_in4 = _val;
}

static void
chip_gen_ppi_in5_set(void *_css, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _css;
	unsigned char _val = (unsigned char) val;

	cpssp->state_in5 = _val;
}

static void
chip_gen_ppi_n_reset_set(void *_css, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _css;

	chip_ppi_io_reset(cpssp);
}

static int
chip_gen_ppi_inb(void *_css, uint8_t *valp, unsigned long addr)
{
	struct cpssp *cpssp = (struct cpssp *) _css;

	chip_ppi_io_inb(cpssp, valp);
	
	return 0;
}

static int
chip_gen_ppi_outb(void *_css, uint8_t val, unsigned long addr)
{
	struct cpssp *cpssp = (struct cpssp *) _css;

	chip_ppi_io_outb(cpssp, val);
	
	return 0;
}

void *
chip_gen_ppi_create(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_boolean *port_power,
	struct sig_boolean *port_reset_hash_,
	struct sig_cs *port_cs,
	struct sig_isa_bus_main *port_bus,
	struct sig_boolean_or *port_gate2,
	struct sig_boolean_or *port_pit_out1,
	struct sig_boolean_or *port_pit_out2
)
{
	static const struct sig_boolean_funcs power_funcs = {
		.set = chip_gen_ppi_power_set,
	};
	static const struct sig_boolean_funcs reset_hash__funcs = {
		.set = chip_gen_ppi_n_reset_set,
	};
	static const struct sig_cs_funcs cs_funcs = {
		.readb = chip_gen_ppi_inb,
		.writeb = chip_gen_ppi_outb,
	};
	static const struct sig_boolean_or_funcs pit_out1_funcs = {
		.set = chip_gen_ppi_in4_set,
	};
	static const struct sig_boolean_or_funcs pit_out2_funcs = {
		.set = chip_gen_ppi_in5_set,
	};
	struct cpssp *cpssp;

	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

	chip_ppi_io_init(cpssp);

	/* Out */
	cpssp->port_gate2 = port_gate2;
	sig_boolean_or_connect_out(port_gate2, cpssp, 0);

	/* Call */
	sig_cs_connect(port_cs, cpssp, &cs_funcs);

	/* In */
	sig_boolean_connect_in(port_power, cpssp, &power_funcs);

	sig_boolean_connect_in(port_reset_hash_, cpssp, &reset_hash__funcs);

	cpssp->state_in4 = 0;
	sig_boolean_or_connect_in(port_pit_out1, cpssp, &pit_out1_funcs);

	cpssp->state_in5 = 0;
	sig_boolean_or_connect_in(port_pit_out2, cpssp, &pit_out2_funcs);

	return cpssp;
}

void
chip_gen_ppi_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	free(cpssp);
}
