/* $Id: sig_boolean.h,v 1.22 2009-05-21 16:38:06 vrsieh Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_BOOLEAN_H_INCLUDED
#define __SIG_BOOLEAN_H_INCLUDED

#include "sig_gen.h"

struct sig_boolean_funcs {
	void (*set)(void *s, unsigned int val);
	void (*set_ext)(void *s, unsigned int val);
};

struct sig_boolean {
	enum sig_gen_type type;
	struct {
		void *s;
		const struct sig_boolean_funcs *f;
		unsigned int in;
	} in[64];
	int in_count;

	struct {
		void *s;
		unsigned int out;
	} out[64];
	int out_count;
};

struct sig_boolean_merge {
	struct sig_boolean *s0;
	struct sig_boolean *s1;
};

extern void
sig_boolean_set(struct sig_boolean *b, void *s, unsigned int val);

extern void
sig_boolean_connect_in(struct sig_boolean *b,
		void *s, const struct sig_boolean_funcs *f);
extern void
sig_boolean_connect_out(struct sig_boolean *b,
		void *s, unsigned int val);

extern struct sig_boolean_merge *
sig_boolean_merge(struct sig_boolean *s0, struct sig_boolean *s1);
extern void
sig_boolean_split(struct sig_boolean_merge *m);

extern struct sig_boolean *
sig_boolean_create(const char *name);
extern void
sig_boolean_destroy(struct sig_boolean *b);

#endif /* __SIG_BOOLEAN_H_INCLUDED */
