/* $Id: FAUhdlc.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __FAUHDLC_HPP_INCLUDED
#define __FAUHDLC_HPP_INCLUDED

#include <list>
#include <iostream>
#include <string>
#include "frontend/ast/AstNode.hpp"
#include "frontend/misc/SymbolTable.hpp"
#include "intermediate/Node.hpp"

namespace compiler {

//! main compiler class.
class FAUhdlc {
public:
	//! c'tor
	FAUhdlc();

	//! d'tor
	~FAUhdlc();

	//! parse the command line arguments
	/** @param argc number of command line arguments.
          * @param argv vector of command line arguments.
          */
	void parseCmdLine(int argc, char **argv);

	//! compile.
	/** @return exit status */
	int run();

private:
	/** possible error codes */
	enum ResultCodes {
		FAUHDLC_EXIT_SUCCESS = 0, 	//!< everything ok.
		FAUHDLC_EXIT_COMMAND_ARGS = 1,	//!< wrong command line args
		FAUHDLC_EXIT_ERROR = 3, //!< compile error was found
		FAUHDLC_EXIT_EXCEPTION = 4	//!< other Exception occured
	};

	//! mapping class for filename to library name
	struct LibFile {
		std::string *filename; 	//!< full path to file.
		const char *library;	//!< name of library in which file is.
	};

	//! display command line usage.
	/** @param out stream on which usage should be put. */
	void usage(std::ostream &out) const;

	//! parse a file
	void doParse(void);

	//! do the semantic analysis
	void doSemanticAnalysis(void);

	//! write out any warnings/errors 
	void putCompileMessages(void);

	//! perform transformations on intermediate code
	/** currently, this will only write the intermediate code to 
	 *  the output file, in case one was specified.
	 *  More to come.
	 */
	void doIntermediateTransform(void);

	/** top AST node. */
	ast::AstNode *topNode;

	/** stop after parsing */
	bool parseOnly;

	/** generate dot file after parsing. */
	bool dotParse;

	/** result code reported back to main */
	enum ResultCodes resultCode;

	/** file that should get compiled */
	std::list<struct LibFile*> sourceFiles;

	/** filename of the dot file after parsing */
	const char *dotParseFile;
	
	/** name of the output file */
	const char *outputFile;

	/** symbol table used in first steps of semantic analysis */
	ast::SymbolTable *symbolTable;

	/** intermediate code top node. */
	intermediate::Node *iTopNode;

	/** create dot file after constant propagation? */
	bool dotConst;

	/** filename of the dot file after constant propagation */
	const char *dotConstFile;

	/** freestanding mode? (don't load common libraries like std_logic */
	bool freeStanding;
};

}; /* namespace compiler */

#endif /* __FAUHDLC_HPP_INCLUDED */
