/***************************************************************************
                          FLReceiver.h  -  description
                             -------------------
    begin                : Thu Dec 6 2001
    copyright            : (C) 2001,2002 by Federico Albujer Zornoza
    email                : mail@infosial.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FLRECEIVER_H
#define FLRECEIVER_H

#include <qobject.h>

class FLSqlCursor;
class FLFormDB;

/** Esta clase abstracta engloba objetos que puede recibir informacin de los formularios de datos.

	Cuando se quiere crea un formulario del tipo FLFormDB con funcionalidad extra o
	para controlar sus componentes segn ciertas condiciones,	se deben crear clases que
	hereden de FLReceiver y pasarle una instancia de ellas al formulario.
	Esto permitir que la nueva clase del tipo FLReceiver, pueda controlar los componentes del formulario
	FLFormDB, recibir seales de este a sus "slots", controlar los registros del cursor y devolver valores
	para campos calculados.

  	@author Federico Albujer Zornoza
  	@version 0.4 */
class FLReceiver : public QObject
{
    Q_OBJECT

	public:
	
	/** constructor */
	FLReceiver();

	/** destructor */
	virtual ~FLReceiver();

	/** Establece el cursor con el que se debe trabajar.
	
		@param c Cursor con el que trabajar */
	void setCursor(FLSqlCursor *c);
	
	/** Establece cual es el formulario con el que se puede comunicar, y que
	    podr enviar seales a el receptor.

	    @param sender   Una instancia del tipo FLFormDB o heredar de el, que ser
                        el formulario para que un objeto de esta clase pueda tratar. */
	virtual void setSender(FLFormDB *sender);

	/** Este mtodo devuelve el valor de un campo calculado,
	    ser invocado por el objeto FLSqlCursor, cuando el campo est
	    definido en los metadatos como calculado.

		Cuando se necesita saber el valor de un campo calculado, este mtodo
		es invocado y debe devolver el valor para dicho campo.

		@param name	Nombre del campo del que obtener el valor calculado.*/
	virtual QVariant calculateField (const QString & name);

        /** Este metodo devuelve el valor ms aconsejable para ser usado en un campo
              contador o de referencia.

              Este metodo es muy util cuando se insertan registros en los que
              la referencia es secuencial y no nos acordamos de cual fue el ultimo
              numero usado. El valor devuelto es un QVariant del tipo de campo en
              el que se busca la ultima referencia. Lo ms aconsejable es que el tipo
              del campo sea 'String' porque as se le puede dar formato y ser
              usado para generar un cdigo de barras. De todas formas la funcin
              soporta tanto que el campo sea de tipo 'String' como de tipo 'double'.
              Aunque el mtodo tiene una implemntacin por defecto, que puede servir
              para la mayora de los casos, podra ser aconsejable reimplementar el
              mtodo en las clases hijas (procesos de los formularios) para obtener
              secuencias mas elaboradas, dependiendo del caso.

              @author Andrs Otn Urbano (andresoton@eresmas.com)
              @param name              Nombre del campo contador.
              @return Siguiente valor aconsejable de la secuencia. */
   virtual QVariant calculateCounter(const QString & name);

	protected:

	/** Formulario que ser controlado por un objeto de esta clase.*/
	FLFormDB *sender_;
	
	/** Cursor con el que trabajan los objetos de esta clase */
	FLSqlCursor *cursor_;
};

#endif
