/***************************************************************************
                          FLApplication.cpp  -  description
                             -------------------
    begin                : Mon Jul 2 2001
    copyright            : (C) 2001,2002 by Federico Albujer Zornoza
    email                : mail@infosial.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "FLApplication.h"
#include "FLAbout.h"
#include "helpwindow.h"
#include "FLFormDB.h"
#include "FLSqlCursor.h"
#include "FLTableMetaData.h"
#include "FLAction.h"
#include "FLReceiver.h"
#include "FLManager.h"
#include "../process/FLInterface.h"

#include "../icons/mini-splashfx.xpm"
#include "../icons/splashfx.h"

static QLabel *splash = 0;

QPixmap
splashScreen ()
{
  Embed2 *e = &embed_vec2[0];
  while (e->name)
	{
	  if (QString (e->name) == "splashfx.png")
		{
		  QImage img;
		  img.loadFromData ((const uchar *) e->data, e->size);
		  QPixmap pix;
		  pix.convertFromImage (img);
		  return pix;
		}
	  e++;
	}
  return QPixmap ();
}

FLApplication::FLApplication (int &argc, char **argv):
QApplication (argc, argv), pWorkspace (0), generalDB_ (0), mainWidget_ (0)
{
}

FLApplication::~FLApplication ()
{
  if (generalDB_)
	generalDB_->close ();

  writeState ();
}

void
FLApplication::set_splash_status (const QString & txt)
{
  if (!splash)
	return;
  QTimer timer;
  timer.start (250, TRUE);

  splash->repaint (false);
  QPainter p (splash);

  QString s = tr ("Publicado bajo GNU General Public License  versin 2");

  int width;
  if (txt.length () > s.length ())
	width = splash->fontMetrics ().boundingRect (txt).width ();
  else
	width = splash->fontMetrics ().boundingRect (s).width ();
  int hFont = splash->fontMetrics ().height ();

  p.fillRect (5, 478, width + 8, 2 * hFont + hFont / 2, QBrush (Qt::white));

  p.setPen (Qt::black);
  p.drawText (8, hFont + 478, txt);
  p.drawText (8, 2 * hFont + 480, s);

  while (timer.isActive ())
	processEvents ();

  QApplication::flush ();
}

QLabel *
FLApplication::showSplash ()
{
  QRect screen = QApplication::desktop ()->screenGeometry ();
  QSettings config;
  QString keybase ("/facturalux/" VERSION "/");

  QRect mainRect;
  bool show = config.readBoolEntry (keybase + "SplashScreen", true);
  mainRect.setX (config.readNumEntry (keybase + "Geometries/MainwindowX", 0));
  mainRect.setY (config.readNumEntry (keybase + "Geometries/MainwindowY", 0));
  mainRect.setWidth (config.readNumEntry (keybase + "Geometries/MainwindowWidth", 500));
  mainRect.setHeight (config.readNumEntry (keybase + "Geometries/MainwindowHeight", 500));
  screen = QApplication::desktop ()->screenGeometry (QApplication::desktop ()->screenNumber (mainRect.center ()));

  if (show)
	{
	  splash = new QLabel (0, "splash", WDestructiveClose | WStyle_Customize | WStyle_NoBorder | WX11BypassWM | WStyle_StaysOnTop);
	  splash->setFrameStyle (QFrame::WinPanel | QFrame::Raised);
	  splash->setPixmap (splashScreen ());
	  QFont f ("Helvetica", 12, QFont::DemiBold);
	  splash->setFont (f);
	  splash->adjustSize ();
	  splash->setCaption ("FacturaLUX");
	  splash->move (screen.center () - QPoint (splash->width () / 2, splash->height () / 2));
	  splash->show ();
	  splash->repaint (false);
	  QApplication::flush ();
	  set_splash_status (tr ("SPLASH !!!"));
	}

  return splash;
}

void
FLApplication::setMainWidget (QWidget * w)
{
  set_splash_status (tr ("Inicializando..."));

  if (!w)
	return;
  mainWidget_ = w;
  QPixmap pix ((const char **) minilogofx);

  mainWidget_->setIcon (pix);
  mainWidget_->setCaption ("FacturaLUX " VERSION);
  mainWidget_->setFont (font ());

  initView ();
  initActions ();
  initMenuBar ();
  initToolBar ();
  initStatusBar ();
  initStyles ();

  readState ();

  QApplication::setMainWidget (w);
}

void
FLApplication::makeStyle (const QString & style)
{
  setStyle (style);
  QSettings settings;
  QString keybase ("/facturalux/" VERSION "/");

  settings.writeEntry (keybase + "estilo", style);
}

void
FLApplication::chooseFont ()
{
  setFont (QFontDialog::getFont (0, font (), mainWidget_), true);
  QWidgetList *list = allWidgets ();
  QWidgetListIt it (*list);
  QWidget *w;

  while ((w = it.current ()) != 0)
	{
	  ++it;
	  w->setFont (font ());
	}

  QSettings settings;
  QString keybase ("/facturalux/" VERSION "/");

  settings.writeEntry (keybase + "fuente/familia", font ().family ());
  settings.writeEntry (keybase + "fuente/puntos", font ().pointSize ());
  settings.writeEntry (keybase + "fuente/negrita", font ().bold ());
  settings.writeEntry (keybase + "fuente/cursiva", font ().italic ());
  settings.writeEntry (keybase + "fuente/subrayado", font ().underline ());
  settings.writeEntry (keybase + "fuente/tachado", font ().strikeOut ());
}

void
FLApplication::initActions ()
{
  QObject *obj = mainWidget_->child ("windowCascadeAction");
  if (obj)
	connect ((QAction *) obj, SIGNAL (activated ()), pWorkspace, SLOT (cascade ()));

  obj = mainWidget_->child ("windowTileAction");
  if (obj)
	connect ((QAction *) obj, SIGNAL (activated ()), pWorkspace, SLOT (tile ()));
}

void
FLApplication::initMenuBar ()
{
  QObject *obj = mainWidget_->child ("windowMenu");

  if (obj)
	connect ((QPopupMenu *) obj, SIGNAL (aboutToShow ()), this, SLOT (windowMenuAboutToShow ()));
}

void
FLApplication::initToolBar ()
{
  QObject *obj = mainWidget_->child ("toolBar");

  if (obj)
	((QToolBar *) obj)->addSeparator ();
  QWhatsThis::whatsThisButton ((QToolBar *) obj);
}

void
FLApplication::initStatusBar ()
{
  ((QMainWindow *) mainWidget_)->statusBar ()->message (tr ("Listo."));
  ((QMainWindow *) mainWidget_)->statusBar ()->setSizeGripEnabled (false);
}

void
FLApplication::initView ()
{
  QVBox *view_back = new QVBox (mainWidget_);

  view_back->setFrameStyle (QFrame::StyledPanel | QFrame::Sunken);
  pWorkspace = new QWorkspace (view_back);
  pWorkspace->setScrollBarsEnabled (true);
  ((QMainWindow *) mainWidget_)->setCentralWidget (view_back);
}

void
FLApplication::initStyles ()
{
  QPopupMenu *style = new QPopupMenu (mainWidget_);

  style->setCheckable (TRUE);

  style->setCheckable (TRUE);
  QActionGroup *ag = new QActionGroup (mainWidget_, 0);

  ag->setExclusive (TRUE);
  QSignalMapper *styleMapper = new QSignalMapper (mainWidget_);
  connect (styleMapper, SIGNAL (mapped (const QString &)), this, SLOT (makeStyle (const QString &)));
  QStringList list = QStyleFactory::keys ();

  list.sort ();
  QDict < int >stylesDict (17, FALSE);

  for (QStringList::Iterator it = list.begin (); it != list.end (); ++it)
	{
	  QString styleStr = *it;
	  QString styleAccel = styleStr;

	  if (stylesDict[styleAccel.left (1)])
		{
		  for (uint i = 0; i < styleAccel.length (); i++)
			{
			  if (!stylesDict[styleAccel.mid (i, 1)])
				{
				  stylesDict.insert (styleAccel.mid (i, 1), (const int *) 1);
				  styleAccel = styleAccel.insert (i, '&');
				  break;
				}
			}
		}
	  else
		{
		  stylesDict.insert (styleAccel.left (1), (const int *) 1);
		  styleAccel = "&" + styleAccel;
		}
	  QAction *a = new QAction (styleStr, QIconSet (), styleAccel, 0, ag, 0,
								ag->isExclusive ());
	  QSettings settings;
	  QString keybase ("/facturalux/" VERSION "/");
	  if (styleStr == settings.readEntry (keybase + "estilo", "Platinum"))
		a->setOn (true);
	  connect (a, SIGNAL (activated ()), styleMapper, SLOT (map ()));
	  styleMapper->setMapping (a, a->text ());
	}
  ag->addTo (style);
  QObject *obj = mainWidget_->child ("settingsMenu");

  if (obj)
	((QPopupMenu *) obj)->insertItem (tr ("&Apariencia" ), style);
}

bool FLApplication::queryExit ()
{
  int
	exit =
	QMessageBox::information (mainWidget_, tr ("Salir..."),
							  tr (" Quiere salir de la aplicacin ?"),
							  QMessageBox::Yes,
							  QMessageBox::No | QMessageBox::Default | QMessageBox::Escape);
  return (exit == QMessageBox::Yes);
}

void
FLApplication::generalExit ()
{
  if (queryExit ())
	quit ();
}

void
FLApplication::toggleToolBar (bool toggle)
{
  if (toggle == false)
	{
	  QObject *obj = mainWidget_->child ("toolBar");

	  if (obj)
		((QToolBar *) obj)->hide ();
	}
  else
	{
	  QObject *obj = mainWidget_->child ("toolBar");

	  if (obj)
		((QToolBar *) obj)->show ();
	};
}

void
FLApplication::toggleStatusBar (bool toggle)
{
  if (toggle == false)
	((QMainWindow *) mainWidget_)->statusBar ()->hide ();
  else
	((QMainWindow *) mainWidget_)->statusBar ()->show ();
}

void
FLApplication::helpAbout ()
{
  FLAbout *about = new FLAbout (VERSION, mainWidget_);

  about->exec ();
}

void
FLApplication::helpIndex ()
{
  if (!pWorkspace->windowList ().isEmpty ())
	{
	  QWidgetList windows = pWorkspace->windowList ();

	  for (int i = 0; i < int (windows.count ()); ++i)
		{
		  if (windows.at (i)->isA ("HelpWindow"))
			{
			  windows.at (i)->showNormal ();
			  windows.at (i)->setFocus ();
			  return;
			}
		}
	}
  QString index = FLDATA "/doc/facturalux/index.html";
  HelpWindow *help = new HelpWindow (index, ".", pWorkspace, "help viewer");

  help->showMaximized ();
}

void
FLApplication::statusHelpMsg (const QString & text)
{
  ((QMainWindow *) mainWidget_)->statusBar ()->message (text, 2000);
}

void
FLApplication::windowMenuAboutToShow ()
{
  QObject *obj = mainWidget_->child ("windowMenu");

  if (obj)
	((QPopupMenu *) obj)->clear ();

  QObject *obj2 = mainWidget_->child ("windowCascadeAction");

  if (obj2)
	((QAction *) obj2)->addTo ((QPopupMenu *) obj);

  obj2 = mainWidget_->child ("windowTileAction");
  if (obj2)
	((QAction *) obj2)->addTo ((QPopupMenu *) obj);

  obj2 = mainWidget_->child ("windowCloseAction");
  if (obj2)
	((QAction *) obj2)->addTo ((QPopupMenu *) obj);

  if (pWorkspace->windowList ().isEmpty ())
	{
	  QObject *obj = mainWidget_->child ("windowActionGroup");

	  if (obj)
		((QActionGroup *) obj)->setEnabled (false);
	}
  else
	{
	  QObject *obj = mainWidget_->child ("windowActionGroup");

	  if (obj)
		((QActionGroup *) obj)->setEnabled (true);
	  obj = mainWidget_->child ("windowMenu");
	  if (obj)
		((QPopupMenu *) obj)->insertSeparator ();
	}

  QWidgetList windows = pWorkspace->windowList ();

  for (int i = 0; i < int (windows.count ()); ++i)
	{
	  QObject *obj = mainWidget_->child ("windowMenu");

	  if (obj)
		{
		  int id = ((QPopupMenu *) obj)->insertItem (windows.at (i)->caption (),
													 this,
													 SLOT (windowMenuActivated (int)));
		  ((QPopupMenu *) obj)->setItemParameter (id, i);
		  ((QPopupMenu *) obj)->setItemChecked (id, pWorkspace->activeWindow () == windows.at (i));
		}
	}
}

void
FLApplication::windowMenuActivated (int id)
{
  QWidget *w = pWorkspace->windowList ().at (id);

  if (w)
	w->setFocus ();
}

bool FLApplication::existsFormInMDI (const QString & id)
{
  if (id.isEmpty () || !pWorkspace)
	return false;

  if (!pWorkspace->windowList ().isEmpty ())
	{
	  QWidgetList
		windows =
		pWorkspace->
		windowList ();

	  for (int i = 0; i < int (windows.count ()); ++i)
		{
		  if (((FLFormDB *) windows.at (i))->idMDI () == id)
			{
			  windows.at (i)->showNormal ();
			  windows.at (i)->setFocus ();
			  return true;
			}
		}
	}

  return false;
}

void
FLApplication::openMasterForm (const QString & n, const QPixmap & p)
{
  FLAction *a = FLManager::action (n);

  if (existsFormInMDI (a->name ()))
	return;

  QApplication::setOverrideCursor (Qt::WaitCursor);
  FLReceiver *r = FLInterface::getReceiver (a->masterProcess ());
  FLFormDB *f = new FLFormDB (a->table (), pWorkspace, Qt::WDestructiveClose, r);
  f->cursor ()->setAction (a);
  f->setIdMDI (a->name ());
  QWidget *w;

  if (r)
	w = QWidgetFactory::create (a->form (), r, f);
  else
	w = QWidgetFactory::create (a->form (), f, f);

  if (!w)
	{
	  qWarning (tr ("FLApplication : No se ha podido cargar '") + a->form () + tr ("'. Ejecute 'make install' despues de compilar la aplicacin."));
	  QApplication::restoreOverrideCursor ();
	  return;
	}

  if (a->caption () != QString::null)
	f->setCaption (a->caption ());

  f->setIcon (p);
  f->setMainWidget (w);
  f->setFocus ();
  if (pWorkspace->windowList ().isEmpty ())
	f->showMaximized ();
  else
	f->show ();
  QApplication::restoreOverrideCursor ();
}

void
FLApplication::openDefaultForm ()
{
  const QObject *s = sender ();

  if (!s->isA ("QAction"))
	{
	  qWarning (tr ("FLApplication : El objeto que envia seales para abrir formularios debe ser de la clase QAction"));
	  return;
	}
  QPixmap icon = ((QAction *) s)->iconSet ().pixmap ();
  openMasterForm (s->name (), icon);
}

void
FLApplication::windowClose ()
{
  if (!pWorkspace->windowList ().isEmpty ())
	pWorkspace->activeWindow ()->close ();
}

void
FLApplication::setGeneralDB (QSqlDatabase * db)
{
  if (!db)
	return;
  generalDB_ = db;
}

void
FLApplication::writeState ()
{
  QSettings config;
  QString keybase ("/facturalux/" VERSION "/");

	if (pWorkspace)
	{
		QStringList windowsOpened;
		if (!pWorkspace->windowList ().isEmpty ())
		{
			QWidgetList windows = pWorkspace->windowList ();

			for (int i = 0; i < int (windows.count ()); ++i)
				windowsOpened << ((FLFormDB *) windows.at (i))->idMDI ();
		}

		config.writeEntry (keybase + "windowsOpened", windowsOpened, ',');
		config.writeEntry (keybase + "Geometry/MainwindowMaximized", mainWidget_->isMaximized ());
		config.writeEntry (keybase + "Geometry/MainwindowX", mainWidget_->x ());
		config.writeEntry (keybase + "Geometry/MainwindowY", mainWidget_->y ());
		config.writeEntry (keybase + "Geometry/MainwindowWidth", mainWidget_->width ());
		config.writeEntry (keybase + "Geometry/MainwindowHeight", mainWidget_->height ());
	}
}

void
FLApplication::readState ()
{
  set_splash_status (tr ("Restableciendo sesin anterior..."));
  QSettings config;
  QString keybase ("/facturalux/" VERSION "/");

  QStringList windowsOpened;
  windowsOpened = config.readListEntry (keybase + "windowsOpened", ',');
  if (!windowsOpened.isEmpty ())
	{
	  QObject *obj = 0;
	  for (QStringList::Iterator it = windowsOpened.begin (); it != windowsOpened.end (); ++it)
		{
		  QString n = (*it);
		  obj = mainWidget_->child (n, "QAction");
		  if (obj)
			openMasterForm (n, ((QAction *) obj)->iconSet ().pixmap ());
		}
	}

  QRect r (mainWidget_->pos (), mainWidget_->size ());
  if (!config.readBoolEntry (keybase + "Geometry/MainwindowMaximized", FALSE))
	{
	  r.setX (config.readNumEntry (keybase + "Geometry/MainwindowX", r.x ()));
	  r.setY (config.readNumEntry (keybase + "Geometry/MainwindowY", r.y ()));
	  r.setWidth (config.readNumEntry (keybase + "Geometry/MainwindowWidth", r.width ()));
	  r.setHeight (config.readNumEntry (keybase + "Geometry/MainwindowHeight", r.height ()));

	  QRect desk = QApplication::desktop ()->geometry ();
	  QRect inter = desk.intersect (r);
	  mainWidget_->resize (r.size ());
	  if (inter.width () * inter.height () > (r.width () * r.height () / 20))
		mainWidget_->move (r.topLeft ());
	}
  else
	mainWidget_->resize (QApplication::desktop ()->geometry ().size ());
}
